/*
 * Decompiled with CFR 0.152.
 */
package org.epoxide.surge.libs;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.text.WordUtils;

public class TextUtils {
    private static final Map<Character, ChatFormat> CHARACTER_TO_FORMAT = new HashMap<Character, ChatFormat>();
    private static final Map<String, ChatFormat> NAME_TO_FORMAT = new HashMap<String, ChatFormat>();
    public static final char FORMAT_PREFIX = '\u00a7';
    public static final Pattern FORMAT_PATTERN = Pattern.compile("(?i)" + String.valueOf('\u00a7') + "[0-9A-FK-OR]");

    public static List<String> wrapStringToList(String string, int lnLength, boolean wrapLongWords, List<String> list) {
        String[] lines = WordUtils.wrap((String)string, (int)lnLength, null, (boolean)wrapLongWords).split(SystemUtils.LINE_SEPARATOR);
        list.addAll(Arrays.asList(lines));
        return list;
    }

    public static List<String> wrapStringToListWithFormat(String string, int lnLength, boolean wrapLongWords, List<String> list, TextFormatting format) {
        String[] lines;
        for (String line : lines = WordUtils.wrap((String)string, (int)lnLength, null, (boolean)wrapLongWords).split(SystemUtils.LINE_SEPARATOR)) {
            list.add(format + line);
        }
        return list;
    }

    public static String stripFormatting(String text) {
        return text == null ? null : FORMAT_PATTERN.matcher(text).replaceAll("");
    }

    public static ChatFormat getValueByCharacter(char character) {
        return CHARACTER_TO_FORMAT.get(Character.valueOf(character));
    }

    public static ChatFormat getValueByName(String name) {
        return NAME_TO_FORMAT.get(name.toLowerCase());
    }

    public static String formatString(String string, ChatFormat format) {
        return (Object)((Object)format) + string + (Object)((Object)ChatFormat.RESET);
    }

    public static enum ChatFormat {
        BLACK('0'),
        DARK_BLUE('1'),
        DARK_GREEN('2'),
        DARK_AQUA('3'),
        DARK_RED('4'),
        DARK_PURPLE('5'),
        GOLD('6'),
        GRAY('7'),
        DARK_GRAY('8'),
        BLUE('9'),
        GREEN('a'),
        AQUA('b'),
        RED('c'),
        LIGHT_PURPLE('d'),
        YELLOW('e'),
        WHITE('f'),
        OBFUSCATED('k', true),
        BOLD('l', true),
        STRIKETHROUGH('m', true),
        UNDERLINE('n', true),
        ITALIC('o', true),
        RESET('r');

        private final char formatCode;
        private final boolean isStyle;
        private final String formatText;

        private ChatFormat(char character) {
            this(character, false);
        }

        private ChatFormat(char character, boolean isStyled) {
            this.formatCode = character;
            this.isStyle = isStyled;
            this.formatText = "\u00a7" + character;
        }

        public char getFormattingCode() {
            return this.formatCode;
        }

        public boolean isStyled() {
            return this.isStyle;
        }

        public boolean isColor() {
            return !this.isStyle && this != RESET;
        }

        public String getName() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.formatText;
        }
    }
}

