/*
 * Decompiled with CFR 0.152.
 */
package org.epoxide.surge.libs;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.Resources;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.epoxide.surge.libs.Constants;

public class PlayerUtils {
    public static BiMap<String, UUID> PROFILE_CACHE = HashBiMap.create();

    public static String getPlayerNameFromUUID(UUID uuid) {
        if (PROFILE_CACHE.containsValue((Object)uuid)) {
            return (String)PROFILE_CACHE.inverse().get((Object)uuid);
        }
        String name = null;
        try {
            BufferedReader reader = Resources.asCharSource((URL)new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", "")), (Charset)StandardCharsets.UTF_8).openBufferedStream();
            JsonReader json = new JsonReader((Reader)reader);
            json.beginObject();
            while (json.hasNext()) {
                if (json.nextName().equals("name")) {
                    name = json.nextString();
                    continue;
                }
                json.skipValue();
            }
            json.endObject();
            json.close();
            reader.close();
        }
        catch (Exception exception) {
            Constants.LOG.warn("Could not get name for " + uuid + " " + exception.getMessage());
            name = exception.getMessage();
        }
        return name;
    }

    public static UUID getUUIDFromName(String username) {
        if (PROFILE_CACHE.containsKey((Object)username)) {
            return (UUID)PROFILE_CACHE.get((Object)username);
        }
        UUID uuid = null;
        try {
            BufferedReader reader = Resources.asCharSource((URL)new URL("https://api.mojang.com/users/profiles/minecraft/" + username), (Charset)StandardCharsets.UTF_8).openBufferedStream();
            JsonReader json = new JsonReader((Reader)reader);
            json.beginObject();
            while (json.hasNext()) {
                if (json.nextName().equals("id")) {
                    uuid = PlayerUtils.fixStrippedUUID(json.nextString());
                    continue;
                }
                json.skipValue();
            }
            json.endObject();
            json.close();
            reader.close();
        }
        catch (Exception exception) {
            Constants.LOG.warn("Could not get name for " + username + " " + exception.getMessage());
        }
        return uuid;
    }

    public static UUID fixStrippedUUID(String uuidString) {
        return uuidString.length() != 32 ? null : UUID.fromString(uuidString.substring(0, 8) + "-" + uuidString.substring(8, 12) + "-" + uuidString.substring(12, 16) + "-" + uuidString.substring(16, 20) + "-" + uuidString.substring(20, 32));
    }
}

