/*
 * Decompiled with CFR 0.152.
 */
package org.epoxide.surge.handler;

import java.io.File;
import java.io.IOException;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.epoxide.surge.features.FeatureManager;
import org.epoxide.surge.libs.Constants;

public class PersistentDataHandler {
    private static File saveFile;
    public static NBTTagCompound persistentData;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new PersistentDataHandler());
        PersistentDataHandler.readData();
    }

    public static void readData() {
        try {
            persistentData = CompressedStreamTools.func_74797_a((File)PersistentDataHandler.getSaveFile());
            if (persistentData == null) {
                persistentData = new NBTTagCompound();
            }
            FeatureManager.FEATURES.forEach(feature -> feature.readNBT(persistentData));
        }
        catch (IOException e) {
            Constants.LOG.warn("Issue loading data file! Please report! " + e);
        }
    }

    public static void saveData() {
        try {
            if (persistentData == null) {
                persistentData = new NBTTagCompound();
            }
            FeatureManager.FEATURES.forEach(feature -> feature.writeNBT(persistentData));
            CompressedStreamTools.func_74795_b((NBTTagCompound)persistentData, (File)PersistentDataHandler.getSaveFile());
        }
        catch (IOException e) {
            Constants.LOG.warn("Issue writing data file! Please report! " + e);
        }
    }

    public static File getSaveFile() {
        if (saveFile != null) {
            return saveFile;
        }
        File surgeDirectory = new File("Surge");
        if (!surgeDirectory.exists()) {
            surgeDirectory.mkdirs();
        }
        return new File(surgeDirectory, "SurgeData.nbt");
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        PersistentDataHandler.saveData();
    }
}

