/*
 * Decompiled with CFR 0.152.
 */
package org.epoxide.surge.features.loadtime;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLEvent;
import org.apache.commons.lang3.SystemUtils;
import org.epoxide.surge.features.Feature;
import org.epoxide.surge.features.loadtime.LoadTime;
import org.epoxide.surge.libs.Constants;
import org.epoxide.surge.libs.TextUtils;

public class FeatureLoadTimes
extends Feature {
    private static final HashMap<String, List<LoadTime>> LOAD_TIMES = new HashMap();
    private static final HashMap<String, Long> LOAD_TOTAL_TIME = new HashMap();
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");

    @Override
    public void onFMLFinished() {
        File loadDirectory;
        File surgeDirectory = new File("Surge");
        String timestamp = TIME_FORMAT.format(new Date());
        if (!surgeDirectory.exists()) {
            surgeDirectory.mkdirs();
        }
        if (!(loadDirectory = new File(surgeDirectory, "loadtimes")).exists()) {
            loadDirectory.mkdirs();
        }
        try (FileWriter writer = new FileWriter(new File(loadDirectory, "Surge-Load-Time-Analysis-" + timestamp + ".txt"));){
            writer.write("#Surge Load Time Analysis - " + timestamp + SystemUtils.LINE_SEPARATOR);
            for (String line : TextUtils.wrapStringToList("This file contains approximate information about how long each mod takes to load. The load time of each mod is split into groups which represent the loading stages of the game. If a mod does not have a load time listed, it took less than 0.01 seconds to load. Please note that a mod being on this list does not mean it is slow or broken. While this can be the case, load times can vary depending on how much content a mod provides.", 80, false, new ArrayList<String>())) {
                writer.write(line + SystemUtils.LINE_SEPARATOR);
            }
            writer.write(SystemUtils.LINE_SEPARATOR);
            long totalTime = 0L;
            for (String key : LOAD_TOTAL_TIME.keySet()) {
                totalTime += LOAD_TOTAL_TIME.get(key).longValue();
            }
            writer.write(String.format("Total time: %.2f sec", (double)totalTime / 1000.0) + SystemUtils.LINE_SEPARATOR);
            writer.write(SystemUtils.LINE_SEPARATOR);
            for (String key : LOAD_TIMES.keySet()) {
                writer.write(String.format("#%s - %.2f sec", key, (double)LOAD_TOTAL_TIME.get(key).longValue() / 1000.0) + SystemUtils.LINE_SEPARATOR);
                List<LoadTime> times = LOAD_TIMES.get(key);
                times.sort((a, b) -> a.getTime() < b.getTime() ? 1 : (a.getTime() == b.getTime() ? 0 : -1));
                for (LoadTime time : times) {
                    writer.write(time.toString() + SystemUtils.LINE_SEPARATOR);
                }
                writer.write(SystemUtils.LINE_SEPARATOR);
            }
        }
        catch (IOException exception) {
            Constants.LOG.warn((Object)exception);
        }
    }

    public static void registerLoadingTime(ModContainer mod, FMLEvent stateEvent, long startTime, long endTime) {
        String stageName = stateEvent.getClass().getSimpleName();
        long elapsed = endTime - startTime;
        if (elapsed < 10L) {
            return;
        }
        LoadTime loadTime = new LoadTime(mod.getName(), elapsed);
        Long totalTime = LOAD_TOTAL_TIME.get(stageName);
        if (totalTime == null) {
            LOAD_TOTAL_TIME.put(stageName, elapsed);
        } else {
            LOAD_TOTAL_TIME.put(stageName, totalTime + elapsed);
        }
        if (LOAD_TIMES.containsKey(stageName)) {
            LOAD_TIMES.get(stageName).add(loadTime);
        } else {
            ArrayList<LoadTime> times = new ArrayList<LoadTime>();
            times.add(loadTime);
            LOAD_TIMES.put(stageName, times);
        }
    }

    @Override
    public boolean enabledByDefault() {
        return false;
    }
}

