/*
 * Decompiled with CFR 0.152.
 */
package org.epoxide.surge.features.hideplayers;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.epoxide.surge.command.CommandSurgeWrapper;
import org.epoxide.surge.features.Feature;
import org.epoxide.surge.features.hideplayers.CommandHide;
import org.epoxide.surge.features.hideplayers.CommandWhitelist;
import org.epoxide.surge.libs.PlayerUtils;

@SideOnly(value=Side.CLIENT)
public class FeatureHidePlayer
extends Feature {
    private static final List<UUID> WHITELISTED = new ArrayList<UUID>();
    private static UUID clientID = null;
    private static boolean hidePlayers = false;

    @Override
    public void onInit() {
        clientID = PlayerUtils.fixStrippedUUID(Minecraft.func_71410_x().func_110432_I().func_148255_b());
        CommandSurgeWrapper.addCommand(new CommandHide());
        CommandSurgeWrapper.addCommand(new CommandWhitelist());
    }

    @SubscribeEvent
    public void onPlayerPreRender(RenderPlayerEvent.Pre event) {
        if (!event.getEntityPlayer().func_110124_au().equals(clientID) && hidePlayers && !WHITELISTED.contains(event.getEntityPlayer().func_110124_au())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onSpecialPreRender(RenderPlayerEvent.Specials.Pre event) {
        if (!event.getEntityPlayer().func_110124_au().equals(clientID) && hidePlayers && !WHITELISTED.contains(event.getEntityPlayer().func_110124_au())) {
            event.setCanceled(true);
        }
    }

    public static List<UUID> getWhitelist() {
        return WHITELISTED;
    }

    public static boolean isHiding() {
        return hidePlayers;
    }

    public static void toggleHiding() {
        hidePlayers = !hidePlayers;
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public void readNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            hidePlayers = nbt.func_74767_n("hidePlayers");
        }
        NBTTagList list = nbt.func_150295_c("hidePlayers", 8);
        for (int index = 0; index < list.func_74745_c(); ++index) {
            NBTTagString string = (NBTTagString)list.func_179238_g(index);
            WHITELISTED.add(UUID.fromString(string.func_150285_a_()));
        }
    }

    @Override
    public void writeNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            nbt.func_74757_a("hidePlayers", hidePlayers);
            NBTTagList list = new NBTTagList();
            for (UUID uuid : WHITELISTED) {
                list.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
            }
            nbt.func_74782_a("playerWhitelist", (NBTBase)list);
        }
    }
}

