/*
 * Decompiled with CFR 0.152.
 */
package org.epoxide.surge.features.hideplayers;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.epoxide.surge.command.SurgeCommand;
import org.epoxide.surge.features.hideplayers.FeatureHidePlayer;
import org.epoxide.surge.libs.PlayerUtils;
import org.epoxide.surge.libs.TextUtils;

@SideOnly(value=Side.CLIENT)
public class CommandWhitelist
implements SurgeCommand {
    @Override
    public String getSubName() {
        return "whitelist";
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length > 0) {
            List<UUID> whitelist = FeatureHidePlayer.getWhitelist();
            String commandName = args[0];
            if (commandName.equalsIgnoreCase("list")) {
                StringBuilder builder = new StringBuilder(I18n.func_135052_a((String)"message.surge.whitelist.list", (Object[])new Object[0]));
                for (UUID uuid : whitelist) {
                    builder.append("\n> ").append(PlayerUtils.getPlayerNameFromUUID(uuid));
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(builder.toString()));
            }
            if (args.length == 2) {
                String username = args[1];
                UUID id = PlayerUtils.getUUIDFromName(username);
                if (id == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.surge.whitelist.missing", (Object[])new Object[]{TextUtils.formatString(username, TextUtils.ChatFormat.RED)})));
                    return;
                }
                if (commandName.equalsIgnoreCase("add")) {
                    if (whitelist.contains(id)) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.surge.whitelist.already", (Object[])new Object[]{TextUtils.formatString(username, TextUtils.ChatFormat.RED)})));
                    } else {
                        whitelist.add(id);
                        sender.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.surge.whitelist", (Object[])new Object[]{TextUtils.formatString(username, TextUtils.ChatFormat.GREEN)})));
                    }
                } else if (args[0].equalsIgnoreCase("remove")) {
                    if (whitelist.contains(id)) {
                        whitelist.remove(id);
                        sender.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.surge.whitelist.removed", (Object[])new Object[]{TextUtils.formatString(username, TextUtils.ChatFormat.RED)})));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"message.surge.whitelist.not", (Object[])new Object[]{TextUtils.formatString(username, TextUtils.ChatFormat.RED)})));
                    }
                }
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("/surge " + this.getUsage()));
        }
    }

    @Override
    public String getUsage() {
        return "whitelist [add|remove|list] [username]";
    }
}

