/*
 * Decompiled with CFR 0.152.
 */
package org.epoxide.surge.features.gpucloud;

import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CloudRenderer
extends IRenderHandler
implements IResourceManagerReloadListener {
    private static final float PX_SIZE = 0.00390625f;
    private static final VertexFormat FORMAT = DefaultVertexFormats.field_181709_i;
    private static final int HEIGHT = 4;
    private static final int FULL_WIDTH = 64;
    private static final int START = -32;
    private static final int END = 32;
    private static final int SECTION_WIDTH = 8;
    private static final float INSET = 0.001f;
    private static final float ALPHA = 0.8f;
    private static Minecraft MC;
    private static final ResourceLocation TEXTURE;
    private final RenderGlobal renderGlobal;
    private int displayList = -1;
    private net.minecraft.client.renderer.vertex.VertexBuffer vbo;
    private int cloudMode = -1;
    private final DynamicTexture COLOR_TEX;
    private int texW;
    private int texH;
    private boolean wasVbo = false;

    public CloudRenderer(RenderGlobal renderGlobal) {
        MC = Minecraft.func_71410_x();
        MinecraftForge.EVENT_BUS.register((Object)this);
        IResourceManager resourceManager = MC.func_110442_L();
        ((IReloadableResourceManager)resourceManager).func_110542_a((IResourceManagerReloadListener)this);
        this.COLOR_TEX = new DynamicTexture(1, 1);
        this.renderGlobal = renderGlobal;
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        int i;
        if (!CloudRenderer.MC.field_71441_e.field_73011_w.func_76569_d()) {
            return;
        }
        if (this.wasVbo != OpenGlHelper.func_176075_f() || this.cloudMode != CloudRenderer.MC.field_71474_y.func_181147_e() || (OpenGlHelper.func_176075_f() ? this.vbo == null : this.displayList < 0)) {
            this.wasVbo = OpenGlHelper.func_176075_f();
            this.cloudMode = CloudRenderer.MC.field_71474_y.func_181147_e();
            this.rebuild();
        }
        Entity entity = MC.func_175606_aa();
        double totalOffset = (float)this.renderGlobal.field_72773_u + partialTicks;
        double x = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks + totalOffset * 0.03;
        double y = (double)CloudRenderer.MC.field_71441_e.field_73011_w.func_76571_f() - (entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks) + 0.33;
        double z = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks;
        if (this.cloudMode == 2) {
            z += 0.33 * (double)this.getScale();
        }
        int scale = this.getScale();
        int offU = this.fullCoord(x, scale);
        int offV = this.fullCoord(z, scale);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)(offU * scale) - x), (double)y, (double)((double)(offV * scale) - z));
        offU = Math.floorMod(offU, this.texW);
        offV = Math.floorMod(offV, this.texH);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179109_b((float)((float)offU * 0.00390625f), (float)((float)offV * 0.00390625f), (float)0.0f);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179129_p();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Vec3d color = CloudRenderer.MC.field_71441_e.func_72824_f(partialTicks);
        float r = (float)color.field_72450_a;
        float g = (float)color.field_72448_b;
        float b = (float)color.field_72449_c;
        if (CloudRenderer.MC.field_71474_y.field_74337_g) {
            float tempR = r * 0.3f + g * 0.59f + b * 0.11f;
            float tempG = r * 0.3f + g * 0.7f;
            float tempB = r * 0.3f + b * 0.7f;
            r = tempR;
            g = tempG;
            b = tempB;
        }
        this.COLOR_TEX.func_110565_c()[0] = 0xFF000000 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
        this.COLOR_TEX.func_110564_a();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179144_i((int)this.COLOR_TEX.func_110552_b());
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        CloudRenderer.MC.field_71446_o.func_110577_a(TEXTURE);
        ByteBuffer buffer = Tessellator.func_178181_a().func_178180_c().func_178966_f();
        if (OpenGlHelper.func_176075_f()) {
            this.vbo.func_177359_a();
            int stride = FORMAT.func_177338_f();
            GlStateManager.func_187420_d((int)3, (int)5126, (int)stride, (int)0);
            GlStateManager.func_187410_q((int)32884);
            GlStateManager.func_187405_c((int)2, (int)5126, (int)stride, (int)12);
            GlStateManager.func_187410_q((int)32888);
            GlStateManager.func_187406_e((int)4, (int)5121, (int)stride, (int)20);
            GlStateManager.func_187410_q((int)32886);
        } else {
            buffer.limit(FORMAT.func_177338_f());
            for (i = 0; i < FORMAT.func_177345_h(); ++i) {
                ((VertexFormatElement)FORMAT.func_177343_g().get(i)).func_177375_c().preDraw(FORMAT, i, FORMAT.func_177338_f(), buffer);
            }
            buffer.position(0);
        }
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        if (OpenGlHelper.func_176075_f()) {
            this.vbo.func_177358_a(7);
        } else {
            GlStateManager.func_179148_o((int)this.displayList);
        }
        if (!CloudRenderer.MC.field_71474_y.field_74337_g) {
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        } else {
            switch (EntityRenderer.field_78515_b) {
                case 0: {
                    GlStateManager.func_179135_a((boolean)false, (boolean)true, (boolean)true, (boolean)true);
                    break;
                }
                case 1: {
                    GlStateManager.func_179135_a((boolean)true, (boolean)false, (boolean)false, (boolean)true);
                }
            }
        }
        if (OpenGlHelper.func_176075_f()) {
            this.vbo.func_177358_a(7);
        } else {
            GlStateManager.func_179148_o((int)this.displayList);
        }
        if (OpenGlHelper.func_176075_f()) {
            this.vbo.func_177361_b();
        }
        buffer.limit(0);
        for (i = 0; i < FORMAT.func_177345_h(); ++i) {
            ((VertexFormatElement)FORMAT.func_177343_g().get(i)).func_177375_c().postDraw(FORMAT, i, FORMAT.func_177338_f(), buffer);
        }
        buffer.position(0);
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    private int getScale() {
        return this.cloudMode == 2 ? 12 : 8;
    }

    private void vertices(VertexBuffer buffer) {
        boolean fancy = this.cloudMode == 2;
        float scale = this.getScale();
        float cullDist = 2.0f * scale;
        float bCol = fancy ? 0.7f : 1.0f;
        buffer.func_181668_a(7, FORMAT);
        float sectStart = -32.0f * scale;
        float sectEnd = 32.0f * scale;
        float sectStep = 8.0f * scale;
        float sectPx = 0.00390625f / scale;
        float sectX0 = sectStart;
        for (float sectX1 = sectStart + sectStep; sectX1 <= sectEnd; sectX1 += sectStep) {
            if (Float.isNaN(sectX0)) {
                sectX0 = sectX1;
                continue;
            }
            float sectZ0 = sectStart;
            for (float sectZ1 = sectStart + sectStep; sectZ1 <= sectEnd; sectZ1 += sectStep) {
                float u0 = sectX0 * sectPx;
                float u1 = sectX1 * sectPx;
                float v0 = sectZ0 * sectPx;
                float v1 = sectZ1 * sectPx;
                buffer.func_181662_b((double)sectX0, 0.0, (double)sectZ0).func_187315_a((double)u0, (double)v0).func_181666_a(bCol, bCol, bCol, 0.8f).func_181675_d();
                buffer.func_181662_b((double)sectX1, 0.0, (double)sectZ0).func_187315_a((double)u1, (double)v0).func_181666_a(bCol, bCol, bCol, 0.8f).func_181675_d();
                buffer.func_181662_b((double)sectX1, 0.0, (double)sectZ1).func_187315_a((double)u1, (double)v1).func_181666_a(bCol, bCol, bCol, 0.8f).func_181675_d();
                buffer.func_181662_b((double)sectX0, 0.0, (double)sectZ1).func_187315_a((double)u0, (double)v1).func_181666_a(bCol, bCol, bCol, 0.8f).func_181675_d();
                if (fancy) {
                    float sliceCoord1;
                    float sliceCoord0;
                    buffer.func_181662_b((double)sectX0, 4.0, (double)sectZ0).func_187315_a((double)u0, (double)v0).func_181666_a(1.0f, 1.0f, 1.0f, 0.8f).func_181675_d();
                    buffer.func_181662_b((double)sectX0, 4.0, (double)sectZ1).func_187315_a((double)u0, (double)v1).func_181666_a(1.0f, 1.0f, 1.0f, 0.8f).func_181675_d();
                    buffer.func_181662_b((double)sectX1, 4.0, (double)sectZ1).func_187315_a((double)u1, (double)v1).func_181666_a(1.0f, 1.0f, 1.0f, 0.8f).func_181675_d();
                    buffer.func_181662_b((double)sectX1, 4.0, (double)sectZ0).func_187315_a((double)u1, (double)v0).func_181666_a(1.0f, 1.0f, 1.0f, 0.8f).func_181675_d();
                    float slice = sectX0;
                    while (slice < sectX1) {
                        sliceCoord0 = slice * sectPx;
                        sliceCoord1 = sliceCoord0 + 0.00390625f;
                        if (slice > -cullDist) {
                            buffer.func_181662_b((double)(slice += 0.001f), 0.0, (double)sectZ1).func_187315_a((double)sliceCoord0, (double)v1).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                            buffer.func_181662_b((double)slice, 4.0, (double)sectZ1).func_187315_a((double)sliceCoord1, (double)v1).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                            buffer.func_181662_b((double)slice, 4.0, (double)sectZ0).func_187315_a((double)sliceCoord1, (double)v0).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                            buffer.func_181662_b((double)slice, 0.0, (double)sectZ0).func_187315_a((double)sliceCoord0, (double)v0).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                            slice -= 0.001f;
                        }
                        if (!((slice += scale) <= cullDist)) continue;
                        buffer.func_181662_b((double)(slice -= 0.001f), 0.0, (double)sectZ0).func_187315_a((double)sliceCoord0, (double)v0).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                        buffer.func_181662_b((double)slice, 4.0, (double)sectZ0).func_187315_a((double)sliceCoord1, (double)v0).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                        buffer.func_181662_b((double)slice, 4.0, (double)sectZ1).func_187315_a((double)sliceCoord1, (double)v1).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                        buffer.func_181662_b((double)slice, 0.0, (double)sectZ1).func_187315_a((double)sliceCoord0, (double)v1).func_181666_a(0.9f, 0.9f, 0.9f, 0.8f).func_181675_d();
                        slice += 0.001f;
                    }
                    slice = sectZ0;
                    while (slice < sectZ1) {
                        sliceCoord0 = slice * sectPx;
                        sliceCoord1 = sliceCoord0 + 0.00390625f;
                        if (slice > -cullDist) {
                            buffer.func_181662_b((double)sectX0, 0.0, (double)(slice += 0.001f)).func_187315_a((double)u0, (double)sliceCoord0).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                            buffer.func_181662_b((double)sectX0, 4.0, (double)slice).func_187315_a((double)u0, (double)sliceCoord1).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                            buffer.func_181662_b((double)sectX1, 4.0, (double)slice).func_187315_a((double)u1, (double)sliceCoord1).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                            buffer.func_181662_b((double)sectX1, 0.0, (double)slice).func_187315_a((double)u1, (double)sliceCoord0).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                            slice -= 0.001f;
                        }
                        if (!((slice += scale) <= cullDist)) continue;
                        buffer.func_181662_b((double)sectX1, 0.0, (double)(slice -= 0.001f)).func_187315_a((double)u1, (double)sliceCoord0).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                        buffer.func_181662_b((double)sectX1, 4.0, (double)slice).func_187315_a((double)u1, (double)sliceCoord1).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                        buffer.func_181662_b((double)sectX0, 4.0, (double)slice).func_187315_a((double)u0, (double)sliceCoord1).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                        buffer.func_181662_b((double)sectX0, 0.0, (double)slice).func_187315_a((double)u0, (double)sliceCoord0).func_181666_a(0.8f, 0.8f, 0.8f, 0.8f).func_181675_d();
                        slice += 0.001f;
                    }
                }
                sectZ0 = sectZ1;
            }
            sectX0 = sectX1;
        }
    }

    private void rebuild() {
        if (this.vbo != null) {
            this.vbo.func_177362_c();
        }
        if (this.displayList >= 0) {
            GLAllocation.func_74523_b((int)this.displayList);
            this.displayList = -1;
        }
        if (CloudRenderer.MC.field_71474_y.func_181147_e() != 0) {
            Tessellator tess = Tessellator.func_178181_a();
            VertexBuffer buffer = tess.func_178180_c();
            if (OpenGlHelper.func_176075_f()) {
                this.vbo = new net.minecraft.client.renderer.vertex.VertexBuffer(FORMAT);
            } else {
                this.displayList = GLAllocation.func_74526_a((int)1);
                GlStateManager.func_187423_f((int)this.displayList, (int)4864);
            }
            this.vertices(buffer);
            if (OpenGlHelper.func_176075_f()) {
                buffer.func_178977_d();
                buffer.func_178965_a();
                this.vbo.func_181722_a(buffer.func_178966_f());
            } else {
                tess.func_78381_a();
                GlStateManager.func_187415_K();
            }
        }
    }

    private int fullCoord(double coord, int scale) {
        return (int)coord / scale - (coord < 0.0 ? 1 : 0);
    }

    private void reloadTextures() {
        CloudRenderer.MC.field_71446_o.func_110577_a(TEXTURE);
        this.texW = GlStateManager.func_187411_c((int)3553, (int)0, (int)4096);
        this.texH = GlStateManager.func_187411_c((int)3553, (int)0, (int)4097);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        this.reloadTextures();
    }

    static {
        TEXTURE = new ResourceLocation("textures/environment/clouds.png");
    }
}

