/*
 * Decompiled with CFR 0.152.
 */
package org.epoxide.surge.features;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.epoxide.surge.client.ProxyClient;
import org.epoxide.surge.features.Feature;
import org.epoxide.surge.features.loadtime.FeatureLoadTimes;
import org.epoxide.surge.features.pigsleep.FeaturePigmanSleep;
import org.epoxide.surge.handler.ConfigurationHandler;

public class FeatureManager {
    public static final List<Feature> FEATURES = new ArrayList<Feature>();

    public static void initFeatures() {
        if (FMLCommonHandler.instance().getSidedDelegate() != null && FMLCommonHandler.instance().getSide().isClient()) {
            ProxyClient.registerClient();
        }
        FeatureManager.registerFeature(new FeatureLoadTimes(), "Load Time Analysis", "Records the load time of all mods being loaded.");
        FeatureManager.registerFeature(new FeaturePigmanSleep(), "Pigman Sleep", "Allow the player to sleep while pigman are around, unless angered");
    }

    public static void registerFeature(Feature feature, String name, String description) {
        for (Feature ff : FEATURES) {
            if (feature.getClass() != ff.getClass()) continue;
            return;
        }
        boolean bl = feature.enabled = ConfigurationHandler.isFeatureEnabled(feature, name, description) && (!feature.disableWithOptifine() || feature.disableWithOptifine() && !FMLClientHandler.instance().hasOptifine());
        if (feature.enabled) {
            feature.configName = name.toLowerCase().replace(' ', '_');
            FEATURES.add(feature);
        }
    }

    public static Feature getFeature(Class<? extends Feature> f) {
        for (Feature feature : FEATURES) {
            if (feature.getClass() != f) continue;
            return feature;
        }
        ConfigurationHandler.initConfig(new File("config/surge.cfg"));
        FeatureManager.initFeatures();
        ConfigurationHandler.syncConfig();
        for (Feature feature : FEATURES) {
            if (feature.getClass() != f) continue;
            return feature;
        }
        return null;
    }

    public static boolean isEnabled(Feature f) {
        return f != null && f.enabled && (!f.disableWithOptifine() || f.disableWithOptifine() && !FMLClientHandler.instance().hasOptifine());
    }
}

