/*
 * Decompiled with CFR 0.152.
 */
package org.epoxide.surge.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.client.FMLClientHandler;
import org.epoxide.surge.asm.ASMUtils;
import org.epoxide.surge.features.Feature;
import org.epoxide.surge.features.FeatureManager;
import org.epoxide.surge.features.animation.FeatureDisableAnimation;
import org.epoxide.surge.features.fatalmodelload.FeatureFatalModelLoading;
import org.epoxide.surge.features.loadtime.FeatureLoadTimes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class SurgeTransformerManager
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] classBytes) {
        Feature f;
        if (transformedName.equals("net.minecraft.client.renderer.texture.TextureAtlasSprite") && !FMLClientHandler.instance().hasOptifine() && FeatureManager.isEnabled(f = FeatureManager.getFeature(FeatureDisableAnimation.class))) {
            ClassNode clazz = ASMUtils.createClassFromByteArray(classBytes);
            this.transformUpdateAnimation(ASMUtils.getMethodFromClass(clazz, ASMUtils.isSrg ? "func_94219_l" : "updateAnimation", "()V"));
            return ASMUtils.createByteArrayFromClass(clazz, 1);
        }
        if (transformedName.equals("net.minecraftforge.fml.common.LoadController") && FeatureManager.isEnabled(f = FeatureManager.getFeature(FeatureLoadTimes.class))) {
            ClassNode clazz = ASMUtils.createClassFromByteArray(classBytes);
            this.transformSendEventToModContainer(ASMUtils.getMethodFromClass(clazz, "sendEventToModContainer", "(Lnet/minecraftforge/fml/common/event/FMLEvent;Lnet/minecraftforge/fml/common/ModContainer;)V"));
            return ASMUtils.createByteArrayFromClass(clazz, 1);
        }
        if (transformedName.equals("net.minecraftforge.client.model.ModelLoader") && FeatureManager.isEnabled(f = FeatureManager.getFeature(FeatureFatalModelLoading.class))) {
            ClassNode clazz = ASMUtils.createClassFromByteArray(classBytes);
            this.transformSetupModelRegistry(ASMUtils.getMethodFromClass(clazz, "setupModelRegistry", "()Lnet/minecraft/util/registry/IRegistry;"));
            return ASMUtils.createByteArrayFromClass(clazz, 1);
        }
        return classBytes;
    }

    private void transformSetupModelRegistry(MethodNode method) {
        InsnList i = new InsnList();
        LabelNode l0 = new LabelNode();
        i.add((AbstractInsnNode)l0);
        i.add((AbstractInsnNode)new MethodInsnNode(184, "org/epoxide/surge/features/fatalmodelload/FeatureFatalModelLoading", "areModsMissing", "()Z", false));
        LabelNode l1 = new LabelNode();
        i.add((AbstractInsnNode)new JumpInsnNode(153, l1));
        LabelNode l2 = new LabelNode();
        i.add((AbstractInsnNode)l2);
        i.add((AbstractInsnNode)new VarInsnNode(25, 0));
        i.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/client/model/ModelLoader", "bakedRegistry", "Lnet/minecraft/util/registry/RegistrySimple;"));
        i.add((AbstractInsnNode)new InsnNode(176));
        i.add((AbstractInsnNode)l1);
        method.instructions.insertBefore(method.instructions.getFirst(), i);
    }

    private void transformUpdateAnimation(MethodNode method) {
        InsnList newInstr = new InsnList();
        newInstr.add((AbstractInsnNode)new MethodInsnNode(184, "org/epoxide/surge/features/animation/FeatureDisableAnimation", "animationDisabled", "()Z", false));
        LabelNode L1 = new LabelNode();
        newInstr.add((AbstractInsnNode)new JumpInsnNode(153, L1));
        newInstr.add((AbstractInsnNode)new LabelNode());
        newInstr.add((AbstractInsnNode)new InsnNode(177));
        newInstr.add((AbstractInsnNode)L1);
        method.instructions.insert(method.instructions.getFirst().getNext().getNext(), newInstr);
    }

    private void transformSendEventToModContainer(MethodNode method) {
        InsnList needle = new InsnList();
        needle.add((AbstractInsnNode)new LdcInsnNode((Object)"Sending event %s to mod %s"));
        needle.add((AbstractInsnNode)new InsnNode(5));
        needle.add((AbstractInsnNode)new TypeInsnNode(189, "java/lang/Object"));
        needle.add((AbstractInsnNode)new InsnNode(89));
        needle.add((AbstractInsnNode)new InsnNode(3));
        needle.add((AbstractInsnNode)new VarInsnNode(25, 1));
        needle.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/fml/common/event/FMLEvent", "getEventType", "()Ljava/lang/String;", false));
        needle.add((AbstractInsnNode)new InsnNode(83));
        needle.add((AbstractInsnNode)new InsnNode(89));
        needle.add((AbstractInsnNode)new InsnNode(4));
        needle.add((AbstractInsnNode)new VarInsnNode(25, 3));
        needle.add((AbstractInsnNode)new InsnNode(83));
        needle.add((AbstractInsnNode)new MethodInsnNode(184, "net/minecraftforge/fml/common/FMLLog", "log", "(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Ljava/lang/String;[Ljava/lang/Object;)V", false));
        needle.add((AbstractInsnNode)new LabelNode());
        needle.add((AbstractInsnNode)new LineNumberNode(-1, new LabelNode()));
        AbstractInsnNode pointer = ASMUtils.findLastNodeFromNeedle(method.instructions, needle);
        InsnList newInstr = new InsnList();
        newInstr.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/System", "currentTimeMillis", "()J", false));
        newInstr.add((AbstractInsnNode)new VarInsnNode(55, 5));
        newInstr.add((AbstractInsnNode)new LabelNode());
        method.instructions.insert(pointer, newInstr);
        needle = new InsnList();
        needle.add((AbstractInsnNode)new MethodInsnNode(182, "com/google/common/eventbus/EventBus", "post", "(Ljava/lang/Object;)V", false));
        pointer = ASMUtils.findFirstNodeFromNeedle(method.instructions, needle);
        newInstr = new InsnList();
        newInstr.add((AbstractInsnNode)new LabelNode());
        newInstr.add((AbstractInsnNode)new MethodInsnNode(184, "java/lang/System", "currentTimeMillis", "()J", false));
        newInstr.add((AbstractInsnNode)new VarInsnNode(55, 7));
        newInstr.add((AbstractInsnNode)new LabelNode());
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 2));
        newInstr.add((AbstractInsnNode)new VarInsnNode(25, 1));
        newInstr.add((AbstractInsnNode)new VarInsnNode(22, 5));
        newInstr.add((AbstractInsnNode)new VarInsnNode(22, 7));
        newInstr.add((AbstractInsnNode)new MethodInsnNode(184, "org/epoxide/surge/features/loadtime/FeatureLoadTimes", "registerLoadingTime", "(Lnet/minecraftforge/fml/common/ModContainer;Lnet/minecraftforge/fml/common/event/FMLEvent;JJ)V", false));
        newInstr.add((AbstractInsnNode)new LabelNode());
        method.instructions.insert(pointer, newInstr);
    }
}

