// (c) 2007, Uncle MiF
// All rights reserved

var content;
var currentDictionary;// text label on front side
var activeDictionary;// active dictionary name
var search;
var dictionaries;
var version;

// internal
var verbose = 0;

var opacity;
var history;
var curIdx = -1;

function setupOutlets()
{
	content = document.getElementById('content');
	currentDictionary = document.getElementById('currentDictionary');
	search = document.getElementById('searchfield');
	dictionaries = document.getElementById('popup');
	version = document.getElementById('version');
}

function trunc(str)
{
	return str;
}

function createkey(key)
{
 return createInstancePreferenceKey(key); 
}

function dictionary(dName, alias, selected)
{
	var d = document.createElement('option');
	d.setAttribute('apple-group','popup');
	d.setAttribute('value',dName);
	if (dName == selected)
		d.setAttribute('selected',true);
	d.innerHTML = alias;
	return d;
}

function load()
{
	setupParts();
	setupOutlets();
	opacity = content.style.opacity;
	content.style.opacity = 0;
	search.setAttribute('placeholder',getLocalizedString('Lookup Word'));
	if (window.MDictPlugin)
	{
		version.innerHTML = getLocalizedString('ver') + ' ' + MDictPlugin.widgetVersion();
		var ads = MDictPlugin.availableDictionaries();
		var i;
		if (window.widget)
		{
			activeDictionary = widget.preferenceForKey(createkey('activeDictionary'));
			if (activeDictionary)
			{
				currentDictionary.innerHTML = trunc(MDictPlugin.dictionaryAlias(activeDictionary));
			}
		}
		for (i = 0; i < ads.length; i++)
		{
			var dName = ads[i].replace(/\.dict$/i,''); 
			dictionaries.appendChild(dictionary(dName,MDictPlugin.dictionaryAlias(dName),activeDictionary));
		}
	}
}

function dictionaryChanged()
{
	activeDictionary = dictionaries.options[dictionaries.selectedIndex].value;
	if (window.MDictPlugin)
		currentDictionary.innerHTML = trunc(MDictPlugin.dictionaryAlias(activeDictionary));
	if (window.widget)
		widget.setPreferenceForKey(activeDictionary,createkey('activeDictionary'));
	translate();
}

function addHistory(word)
{
	if (!history)
		history = new Array();
	if (curWord() == word)
		return;
	if (curIdx != -1 && curIdx < history.length)
		history = history.splice(0,curIdx+1);
	history.push(word);
	curIdx = history.length - 1;
	if (verbose) alert('addHistory(): '+word+', count: '+history.length+', curIdx = '+curIdx);
}

function curWord()
{
	if (!history || !history.length || curIdx >= history.length)
		return '';
	if (verbose) alert('curWord(): '+history[curIdx]+', curIdx = '+curIdx);
	return history[curIdx];
}

function prevWord()
{
	if (!history || !history.length)
		return '';
	curIdx--;
	if (curIdx < 0)
		curIdx = 0;
	if (verbose) alert('prevWord(): '+history[curIdx]+', curIdx = '+curIdx);
	search.value = history[curIdx];
	search.focus();
	translate();
}

function nextWord()
{
	if (!history || !history.length)
		return '';
	curIdx++;
	if (curIdx >= history.length)
		curIdx = history.length - 1;
	if (verbose) alert('nextWord(): '+history[curIdx]);
	search.value = history[curIdx];
	search.focus();
	translate();
}

function translate()
{
	if (window.MDictPlugin && activeDictionary)
		content.innerHTML = MDictPlugin.translateWord(search.value, activeDictionary);
	if (content.innerHTML)
	{
		content.style.opacity = opacity;
		addHistory(search.value);
	}
	else
		content.style.opacity = 0;
	search.focus();
}

function remove()
{
	widget.setPreferenceForKey(null, createkey('activeDictionary'));
}

function hide()
{
	// your widget has just been hidden stop any timers to
	// prevent cpu usage
}

function show()
{
	// your widget has just been shown.  restart any timers
	// and adjust your interface as needed
}

function showBack(event)
{
	// your widget needs to show the back

	var front = document.getElementById("front");
	var back = document.getElementById("back");

	if (window.widget)
		widget.prepareForTransition("ToBack");

	front.style.display="none";
	back.style.display="block";
	
	if (window.widget)
		setTimeout('widget.performTransition();', 0);
	dictionaries.focus();
}

function showFront(event)
{
	// your widget needs to show the front

	var front = document.getElementById("front");
	var back = document.getElementById("back");

	if (window.widget)
		widget.prepareForTransition("ToFront");

	front.style.display="block";
	back.style.display="none";
	
	if (window.widget)
		setTimeout('widget.performTransition();', 0);
	
	search.focus();
}

if (window.widget)
{
	widget.onremove = remove;
	widget.onhide = hide;
	widget.onshow = show;
}


function onMDictButtonClick(event) 
{
	if (window.widget)
		widget.openApplication('com.MiF.MDict');
}


function onMiFClick(event) 
{
	if (window.widget)
		widget.openURL('http://mif.polimercolor.ru/mdict/');
}

