#!/usr/bin/env perl
# (c) Uncle MiF, 2006. alexey@mitme.ru

require 5.8.0;
use strict;

my $esc = ' &"\'';

our $modules;
BEGIN
{ 
 select STDIN;
 $| = 1;
 select STDOUT;
 $| = 1;
 $modules = __FILE__;
	$modules = '.' if ($modules !~ /\//);
 $modules =~ s/\/[^\/]*$//gos;
 eval "use lib qw($modules/.);";
}
use lib qw(.);
use localization::localization;

$| = 1;
my $dname = $ARGV[0];
my $out = $ARGV[1];

my $silent = $ARGV[2];
$silent ||= 0;
$silent = ($silent =~ /^silent$/i) ? 1 : 0;

my $verPath = $0;
$verPath =~ s/\/[^\/]*$//gos;
$verPath .= '/version';
$verPath =~ s/([$esc])/\\$1/gos;
my $ver = `cat $verPath`;
$ver =~ s/\s+$//gos;

print "\n";
print _L("(c) MiF, MDict, StarDict tabs-dictionary file parser version %#.\n\n",$ver);
unless($dname)
{
	print _L("Usage: %# <dictFile> [<outDir>]\n",$0);
	print _L("\nExample: %# mlr24.tab mlr24dict\n\n",$0);
	exit(1);
}
unless(-f $dname)
{
	print _L("File not found: %#\n",$dname);
	exit(2);
}

my $lastPathComponent = $dname;
$lastPathComponent =~ s/\.tab$//i;
$lastPathComponent =~ s/^.*\///gos;
if (!$lastPathComponent || $lastPathComponent =~ /^\.+$/)
{
	 print _L("Can't parse properly dictionary path\n");
		 exit(20);
}

$out ||= './Unpacked Dictionaries/';

$out .= '/' if ($out !~ /\/$/);
$out .= $lastPathComponent;

print _L("Parsing '%#' to directory '%#'\n",$dname,$out);

if (-d $out || -f $out)
{
	print _L("Directory/file '%#' already exists. Remove now [N/yes]? ",$out);
	my $answer = <STDIN>;
	$answer =~ s/\s+$//gos;
	if ($answer !~ /^yes$/i)
	{
		print _L("User canceled (you must type YES to continue)...\n");
		exit(3);
	}
}

my $sout = $out;
$sout =~ s/([$esc])/\\$1/gos;
`rm -rf $sout; mkdir -p $sout`;

my $words = "$out/Words";
my $replacements = "$out/Replacements";

print _L("Words directory will be: %#\n",$words);
print _L("Replacements directory will be: %#\n",$replacements);

my ($swords, $sreplacements) = ($words, $replacements);

$swords =~ s/([$esc])/\\$1/gos;
$sreplacements =~ s/([$esc])/\\$1/gos;

`mkdir $swords; mkdir $sreplacements;`;

print _L("Processing dictionary file...\n");

local * DICT;

my $ok = 1;
open (DICT, "<$dname") or $ok = 0;
unless($ok)
{
	print _L("Can't open %# for reading", $dname);
	exit(4);
}

my $lnum = 0;
foreach my $line (<DICT>)
{
	$lnum++;
	if ($line =~ /^(.+?)(?:  |\t)(.*)/)
	{
		my ($word, $article) = ($1, $2);
		$word =~ s/^\s+//gos;
		$word =~ s/\s+$//gos;
		next unless (length($word));
		$article =~ s/\\n/\n/gos;
		$article =~ s/\\\\/\\/gos;
		$article =~ s /\b(\d+|[a-oа-о])[>\.]/\n$1./gos;
		$article =~ s /_(I|II|III|IV|V|VI|VII|VIII|IX)/\n$1./gos;
		local * ART;
		my $ok = 1;
 	open (ART, ">$words/$word-$lnum.txt") or $ok = 0;
		if ($ok)
		{
			print ART $article;
			close(ART);
		}
		else
		{
			$ok = 1;
			open (ART, ">$replacements/_REPLACEMENT_$lnum.txt") or $ok = 0;
			if ($ok)
			{
				print _L("Using replacement file for word '%#'\n",$word);
				print ART $word;
				close(ART);
				$ok = 1;
				open (ART, ">$words/_REPLACEMENT_$lnum.txt") or $ok = 0;
				if ($ok)
				{
					print ART $article;
					close(ART);
				}
				else
				{
					print L("Failed: Something wrong with word '%#' and replacement _REPLACEMENT_%#\n", $word, $lnum);
				}
			}
			else
			{
				print _L("Can't write article to file '%#'\n",$word);
			}
		}
	}
	else
	{
		print _L("Bad line %#: %#\n", $lnum, $line);
	}
}

close(DICT);

print _L("Total words processed: %#\n",$lnum);
print _L("Done\n");
system("open $sout") unless ($silent);
