//
//  MAnimation.h
//  MDict
//
//  Created by MiF on 08.02.07.
//  Copyright 2007 MiF. All rights reserved.
// Simple NSAnimation emulation fake for Panther support

#import <Cocoa/Cocoa.h>


@interface MAnimation : NSObject
{
	id delegate;
	
	NSTimeInterval curDuration;
	NSTimeInterval rate;
	NSTimeInterval timeStep;
	NSDate * animationStart;
	NSTimeInterval animationDuration;
	NSAnimationProgress currentProgress;
	NSAnimationBlockingMode blockingMode;
	
	NSAnimationCurve curve;
}

-	(id)initWithDuration:(NSTimeInterval)duration animationCurve:(NSAnimationCurve)animationCurve;

- (void)setDelegate:(id)aDelegate;
- (id)delegate;

- (void)setFrameRate:(NSTimeInterval)aRate;
- (NSTimeInterval)frameRate;

- (void)reset;
- (void)startAnimation;
- (void)stopAnimation;
- (NSAnimationProgress)currentValue;
- (void)setCurrentProgress:(NSAnimationProgress)progress;

-(void)setAnimationBlockingMode:(NSAnimationBlockingMode)animationBlockingMode;
-(NSAnimationBlockingMode)animationBlockingMode;

-(void)dealloc;

@end
