(function($){
	
	function UpdatePopup(container, option) {
		var defaultOption = {
			isforce: false,
			version: "1.0.0",
			content: "11111\n22222\n33333\n44444\n55555",
			onsubmit: function() {}
		};
		var newoption = $.extend({}, defaultOption, option);
		
		var popup = $('<div class="update-container">' +
							'<div class="update">' +
								'<div class="update-header">' +
									'<h1>更新内容</h1>' +
									'<div class="update-close" id="close"></div>' +
								'</div>' +
								'<div class="update-body">' +
									'<div class="update-content">' +
										'<p>更新版本：<span id="version">1.1.1</span></p>' +
										'<p id="content"></p>' +
									'</div>' +
									'<div class="update-progressbar" id="progressbar">' +
										'<div class="progress-track" id="track"></div>' +
										'<div class="progress-ratio" id="ratio">0%</div>' +
									'</div>' +
								'</div>' +
								'<div class="update-footer">' +
									'<div class="update-button" id="submit">更新</div>' +
								'</div>' +
							'</div>' +
						'</div>');
		$(container).append(popup);
		
		$(".update-container #close").addClass(newoption.isforce == 1 ? "isforce" : "");
		$(".update-container #version").text(newoption.version);
		var contentArr = newoption.content.split("\\n");
		$(".update-container #content").html(contentArr.join("<br />"));
		
		$(".update-container #track").width(0);
		$(".update-container #ratio").html("0%");
		
		$(".update-container #close").on("click", function() {
			popup.remove();
		});
		$(".update-container #submit").on("click", function() {
			if ($(this).hasClass("updating")) {
				return;
			}
			$(this).addClass("updating");
			$(this).text("更新中...");
			$(".update-container #progressbar").show();
			$(".update-container #close").addClass("isforce");
			newoption.onsubmit();
		});
		
		this.setRatio = function(ratio) {
			var r = Math.floor(ratio || 0) + "%";
			$(".update-container #track").width(r);
			$(".update-container #ratio").html(r);
		}
		
		this.complete = function() {
			$(".update-container #close").trigger("click");
		}
	}
	
	$.fn.updatepopup = function(option) {
		return this.each(function() {
			var udpopup = new UpdatePopup(this, option);
			$(this).data("update-popup", udpopup);
		});
	}
	
	
})(jQuery);
