(function($) {
	
	$.fn.examplayer = function(option) {
		return this.each(function(i) {
			var player = new ExamPlayer(this, option);
			$(this).data("examplayer", player);
		});
	}
	
	
	
	
	var ExamPlayer = function(container, option) {
		var defaultOption = {
			
		};
		this.container = container;
		this.newOption = $.extend({}, defaultOption, option);
		this.duration = 0;
		this.currentTime = 0;
		
		var player = $('<div class="exam-player">' +
							'<div class="exam-progressbar"></div>' +
							'<div class="exam-start-btn disabled"></div>' +
							'<div class="exam-time">' +
								'<span class="exam-current-time">00:00</span> /<span class="exam-duration-time">00:00</span>' +
							'</div>' +
							'<audio hidden="hidden" class="exam-audio" />' +
						'</div>');
		
		$(this.container).append(player);
		
		$(this.container).find(".exam-progressbar").progressbar({
			onProgress: progressRatio
		});
		
		this.progressbar = $(this.container).find(".exam-progressbar").data("progressbar");
		$(this.progressbar).bind("changed", {instance: this}, function(e, ratio) {
			e.data.instance.examAudio.currentTime = e.data.instance.examAudio.duration * ratio;
		});
		$(this.progressbar).bind("finished", {instance: this}, function(e) {
			e.data.instance.reset();
			$(e.data.instance).trigger("examFinish");
		});
		
		this.examAudio = $(this.container).find(".exam-audio").get(0);
		$(this.examAudio).bind("canplaythrough", {instance: this}, function(e) {
			$(e.data.instance.container).find(".exam-start-btn").removeClass("disabled");
			e.data.instance.progressbar.canDrag = true;
		});
		$(this.examAudio).bind("loadedmetadata", {instance: this}, function(e) {
			$(e.data.instance.container).find(".exam-duration-time").text(formatPlayTime($(this).get(0).duration));
		});
		
		$(this.container).find(".exam-start-btn").click({instance: this}, function(e) {
			if ($(this).hasClass("disabled")) {
				return;
			}
			$(this).toggleClass("selected");
			if ($(this).hasClass("selected")) {
				e.data.instance.playAudio();
				e.data.instance.progressbar.start();
				$(e.data.instance).trigger("examStart");
			} else {
				e.data.instance.pauseAudio();
				e.data.instance.progressbar.pause();
				$(e.data.instance).trigger("examPause");
			}
		});
		
		this.loadAudio = function(url) {
			$(this.examAudio).attr("src", url);
		}
		
		this.playAudio = function() {
			this.examAudio.play();
		}
		
		this.pauseAudio = function() {
			this.examAudio.pause();
		}
		
		this.stopAudio = function() {
			this.examAudio.pause();
			this.examAudio.currentTime = 0;
		}
		
		this.clearAudio = function() {
			$(this.examAudio).attr("src", null);
		}
		
		var ins = this;
		function progressRatio() {
			$(ins.container).find(".exam-current-time").text(formatPlayTime(ins.examAudio.currentTime));
			if (isNaN(ins.examAudio.duration) || ins.examAudio.duration == 0) {
				return 0;
			}
			return ins.examAudio.currentTime / ins.examAudio.duration;
		}
		
		function formatPlayTime(sec) {
			var second = Math.round(sec);
			var mm = Math.floor(second / 60);
			mm = mm < 10 ? "0" + mm : mm;
			var ss = second % 60;
			ss = ss < 10 ? "0" + ss : ss;
			return mm + ":" + ss;
		}
	}
	
	ExamPlayer.prototype = {
		load: function(mp3url) {
			this.clear();
			this.loadAudio(mp3url);
		},
		clear: function() {
			this.reset();
			$(this.container).find(".exam-duration-time").text("00:00");
			$(this.container).find(".exam-start-btn").addClass("disabled");
		},
		reset: function() {
			this.stopAudio();
			this.progressbar.clear();
			$(this.container).find(".exam-current-time").text("00:00");
			$(this.container).find(".exam-start-btn").removeClass("selected");
		}
	};
	
	
	
	
	
	
	
	
	
	
	
	$.fn.progressbar = function(option) {
		return this.each(function(i) {
			var bar = new Progressbar(this, option);
			$(this).data("progressbar", bar);
		});
	}
	
	var Progressbar = function(container, option) {
		var defaultOption = {
			width: "100%",
			height: "8px",
			trackColor: "#FFFFFF",
			thumbColor: "#0000FF",
			interval: 100,
			canDrag: false,
			onProgress: function() { return 0; }
		};
		
		this.container = container;
		this.newOption = $.extend({}, defaultOption, option || {});
		this.canDrag = this.newOption.canDrag;
		this.isRunning = false;
		this.timer;
		
		this.track = $("<div></div>").css({
			"width": this.newOption.width, 
			"height": this.newOption.height,
			"background-color": this.newOption.trackColor,
			"position": "relative"
		});
		$(this.container).append(this.track);
		
		this.thumb = $("<div></div>").css({
			"width": "0",
			"height": this.newOption.height,
			"background-color": this.newOption.thumbColor,
			"position": "absolute",
			"top": "0",
			"left": "0"
		});
		this.track.append(this.thumb);
		
		this.track.click({instance: this}, function(e) {
			if (!e.data.instance.canDrag) {
				return;
			}
			e.data.instance.thumb.width(e.offsetX);
//			var running = e.data.instance.isRunning;
//			e.data.instance.pause();
			$(e.data.instance).trigger("changed", [e.data.instance.thumb.width() / e.data.instance.track.width()])
//			if (running) {
//				e.data.instance.start();
//			}
		});
		
	}
	
	Progressbar.prototype = {
		start: function() {
			this.isRunning = true;
			var instance = this;
			
			this.timer = setInterval(function() {
				var value = instance.newOption.onProgress();
				value = Number(value.toFixed(2));
				instance.thumb.width(value * instance.track.width());
				
				if (instance.thumb.width() >= instance.track.width()) {
					instance.pause();
					instance.thumb.width(instance.track.width());
					$(instance).trigger("finished");
				}
				
			}, instance.newOption.interval);
		},
		pause: function() {
			this.isRunning = false;
			clearInterval(this.timer);
		},
		clear: function() {
			this.isRunning = false;
			this.canDrag = false;
			clearInterval(this.timer);
			this.thumb.width(0);
		}
	}
	
	
})(jQuery);
