(function($){
	
	function DownTaskPopup(opt) {
		
		this.option = opt;
		
		var popup = $('<div class="popup-container">' + 
						'<div class="popup">' +
							'<div class="popup-header">' +
								'<h1>下载任务列表</h1>' +
								'<div class="popup-close" id="closeButton"></div>' +
							'</div>' +
							'<div class="popup-body">' +
								'<div class="download-list" id="downloadList">' +
								'</div>' +
							'</div>' +
							'<div class="popup-footer">' +
								'<div class="popup-footer-offline-path">' +
									'<div class="offline-path">保存到：<input type="text" readonly="readonly" id="offlinepath" value="dkfjskdfjksdjflsdjflk" /></div>' +
									'<div class="offline-reset" id="offlineReset">重新设置</div>' +
								'</div>' +
								'<div class="popup-prompt">*每节课都需创建新目录存资源,推荐目录使用“班级名称+日期”的格式命名。例如：初2013级三年十四班0628</div>' +
								'<div class="popup-footer-button" id="deleteList">清空列表</div>' +
								'<div class="popup-footer-button" id="downloadAll">全部下载</div>' +
//								'<div class="popup-footer-button" id="deleteListAndFile">删除下载列表和文件</div>' +
							'</div>' + 
						'</div>' + 
					'</div>').hide();
		$("body").append(popup);
		
		$("#downloadList").on("click", ".right-delete", {opt: this.option}, function(e){
			var x = e.pageX - $(this).offset().left;
		    var y = e.pageY - $(this).offset().top;
		    var w = $(this).innerWidth();
		    var h = $(this).innerHeight();
		    if (y > ((h - 20) / 2) && y < ((h + 20) / 2) && x > w - 20) {
		    	e.data.opt.ondelete($(this).attr("type"), $(this).attr("fileid"));
		    }
		});
		
		$(".popup .popup-footer #downloadAll").click({opt: this.option}, function(e) {
			if ($(this).attr("state") == "0") {
				return;
			}
			e.data.opt.ondownload();
		});
		
		$(".popup .popup-footer #offlineReset").click({opt: this.option}, function(e) {
			e.data.opt.onOfflineReset();
		});
		
		$(".popup .popup-footer #deleteList").click({opt: this.option}, function(e) {
			e.data.opt.ondeleteAll();
		});
		
//		$(".popup .popup-footer #deleteListAndFile").click({opt: this.option}, function(e) {
//			e.data.opt.ondeleteAllFile();
//		});
		
		$(".popup .popup-close").click({instance: this}, function(e) {
			e.data.instance.hide();
		});
		
		if (!this.option.config || this.option.config == "") {
			return;
		}
		$.ajax({
			type: "get",
			url: "file://" + this.option.config,
			async: true,
			dataType: "xml",
			cache: false,
			success: function(xmlData) {
				addDownloadList(xmlData);
			},
			error: function(a,b,c) {
				alert("未找到XML配置文件！");
			}
		});
		
		/** 添加下载列表 */
		function addDownloadList(data) {
			$(data).find("file").each(function(i){
				var itemdata = new ItemData($(this), $(this).attr("type"));
				var item = $("<div></div>").addClass("download-item right-delete").attr("state", 1);
				var itemname = $("<div></div>").addClass("download-name").text(itemdata.property("name"));
				var itempro = $("<div></div>").addClass("download-progress").text("");
				item.append(itemname);
				item.append(itempro);
				if (itemdata.property("status") != 4) {
					itemdata.setProperty("status", 0);
				}
				itemdata.giveTo(item);
				if (itemdata.property("path") == "" || itemdata.property("url") == "" || itemdata.property("filename") == "") {
					item.attr("state", 2);
				}
				$(".popup #downloadList").append(item);
			});
		}
	}
	
	DownTaskPopup.prototype = {
		show: function() {
			this.checkAllState();
			$(".popup-container").show();
		},
		hide: function() {
			$(".popup-container").hide();
		},
		changeStatus: function(type, fid, property, phase) {
			var currentItem = $(".download-item[type='" + type + "'][fileid='" + fid + "']");
			currentItem.attr(property, phase.status);
			
			if (property == "status" && phase.status == DOWNLOADING) {
				currentItem.find(".download-progress").text(phase.value + "%");
			} else if (property == "status" && phase.status == DOWNLOADED) {
				currentItem.find(".download-progress").text("");
			}
			
			if (property == "state" && phase.status == 0) {
				currentItem.find(".download-state").text("打包中");
			} else if (property == "state" && phase.status == 1) {
				currentItem.find(".download-state").text("");
			} else if (property == "state" && phase.status == 2) {
				currentItem.find(".download-state").text("打包失败");
			}
			this.checkAllState();
		},
		getProperty: function(type, fid, property) {
			var currentItem = $(".download-item[type='" + type + "'][fileid='" + fid + "']");
			return currentItem.attr(property);
		},
		setProperty: function(type, fid, property, value) {
			var currentItem = $(".download-item[type='" + type + "'][fileid='" + fid + "']");
			currentItem.attr(property, value);
		},
		checkAllState: function() {
			if ($(".download-item[state='0']").length > 0 || $(".download-item").length == 0 || 
			$(".download-item[status='4']").length + $(".download-item[status='8']").length + 
			$(".download-item[status='9']").length + $(".download-item[state='2']").length == $(".download-item").length) {
				$(".popup .popup-footer #downloadAll").attr("state", 0);
			} else {
				$(".popup .popup-footer #downloadAll").attr("state", 1);
			}
		},
		addDownloadItem: function(item) {
			
			var tempItem = $("<div></div>").addClass("download-item right-delete");
			var itemname = $("<div></div>").addClass("download-name").text(item.property("name"));
			var itempro = $("<div></div>").addClass("download-progress").text("");
			
			if (item.property("type") == COURSE || item.property("type") == EXAM) {
				tempItem.attr("state", 1);
			} else {
				tempItem.attr("state", 0);
			}
			
			tempItem.append(itemname);
			tempItem.append(itempro);
			item.giveTo(tempItem);
			$(".popup #downloadList").append(tempItem);
			
			this.checkAllState();
		},
		getDownloadItem: function(type, fid) {
			var downloadItem = $(".download-item[type='" + type + "'][fileid='" + fid + "']");
			var item = new ItemData({}, downloadItem.attr("type"));
			item.takeFrom(downloadItem);
			return item;
		},
		getDownloadList: function() {
			var returnlist = [];
			$(".download-item[status='0'][state='1']").each(function(i) {
				var item = new ItemData($(this), $(this).attr("type"));
				returnlist.push(item);
			});
			return returnlist;
		},
		getAllList: function() {
			var alllist = [];
			$(".download-item").each(function(i) {
				var item = new ItemData($(this), $(this).attr("type"));
				alllist.push(item);
			});
			return alllist;
		},
		remove: function(type, fid) {
			$(".download-item").remove("[type='" + type + "'][fileid='" + fid + "']");
			this.checkAllState();
		},
		removeAll: function() {
			$(".popup #downloadList").empty();
			this.checkAllState();
		},
		/** hasundown 是否包括未下载 */
		getAllDownloadState: function(hasundown) {
			var result = true;
			$(".download-item").each(function(i) {
				if (hasundown) {
					if (($(this).attr("status") == 0 || $(this).attr("status") == 1 || $(this).attr("status") == 2 || $(this).attr("status") == 3) && $(this).attr("state") != 2) {
						result = false;
					}
				} else {
					if (($(this).attr("status") == 1 || $(this).attr("status") == 2 || $(this).attr("status") == 3) && $(this).attr("state") != 2) {
						result = false;
					}
				}
				
			});
			return result;
		},
		setOfflinePath: function(path) {
			if (!path || path == "") {
				$(".popup .popup-footer #offlineReset").text("选择目录");
			} else {
				$(".popup .popup-footer #offlineReset").text("重新设置");
			}
			$(".popup #offlinepath").val(path);
		}
	}
	
	
	
	
	
	
	$.downTaskPopup = function(option) {
		var defaultOption = {
			config: "",
			ondownload: null,
			ondelete: null,
			ondeleteAll: null,
			onOfflineReset: null
//			ondeleteAllFile: null
		};
		var newoption = $.extend({}, defaultOption, option);
		var dtpopup = new DownTaskPopup(newoption);
		return dtpopup;
	}
	
	
})(jQuery);
