(function($) {

	$.Alert = function(content, type, callback) {
		
		var ottAlert = $('<div class="ott-alert-container">' + 
							'<div class="ott-alert">' + 
								'<div class="ott-alert-header"></div>' + 
								'<div class="ott-alert-content">' + content + '</div>' + 
								'<div class="ott-alert-buttons"></div>' + 
							'</div>' + 
						'</div>');
		
		$("body").append(ottAlert);
		var alertDIV = ottAlert.find(".ott-alert");
		alertDIV.css("margin-top", -(alertDIV.innerHeight() / 2) + "px");

		var nobutton = $("<div id='nobutton'>取消</div>").addClass("ott-alert-button");
		var yesbutton = $("<div id='yesbutton'>确定</div>").addClass("ott-alert-button");
		
		switch (type)
		{
			case 1:
				$(".ott-alert .ott-alert-buttons").append(yesbutton);
				break;
			case 2:
				$(".ott-alert .ott-alert-buttons").append(nobutton);
				$(".ott-alert .ott-alert-buttons").append(yesbutton);
				break;
			case 0:
			default:
				$(".ott-alert .ott-alert-buttons").append(nobutton);
				break;
		}
		
		$(".ott-alert .ott-alert-buttons #yesbutton").click(function() {
			if (callback != null) {
				callback();
			}
			$(".ott-alert-container").remove();
		});
		
		$(".ott-alert .ott-alert-buttons #nobutton").click(function() {
			$(".ott-alert-container").remove();
		});
		
	}
	
	var promptID;
	$.Prompt = function(msg, delay, callback) {
		clearTimeout(promptID);
		$(".ott-prompt").stop();
		$(".ott-prompt").remove();
		var d = delay || 2000;
		var f = callback || function() {};
		var prompt = $('<div class="ott-prompt">' + msg + '</div>');
		$("body").append(prompt);
		prompt.css("margin-left", -(prompt.innerWidth() / 2) + "px");
		promptID = setTimeout(function() {
			$(".ott-prompt").fadeOut(500, function(){
				$(".ott-prompt").remove();
				f();
			})
		}, d);
	}
	
	
	$.fn.windowDrag = function() {
		
		return this.each(function() {
			
			$(this).bind("mousedown", {instance: this}, onWindowDragStart)
			function onWindowDragStart(event) {
				if (event.target != event.data.instance) {
					return;
				}
				$(window).bind("mousemove", {instance: this, x: event.clientX, y: event.clientY}, onWindowDraging);
				$(window).bind("mouseup", {instance: this}, onWindowDragStop);
			}
			function onWindowDraging(event) {
				var windowX = event.screenX - event.data.x;
				var windowY = event.screenY - event.data.y;
				window.moveTo(windowX, windowY);
			}
			function onWindowDragStop(event) {
				$(window).unbind("mousemove", onWindowDraging);
				$(window).unbind("mouseup", onWindowDragStop);
			}
		});
	}
	
	
	
	$.ajaxSetup({
		beforeSend: function(request) {
			request.setRequestHeader("contentVersion", $.ottversion.version);
		}
	});
	
	
	$(document).on('focus', 'input[readonly]', function () {
		this.blur();
	});
	
	
	
	
	
})(jQuery);





