(function($) {
	
	var RecordPopup = function(container, option) {
		
		var defaultConfig = {
			type: 0,   //0 个人 1小组
			data: {
			},
			rewardShow: false,
			onRewardHandler: function(data) {}
		}
		
		var config = $.extend({}, defaultConfig, option);
		
		var title = (config.type == 0) ? "个人奖励记录" : "小组奖励记录";
		
		var popup = $('<div class="cr3-popup-container"><div class="cr3-popup-record">' +
							'<div class="header">' + title + '<div class="close-button"></div></div>' +
							'<div class="content">暂无获奖记录</div>' +
							'<div class="footer"></div>' +
						'</div></div>');
		
		if (config.rewardShow) {
			var bval = (config.type == 0) ? "个人奖励" : "小组奖励";
			var rewardButton = $('<div class="reward-button">' + bval + '</div>');
			popup.find(".footer").append(rewardButton);
		}
		
		if (config.data.reward && config.data.reward.length > 0) {
			popup.find(".content").empty();
			$.each(config.data.reward, function(i, data) {
				var p = $("<p></p>").text(data.ct + " " + data.message);
				popup.find(".content").append(p);
			});
		}
						
		$(container).append(popup);
		
		popup.find(".close-button").click(function() {
			popup.remove();
		});
		
		popup.find(".reward-button").click(function() {
			config.onRewardHandler(config.data);
			popup.remove();
		});
		
		
	}
	
	
	
	var CallRollPopup = function(container, option) {
		var defaultConfig = {
			data: [],
			player: null,
			onRewardHandler: function(data) {}
		}
		
		var config = $.extend({}, defaultConfig, option);
		
		var bz = [0,1,2,4,12,22,36,52,70,90,120,220,380,560,900];
		var titlelist = [
			["新手上路","实习司机","招摇过市","老司机","十八轮司机","赛车手 ","火车司机 ","开坦克的 ","纵横天下","瞬间移动","瞬间移动I","瞬间移动II","瞬间移动III","瞬间移动IV","瞬间移动V"],
			["列兵","少尉","中尉","上尉","少校","中校","大校","少将","中将","上将","上将I","上将II","上将III","上将IV","上将V"],
			["初来乍到","走马观花 ","崭露头角","一鸣惊人","身经百战","百战金刚","九天战神","独孤求败","金刚不坏","木乃伊","木乃伊I","木乃伊II","木乃伊III","木乃伊IV","木乃伊V"],
			["雏鸡破壳","初生牛犊","草原孤狼","豹跳如雷","虎啸山林","金毛狮王","龙行天下","恐龙化石","始祖鸟","三叶虫","三叶虫I","三叶虫II","三叶虫III","三叶虫IV","三叶虫V" ]
		];
		
		var popup = $('<div class="cr3-popup-container"><div class="cr3-popup-callroll">' +
							'<div class="header">请以下同学回答问题<div class="close-button"></div></div>' +
							'<div class="content"></div>' +
							'<div class="footer">' +
							 	'<div class="reward-button">奖励</div>' +
							 	'<div class="all-choose"><input type="checkbox" />&nbsp;全选</div>' +
							'</div>' +
						'</div></div>');
		var headImg;
		if (config.data.length == 1) {
			$.each(config.data, function(i, person) {
				if (!person.headImg) {
					headImg = "http://head.kouyu100.com/demo1/" + person.userId + ".jpg?v=" + Math.random();
				} else {
					headImg = person.headImg;
				}
				var pHead = $('<div class="headInfo">' +
						 		'<img src="' + headImg + '" />' +
						 		'<p>' + person.userName + '</p>' +
						 	'</div>');
				pHead.find("img").on("error", function() {
					$(this).attr("src", "chrome://teacher_tools/content/images/classroom/default.jpg");
				});
				pHead.data("person-data", person);
				popup.find(".content").append(pHead);
				
				var pAttr = $('<div class="attrInfo"></div>');
				pAttr.append("<p>流派：" + getSectRank(person.sect, person.expNew) + "</p>");
				pAttr.append("<p>朗读：" + showLevel(person.scoreRank) + "</p>");
				pAttr.append("<p>听力：" + showLevel(person.listenLevel) + "</p>");
				pAttr.append("<p>跟读：" + (person.voiceCount || 0) + "</p>");
				pAttr.append("<p>鲜花：" + (person.flowerCount || 0) + "</p>");
				
				popup.find(".content").append(pAttr);
			});
			popup.find(".content").append("<div style='clear: both;'></div>");
			popup.find(".footer").find(".all-choose").hide();
		} else if (config.data.length > 1) {
			$.each(config.data, function(i, person) {
				if (!person.headImg) {
					headImg = "http://head.kouyu100.com/demo1/" + person.userId + ".jpg?v=" + Math.random();
				} else {
					headImg = person.headImg;
				}
				var pHead = $('<div class="headInfo2">' +
						 		'<img src="' + headImg + '" />' +
						 		'<div class="choose-name"><input type="checkbox" />&nbsp;' + person.userName + '</div>' +
						 	'</div>');
				pHead.find("img").on("error", function() {
					$(this).attr("src", "chrome://teacher_tools/content/images/classroom/default.jpg");
				});
				pHead.data("person-data", person);
				popup.find(".content").append(pHead);
			});
			popup.find(".content").append("<div style='clear: both;'></div>");
			popup.find(".all-choose").show();
		}
		
		$(container).append(popup);
		
		popup.find(".reward-button").click(function() {
			var persons = [];
			if (config.data.length == 1) {
				persons.push(popup.find(".headInfo").data("person-data"));
			} else if (config.data.length > 1) {
				popup.find(".headInfo2").each(function() {
					if ($(this).find("input[type='checkbox']").prop("checked") == true) {
						persons.push($(this).data("person-data"));
					}
				});
			}
			if (persons.length == 0) {
				alert("请选择您要奖励的学生");
			} else {
				playAudio(config.player, "reward.wav");
				config.onRewardHandler(persons, "课堂奖励");
				popup.remove();
			}
		});
		
		popup.find(".all-choose input[type='checkbox']").on("change", function() {
			popup.find(".headInfo2 input[type='checkbox']").prop("checked", $(this).prop("checked"));
		});
		
		popup.find(".close-button").click(function() {
			popup.remove();
		});
		
		
		
		
		
		function getSectRank(sect, exp) {
			sect = sect || 0;
			exp = exp || 0;
			var hour = parseInt(exp);
			for (var i = 0; i < bz.length; i++) {
				if (hour < bz[i]) {
					return titlelist[sect][i-1];
				} else if (i == bz.length - 1) {
					return titlelist[sect][i];
				}
			}
		}
		function showLevel(value){
			switch (value) {
				case 1: case "1": return "努力中";
				case 2: case "2": return "不错";
				case 3: case "3": return "良好";
				case 4: case "4": return "优秀";
				case 5: case "5": return "惊艳";
				default: return "未知";
			}
		}
		
		
		
		
		
		
		
	}
	
	
	var RewardPopup = function(container, option) {
		var defaultConfig = {
			type: 0,		//0个人 1小组
			premessage: [
				"回答正确",
				"团队精神",
				"认真听讲",
				"进步很大",
				"遵守纪律",
				"课堂奖励",
				"表现优异",
				"提高很大",
				"勤奋努力",
				"标准动听",
				"作业奖励"
			],
			data: [
				
			],
			player: null,
			onRewardHandler: function(data) {}
		}
		
		var config = $.extend({}, defaultConfig, option);
		
		var buttonValue = (config.type == 0) ? "个人奖励" : "小组奖励";
		
		var popup = $('<div class="cr3-popup-container"><div class="cr3-popup-reward">' +
							'<div class="header">奖励<div class="close-button"></div></div>' +
							'<div class="content">' +
								'<div class="content-left">' +
									'<div class="name"></div>' +
									'<textarea></textarea>' +
								'</div>' +
								'<div class="content-right">' +
									'<select size="3">' +
										'<option value="0" selected="selected" style="color: rgb(204, 204, 204); font-style: oblique;">自己输入</option>' +
									'</select>' +
								'</div>' +
								'<div style="clear: both;"></div>' +
							'</div>' +
							'<div class="footer">' +
								'<div class="reward-button">' + buttonValue + '</div>' +
							'</div>' +
						'</div></div>');
						
		$.each(config.premessage, function(i, message) {
			popup.find(".content .content-right select").append("<option>" + message + "</option>");
		});
		
		var names = [];
		$.each(config.data, function(i, subdata) {
			if (config.type == 0) {
				names.push("@" + subdata.userName);
			} else {
				names.push("@" + subdata.groupName);
			}
		});
		popup.find(".content .content-left .name").text(names.join(","));
		
		$(container).append(popup);
		
		popup.find(".content .content-right select").change(function() {
			if ($(this).val() == "0") {
				popup.find(".content .content-left textarea").val("");
			} else {
				popup.find(".content .content-left textarea").val($(this).val());
			}
		});
		
		popup.find(".close-button").click(function() {
			popup.remove();
		});
		
		popup.find(".reward-button").click(function() {
			var message = popup.find(".content .content-left textarea").val();
			if (message == "") {
				alert("奖励理由不能为空。");
				return;
			}
			playAudio(config.player, "reward.wav");
			config.onRewardHandler(config.data, message);
			popup.remove();
		});
		
	}
	
	
	
	function playAudio(audio, src) {
		if (!audio) {
			return;
		}
		audio.attr("src", "chrome://teacher_tools/content/images/bGmusic/" + src);
		audio.get(0).play();
	}
	
	
	
	
	
	
	
	
	
	$.fn.showRecord = function(option) {
		return this.each(function() {
			var p = new RecordPopup(this, option);
		});
	}
	
	$.fn.showReward = function(option) {
		return this.each(function() {
			var p = new RewardPopup(this, option);
		});
	}
	
	$.fn.showCallRoll = function(option) {
		return this.each(function() {
			var p = new CallRollPopup(this, option);
		});
	}
	
	
})(jQuery);
