(function($) {
	
	
	var Personal = function(container, option) {
		
		var defaultConfig = {
			player: null,
			canSelected: true,
			onAvatarHandler: function(data) {}
		};
		var config = $.extend({}, defaultConfig, option);
		
		var personalBox = $("<div class='personal-box'></div>");
		$(container).append(personalBox);
		
		var audio = $("<audio hidden='hidden'></audio>");
		$(container).append(audio);
		
		personalBox.on("click", ".person .person-avatar", {callback: config.onAvatarHandler}, function(e) {
			var data = $(this).parents(".person").data("person-data");
			e.data.callback(data);
		});
		
		var defaultPersonlist;
		var personlist;
		
		/** 载入学生列表 */
		this.loadPersons = function(persons) {
			defaultPersonlist = persons;
			personlist = defaultPersonlist.concat();
			drawPersons(personlist);
		}
		
		/** 清空学生列表 */
		this.clearPersons = function() {
			personlist = [];
			personalBox.empty();
		}
		
		var isAniming = false;
		/** 随机获取若干学生数据 */
		this.getRandomPerson = function(num) {
			if (isAniming) { return null; } // 动画中限制调用
			personalBox.find(".person").find("input[type='checkbox']").prop("checked", false);
			var returnPerson = [];
			var ri = randomIndex(0, personlist.length, num);
			var persons = choosePerson(ri);
			for (var i = 0; i < num; i++) {
				persons[i].find("input[type='checkbox']").prop("checked", true);
				returnPerson.push(persons[i].data("person-data"));
			}
			return returnPerson;
		}
		/** 随机获取若干学生数据（带动画 ） */
		this.getRandomPersonAnim = function(num, callback) {
			if (isAniming) { return null; } // 动画中限制调用
			isAniming = true;
			personalBox.find(".person").find("input[type='checkbox']").prop("checked", false);
			var returnPerson = [];
			
			var timer = 0;
			playAudio("random.wav");
			var tid = setInterval(function() {
				if (timer < 35) {
					choosePerson(randomIndex(0, personlist.length, 1));
					timer += 1;
				} else {
					clearInterval(tid);
					timer = 0;
					choosePerson([]);
					var persons = choosePerson(randomIndex(0, personlist.length, num));
					playAudio("choose.wav");
					var cid = setInterval(function() {
						if (timer < 4) {
							timer += 1;
							$.each(persons, function(i, person) {
								person.toggleClass("selected");
							});
						} else {
							clearInterval(cid);
							timer = 0;
							$.each(persons, function(i, person) {
								person.find("input[type='checkbox']").prop("checked", true);
								returnPerson.push(person.data("person-data"));
							});
							isAniming = false;
							callback(returnPerson);
						}
					}, 300);
				}
			}, 100);
		}
		
		/** 过去勾选的学生列表 */ 
		this.getSelectedPerson = function() {
			var returnPerson = [];
			personalBox.find(".person").each(function(i) {
				if ($(this).find("input[type='checkbox']").prop("checked")) {
					returnPerson.push($(this).data("person-data"));
				}
			});
			return returnPerson;
		}
		
		/** 通过type排序 0 默认 非0 积分 */
		this.sortPerson = function(type) {
			type = type || 0;
			if (type == 0) {
				personlist = defaultPersonlist.concat();
			} else {
				personlist.sort(function(a, b) {
					return parseInt(b.integral) - parseInt(a.integral);
				});
			}
			drawPersons(personlist);
		}
		
		/** 增加积分 +1 */
		this.addIntegral = function(persons) {
			for (var i = 0; i < persons.length; i++) {
				for (var j = 0; j < personlist.length; j++) {
					if (persons[i].userId == personlist[j].userId) {
						personlist[j].integral++;
					}
				}
			}
			drawPersons(personlist);
		}
		
		function drawPersons(persons) {
			personalBox.empty();
			$.each(personlist, function(i, person) {
				personalBox.append(createNewPerson(person));
			});
		}
		
		function choosePerson(indexarr) {
			personalBox.find(".person.selected").removeClass("selected");
			var persons = [];
			for (var i = 0; i < indexarr.length; i++) {
				var person = personalBox.find(".person:eq(" + indexarr[i] + ")").addClass("selected");
				persons.push(person);
			}
			return persons;
		}
		
		/** 创建一个 person */
		function createNewPerson(params) {
			var headImg;
			if (!params.headImg) {
				headImg = "http://head.kouyu100.com/demo1/" + params.userId + ".jpg?v=" + Math.random();
			} else {
				headImg = params.headImg;
			}
			
			var person = $('<div class="person">' +
								'<div class="person-avatar">' +
									'<img src="' + headImg + '" />' +
									'<p class="integral">' + params.integral + '星</p>' +
								'</div>' +
								'<div class="name">' +
									'<span>' + params.userName + '</span>' +
								'</div>' +
							'</div>');
			
			if (config.canSelected) {
				person.find(".name span").before('<input type="checkbox" />&nbsp;');
			}
							
			person.find("img").on("error", function() {
				$(this).attr("src", "chrome://teacher_tools/content/images/classroom/default.jpg");
			});
			person.data("person-data", params);
			return person;
		}
		
		function randomIndex(b, e, n) {
			b = Math.floor(b);
			e = Math.floor(e);
			var numarr = [];
			if (b > e || n > e - b || n == 0) { return numarr; }
			for (var i = b; i < e; i++) {
				numarr.push(i);
			}
			var returnarr = [];
			for (var j = 0; j < n; j++) {
				var index = Math.floor(Math.random() * numarr.length);
				returnarr.push(numarr.splice(index, 1));
			}
			return returnarr;
		}
		
		function playAudio(src) {
			if (!config.player) {
				return;
			}
			config.player.attr("src", "chrome://teacher_tools/content/images/bGmusic/" + src);
			config.player.get(0).play();
		}
		
		
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	$.fn.personal = function(option) {
		return this.each(function() {
			var p = new Personal(this, option);
			$(this).data("personal", p);
		});
	}
	
	
	
})(jQuery);
