(function($) {
	
	
	var Group = function(container, option) {
		var defaultConfig = {
			canSelected: true,
			online: true,
			onDetailHandler: function(data) {}
		};
		var config = $.extend({}, defaultConfig, option);
		
		var groupBox = $("<div class='team-list'></div>");
		$(container).append(groupBox);
		
		var grouplist;
		
		
		groupBox.on("click", ".team-item .integral .detail", {callback: config.onDetailHandler}, function(e) {
			var data = $(this).parents(".team-item").data("group-data")
			e.data.callback(data);
		});
		
		groupBox.on("mouseover", ".team-item .teamer .all-teamer", function(e) {
			var teamer = $(this).parents(".team-item").data("group-data").grouper;
			showTeamDetail(teamer, $(this).offset().top + 25, $(this).offset().left);
		});
		groupBox.on("mouseout", ".team-item .teamer .all-teamer", function(e) {
			groupBox.find(".teamer-list").remove();
		});
		
		
		this.loadGroups = function(groups) {
			grouplist = groups;
			drawGroups(grouplist);
		}
		
		this.clearGroups = function() {
			grouplist = [];
			groupBox.empty();
		}
		
		this.getSelectedGroup = function() {
			var returnGroup = [];
			groupBox.find(".team-item").each(function() {
				if ($(this).find("input[type='checkbox']").prop("checked")) {
					returnGroup.push($(this).data("group-data"));
				}
			});
			return returnGroup;
		}
		
		this.selectAll = function(boo) {
			boo = boo || false;
			groupBox.find(".team-item").each(function() {
				$(this).find("input[type='checkbox']").prop("checked", boo);
			});
		}
		
		/** 增加积分 +1 */
		this.addIntegral = function(groups) {
			for (var i = 0; i < groups.length; i++) {
				for (var j = 0; j < grouplist.length; j++) {
					if (groups[i].id == grouplist[j].id) {
						grouplist[j].integral++;
					}
				}
			}
			drawGroups(grouplist);
		}
		
		
		
		
		
		
		function showTeamDetail(teamers, top, left) {
			var teamerlist = $('<div class="teamer-list">' +
									'<div class="header"></div>' +
									'<div class="content">' +
									'</div>' +
								'</div>');
			if (teamers.length == 0) {
				teamerlist.find(".content").append("<p>无组员</p>");
			}
			for (var i = 0; i < teamers.length; i++) {
				teamerlist.find(".content").append("<p>" + teamers[i].name + "</p>");
			}
			groupBox.append(teamerlist);
			teamerlist.offset({top: top, left: left});
		}
		
		function drawGroups(groups) {
			groupBox.empty();
			$.each(groups, function(i, group) {
				groupBox.append(createNewGroup(group));
			});
		}
		
		
		function createNewGroup(params) {
			var imageUrl;
			if (config.online) {
				imageUrl = "http://group-cover.oss-cn-hangzhou.aliyuncs.com/" + params.imageUrl + "?v=" + Math.random();
			} else {
				imageUrl = params.imageUrl;
			}
			var newGroup = $('<div class="team-item">' +
								'<div class="number">' + params.groupNo + '</div>' +
								'<div class="icon"><img src="' + imageUrl + '" /></div>' +
								'<div class="name">' + params.groupName + '</div>' +
								'<div class="teamer">' +
									'<p class="caption">' + params.captain + '（组长）</p>' +
									'<p class="all-teamer">所有成员</p>' +
								'</div>' +
								'<div class="integral">' +
									'<div class="detail">详情</div>' +
									'<div class="integral-icon">' +
									'</div>' +
								'</div>' +
							'</div>');
			if (config.canSelected) {
				newGroup.prepend("<div class='check'><input type='checkbox' /></div>");
			} else {
				newGroup.prepend("<div class='none'></div>");
			}
			newGroup.find(".integral-icon").attr("title", params.integral).append(getIntegralIcon(params.integral));
			newGroup.data("group-data", params);
			return newGroup;
		}
		
		/** 根据积分获得积分图标 */
		function getIntegralIcon(integral) {
			var html = "";
			// 皇冠个数
			var icon1 = Math.floor(integral / 100);
			// 太阳个数
			var icon2 = Math.floor((integral % 100) / 50);
			// 月亮个数
			var icon3 = Math.floor(((integral % 100) % 50) / 10);
			// 星星个数
			var icon4 = ((integral % 100) % 50) % 10;
			
			for (var i = 0; i < icon1; i++) {
				html += '<img src="chrome://teacher_tools/content/images/classroom/1.png" />';
			}
			for (var i = 0; i < icon2; i++) {
				html += '<img src="chrome://teacher_tools/content/images/classroom/2.png" />';
			}
			for (var i = 0; i < icon3; i++) {
				html += '<img src="chrome://teacher_tools/content/images/classroom/3.png" />';
			}
			for (var i = 0; i < icon4; i++) {
				html += '<img src="chrome://teacher_tools/content/images/classroom/4.png" />';
			}
			
			return html;
		}
		
		
		
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	$.fn.group = function(option) {
		return this.each(function() {
			var g = new Group(this, option);
			$(this).data("group", g);
		});
	}
	
	
	
	
})(jQuery);
