(function($){
	
	function WordlistShower(option) {
		var defaultOption = {
			onClose: function() {},
			onplayed: function() {}
		};
		this.newOption = $.extend({}, defaultOption, option || {});
		
		this.wordIndex = 1;
		this.wordTotal = 0;
		this.curWord = null;
		this.wordlist = [];
		
		var shower = $('<div class="wordlist-shower-container">' +
							'<div class="wordlist-shower">' +
								'<div class="wordlist-shower-closer"></div>' +
								'<div class="mode-tab">' +
									'<div class="mode-tab-normal selected"></div>' +
									'<div class="mode-tab-spell"></div>' +
								'</div>' +
								'<div class="wordlist-body">' +
									'<div class="wordlist-img"></div>' +
									'<div class="wordlist-laba"><div class="wordlist-laba-image"></div></div>' +
									'<div class="wordlist-prev"></div>' +
									'<div class="wordlist-next"></div>' +
									'<div class="wordlist-page">' +
										'<span id="wordCount"></span>/<span id="wordTotal"></span>' +
									'</div>' +
								'</div>' +
								'<div class="wordlist-play">' +
									'<div class="big-hidden" id="totalShow"></div>' +
									'<div class="big-hidden-box">' +
										'<div class="wordlist-play-item play-word">' +
											'<div id="word"></div>' +
											'<div class="laba" id="wordLaba"></div>' +
										'</div>' +
										'<div class="wordlist-play-item play-sentence">' +
											'<div class="small-hidden" id="sentenceShow"></div>' +
											'<div class="small-hidden-box">' +
												'<div id="sentence"></div>' +
												'<div class="laba" id="sentenceLaba"></div>' +
											'</div>' +
										'</div>' +
									'</div>' +
								'</div>' +
								'<audio id="wordShowerAudio" hidden="hidden" src="" />' +
							'</div>' +
						'</div>');
		$("body").append(shower);
		
		/** 普通模式/拼读模式 标签切换 */
		$(".wordlist-shower .mode-tab-normal").click({instance: this}, function(e) {
			$(".wordlist-shower .mode-tab-spell").removeClass("selected");
			$(".wordlist-shower .mode-tab-normal").addClass("selected");
			$(".wordlist-shower .play-sentence").removeClass("show");
			e.data.instance.showWord("normal");
		});
		$(".wordlist-shower .mode-tab-spell").click({instance: this}, function(e) {
			$(".wordlist-shower .mode-tab-normal").removeClass("selected");
			$(".wordlist-shower .mode-tab-spell").addClass("selected");
			$(".wordlist-shower .play-sentence").removeClass("show");
			e.data.instance.showWord("spell");
		});
		
		/** 关闭按钮点击 */
		$(".wordlist-shower .wordlist-shower-closer").click({instance: this}, function(e) {
			e.data.instance.newOption.onClose();
		});
		
		/** 图片喇叭 */
		$(".wordlist-shower .wordlist-laba").hover(
			function() {
				$(".wordlist-shower .wordlist-laba .wordlist-laba-image").show();
			}, 
			function() {
				$(".wordlist-shower .wordlist-laba .wordlist-laba-image").hide();
			}
		);
		$(".wordlist-shower .wordlist-laba").click({instance: this}, function(e) {
			e.data.instance.playAudio($(this).attr("audiourl"));
		});
		
		/** 上一个 */
		$(".wordlist-shower .wordlist-prev").on("click", {instance: this}, function(e) {
			if (!$(this).hasClass("enabled")) {
				return;
			}
			e.data.instance.wordIndex--;
			e.data.instance.showWordItem(e.data.instance.wordIndex);
		});
		/** 下一个 */
		$(".wordlist-shower .wordlist-next").on("click", {instance: this}, function(e) {
			if (!$(this).hasClass("enabled")) {
				return;
			}
			e.data.instance.wordIndex++;
			e.data.instance.showWordItem(e.data.instance.wordIndex);
		});
		
		/** 大隐藏按钮 */
		$(".wordlist-shower #totalShow").click(function() {
			$(".wordlist-shower .wordlist-play").addClass("show");
		});
		
		/** 小隐藏按钮 */
		$(".wordlist-shower #sentenceShow").click(function() {
			$(".wordlist-shower .play-sentence").addClass("show");
		});
		
		/** 喇叭点击 */
		$(".wordlist-shower .laba").click({instance: this}, function(e) {
			$(".wordlist-shower .laba").prev("div").removeClass("current");
			$(this).prev("div").addClass("current");
			e.data.instance.playAudio($(this).attr("audiourl"));
		});

		this.addWordList = function(wordlist) {
			this.wordlist = wordlist;
			this.wordIndex = 1;
			this.wordTotal = this.wordlist.length;
			
			$(".wordlist-shower .wordlist-page #wordCount").text(this.wordIndex);
			$(".wordlist-shower .wordlist-page #wordTotal").text(this.wordTotal);
			
			this.showWordItem(this.wordIndex);
		}
		
		this.showWordItem = function(index) {
			
			if (index == 1) {
				$(".wordlist-shower .wordlist-prev").removeClass("enabled");
			} else {
				$(".wordlist-shower .wordlist-prev").addClass("enabled");
			}
			if (index == this.wordTotal) {
				$(".wordlist-shower .wordlist-next").removeClass("enabled");
			} else {
				$(".wordlist-shower .wordlist-next").addClass("enabled");
			}
			
			this.curWord = this.wordlist[index - 1];
			
			$(".wordlist-shower .wordlist-play, .wordlist-shower .play-sentence").removeClass("show");
			$(".wordlist-shower .laba").prev("div").removeClass("current");
			
			$(".wordlist-shower .wordlist-page #wordCount").text(index);
			$(".wordlist-shower .wordlist-img").html("<img src='" + this.curWord.picture + "' />");
			$(".wordlist-shower .wordlist-laba").attr("audiourl", this.curWord.audio);
			if ($(".wordlist-shower .mode-tab-normal").hasClass("selected")) {
				this.showWord("normal");
			} else {
				this.showWord("spell");
			}
			$(".wordlist-shower #sentence").text(this.curWord.example);
			$(".wordlist-shower #wordLaba").attr("audiourl", this.curWord.audio);
			$(".wordlist-shower #sentenceLaba").attr("audiourl", this.curWord.exampleaudio);
		}
		
		this.playAudio = function(audiopath) {
			this.newOption.onplayed("wordlist");
			
			$(".wordlist-shower #wordShowerAudio").attr("src", audiopath);
			$(".wordlist-shower #wordShowerAudio").get(0).play();
		}
		this.stopAudio = function() {
			$(".wordlist-shower #wordShowerAudio").get(0).pause();
		}
		this.clearAudio = function() {
			this.stopAudio();
			$(".wordlist-shower #wordShowerAudio").attr("src", null);
		}
		
		this.showWord = function(mode) {
			if (!this.curWord) {
				return "";
			}
			var word;
			switch (mode)
			{
				case "normal":
					word = this.curWord.word;
					break;
				case "spell":
					word = this.curWord.syllable;
					if (!word || word == "") {
						word = this.curWord.word;
					}
					word = SyllableRed(word);
					break;
			}
			$(".wordlist-shower #word").html(word + " " + this.curWord.cntext);
		}
		
		// 拼读模式单词处理 (From kouyu100 classroom.js)
		function SyllableRed(syllable){
			var allInfo = '';
			var reg=/(^\s+)|(\s+$)/g;
			var allArray = syllable.replace(reg,"").split(" ");
			for(var j=0,j_len=allArray.length;j<j_len;j++){
				var array = allArray[j].split("-");
				var ll = '';
					for(var i=0,i_len=array.length;i<i_len;i++){
						each = defineReg(array[i],i+1,i_len);
						ll+= each+"-";
					}
				ll = ll.substring(0,ll.length-1);
			    allInfo += ll + " ";
			}
			allInfo = allInfo.substring(0,allInfo.length-1);
			return allInfo;
		}
		
		function defineReg(obj,index,total){
			var $1 = "<font style='color:#fd8804'>$1</font>";
			var regx1 = /([a|e|i|o|u])/i;
			//第一层判断，无元音字母，是否包含字母y
			if(!regx1.test(obj)){
				var reg_y = /([y]+)/i;
				return obj.replace(reg_y,$1);
			}else{
			  //有元音字母
			  var regex_$vowel = /([a|e|i|o|u]$)/i;//元音字母是否在最后
			  //元音字母在最后
			  if(obj.match(/a|e|i|o|u/ig).length == 1 && regex_$vowel.test(obj)){
				  //最后一个音节
				   if(index==total){
					   //元音字母是否为e,并且字母e前为l
						if(/e/i.test(obj) && /le/i.test(obj)){
							return obj.replace(/(le)/i,$1);
						}
				   }
					return obj.replace(regex_$vowel,$1);
			  }else{
				  var regex2 = /([aeiou]{1,}[wyr]{1}[e]?)|([aeiou]{1,})/i;
				  var regex_index = /[aeiou]/;
				  var index0 = regex_index.exec(obj).index;
				  var letter = obj.substr(index0+1,1);
				  if(/([^aeiouwyr])/.test(letter)){
						return obj.replace(/([aeiou])/i,$1);
				  }else if(regex2.test(obj)){
						var regex = /(([aeiou]{1,}[wyr]{1,}[e]?)|([aeiou]{1,}))/i;
						return obj.replace(regex,$1);
				   }
				   return obj.replace(/([aeiou])/i,$1);
			  }
			}
			return obj;
		}
	}

	WordlistShower.prototype = {
		show: function(list) {
			$(".wordlist-shower-container").show();
			this.addWordList(list);
		},
		hide: function() {
			this.clear();
			$(".wordlist-shower-container").hide();
		},
		clear: function() {
			
			this.wordIndex = 1;
			this.wordTotal = 0;
			this.curWord = null;
			this.wordlist = [];
			this.clearAudio();
			
//			$(".wordlist-shower .mode-tab-normal").trigger("click");
			
			$(".wordlist-shower .wordlist-play, .wordlist-shower .play-sentence").removeClass("show");
			$(".wordlist-shower .wordlist-prev, .wordlist-shower .wordlist-next").removeClass("enabled");
			$(".wordlist-shower .laba").prev("div").removeClass("current");
			
			$(".wordlist-shower .wordlist-page #wordCount").text(this.wordIndex);
			$(".wordlist-shower .wordlist-page #wordTotal").text(this.wordTotal);
			
			$(".wordlist-shower .wordlist-img").html("");
			$(".wordlist-shower #word").html("");
			$(".wordlist-shower #sentence").text("");
			$(".wordlist-shower #wordLaba").attr("audiourl", null);
			$(".wordlist-shower #sentenceLaba").attr("audiourl", null);
		}
		
		
	};

	$.wordlistshower = function(option) {
		var ws = new WordlistShower(option);
		return ws;
	}

})(jQuery)
