(function($){
	
	
	function WordlistPreview(option) {
		
		var defaultOption = {
			onClose: function() {},
			onplayed: function() {}
		};
		this.newOption = $.extend({}, defaultOption, option||{});
		
		var wordlist = $('<div class="wordlist-preview-container">' +
							'<div class="wordlist-preview">' +
								'<div class="wordlist-preview-close"></div>' +
								'<div class="caption">' +
									'<div class="word-item">' +
										'<div class="word">单词</div>' +
										'<div class="translate"></div>' +
										'<div class="playaudio">播放</div>' +
										'<div class="example">例句</div>' +
									'</div>' +
								'</div>' +
								'<div class="word-list"></div>' +
								'<div class="translate-box">' +
									'<div class="translate-image"></div>' + 
									'<div class="translate-title"></div>' + 
								'</div>' +
								'<audio id="wordPreviewAudio" hidden="hidden" src="" />' +
							'</div>' +
						'</div>');
						
		$("body").append(wordlist);
		
		$(".wordlist-preview .wordlist-preview-close").click({instance: this}, function(e) {
			e.data.instance.newOption.onClose();
		});
		
		$(".wordlist-preview").on("click", ".word-list .word-item .playaudio div", {instance: this}, function(e) {
			e.data.instance.playAudio($(this).parent(".playaudio").attr("audio"));
		});
		
		$(".wordlist-preview").on("mouseenter", ".word-list .word-item .translate div", function() {
			var cntext = $(this).parent(".translate").attr("cntext");
			var picture = $(this).parent(".translate").attr("picture");
			
			$(".wordlist-preview .translate-box .translate-title").text(cntext);
			$(".wordlist-preview .translate-box .translate-image").html("<img src='" + picture + "' />");
			
			var positionTop;
			if ($(this).parents(".word-item").offset().top - $(".wordlist-preview .translate-box").height() < 108) {
				$(".wordlist-preview .translate-box").addClass("down");
				positionTop = $(this).parents(".word-item").position().top + $(this).parents(".word-item").height();
			} else {
				$(".wordlist-preview .translate-box").removeClass("down");
				positionTop = $(this).parents(".word-item").position().top - $(".wordlist-preview .translate-box").height();
			}
			$(".wordlist-preview .translate-box").css("top", positionTop);
			$(".wordlist-preview .translate-box").show();
		});
		$(".wordlist-preview").on("mouseleave", ".word-list .word-item .translate div", function() {
			$(".wordlist-preview .translate-box .translate-title").text("");
			$(".wordlist-preview .translate-box .translate-image").html("");
			
			$(".wordlist-preview .translate-box").css("top", "-1000px");
			$(".wordlist-preview .translate-box").hide();
		});
		
		this.addWordList = function(list) {
			$.each(list, function(i, item) {
				var wordItem = $("<div class='word-item'></div>");
				var word = $("<div class='word'></div>").text(item.word);
				wordItem.append(word);
				var translate = $("<div class='translate'><div></div></div>").attr({
					cntext: item.cntext,
					picture: item.picture,
				});
				wordItem.append(translate);
				var playaudio = $("<div class='playaudio'><div></div></div>").attr({
					audio: item.audio
				});
				wordItem.append(playaudio);
				var example = $("<div class='example'></div>").html(item.example);
				wordItem.append(example);
				var operation;
				$(".wordlist-preview .word-list").append(wordItem);
			});
		}
		
		this.playAudio = function(audiopath) {
			this.newOption.onplayed("wordlist");
			
			$(".wordlist-preview #wordPreviewAudio").attr("src", audiopath);
			$(".wordlist-preview #wordPreviewAudio").get(0).play();
		}
		
	}
	
	WordlistPreview.prototype = {
		show: function(list) {
			$(".wordlist-preview-container").show();
			this.addWordList(list);
		},
		hide: function() {
			this.clear();
			$(".wordlist-preview-container").hide();
		},
		clear: function() {
			$(".wordlist-preview .word-list").empty();
		}
	};
	
	$.wordlistpreview = function(option) {
		var wp = new WordlistPreview(option);
		return wp;
	}
	
})(jQuery)
