(function($){
	
	function WordlistChooser(option) {
		
		var defaultOption = {
			onClose: function() {},
			onFinish: function(data) {},
			onplayed: function() {}
		};
		this.newOption = $.extend({}, defaultOption, option || {});
		
		this.wordIndex = 1;
		this.wordTotal = 0;
		this.curWord = null;
		this.wordlist = [];
		
		this.rightCount = 0;
		this.wrongCount = 0;
		
		var audioCount = 1;
		var isFinishAudio = false;
		var curWordState = true;
		
		var chooser = $('<div class="wordlist-chooser-container">' +
							'<div class="wordlist-chooser">' +
								'<div class="closer"></div>' +
								'<div class="header">' +
									'<div class="title"></div>' +
									'<div class="infor">' +
										'<span>播放次数：</span>' +
										'<select id="playCountSelector">' +
											'<option value="1">1</option>' +
											'<option value="2">2</option>' +
											'<option value="3" selected="selected">3</option>' +
											'<option value="4">4</option>' +
											'<option value="5">5</option>' +
										'</select>' +
										'<span>单词总数：</span>' +
										'<span id="wordTotalCount"></span>' +
										'<span>正确：</span>' +
										'<span id="wordRightCount"></span>' +
										'<span>错误：</span>' +
										'<span id="wordWrongCount"></span>' +
									'</div>' +
								'</div>' +
								'<div class="body">' +
									'<div class="option optionA"></div>' +
									'<div class="option optionB"></div>' +
									'<div class="option optionC"></div>' +
									'<div class="option optionD"></div>' +
								'</div>' +
								'<div class="footer">' +
									'<div class="page-num">' +
										'<span id="wordCount"></span>/<span id="wordTotal"></span>' +
									'</div>' +
								'</div>' +
								'<audio id="wordChooseAudio" hidden="hidden" src="" />' +
							'</div>' +
						'</div>');
		$("body").append(chooser);
		
		$(".wordlist-chooser .closer").click({instance: this}, function(e){
			e.data.instance.newOption.onClose();
		});
		
		$(".wordlist-chooser #wordChooseAudio").on("ended", {instance: this}, function(e) {
			if (isFinishAudio) {
				e.data.instance.wordIndex++;
				e.data.instance.setQuestion(e.data.instance.wordIndex);
			} else {
				audioCount ++;
				var audioTotal = $(".wordlist-chooser #playCountSelector").find("option:selected").val();
				if (audioCount > audioTotal) {
					return;
				}
				setTimeout(function() {
					e.data.instance.playAudio();
				}, 1500);
			}
		});
		
		
		this.addWordlist = function(list) {
			this.wordlist = orderArray(list);
			this.wordIndex = 1;
			this.wordTotal = this.wordlist.length;
			
			this.rightCount = 0;
			this.wrongCount = 0;
			
			$(".wordlist-chooser .header #wordTotalCount").text(this.wordTotal);
			$(".wordlist-chooser .header #wordRightCount").text(this.rightCount);
			$(".wordlist-chooser .header #wordWrongCount").text(this.wrongCount);
			$(".wordlist-chooser .footer #wordCount").text(this.wordIndex);
			$(".wordlist-chooser .footer #wordTotal").text(this.wordTotal);
			$(".wordlist-chooser .body .option").off("click", onChooseAnswer);
			
			this.setQuestion(this.wordIndex);
		}
		
		this.setQuestion = function(index) {
			
			audioCount = 1;
			isFinishAudio = false;
			curWordState = true;
			
			if (index > this.wordTotal) {
				this.finish();
				return;
			}
			
			this.curWord = this.wordlist[index - 1];
			$(".wordlist-chooser .footer #wordCount").text(index);
			
			$(".wordlist-chooser .body .option").removeClass("right").show();
			
			var right = {answer: "right", url: this.curWord.picture};
			var wrong1 = {answer: "wrong", url: this.curWord.dispicture1};
			var wrong2 = {answer: "wrong", url: this.curWord.dispicture2};
			var wrong3 = {answer: "wrong", url: this.curWord.dispicture3};
			
			var answers = orderArray([right, wrong1, wrong2, wrong3]);
			
			$(".wordlist-chooser #wordChooseAudio").attr("src", this.curWord.audio);
			
			$(".wordlist-chooser .header .title").html(this.curWord.word);
			$(".wordlist-chooser .body .optionA").html($("<img />").attr("src", answers[0].url)).attr("answer", answers[0].answer);
			$(".wordlist-chooser .body .optionB").html($("<img />").attr("src", answers[1].url)).attr("answer", answers[1].answer);
			$(".wordlist-chooser .body .optionC").html($("<img />").attr("src", answers[2].url)).attr("answer", answers[2].answer);
			$(".wordlist-chooser .body .optionD").html($("<img />").attr("src", answers[3].url)).attr("answer", answers[3].answer);
			$(".wordlist-chooser .body .option").on("click", {instance: this}, onChooseAnswer);
			
			this.playAudio();
		}
		
		this.playAudio = function() {
			if ($(".wordlist-chooser #wordChooseAudio").attr("src")) {
				this.newOption.onplayed("wordlist");
				
				$(".wordlist-chooser #wordChooseAudio").get(0).play();
			}
		}
		
		this.stopAudio = function() {
			$(".wordlist-chooser #wordChooseAudio").get(0).pause();
//			$(".wordlist-chooser #wordChooseAudio").get(0).currentTime = 0;
		}
		
		this.clearAudio = function() {
			this.stopAudio();
			$(".wordlist-chooser #wordChooseAudio").attr("src", null);
		}
		
		this.finish = function() {
			var finishData = {
				rightCount: this.rightCount,
				wrongCount: this.wrongCount,
				score: Math.round(this.rightCount / this.wordTotal * 100)
			};
			var finishCallback = this.newOption.onFinish;
			setTimeout(function() {
				finishCallback(finishData);
			}, 1000);
		}
		
		function orderArray(target) {
			var targetArray = target.concat();
			var returnArray = [];
			var leng = targetArray.length;
			for (var i = 0; i < leng; i++) {
				var random = Math.floor(Math.random() * targetArray.length);
				returnArray.push(targetArray.splice(random, 1)[0]);
			}
			return returnArray;
		}
		
		function onChooseAnswer(e) {
			if ($(this).attr("answer") == "right") {
				$(".wordlist-chooser .body .option").off("click", onChooseAnswer);
				e.data.instance.stopAudio();
				$(this).addClass("right");
				isFinishAudio = true;
				setTimeout(function() {
					e.data.instance.playAudio();
				}, 500);
				
				if (curWordState) {
					e.data.instance.rightCount ++;
					$(".wordlist-chooser .header #wordRightCount").text(e.data.instance.rightCount);
				} else {
					e.data.instance.wrongCount ++;
					$(".wordlist-chooser .header #wordWrongCount").text(e.data.instance.wrongCount);
				}
				
			} else {
				curWordState = false;
				$(this).hide();
			}
		}
		
	}
	
	WordlistChooser.prototype = {
		
		clear: function() {
			this.wordIndex = 1;
			this.wordTotal = 0;
			this.curWord = null;
			this.wordlist = [];
			
			this.rightCount = 0;
			this.wrongCount = 0;
			this.clearAudio();
			$(".wordlist-chooser .header .title").html("");
			$(".wordlist-chooser .body .option").html("");
			$(".wordlist-chooser .footer #wordCount").text(this.wordIndex);
			$(".wordlist-chooser .footer #wordTotal").text(this.wordTotal);
		},
		
		show: function(wordlist) {
			$(".wordlist-chooser-container").show();
			this.addWordlist(wordlist);
		},
		
		hide: function() {
			this.clear();
			$(".wordlist-chooser-container").hide();
		}
		
	}
	
	$.wordlistchooser = function(option) {
		var wc = new WordlistChooser(option);
		return wc;
	}
	
})(jQuery);
