(function($){
	var SimplePlayer = function(option) {
		
		var defaultOption = {onplayed: function() {}};
		var newOption = $.extend({}, defaultOption, option||{});
		
		this.audiopath = null;
		this.audioduration = 0;
		this.audioposition = 0;
		this.audioplayer = null;
		this.title = "";
		
		this.audioplayer = $('<div class="simple-player">' +
								'<div class="title"></div>' +
								'<div class="player-progressbar">' +
									'<div class="player-progressbar-thumb"></div>' +
								'</div>' +
								'<div class="player-button">播放</div>' +
								'<div class="player-closer"></div>' +
								'<audio id="audio"></audio>' + 
							'</div>');
		$("body").append(this.audioplayer);
		
		this.audioplayer.find("#audio").on("loadedmetadata", {instance: this}, function(e) {
			e.data.instance.audioduration = $(this).get(0).duration;
		});
		this.audioplayer.find("#audio").on("ended", {instance: this}, function(e) {
			stopTimer();
			e.data.instance.init();
		});
		
		$(".simple-player .player-button").click({instance: this}, function(e) {
			if ($(".simple-player #audio").get(0).paused) {
				e.data.instance.play();
			} else {
				e.data.instance.pause();
			}
			
		});
		$(".simple-player .player-closer").click({instance: this}, function(e) {
			e.data.instance.closeplayer();
		});
		
		var thumb = $(".simple-player .player-progressbar .player-progressbar-thumb");
		var track = $(".simple-player .player-progressbar");
		thumb.bind("mousedown", {instance: this}, onThumbMouseDown);
		track.bind("click", {instance: this}, onTrackClick);
		
		function onTrackClick(e) {
			var x = e.pageX - thumb.width() / 2;
			thumb.offset({left: x});
			var pos = (thumb.offset().left - track.offset().left) / (track.width() - thumb.width());
			e.data.instance.seek(pos);
		}
		
		function onThumbMouseDown(e) {
			$("body").bind("mousemove", {instance: e.data.instance}, onThumbMouseMove);
			$("body").bind("mouseup", {instance: e.data.instance}, onThumbMouseUp);
		}
		
		function onThumbMouseMove(e) {
			
			var x = e.pageX - thumb.width() / 2;
			if (x < track.offset().left) {
				x = track.offset().left;
			}
			if (x > track.offset().left + track.width() - thumb.width()) {
				x = track.offset().left + track.width() - thumb.width();
			}
			thumb.offset({left: x});
		}
		
		function onThumbMouseUp(e) {
			$("body").unbind("mousemove");
			$("body").unbind("mouseup");
			var pos = (thumb.offset().left - track.offset().left) / (track.width() - thumb.width());
			e.data.instance.seek(pos);
		}
		
		var timerid;
		var isTimerRunning = false;
		function startTimer() {
			timerid = setInterval(function(){
				progress();
			}, 10);
			isTimerRunning = true;
		}
		function stopTimer() {
			clearInterval(timerid);
			isTimerRunning = false;
		}
		
		
		function progress() {
			var currentTime = $(".simple-player #audio").get(0).currentTime;
			var duration = $(".simple-player #audio").get(0).duration;
			var x = (track.width() - thumb.width()) * (currentTime / duration) + track.offset().left;
			thumb.offset({left: x});
		}
		
		this.play = function() {
			if (newOption.onplayed) {
				newOption.onplayed("simpleplayer");
			}
			
			$(".simple-player .player-button").text("暂停");
			$(".simple-player #audio").get(0).play();
			startTimer();
		};
		
		this.pause = function() {
			$(".simple-player .player-button").text("播放");
			$(".simple-player #audio").get(0).pause();
			stopTimer();
		};
		this.stop = function() {
			$(".simple-player .player-button").text("播放");
			$(".simple-player #audio").get(0).pause();
			$(".simple-player #audio").attr("src", null);
			stopTimer();
		};
		this.seek = function(pos) {
			var seektime = this.audioduration * pos;
			$(".simple-player #audio").get(0).currentTime = seektime;
		}
		
		this.init = function() {
			$(".simple-player .player-button").text("播放");
			var x = track.offset().left;
			thumb.offset({left: x});
		}
	}
	
	SimplePlayer.prototype = {
		show: function(item) {
			$(".simple-player").show();
			$(".simple-player .title").text(item.title);
			this.audiopath = item.audiopath;
			$(".simple-player #audio").attr("src", this.audiopath);
			this.init();
		},
		closeplayer: function() {
			$(".simple-player .title").text("");
			this.stop();
			this.audiopath = null;
			this.audioduration = 0;
			this.audioposition = 0;
			this.title = "";
			$(".simple-player").hide();
		}
	}
	
	$.simpleplayer = function(option) {
		var sp = new SimplePlayer(option);
		return sp;
	}
	
})(jQuery);
