$(function() {
	$('#_province').change(function() {
		$.ajax({
			url: "http://teachertool.kouyu100.com/findCityByProvinceForTeacher.action?aaa=" + Math.random(),
			type: "get",
			contentType: "application/jsonp; charset=utf-8",
			dataType: "jsonp",
			data: {"provinceId" : $("#province").val()},
			jsonp: "callback",
			jsonpCallback: "cityList",
			success: function(msg) {
				$("#city").html("<option value=\"-1\">&nbsp;&nbsp;请选择市</option>");
				$("#district").html("<option value=\"-1\">&nbsp;&nbsp;请选择区/县</option>");
				$("#school").html("<option value=\"-1\">&nbsp;&nbsp;请选择学校</option>");
				var temp = getcityListHtml(msg);
		        $("#city").html(temp);
		        $("#city").removeAttr("disabled");
		        $("#city").trigger("cityInforReady");
			},
			error: function(XMLHttpRequest, textStatus, errorThrown) {
				alert('市--信息加载失败');
			}
		});
	});
	$('#_city').change(function() {
		$.ajax({
			url: "http://teachertool.kouyu100.com/findDistrictByCityIdForTeacher.action?aaa=" + Math.random(),
			type: "get",
			contentType: "application/jsonp; charset=utf-8",
			dataType: "jsonp",
			data: {"cityId" : $("#city").val()},
			jsonp: "callback",
			jsonpCallback: "districtList",
			success: function(msg) {
				$("#district").html("<option value=\"-1\">&nbsp;&nbsp;请选择区/县</option>");
				$("#school").html("<option value=\"-1\">&nbsp;&nbsp;请选择学校</option>");
				var temp = getDistrictListHtml(msg);
				$("#district").html(temp);
				$("#district").removeAttr("disabled");
				$("#district").trigger("districtInforReady");
			},
			error: function(XMLHttpRequest, textStatus, errorThrown) {
				alert('县--信息加载失败');
				
			}
		});
	});
	$('#_district').change(function() {
		$.ajax({
			url: "http://teachertool.kouyu100.com/findDomainByDistrictIdForTeacher.action?aaa=" + Math.random(),
			type: "get",
			contentType: "application/jsonp; charset=utf-8",
			dataType: "jsonp",
			data: {"cityId" : $("#city").val(),"districtId":$("#district").val()},
			jsonp: "callback",
			jsonpCallback: "domainList",
			success: function(msg) {
				$("#school").html("<option value=\"-1\">&nbsp;&nbsp;请选择学校</option>");
				var temp = getDomainListHtml(msg);
				$("#school").html(temp);
				$("#school").removeAttr("disabled");
				$("#school").trigger("schoolInforReady");
			},
			error: function(XMLHttpRequest, textStatus, errorThrown) {
				alert('校--信息加载失败');
				
			}
		});

	});
});

function getcityListHtml(json) {
	var temp = "<option value='-1' selected='selected'>&nbsp;&nbsp;请选择市</option>";
	$.each(json.userCityList, function(i, city) {

		temp += "<option value='" + city.cityId + "'>&nbsp;&nbsp;" + city.cityName + "</option>"
	});
	return temp;
}

function getDistrictListHtml(json) {
	var temp = "<option value='-1' selected='selected'>&nbsp;&nbsp;请选择区/县</option>";
	$.each(json.userDistrictList, function(i, district) {
		temp += "<option value='" + district.districtId + "'>&nbsp;&nbsp;" + district.districtName + "</option>"
	});
	return temp;
}

function getDomainListHtml(json) {
	var temp = "<option value='-1' selected='selected'>&nbsp;&nbsp;请选择学校</option>";
	$.each(json.domainList, function(i, value) {
		temp += "<option value='" + value.url + "' domain='" + value.domain + "'>&nbsp;&nbsp;" + value.name + "</option>"
	});
	return temp;
}