
/** 获取URL参数 */
function getparams() {
	var localhref = String(window.document.location.href);
	var paramstart = localhref.indexOf("?");
	var paramstring = localhref.substr(paramstart + 1, localhref.length);
	
	var params = paramstring.split("&");
	var returnparam = {};
	for (var i = 0; i < params.length; i++) {
		var param = params[i];
		var paramArr = param.split("=");
		returnparam[paramArr[0]] = paramArr[1];
	}
	return returnparam;
}
/** 组合URL参数 */
function combparams(obj) {
	var returnparam = "";
	for (var i in obj) {
		returnparam += (i + "=" + obj[i]) + "&";
	}
	if (obj == null || obj == undefined || obj == {}) {
		return returnparam;
	} else {
		return "?" + returnparam.substring(0, returnparam.length - 1);
	}
	
}
/** 跳转新页面 */
function gotoNew(url, params) {
	if (!params) {
		window.location.href = url;
		return;
	}
	window.location.href = url + combparams(params);
}
/** 打开新窗口 */
function gotoNewWindow(url) {
	window.open(url, "bmarks", "chrome");
}
/** 关闭窗口 */
function window_close() {
	window.close();
}
/** 窗口最小化 */
function window_minimize() {
//	alert("minimize");
	window.minimize();
}

/** 重启主程序 */
function relaunch() {
	var file = new FileUtils.File(appRoot() + "口语100离线课堂工具.exe");
	file.launch();
}

/** 窗口刷新 */
function window_refresh() {
	window.location.reload();
}

function checkCloseFile() {
	var file = new FileUtils.File(FileUtils.getDir("CurProcD", ["xulrunner"]).path + "\\" + "appclose.exe");
	return file.exists();
}

function checkHelpFile() {
	var file = new FileUtils.File(defaultDataRoot() + "help\\index.html");
	return file.exists();
}

function killprocess() {
	var root = FileUtils.getDir("CurProcD", ["xulrunner"]).path + "\\";
	var file = new FileUtils.File(root + "appclose.exe");
	if (file.exists()) {
		file.launch();
	}
}



/** 读取配置文件 */
function getLoginParams() {
	var file = new FileUtils.File(configRoot() + "login.json");
	
	var loginParam;
	if (!file.exists()) {
		alert("未获取到登录信息！");
	} else {
		loginParam = JSON.parse(readFileToString(file));
		return loginParam;
	}
}

/** 设置登录参数 */
function setLoginParams(param) {
	var file = new FileUtils.File(configRoot() + "login.json");
	var loginParams;
	if (file.exists()) {
		writeFileToString(configRoot() + "login.json", JSON.stringify(param));
	} else {
		createFile(file.path, JSON.stringify(param));
	}
}

/** 读取配置文件 */
function getConfig(property) {
	var file = new FileUtils.File(configRoot() + "config.json");
	if (!file.exists()) {
		try {
			createFile(file.path, JSON.stringify(defaultConfig()));
		} catch (e) {
//			alert(e);
		}
		return null;
	}
	try {
		var config = JSON.parse(readFileToString(file));
	} catch (e) {
		alert(e);
	}
	
	if (!property) {
		return config;
	} else {
		return config[property];
	}
}

/** 修改配置文件 */
function setConfig(property, value) {
	var file = new FileUtils.File(configRoot() + "config.json");
	var config = JSON.parse(readFileToString(file));
	config[property] = value;
	writeFileToString(configRoot() + "config.json", JSON.stringify(config));
}
/** 默认配置文件格式 */
function defaultConfig() {
	return {
		isGuide: true,
		offlinePath: "",
		login: {
			provinceId: -1,
			provinceName: "",
			cityId: -1,
			cityName: "",
			districtId: -1,
			districtName: "",
			server: -1,
			domain: "",
			school: "",
			username: "",
			password: ""
		},
		defaultCourse: {
			domain: "",
			bookId: -1,
			lessonId: -1
		},
		defaultSeehear: {
			domain: "",
			bookId: -1,
			lessonId: -1
		},
		defaultExam: {
			domain: "",
			bookId: -1,
			lessonId: -1
		},
		downloadRecord: []
	}
}

/** 添加下载记录 */
function appendDownloadRecord(records) {
//	var aaa = getConfig("downloadRecord");
//	if (aaa == null) {
//		aaa = defaultConfig().downloadRecord;
//	}
//	aaa.unshift(records);
//	setConfig("downloadRecord", aaa);
	var file = new FileUtils.File(configRoot() + "config.json");
	var config = JSON.parse(readFileToString(file));
	config.downloadRecord.unshift(records);
	/*for (var i = 0; i < records.length; i++) {
		config.downloadRecord.unshift(records[i]);
	}*/
	writeFileToString(configRoot() + "config.json", JSON.stringify(config));
}

/**
 * 数据/配置文件存放目录
 */
function configRoot() {
	var root = FileUtils.getDir("Home", ["arivoc", "ott"], true).path + "\\";
	return root;
}

/**
 * 更新文件下载目录
 */
function defaultDataRoot() {
	var root = FileUtils.getDir("AChrom", ["DATA"], true).path + "\\";
	return root;
}

/**
 * 更新文件目录
 */
function updateContentPath() {
	var root = FileUtils.getDir("AChrom", [], true).path + "\\";
	return root;
}

function appRoot() {
	var root = FileUtils.getDir("CurProcD", [], true).path + "\\";
	return root;
}

/**
 * 获取存放资源包的根目录
 */
function dataRoot() {
	return getConfig("offlinePath") + "\\";
}

/**
 * 获取存放数据的目录
 */
function dataDir(paths) {
	var dir = dataRoot() + paths + "\\";
	return dir;
}

/** 本地创建一个文件 */
function createFile(path, content) {
	var filepath = path;
	var xmlfile = new FileUtils.File(filepath);
	if (xmlfile.exists()) {
		return;
	}
	
	xmlfile.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, FileUtils.PERMS_FILE);
	
	if (content) {
		writeFileToString(filepath, content);
	}
}
/** 异步读取本地文件内容 */
function getFileContent(path, callback) {
	var filepath = path;
	var xmlfile = new FileUtils.File(filepath);
	
	if (!xmlfile.exists()) {
		callback(null);
		return;
	}
	
	NetUtil.asyncFetch(xmlfile, function(inputStream, status) {
		if (!Components.isSuccessCode(status)) {
		  	// Handle error!
		  	return;
		}
		var xmlContent;
		try {
			xmlContent = NetUtil.readInputStreamToString(inputStream, inputStream.available());
		} catch (e) {
			xmlContent = "";
		}
		callback(xmlContent);
	});
	
}
/** 同步读取本地文件内容 */
function readFileToString(file){	
	
	var data = "";
	var fstream = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
	var cstream = Components.classes["@mozilla.org/intl/converter-input-stream;1"].createInstance(Components.interfaces.nsIConverterInputStream);
	
	if(!file.exists()) {
		return null;
	}
	
	fstream.init(file, -1, 0, 0);
	cstream.init(fstream, "UTF-8", 0, 0); 
	
	var read = -1;
	var str = {};
	while(read != 0){
		read = cstream.readString(0xffffffff, str);
		data += str.value;
	}
	cstream.close(); 	
	return data;	
}
/** 写内容到本地文件 */
function writeStringToFile(path, content, callback) {
	var rootpath = dataRoot();
	var xmlpath = rootpath + path;
	var xmlfile = new FileUtils.File(xmlpath);
	
	var ostream = FileUtils.openSafeFileOutputStream(xmlfile);
	var converter = Components.classes["@mozilla.org/intl/scriptableunicodeconverter"].createInstance(Components.interfaces.nsIScriptableUnicodeConverter);
	converter.charset = "UTF-8";
	var istream = converter.convertToInputStream(content);
	NetUtil.asyncCopy(istream, ostream, function(status) {
		if (!Components.isSuccessCode(status)) {
//			log("writeFaile:" + content);
			return;
		}
		callback();
	});
}
/** 同步写内容到本地文件 */
function writeFileToString(path, str){
	var filepath = path;
	var file = new FileUtils.File(filepath);
	
	var fstream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
	var cstream = Components.classes["@mozilla.org/intl/converter-output-stream;1"].createInstance(Components.interfaces.nsIConverterOutputStream);
	
	if(!file.exists()) {
		createFile(file.path, str);
		return;
	}
	
	fstream.init(file, -1, 0, 0);
	cstream.init(fstream, "UTF-8", 0, 0);
	
	cstream.writeString(str);
	cstream.close();
}
/** 删除一个本地文件或目录 */
function delectFile(path) {
	if (!path || path == "") {
		return;
	}
	var filepath = path;
	var file = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsIFile);
	file.initWithPath(filepath);
	
	if (file.exists()) {
		try {
			file.remove(true);
		} catch (e) {
		}
	}
}

const COURSE = "course";
const EXAM = "exam";
const OTHER = "other";
const SEEHEAR = "seehear";
const WORDLIST = "wordlist";
const LIST = "list";
const COURSE_HOMEWORK = "courseHomework";
const PRAISE_CONCERN = "praiseConcern";
const VIDEO_PICTURE = "videoPicture";
const REWARD = "reward";

/** 下载状态 */
const UNDOWNLOAD = 0;
const DOWNLOADING = 1;
const DOWNLOADED = 2;
const UNZIPING = 3;
const UNZIPED = 4;
const DOWNLOADERROR = 8;
const UNZIPERROR = 9;

var downloadlist = [];

/** 下载并解压 */
function downloadAndUnzip(filetype, fileid, downloadurl, downloadpath, unzippath, callback) {
	//当前阶段 （0：未下载；1：下载中；2：下载完；3：解压中；4：解压完）
	var currentPhase = {status: UNDOWNLOAD};
	
	//根目录
//	var rootpath = dataRoot();
	
	//download目标文件
	var downloadfile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
	downloadfile.initWithPath(downloadpath);
	if (downloadfile.exists()) {
		delectFile(unzippath);
	}
	downloadfile.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0666);
	
	try {
		download(downloadurl + "?r=" + Math.random(), downloadfile);
	} catch (e) {
		currentPhase = {status: DOWNLOADERROR};
		callback(filetype, currentPhase, fileid);
	}
	
	
	/** 下载ZIP文件 */
	function download(url, file) {
		var downloadPromise = null;
		
		var downloader;
		Downloads.createDownload({
			source: url,
			target: file
		}).then(function(a) {
			downloader = a;
			downloadlist.push({type: filetype, fileid: fileid, downloader: downloader});
			downloader.onchange = function() {
				currentPhase = {status: DOWNLOADING, value: downloader.progress};
				callback(filetype, currentPhase, fileid);
				if (downloader.succeeded == true) {
					onDownloadSuccess();
				}
			}
			downloader.start();
		}, function() {
			currentPhase = {status: DOWNLOADERROR};
			callback(filetype, currentPhase, fileid);
			return;
		});
		
		return downloadPromise;
	}
	
	function onDownloadSuccess() {
		currentPhase = {status: DOWNLOADED};
		callback(filetype, currentPhase, fileid);
		
		//不需解压时， unzippath为null;
		if (unzippath != null) {
			try {
				decompression();
			} catch (e) {
				currentPhase = {status: UNZIPERROR};
				callback(filetype, currentPhase, fileid);
			}
			
		}
	}
	
	/** 解压ZIP文件 */
	function decompression() {
		var zipfile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
	    var zippath = downloadpath;
		zipfile.initWithPath(zippath);
		if (!zipfile.exists()) {
			currentPhase = {status: UNZIPERROR};
			callback(filetype, currentPhase, fileid);
			return;
		}
		
		var zipReader = Components.classes["@mozilla.org/libjar/zip-reader;1"].createInstance(Components.interfaces.nsIZipReader);
		zipReader.open(zipfile);
		var entries = zipReader.findEntries(null);
		
		var isEnd = false;
		while (entries.hasMore()) {
        	var entryPointer = entries.getNext(); 
        	var entry = zipReader.getEntry(entryPointer);
        	var inputStream = zipReader.getInputStream(entryPointer);
        	var subfile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
        	
        	isEnd = !entries.hasMore();

			subfile.initWithPath(unzippath + "\\" + entryPointer);
			if (subfile.exists()) {
				subfile.remove();
			}
			subfile.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0666);
			writeStreamToFile(subfile, inputStream, isEnd).then(function(end){
				currentPhase = {status: UNZIPED};
				if (end) {
					callback(filetype, currentPhase, fileid);
				}
			}, function(){
				currentPhase = {status: UNZIPERROR};
				callback(filetype, currentPhase, fileid);
				return;
			});
		}
		zipReader.close();
	}
	
	/** 异步写文件流 */
	function writeStreamToFile(file, stream, isEnd) {
		var promise = new Promise(function(resolve, reject) {
			var ostream = Components.classes["@mozilla.org/network/file-output-stream;1"].createInstance(Components.interfaces.nsIFileOutputStream);
			ostream.init(file, -1, -1, 0);
			NetUtil.asyncCopy(stream, ostream, function(aResult) {
			  	if (!Components.isSuccessCode(aResult)) {
			    	reject();
			  	} else {
			  		resolve(isEnd);
			  	}
			});
		});
		return promise;
	}
}

/** 取消下载 */
function clearDownload(filetype, fileid) {
	$.each(downloadlist, function(i, item) {
		if (item.type == filetype && item.fileid == fileid && !item.downloader.stopped) {
			item.downloader.cancel().then(function() {
				item.downloader.removePartialData();
				deleteOne(filetype, fileid, true);
			}, function() {
//				deleteOne(filetype, fileid, true);
			});
		}
	});
}

function clearAllDownload() {
	$.each(downloadlist, function(i, item) {
		item.downloader.cancel().then(function() {
			item.downloader.removePartialData();
			deleteOne(filetype, fileid, true);
		}, function() {
		});
	});
}

/** 获取下载需要的数据 */
function newItemData(type, fid, option) {
	
	var newData = {};
	newData.type = type;
	newData.fileid = fid;
	newData.status = 0;
	
	switch (type)
	{
		case COURSE:
			newData.bookname = option.bookname;
			newData.lessonname = option.lessonname;
			newData.bookcname = option.bookcname;
			newData.lessoncname = option.lessoncname;
			newData.name = option.bookcname + "--" + option.lessoncname;
			newData.url = "http://course2.kouyu100.com/course/" + option.bookname + "/" + option.lessonname + "/mp3.zip";
			newData.filename = "mp3.zip";
			newData.path = "course\\" + option.bookname + "\\" + option.lessonname;
			break;
		case EXAM:
			newData.bookname = option.bookname;
			newData.lessonname = option.lessonname;
			newData.name = option.bookname + "--" + option.lessonname;
			newData.url = "http://exam2.kouyu100.com/userDomain/" + option.examurl;
			var examdirs = option.examurl.split("/");
			var filename = examdirs.pop();
			examdirs.shift();
			examdirs.push(filename.substring(0, filename.indexOf(".zip")));
			newData.filename = filename;
			newData.path = "exam\\" + examdirs.join("\\");
			break;
		case LIST:
			newData.name = option.name;
			newData.url = "";
			newData.filename = "";
			newData.path = "";
			
			/*newData.url = "https://kouyu100-exam.oss-cn-hangzhou.aliyuncs.com/" + option.listurl;
			var listdirs = option.listurl.split("/");
			var listname = listdirs.pop();
			listdirs.push(listname.substring(0, listname.indexOf(".zip")));
			newData.filename = listname;
			newData.path = "list\\" + listdirs.join("\\");*/

			break;
		case COURSE_HOMEWORK:
			newData.name = option.name;
			newData.url = "";
			newData.filename = "";
			newData.path = "";
		
			/*newData.url = "https://kouyu100-exam.oss-cn-hangzhou.aliyuncs.com/" + option.homeworkurl;
			var homeworkdirs = option.homeworkurl.split("/");
			var homeworkname = homeworkdirs.pop();
			homeworkdirs.push(homeworkname.substring(0, homeworkname.indexOf(".zip")));
			newData.filename = homeworkname;
			newData.path = "courseHomework\\" + homeworkdirs.join("\\");*/

			break;
			
		case VIDEO_PICTURE:
			newData.name = option.name;
			newData.url = "";
			newData.filename = "";
			newData.path = "";
			
//			newData.url = "http://kouyu100-exam.oss-cn-hangzhou.aliyuncs.com/" + option.videourl;
//			var videodirs = option.videourl.split("/");
//			var videoname = videodirs.pop();
//			videodirs.push(videoname.substring(0, videoname.indexOf(".zip")));
//			newData.filename = videoname;
//			newData.path = "videoPicture\\" + videodirs.join("\\");
			break;
		case PRAISE_CONCERN:
			newData.name = option.name;
			newData.url = "";
			newData.filename = "";
			newData.path = "";
			
			/*newData.url = "https://kouyu100-exam.oss-cn-hangzhou.aliyuncs.com/" + option.praiseurl;
			var praisedirs = option.praiseurl.split("/");
			var praisename = praisedirs.pop();
			praisedirs.push(praisename.substring(0, praisename.indexOf(".zip")));
			newData.filename = praisename;
			newData.path = "praiseConcern\\" + praisedirs.join("\\");*/

			break;
		case OTHER:
			newData.name = option.name;
			newData.url = "";
			newData.filename = "";
			newData.path = "";
			
//			newData.url = "http://kouyu100-exam.oss-cn-hangzhou.aliyuncs.com/" + option.otherurl;
//			var otherdirs = option.otherurl.split("/");
//			var othername = otherdirs.pop();
//			otherdirs.push(othername.substring(0, othername.indexOf(".zip")));
//			newData.filename = othername;
//			newData.path = "other\\" + otherdirs.join("\\");
			break;
		case SEEHEAR:
			newData.name = option.bookname + "--" + option.lessonname;
			newData.url = "";
			newData.filename = "";
			newData.path = "";
			
//			newData.url = "http://kouyu100-exam.oss-cn-hangzhou.aliyuncs.com/" + option.zipurl;
//			var seeheardirs = option.zipurl.split("/");
//			var seehearname = seeheardirs.pop();
//			seeheardirs.shift();
//			seeheardirs.shift();
//			seeheardirs.push(seehearname.substring(0, seehearname.indexOf(".zip")));
//			newData.filename = seehearname;
//			newData.path = "seehear\\" + seeheardirs.join("\\");
			break;
		case WORDLIST:
			newData.name = option.name;
			newData.url = "";
			newData.filename = "";
			newData.path = "";
			
//			newData.url = "http://kouyu100-exam.oss-cn-hangzhou.aliyuncs.com/" + option.wordurl;
//			var worddirs = option.wordurl.split("/");
//			var wordname = worddirs.pop();
//			worddirs.push(wordname.substring(0, wordname.indexOf(".zip")));
//			newData.filename = wordname;
//			newData.path = "wordlist\\" + worddirs.join("\\");
			break;
		case REWARD:
			newData.name = option.name;
			newData.url = "";
			newData.filename = "";
			newData.path = "";
			break;
	}
	var item = new ItemData(newData, type);
	return item;
}


function ItemData(o, t) {
	//必需字段
	ItemData.INDISPENSABLE = ["fileid", "filename", "type", "url", "path", "status", "name"];
	//附加字段
	ItemData.COURSE_TYPE = ["bookname", "lessonname", "bookcname", "lessoncname"];
	ItemData.EXAM_TYPE = ["bookname", "lessonname"];
	
	
	this.type = t;
	this.propertys = getPropertysByType(this.type);
	// 初始化属性赋值
	this.takeFrom(o);
	
	
	function getPropertysByType(type) {
		switch (type)
		{
			case COURSE:
				return ItemData.INDISPENSABLE.concat(ItemData.COURSE_TYPE);
			case EXAM:
				return ItemData.INDISPENSABLE.concat(ItemData.EXAM_TYPE);
			default: 
				return ItemData.INDISPENSABLE;
		}
	}
}

ItemData.prototype = {
	/** 根据属性名获得属性值 */
	property: function(f) {
		if (this.propertys.indexOf(f) > -1) {
			return this[f];
		} else {
			return undefined;
		}
	},
	/** 根据属性名修改属性值 */
	setProperty: function(key, value) {
		if (this.propertys.indexOf(key) > -1) {
			this[key] = value;
		} else {
			
		}
	},
	/** 向目标对象属性赋值 */
	giveTo: function(ins) {
		if (!ins) { return; }
		var isJQuery = (ins instanceof jQuery);
		for (var i = 0; i < this.propertys.length; i++) {
			var property = this.propertys[i];
			if (isJQuery) {
				ins.attr(property, this[property]);
			} else {
				ins[property] = this[property];
			}
		}
	},
	/** 从目标对象获取属性赋值 */
	takeFrom: function(ins) {
		if (!ins) { return; }
		var isJQuery = (ins instanceof jQuery);
		for (var i = 0; i < this.propertys.length; i++) {
			var property = this.propertys[i];
			if (isJQuery) {
				this[property] = ins.attr(property);
			} else {
				this[property] = ins[property];
			}
		}
	}
}

/**
 * XML管理器
 * @param {Object} xmlpath xml路径
 * @param {Object} callback 建立完成的回调函数
 */
function XMLOperator(xmlpath) {
	this.path = xmlpath;
	this.data;
	var xmlfile = new FileUtils.File(this.path);
	var xmldata = readFileToString(xmlfile);
	if (xmldata == null) {
		this.data = $("<filelist></filelist>");
		createFile(this.path, "<filelist></filelist>");
	} else if (xmldata == "") {
		this.data = $("<filelist></filelist>");
	} else {
		this.data = $(xmldata);
	}
}

XMLOperator.prototype = {
	/** 添加一个file */
	addItem: function(item) {
		var fileItem = $("<file></file>");
		item.giveTo(fileItem);
		this.data.append(fileItem);
		this.refresh();
	},
	/** 删除file */
	remove: function(type, id) {
		this.data.find("file").remove("[type='" + type + "'][fileid='" + id + "']");
		this.refresh();
	},
	/** 清除所有file */
	removeAll: function() {
		this.data.empty();
		this.refresh();
	},
	/** 判断file是否存在 */
	exists: function(id, type) {
		var boo = false;
		this.data.find("file").each(function(i) {
			if ($(this).attr("fileid") == id && $(this).attr("type") == type) {
				boo = true;
			}
		});
		return boo;
	},
	/** 修改file属性 */
	setProperty: function (type, id, property, value) {
		this.data.find("file[type='" + type + "'][fileid='" + id + "']").attr(property, value);
		this.refresh();
	},
	/** 刷新XML文件（写入新数据） */
	refresh: function() {
//		writeStringToFile(this.path, this.toString());
		writeFileToString(this.path, this.toString());
	},
	/** 获取XML字符串 */
	toString: function() {
		return "<filelist>" + this.data.html() + "</filelist>";
	}
}

/** 从目标数组中取出若干项目 */
function getElementsFromArray(target, begin, end) {
	var temarray = [];
	for(var i = begin; i <= end; i++) {
		if (i > target.length - 1) {
			break;
		}
		temarray.push(target[i]);
	}
	return temarray;
}

/** 创建一个资源包标识文件 */
function createResourceIdenFile(path, obj) {
	var jsonString = JSON.stringify(obj);
	var filepath = path + ".resourcepackage";
	var resourceFile = new FileUtils.File(filepath);
	if (resourceFile.exists()) {
		try {
			resourceFile.remove(true);
		} catch (e) {}
	}
	createFile(filepath, jsonString);
}
