var operator;			//XML管理器
var downloadPopup;		//下载任务弹窗
var lassNameJson;       //班级名单
var offlinepath;	//离线目录
var classinfor;

/** 在线课堂页 数据 配置文件 弹窗等 初始化 */
function initDownloadPopup(classInfor) {
	
	classinfor = classInfor;
	
	operator = new XMLOperator(configRoot() + "download.xml");
	
	downloadPopup = $.downTaskPopup({
		config: null,
//		config: configRoot() + "download.xml",
		ondownload: downloadAll,
		ondelete: deleteOneItem,
		ondeleteAll: deleteAll,
		onOfflineReset: offlineReset
	});
	
	offlinepath = getConfig("offlinePath");
	if (!offlinepath) {
		offlinepath = defaultConfig().offlinePath;
	}
	downloadPopup.setOfflinePath(offlinepath);
}

/** 重新选择资源包下载地址 */
function offlineReset() {
	var nsIFilePicker = Components.interfaces.nsIFilePicker;
	var fp = Components.classes["@mozilla.org/filepicker;1"].createInstance(nsIFilePicker);
	fp.init(window, "选择离线数据文件夹", nsIFilePicker.modeGetFolder);
	fp.open(function(r) {
		if (r == 0) {
			offlinepath = fp.file.path;
			setConfig("offlinePath", offlinepath);
			downloadPopup.setOfflinePath(offlinepath);
		}
	});
}

/** 下载所有文件 */
function downloadAll() {
	
	if (offlinepath == "") {
		$.Alert("请设置离线目录，推荐使用 “班级名称+日期”的格式命名，例如：2013级三年十四班0628！", 2, function() {
			offlineReset();
		});
	} else {
		$.Alert("确定要将“" + classinfor.classname +  "”的数据下载到: " + offlinepath + "目录中吗?", 2, onAlertYes);
	}
	
	function onAlertYes() {
		/** 班级名单 */
		$.ottdata.getClassNameData({orgId:classid,orgType:classtype}, function(result){
			lassNameJson = result.classNameJson; 
			lassNameJson.orgId = classid;
			lassNameJson.orgType = classtype;
			lassNameJson.server = server;
			lassNameJson.domain = domain;
			var classnamePath = dataRoot() + "className\\classname.json";
			var xmlfile = new FileUtils.File(classnamePath);
			if (xmlfile.exists()) {
				xmlfile.remove(true);
			}
			createFile( classnamePath ,JSON.stringify(lassNameJson));
		});
		
		var list = downloadPopup.getDownloadList();
		$.each(list, function(i) {
			var item = list[i];
			downloadOne(item.property("type"), item.property("fileid"));
		});
	}
	
}

/** 获取当前时间 */
Date.prototype.Format = function (fmt) { //author: meizz 
var o = {
	"M+": this.getMonth() + 1, //月份 
	"d+": this.getDate(), //日 
	"h+": this.getHours(), //小时 
	"m+": this.getMinutes()
	};
	if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
	for (var k in o)
	if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
	return fmt;
}

/** 下载一个文件 */
function downloadOne(type, fid) {
	var item = downloadPopup.getDownloadItem(type, fid);
	
	var url = item.property("url");
	var name = item.property("filename");
	var id = item.property("fileid");
	var dir = dataDir(item.property("path"));
	
	downloadAndUnzip(type, id, url, dir + name, dir, function(type, phase, fileid) {
		downloadResult(type, phase, fileid);
	});
}
/** 下载完成处理 */
function downloadResult(type, phase, fileid) {
	if (phase.status != UNZIPED) {
		downloadPopup.changeStatus(type, fileid, "status", phase);
		operator.setProperty(type, fileid, "status", phase.status);
		return;
	}
	extraActionAfterUnzip(type, fileid, function(result) {
		if (result == "error") {
			downloadPopup.changeStatus(type, fileid, "status", {status: UNZIPED});
			operator.setProperty(type, fileid, "status", UNZIPED);
		} else {
			downloadPopup.changeStatus(type, fileid, "status", {status: UNZIPED});
			operator.setProperty(type, fileid, "status", UNZIPED);
			// 添加下载记录
			appendDownloadRecord(getDownloadRecordInfo(type, fileid));
		}
	});
}

function getDownloadRecordInfo(type, fileid){
	var item2 = downloadPopup.getDownloadItem(type,fileid);
	var txt = "";
	if(type=="course"){
		txt = '课文朗读《'+item2.property("name")+'》';
	}else if(type=="exam"){
		txt = '听力测试《'+item2.property("name")+'》';
	}else if(type=="seehear"){
		txt = '泛视听《'+item2.property("name")+'》';
	}else{
		txt = item2.property("name") + " ";
	}
	var text = (new Date()).Format("yyyy-MM-dd hh:mm")+" 下载“"+$(".class_info_name .curName").text()+"”"+txt+"到"+offlinepath+"目录中。";
	var records = {
		type : type,
		classname : $(".class_info_name .curName").text(),
		filename : item2.property("name"),
		createtime : (new Date()).Format("yyyy-MM-dd hh:mm"),
		path : offlinepath,
		text:text
	}
	return records;
}

/** 删除所有文件 */
function deleteAllFile() {
	deleteAll(true);
}
/** 删除所有列表 */
function deleteAll(hasfile) {
	if (!downloadPopup.getAllDownloadState(true)) {
		$.Alert("存在未下载完成的项目，确定要清空所有吗？", 2, onDeleteAll);
	} else {
		onDeleteAll();
	}
	
	function onDeleteAll() {
		var list = downloadPopup.getAllList();
		$.each(list, function(i, item) {
			clearDownload(item.property("type"), item.property("fileid"));
			deleteOne(item.property("type"), item.property("fileid"), hasfile);
		});
		operator.removeAll();
	}
}
function deleteOneItem(type, fid, hasfile) {
	var curStatus = downloadPopup.getProperty(type, fid, "status");
	var curState = downloadPopup.getProperty(type, fid, "state");
	if (curStatus != 4 && curStatus != 8 && curStatus != 9 && curState != 2) {
		$.Alert("该项目尚未下载完成，确定要删除吗？", 2, function() {
			clearDownload(type, fid);
			deleteOne(type, fid, hasfile);
		});
	} else {
		deleteOne(type, fid, hasfile);
	}
}
/** 删除一个文件 */
function deleteOne(type, fid, hasfile) {
	var item = downloadPopup.getDownloadItem(type, fid);
	downloadPopup.remove(type, fid);
	operator.remove(type, fid);
	$.ottdata.remove(type, fid);
	if (hasfile) {
		try {
			delectFile(dataDir(item.property("path")));
		} catch (e) {}
	}
}
/** 创建一个下载项目 */
function createDownloadItem(type, item) {
	if (item == null) {
		return;
	}
	var option = {};
	var fileid;
	var prompt = "";
	switch (type)
	{
		case COURSE:
			option.bookname = $(item).attr("bookName");
			option.lessonname = $(item).attr("lessonName");
			option.bookcname = $(item).attr("bookCName");
			option.lessoncname = $(item).attr("lessonCName");
			fileid = $(item).attr("lessonId");
			prompt = option.lessoncname;
			break;
		case EXAM:
			option.bookname = $(item).attr("bookName");
			option.lessonname = $(item).attr("lessonName");
			option.examurl = arivoc_exam.zipUrl;
			fileid = $(item).attr("lessonId");
			prompt = option.lessonname;
			break;
		case LIST:
			fileid = item.fileid;
			option.listurl = item.listurl;
			option.name = item.name;
			break;
		case COURSE_HOMEWORK:
			fileid = item.fileid;
			option.homeworkurl = item.homeworkurl;
			option.name = item.name;
			break;
		case VIDEO_PICTURE:
			fileid = item.fileid;
			option.videourl = item.videourl;
			option.name = item.name;
			break;
		case PRAISE_CONCERN:
			fileid = item.fileid;
			option.praiseurl = item.praiseurl;
			option.name = item.name;
			break;
		case OTHER:
			fileid = item.fileid;
			option.otherurl = item.otherurl;
			option.name = item.name;
			break;
		case SEEHEAR:
			fileid = item.fileid;
			option.seehearurl = item.seehearurl;
			option.bookname = item.bookname;
			option.lessonname = item.lessonname;
			prompt = option.lessonname;
			break;
		case WORDLIST:
			fileid = item.fileid;
			option.wordurl = item.wordurl;
			option.name = item.name;
			break;
		case REWARD:
			fileid = item.fileid;
			option.rewardurl = item.rewardurl;
			option.name = item.name;
			break;
	}
	var item = newItemData(type, fileid, option);
	if (operator.exists(item.property("fileid"), item.property("type"))) {
		deleteOne(item.property("type"), item.property("fileid"), false);
	}
	downloadPopup.addDownloadItem(item);
	$.Prompt(prompt + "添加成功");
	operator.addItem(item);
}

/** 补充参数 */
function supplyProperty(type, fileid, params) {
	for (var ii in params) {
		downloadPopup.setProperty(type, fileid, ii, params[ii]);
		operator.setProperty(type, fileid, ii, params[ii]);
	}
}

/** 下载完成添加附加文件 */
function addNewExtraFile(path, filename, data) {
	if (!path || path == "") {
		return;
	}
	var filedata;
	if (typeof(data) == "string") {
		filedata = data;
	} else if (typeof(data) == "object") {
		filedata = JSON.stringify(data);
	}
	var filepath = dataRoot() + path + "\\" + filename;
	createFile(filepath, filedata);
}

function extraActionAfterUnzip(type, fileid, callback) {
	var curDownloadItem = downloadPopup.getDownloadItem(type, fileid);
	switch (type) 
	{
		case COURSE:
			var courseInfor = "<pratices><bookname>"
								+ curDownloadItem.property("bookname") + 
								"</bookname><bookcname>"
								+ curDownloadItem.property("bookcname") + 
								"</bookcname><lessonname>"
								+ curDownloadItem.property("lessonname") + 
								"</lessonname><lessoncname>"
								+ curDownloadItem.property("lessoncname") + 
								"</lessoncname></pratices>";
			addNewExtraFile(curDownloadItem.property("path"), "infor.xml", courseInfor);
			$.ottdata.getCourseBuckle({lessId: curDownloadItem.property("fileid")}, function(result) {
				if (result == "error") {
					addNewExtraFile(curDownloadItem.property("path"), "buckle.json", {isBuckle: 0});
				} else {
					addNewExtraFile(curDownloadItem.property("path"), "buckle.json", result);
				}
				callback();
			});
			break;
		case EXAM:
			var examInfor = "<pratices><bookname>"
							+ curDownloadItem.property("bookname") + 
							"</bookname><bookcname>"
							+ curDownloadItem.property("bookcname") + 
							"</bookcname><lessonname>"
							+ curDownloadItem.property("lessonname") + 
							"</lessonname><lessoncname>"
							+ curDownloadItem.property("lessoncname") + 
							"</lessoncname></pratices>";
			addNewExtraFile(curDownloadItem.property("path"), "infor.xml", examInfor);
			$.ottdata.getExamContentData({examId: curDownloadItem.property("fileid")}, function(result) {
				if (result == "error") {
					callback(result);
				} else {
//					var file = new FileUtils.File(dataRoot() + curDownloadItem.property("path") + "\\exam.xml");
//					var exam1 = readFileToString(file);
//					var x2js = new X2JS();
//					var finalExam = $.extend(true, {}, x2js.xml_str2json(result.xml1), x2js.xml_str2json(exam1));
//					addNewExtraFile(curDownloadItem.property("path"), "exam2.xml", x2js.json2xml_str(finalExam));
					addNewExtraFile(curDownloadItem.property("path"), "exam2.xml", result.xml1);
					callback();
				}
			});
			break;
		default:
			callback();
			break;
	}
	
}

/** 下载弹窗弹出 */
function showDownload() {
	downloadPopup.show();
}