(function($) {
	
//	$.data.getClassroomData({}, function(result){});
	
	$.ottdata = {
		/** 服务器名 域名 */
		server: "",
		domain: "",
		
		/** 是否空闲 */
		isfree: function() {
			return (ajaxQueue.length == 0 && !isAjaxQueueLoading);
		},
		/** 移除一个打包请求 */
		remove: function(type, fileid) {
			
			if (isAjaxQueueLoading) {
				if (curAjaxItem.type == type && curAjaxItem.fileid == fileid) {
					curAjax.abort();
					curAjax = null;
					curAjaxItem = null;
					isAjaxQueueLoading = false;
					return;
				}
			}
			
			for (var i = 0; i < ajaxQueue.length; i++) {
				if (ajaxQueue[i].type == type && ajaxQueue[i].fileid == fileid) {
					ajaxQueue.splice(i, 1);
				}
			}
		},

		/** 班级名单 */
		getClassNameData: function(data, callback) {
			callAjax("className", data, callback);
		},
		
		/** 班级榜单 */
		getClassroomData: function(data, callback) {
			callAjax("classroom", data, callback);
		},
		getListZip: function(data, callback) {
			callAjax("listZip", data, callback);
		},
		/** 跟读作业 */
		getReadData: function(data, callback) {
			callAjax("read", data, callback);
		},
		getReadZip: function(data, callback) {
			callAjax("readZip", data, callback);
		},
		/** 微视频 */
		getVideoData: function(data, callback) {
			callAjax("video", data, callback);
		},
		getVideoZip: function(data, callback) {
			callAjax("videoZip", data, callback);
		},
		
		/** 值得课堂上表扬和关注的人和事 */
		getPraiseData: function(data, callback) {
			callAjax("praise", data, callback);
		},
		getPraiseZip: function(data, callback) {
			callAjax("praiseZip", data, callback);
		},
		
		/** 课文领读 */
		getCourseBookData: function(data, callback) {
			callAjax("courseBook", data, callback);
		},
		getCourseLessonData: function(data, callback) {
			callAjax("courseLesson", data, callback);
		},
		getCourseBuckle: function(data, callback) {
			callAjax("courseBuckle", data, callback);
		},
		
		/** 其他课堂资源 */
		getOtherData: function(data, callback) {
			callAjax("other", data, callback);
		},
		getOtherZip: function(data, callback) {
			callAjax("otherZip", data, callback);
		},
		
		/** 泛视听 */
		getSeehearBookData: function(data, callback) {
			callAjax("seehearBook", data, callback);
		},
		getSeehearLessonData: function(data, callback) {
			callAjax("seehearLesson", data, callback);
		},
		getSeehearContentData: function(data, callback) {
			callAjax("seehearContent", data, callback);
		},
		getSeehearZip: function(data, callback) {
			callAjax("seehearZip", data, callback);
		},
		
		/** 听力测试 */
		getExamBookData: function(data, callback) {
			callAjax("examBook", data, callback);
		},
		getExamLessonData: function(data, callback) {
			callAjax("examLesson", data, callback);
		},
		getExamContentData: function(data, callback) {
			callAjax("examContent", data, callback);
		},
		
		/** 词表资源 */
		getWordData: function(data, callback) {
			callAjax("wordlist", data, callback);
		},
		getWordZip: function(data, callback) {
			callAjax("wordlistZip", data, callback);
		},
		
		/** 奖励记录 */
		getRewardData: function(data, callback) {
			callAjax("reward", data, callback);
		},
		getRewardZip: function(data, callback) {
			callAjax("rewardZip", data, callback);
		},
		
		
		clearRollcall: function(data, callback) {
			callAjax("clearRollcall", data, callback);
		},
		createNewPeriod: function(data, callback) {
			callAjax("newPeriod", data, callback);
		}
	};
	
	var jsonpCallbacks = {
		className: {callback: "classNameBack", url: "/teachertoolsGetClassNameList.action", isqueue: false},
		classroom: {callback: "listXMLBack", url: "/teacher_tools_showBangList.action", isqueue: false},
		read: {callback: "courseHomeworkXMLBack", url: "/teacher_tools_showExampleList.action", isqueue: false},
		video: {callback: "videoPictureBack", url: "/teachertoolsgetVideoPictureList.action", isqueue: false},
		praise: {callback: "praiseConcernBack", url: "/teachertoolsGetPersonalRewardForShow.action", isqueue: false},
		courseBook: {callback: "bookBack", url: "/teachertoolsshowbooks.action", isqueue: false},
		courseLesson: {callback: "lessonBack", url: "/teachertoolsshowlessons.action", isqueue: false},
		courseBuckle: {callback: "resourceBuckleBack", url: "/teachertoolsGetResourceBuckle.action", isqueue: false},
		other: {callback: "resourceBack", url: "/teachertoolsgetOtherResource.action", isqueue: false},
		seehearBook: {callback: "", url: "", isqueue: false},
		seehearLesson: {callback: "", url: "", isqueue: false},
		examBook: {callback: "examBookBack", url: "/teachertoolsshowexambooks.action", isqueue: false},
		examLesson: {callback: "examBack", url: "/teachertoolsshowexams.action", isqueue: false},
		examContent: {callback: "examXMLBack", url: "/teachertoolsgetExamXML.action", isqueue: false},
		seehearContent: {callback: "fstingXMLBack", url: "/teachertoolsgetExamFstingXML.action", isqueue: false},
		wordlist: {callback: "teacherWordBack", url: "/teachertoolsgetTeacherWordForClass.action", isqueue: false},
		reward: {callback: "classroomRewardBack", url: "/teacher_tools_showClassroomRewardList.action", isqueue: false},
		
		//请求下载ZIP包
		listZip: {callback: "listZipBack", url: "/teacher_tools_getBangZip.action", isqueue: false},
		readZip: {callback: "courseHomeworkZipBack", url: "/teacher_tools_getExampleZip.action", isqueue: false},
		
		videoZip: {callback: "videoPictureZipBack", url: "/teachertoolsgetVideoPictureZip.action", isqueue: false},
		praiseZip: {callback: "praiseConcernZipBack", url: "/teacher_tools_getPersonalRewardZip.action", isqueue: false},
		
		otherZip: {callback: "resourceZipBack", url: "/teachertoolsgetOtherResourceZip.action", isqueue: false},
		seehearZip: {callback: "fstingZipBack", url: "/teachertoolsgetExamFstingZip.action", isqueue: false},
		wordlistZip: {callback: "teacherWordZipBack", url: "/teachertoolsgetTeacherWordZip.action", isqueue: false},
		rewardZip: {callback: "rewardPersonalBack", url: "/teacher_tools_showRewardPersonalZip.action", isqueue: false},
		
		//点名清除
		clearRollcall: {callback: "deletClassRollCallBack", url: "/deletClassRollCallForTeacherTools.action", isqueue: false},
		//模块3 开始新周期
		newPeriod: {callback: "classroomRewardBack", url: "/teacher_tools_createNewPeriod.action", isqueue: false}
	};
	
	var ajaxQueue = [];
	var curAjaxItem = null;
	var isAjaxQueueLoading = false;
	var curAjax;
	
//	setInterval(ajaxQueueCall, 500);
	
	function callAjax(type, data, callback) {
		if (jsonpCallbacks[type].url == "" || jsonpCallbacks[type].callback == "") {
			return;
		}
		if (!data) {
			data = {};
		}
		var fixed = getJsonpfixed();
		data.callbackfix = fixed;
		
//		if (jsonpCallbacks[type].isqueue) {
//			var ajaxItem = {};
//			ajaxItem.url = jsonpCallbacks[type].url;
//			ajaxItem.callback = jsonpCallbacks[type].callback + fixed;
//			ajaxItem.callbackfunc = callback;
//			ajaxItem.fileid = data.fileid;
//			ajaxItem.type = data.type;
//			delete data.fileid;
//			delete data.type;
//			ajaxItem.data = data;
//			ajaxQueue.push(ajaxItem);
//			return;
//		}
		$.ajax({
			url: "http://" + server + "/" + domain + jsonpCallbacks[type].url +"?aaa="+Math.random(),
			type: "get",
			contentType: "application/jsonp; charset=utf-8",
			dataType: "jsonp",
			jsonp: "callback",
			jsonpCallback: jsonpCallbacks[type].callback + fixed,
			data: data,
			success: function(returndata) {
				if (returndata.result == 0) {
					callback(returndata);
				} else {
					callback("error");
//					alert("返回数据异常：" + type + "---" + returndata.result);
				}
			},
			error: function(jqXHR, textStatus, errorThrown) {
				callback("error");
//				alert("接口请求失败：" + type + "---" + textStatus + "---" + errorThrown);
			}
		});
	}
	
//	function ajaxQueueCall() {
//		
//		if (isAjaxQueueLoading || (!isAjaxQueueLoading && ajaxQueue.length == 0)) {
//			return;
//		}
//		curAjaxItem = ajaxQueue.shift();
//		isAjaxQueueLoading = true;
//		curAjax = $.ajax({
//			url: "http://" + server + "/" + domain + curAjaxItem.url,
//			type: "get",
//			contentType: "application/jsonp; charset=utf-8",
//			dataType: "jsonp",
//			jsonp: "callback",
//			jsonpCallback: curAjaxItem.callback,
//			data: curAjaxItem.data,
//			success: function(returndata) {
//				if (returndata.result == 0) {
//					curAjaxItem.callbackfunc(returndata);
//				} else {
//					curAjaxItem.callbackfunc("error");
//				}
//				curAjax = null;
//				curAjaxItem = null;
//				isAjaxQueueLoading = false;
//			},
//			error: function(XMLHttpRequest, textStatus, errorThrown) {
//				curAjaxItem.callbackfunc("error");
//				curAjaxItem = null;
//				curAjax = null;
//				isAjaxQueueLoading = false;
//			}
//		});
//	}
	
	/** 获取jsonpcallback 标识 */
	function getJsonpfixed() {
		var fix = new Date().getTime() + "_" + Math.floor(Math.random() * 10000);
		return fix;
	}
	
})(jQuery);
