(function($) {
	
	$.ottdata = {
		
		rootpath: "",
		
		/** 班级名单 */
		getClassNameData: function() {
			var name = getOfflineData("classname");
			var nameData = new Object();
			if(name.files.length==0){
				return nameData;
			}
			var xmlTxt = (readFileToString(name.files[0]));
			nameData = JSON.parse(xmlTxt);
			return nameData;
		},
	
		/** 班级榜单 */
		getClassroomData: function() {
			var list = getOfflineData("classroom");
			var listdata = new Object();
			listdata.colloquialArr = [];
			listdata.flowerArr = [];
			listdata.popularityArr = [];
			listdata.studyArr = [];
			if (list.files.length == 0) {
				return listdata;
			}
			var xmlTxt = $(readFileToString(list.files[0]));
			var colloquial = $(xmlTxt).children("colloquial");
			var cl = $(colloquial).find("list");
			for(var i=0;i<cl.length;i++){
				var colloquialData = {}
				colloquialData.name = $(cl[i]).children("name").text();
				colloquialData.uId =  $(cl[i]).children("uId").text();
				colloquialData.headUrl = $(cl[i]).children("headUrl").text();
				colloquialData.score = $(cl[i]).children("score").text();
				colloquialData.domain = $(cl[i]).children("domain").text();
				colloquialData.rootpath = list.rootpath[i];
				listdata.colloquialArr.push(colloquialData);
			}
			
			var flower = $(xmlTxt).children("flower");
			var fl = $(flower).find("list");
			for(var i=0;i<fl.length;i++){
				var flowerData = {}
				flowerData.name = $(fl[i]).children("name").text();
				flowerData.uId =  $(fl[i]).children("uId").text();
				flowerData.headUrl = $(fl[i]).children("headUrl").text();
				flowerData.flowerNum = $(fl[i]).children("flowerNum").text();
				flowerData.domain = $(fl[i]).children("domain").text();
				flowerData.rootpath = list.rootpath[i];
				listdata.flowerArr.push(flowerData);
			}
			var popularity = $(xmlTxt).children("popularity");
			var pl = $(popularity).find("list");
			for(var i=0;i<pl.length;i++){
				var popularityData = {}
				popularityData.name = $(pl[i]).children("name").text();
				popularityData.uId =  $(pl[i]).children("uId").text();
				popularityData.headUrl = $(pl[i]).children("headUrl").text();
				popularityData.fansNum = $(pl[i]).children("fansNum").text();
				popularityData.messageNum = $(pl[i]).children("messageNum").text();
				popularityData.domain = $(pl[i]).children("domain").text();
				popularityData.rootpath = list.rootpath[i];
				listdata.popularityArr.push(popularityData);
			}
			
			var study = $(xmlTxt).children("study");
			var sl = $(study).find("list");
			for(var i=0;i<sl.length;i++){
				var studyData = {}
				studyData.name = $(sl[i]).children("name").text();
				studyData.uId =  $(sl[i]).children("uId").text();
				studyData.headUrl = $(sl[i]).children("headUrl").text();
				studyData.minutes = $(sl[i]).children("minutes").text();
				studyData.domain = $(sl[i]).children("domain").text();
				studyData.rootpath = list.rootpath[i];
				listdata.studyArr.push(studyData);
			}
			return listdata;
		
		},
		
		/** 跟读作业 */
		getReadData: function() {
			var list = getOfflineData("read");
			var listdata = new Object();
			listdata.courseHomeworkArray = [];
			for (var i = 0; i < list.files.length; i++) {
				var homework = new Object();
				var xmlTxt = $(readFileToString(list.files[i]));
				homework.id = $(xmlTxt).children("id").text();
				homework.bookname = $(xmlTxt).children("bookname").text();
				homework.lessonname = $(xmlTxt).children("lessonname").text();
				homework.createtime = $(xmlTxt).children("createtime").text();
				homework.practicetimes = $(xmlTxt).children("practicetimes").text();
				homework.type = $(xmlTxt).children("type").text();
				
				homework.lessonid = $(xmlTxt).children("lessonid").text();
				homework.tag = $(xmlTxt).children("tag").text();
				homework.courseId = $(xmlTxt).children("courseId").text();
				homework.hwid = $(xmlTxt).children("hwid").text();
			
				homework.score = $(xmlTxt).children("score").text();
				homework.analysis = $(xmlTxt).children("analysis").text();
				homework.rootpath = list.rootpath[i];
				homework.sentence  = [];
				var sentence = $(xmlTxt).children("sentence");
				for(var j=0;j<sentence.length;j++){
					var sentenceData = {}
					sentenceData.name = $(sentence[j]).children("name").text();
					sentenceData.uId =  $(sentence[j]).children("uId").text();
					sentenceData.headUrl = $(sentence[j]).children("headUrl").text();
					sentenceData.classnames = $(sentence[j]).children("classnames").text();
					sentenceData.audiopath = $(sentence[j]).children("audiopath").text();
					sentenceData.text = $(sentence[j]).find("text").text();
					homework.sentence.push(sentenceData);
				}
				listdata.courseHomeworkArray.push(homework);
			}
			return listdata;
		},
		
		/** 微视频 */
		getVideoData: function() {
			var list = getOfflineData("video");
			var listdata = new Object();
			listdata.videoPictureArray = [];
			for (var i = 0; i < list.files.length; i++) {
				var video = new Object();
				var xmlTxt = $(readFileToString(list.files[i]));
				video.id = $(xmlTxt).children("id").text();
				video.name = $(xmlTxt).children("name").text();
				video.imagepath = $(xmlTxt).children("imagepath").text();
				video.videopath = $(xmlTxt).children("videopath").text();
				video.createtime = $(xmlTxt).children("createtime").text();
				video.type = $(xmlTxt).children("type").text();
				video.rootpath =  list.rootpath[i];
				listdata.videoPictureArray.push(video);
			}
			return listdata;
		},
		
		/** 值得课堂上表扬和关注的人和事 */
		getPraiseData: function() {
			var list = getOfflineData("praise");
			var listdata = new Object();
			listdata.praiseConcernArray = [];
			for (var i = 0; i < list.files.length; i++) {
				var praise = new Object();
				var xmlTxt = $(readFileToString(list.files[i]));
				praise.createtime = $(xmlTxt).children("createtime").text();
				praise.type = $(xmlTxt).children("type").text();
				praise.id = $(xmlTxt).children("id").text();
				praise.name = $(xmlTxt).children("name").text();
				praise.uId = $(xmlTxt).children("uId").text();
				praise.bookname = $(xmlTxt).children("bookname").text();
				praise.lessonname = $(xmlTxt).children("lessonname").text();
				praise.homeworktime = $(xmlTxt).children("homeworktime").text();
				praise.classname = $(xmlTxt).children("classname").text();
				praise.text = $(xmlTxt).children("text").text();
				praise.videopath = $(xmlTxt).children("videopath").text();
				praise.videoimg = $(xmlTxt).children("videoimg").text();
				praise.imagepath = $(xmlTxt).children("imagepath").text();
				praise.audiopath = $(xmlTxt).children("audiopath").text();
				praise.solitairePer = $(xmlTxt).children("solitairePer").text();
				praise.dubbingScore = $(xmlTxt).children("dubbingScore").text();
				praise.acName = $(xmlTxt).children("acName").text();
				praise.rootpath = list.rootpath[i];
				praise.sentence  = [];
				var sentence = $(xmlTxt).children("sentence");
				for(var j=0;j<sentence.length;j++){
					var sentenceData = {}
					sentenceData.uname = $(sentence[j]).children("uname").text();
					sentenceData.actorName = $(sentence[j]).children("actorName").text();
					sentenceData.actorImg =  $(sentence[j]).children("actorImg").text();
					sentenceData.audiopath = $(sentence[j]).children("audiopath").text();
					sentenceData.text = $(sentence[j]).find("text").text();
					praise.sentence.push(sentenceData);
				}
				listdata.praiseConcernArray.push(praise);
			}
			return listdata;
		},
		
		/** 课文领读 */
		getCourseData: function() {
			var list = getOfflineData("course");
			var listdata = new Object();
			for (var i = 0; i < list.files.length; i++) {
				var lesson = new Object();
				var subxml = $(readFileToString(list.files[i]));
				lesson.bookName = subxml.children("bookname").text();
				lesson.bookCName = subxml.children("bookcname").text();
				lesson.lessonName = subxml.children("lessonname").text();
				lesson.lessonCName = subxml.children("lessoncname").text();
				lesson.rootpath = list.rootpath[i];
				
				var bookgroup = lesson.bookName;
				if (!listdata.hasOwnProperty(bookgroup) || !listdata[bookgroup] instanceof Array) {
					listdata[bookgroup] = new Array();
				}
				listdata[bookgroup].push(lesson);
			}
			return listdata;
		},
		
		/** 其他课堂资源 */
		getOtherData: function() {
			var otherlist = getOfflineData("other");
			var rootpaths = otherlist.rootpath;
			var otherfile = otherlist.files;
			
			var returnlist = new Array();
			for (var i = 0; i < otherfile.length; i++) {
				var other = $(readFileToString(otherfile[i]));
				var otheritem = new Object();
				otheritem.name = other.children("name").text();
				otheritem.createtime = other.children("createtime").text();
				otheritem.audiopath = "file://" + rootpaths[i] + other.children("audiopath").text();
				returnlist.push(otheritem);
			}
			return returnlist;
		},
		
		/** 泛视听 */
		getSeehearData: function() {
			var list = getOfflineData("seehear");
			var listdata = new Object();
			
			for (var i = 0; i < list.files.length; i++) {
				var lesson = new Object();
				
				var subxml = $(readFileToString(list.files[i]));
				lesson.bookName = subxml.children("bookname").text();
				lesson.lessonName = subxml.children("lessonname").text();
				lesson.type = subxml.children("type").text();
				lesson.media = subxml.children("media").text();
				lesson.content = subxml.children("content").text();
				lesson.rootpath = list.rootpath[i];
				
				var bookgroup = lesson.bookName;
				if (!listdata.hasOwnProperty(bookgroup) || !listdata[bookgroup] instanceof Array) {
					listdata[bookgroup] = new Array();
				}
				listdata[bookgroup].push(lesson);
			}
			
			return listdata;
			
		},
		
		/** 听力测试 */
		getExamData: function() {
			var list = getOfflineData("exam");
			var listdata = new Object();
			
			for (var i = 0; i < list.files.length; i++) {
				var lesson = new Object();
				var subxml = $(readFileToString(list.files[i]));
				
				lesson.bookName = subxml.children("bookname").text();
				lesson.lessonName = subxml.children("lessonname").text();
				lesson.rootpath = list.rootpath[i];
				
				var bookgroup = lesson.bookName;
				if (!listdata.hasOwnProperty(bookgroup) || !listdata[bookgroup] instanceof Array) {
					listdata[bookgroup] = new Array();
				}
				listdata[bookgroup].push(lesson);
			}
			
			return listdata;
		},
		
		/** 词表资源 */
		getWordData: function() {
			var list = getOfflineData("wordlist");
			var rootpaths = list.rootpath;
			var wordfile = list.files;
			
			var returnlist = new Array();
			for (var i = 0; i < wordfile.length; i++) {
				var wordlist = $(readFileToString(wordfile[i]));
				var wordlistitem = new Object();
				
				wordlistitem.wordListName = wordlist.children("listname").text();
				wordlistitem.createtime = wordlist.children("createtime").text();
				wordlistitem.num = wordlist.children("subword").length;
				wordlistitem.wordList = [];
				wordlist.children("subword").each(function() {
					var subword = {};
					subword.word = $(this).children("word").text();
					subword.cntext = $(this).children("cntext").text();
					subword.example = $(this).children("example").text();
					subword.exampleaudio = "file://" + rootpaths[i] + $(this).children("exampleaudio").text();
					subword.syllable = $(this).children("syllable").text();
					subword.picture = "file://" + rootpaths[i] + $(this).children("picture").text();
					subword.dispicture1 = "file://" + rootpaths[i] + $(this).children("dispicture1").text();
					subword.dispicture2 = "file://" + rootpaths[i] + $(this).children("dispicture2").text();
					subword.dispicture3 = "file://" + rootpaths[i] + $(this).children("dispicture3").text();
					subword.audio = "file://" + rootpaths[i] + $(this).children("audio").text();
					wordlistitem.wordList.push(subword);
				});
				returnlist.push(wordlistitem);
			}
			return returnlist;
		},
		
		
		/** 奖励记录 */
		getRewardData: function() {
			var reward = getOfflineData("reward");
			var rootpaths = reward.rootpath;
			var rewardfile = reward.files;
			
			var rewardData = {};
			rewardData.personal = [];
			rewardData.group = [];
			var rewardXMLData = $(readFileToString(rewardfile[0]));
			
			// 个人奖励数据
			var personalData = rewardXMLData.children("personal");
			personalData.children("period").each(function() {
				var period = {};
				period.pid = $(this).children("pid").text();
				period.stime = $(this).children("stime").text();
				period.etime = $(this).children("etime").text();
				period.subperson = [];
				$(this).children("subperson").each(function() {
					var person = {};
					person.userId = $(this).children("userId").text();
					person.userName = $(this).children("userName").text();
					person.integral = $(this).children("integral").text();
					person.headImg = "file://" + rootpaths[0] + $(this).children("userId").text() + ".jpg";
					person.expNew = $(this).children("expNew").text();
					person.flowerCount = $(this).children("flowerCount").text();
					person.listenLevel = $(this).children("listenLevel").text();
					person.scoreRank = $(this).children("scoreRank").text();
					person.sect = $(this).children("sect").text();
					person.voiceCount = $(this).children("voiceCount").text();
					person.reward = [];
					$(this).children("reward").each(function() {
						var reward = {};
						reward.id = $(this).children("id").text();
						reward.ct = $(this).children("ct").text();
						reward.message = $(this).children("message").text();
						person.reward.push(reward);
					});
					period.subperson.push(person);
				});
				rewardData.personal.push(period);
			});
			
			// 个人奖励数据
			var groupData = rewardXMLData.children("group");
			groupData.children("period").each(function() {
				var period = {};
				period.pid = $(this).children("pid").text();
				period.stime = $(this).children("stime").text();
				period.etime = $(this).children("etime").text();
				period.subgroup = [];
				$(this).children("subgroup").each(function() {
					var group = {};
					group.captain = $(this).children("captain").text();
					group.groupId = $(this).children("groupId").text();
					group.groupName = $(this).children("groupName").text();
					group.groupNo = $(this).children("groupNo").text();
					group.id = $(this).children("id").text();
					group.imageUrl = "file://" + rootpaths[0] + $(this).children("imageUrl").text();
					group.integral = $(this).children("integral").text();
					
					group.grouper = [];
					$(this).children("grouper").each(function() {
						var grouper = {};
						grouper.id = $(this).children("id").text();
						grouper.name = $(this).children("name").text();
						group.grouper.push(grouper);
					});
					
					group.reward = [];
					$(this).children("reward").each(function() {
						var reward = {};
						reward.id = $(this).children("id").text();
						reward.ct = $(this).children("ct").text();
						reward.message = $(this).children("message").text();
						group.reward.push(reward);
					});
					period.subgroup.push(group);
				});
				rewardData.group.push(period);
			});
			
			return rewardData;
		},
		
		
		/** 离线信息采集 */
		getOfflineInfor: function() {
			var infors = [];
			for (var index in offlineConfigs) {
				if (index == "classname") {
					continue;
				}
				var list = getOfflineData(index);
				if (list.files.length > 0) {
					infors.push(offlineConfigs[index].actionType);
				}
			}
			return infors.join("-");
		}
		
		
	};
	
	var offlineConfigs = {
		classname: {path: "className", xname: "classname.json", actionType: -1},
		classroom: {path: "list", xname: "list.xml", actionType: 18},
		read: {path: "courseHomework", xname: "content.xml", actionType: 19},
		video: {path: "videoPicture", xname: "content.xml", actionType: 20},
		praise: {path: "praiseConcern", xname: "content.xml", actionType: 21},
		course: {path: "course", xname: "infor.xml", actionType: 22},
		other: {path: "other", xname: "content.xml", actionType: 23},
		seehear: {path: "seehear", xname: "content.xml", actionType: 24},
		exam: {path: "exam", xname: "infor.xml", actionType: 25},
		wordlist: {path: "wordlist", xname: "content.xml", actionType: 26},
		reward: {path: "reward", xname: "list.xml", actionType: 27}
	};
	
	function getOfflineData(type) {
		var file = new FileUtils.File($.ottdata.rootpath + offlineConfigs[type].path);
		
		var data = new Object();
		data.files = [];
		data.rootpath = [];
		ergodic(data, file, offlineConfigs[type].xname);
		
		return data;
	}
	function ergodic(data, file, xmlname) {
		if (!file.exists()) {
			return data;
		}
		var entry = file.directoryEntries;
		while(entry.hasMoreElements()) {
			var subentry = entry.getNext();
			subentry.QueryInterface(Components.interfaces.nsIFile);
			if (subentry.isDirectory()) {
				ergodic(data, subentry, xmlname);
			} else {
				var xmlpath = file.path + "\\" + xmlname;
				var xmlroot = file.path + "\\";
				var xmlfile = new FileUtils.File(xmlpath);
				if(xmlfile.exists()){
					data.rootpath.push(xmlroot);
					data.files.push(xmlfile);
				} else {
//					data.files.push(null);
				}
				break;
			}
		}
	}
	
})(jQuery);
