
var arivoc_log_divId = null;
var arivoc_exam = null;
var arivoc_exam_audio_playId = null;
var arivoc_btn_exam_play = null;
var arivoc_label_total_time = null;
var arivoc_label_cur_time = null;
var arivoc_exam_progressId = null;
var arivoc_exam_progressBarId = null;
var arivoc_exam_progressTrackId = null;
var arivoc_exam_titleDivId = null;
var arivoc_exam_groupsDivId = null;
var arivoc_exam_submit = null;
var arivoc_exam_score = null;

var candrag = false;

function arivoc_exam_getXML(xmlpath) {

	var exam_url = xmlpath + "exam.xml";	
	var exam2_url = xmlpath + "exam2.xml";	
	var event_url = xmlpath + "event.xml";
	
	candrag = false;
	
	arivoc_exam = new Arivoc_Listen_Exam();
	arivoc_exam.root_path = xmlpath;
	arivoc_exam.mp3Url = xmlpath + "0.mp3";
	arivoc_exam.online = false;
	arivoc_exam.clear();
	
	var exam1,exam2;
	
	$.ajax({
		type : "get",
		url : exam_url,
		async: false,
		dataType : "xml",
		timeout : 1000,
		cache : false,
		success : function(data) {exam1 = data;},
		error: function(a, b, c) {alert("error");}
	});
	
	$.ajax({
		type : "get",
		url : exam2_url,
		async: false,
		dataType : "xml",
		timeout : 1000,
		cache : false,
		success : function(data) {exam2 = data;},
		error: function(a, b, c) {alert("error");}
	});
	
	arivoc_exam_parseExamXML(exam1, exam2);
	
	$.ajax({
		type : "get",
		url : event_url,
		async: false,
		dataType : "xml",
		timeout : 1000,
		cache : false,
		success : arivoc_exam_parseEventXML
	});
	
	arivoc_exam.init();
	arivoc_exam.draw();
	
	$("#"+arivoc_btn_exam_play).bind("click",on_btn_Arivoc_Exam_Started);
}

function arivoc_exam_getXMLOnLine(urlStr, mp3URL, examId) {	
	
	candrag = false;
	
	arivoc_exam = new Arivoc_Listen_Exam();
	arivoc_exam.root_path = "http://exam2.kouyu100.com/";
	arivoc_exam.mp3Url = "http://exam2.kouyu100.com"+mp3URL;
	arivoc_exam.online = true;
	arivoc_exam.clear();
	
	$.ajax({
		type:"get",
		url:urlStr,
		async:false,
		contentType:"application/jsonp; charset=utf-8",
		dataType:"jsonp",
		jsonp:"callback",
		jsonpCallback:"examXMLBack",
		data: {
			examId: examId
		},
		success: function(returndata) {
			if (returndata.result == 0) {
				arivoc_exam_parseExamXML(returndata.xml1, returndata.xml1);
				arivoc_exam_parseEventXML(returndata.xml2);
				arivoc_exam.zipUrl = returndata.zipUrl;
				
				arivoc_exam.init();
				arivoc_exam.draw();
				
				$("#"+arivoc_btn_exam_play).bind("click",on_btn_Arivoc_Exam_Started);
			}
		},
		error: function(XMLHttpRequest, textStatus, errorThrown) {
//			alert("获取课内容失败！");
		}
	});	
}

function arivoc_exam_parseExamXML(data, data2) {
	
	arivoc_exam.examId = $(data).find("examId").text();
	arivoc_exam.examName = $(data).find("examName").text();
	arivoc_exam.examType = $(data).find("examType").text();
	arivoc_exam.material = $(data).find("material").text();
	arivoc_exam.isAnswerCard = $(data).find("isAnswerCard").text();
	
	var choose_index = 0;
	
	var groupList = $(data).find("group");
	var groupList2 = $(data2).find("group");
	for(var i=0; i<groupList.length; i++) {
		
		var g = groupList[i];
		var g2 = groupList2[i];
		var group = new Arivoc_Listen_Exam_Group();
		group.examId = arivoc_exam.examId;
		group.id = $(g).children("id").text();
		group.groupType = $(g).children("groupType").text();
		group.groupName = $(g).children("groupName").text();
		// 如果是图片 从exam.xml取数据 || 否则从exam2.xml中取数据
		var groupDesc = $(g).children("groupDesc").text();
		var groupDescLast = groupDesc.substr(groupDesc.length - 4, 4);
		if (groupDescLast == ".jpg" || groupDescLast == ".png" || groupDescLast == ".gif") {
			group.groupDesc = $(g).children("groupDesc").text();
		} else {
			group.groupDesc = $(g2).children("groupDesc").text();
		}
//		group.groupDesc = $(g).children("groupDesc").text();
		group.isReStart = $(g).children("isReStart").text();
		
		if(group.isReStart==1){
			choose_index = 0;
		}
		
		var blankList = $(g).find("blank");
		var blankList2 = $(g2).find("blank");
		for (var k = 0; k < blankList.length; k++) {
			var b = blankList[k];
			var b2 = blankList2[k];
			var blank = new Arivoc_Listen_Exam_Blank();
			blank.examId = arivoc_exam.examId;
			blank.groupId = group.id;
			blank.indexId = (++choose_index);
			blank.id = $(b).children("id").text();
			blank.title = $(b).children("title").text();
			blank.answer = $(b2).children("answer").text();
			blank.score = $(b2).children("score").text();
			
			group.blanks.push(blank);		
		}
		
		var chooseList = $(g).find("choose");
		var chooseList2 = $(g2).find("choose");
		for(var j=0; j < chooseList.length; j++){
			var c = chooseList[j];
			var c2 = chooseList2[j];
			var choose = new Arivoc_Listen_Exam_Choose();
			choose.examId = arivoc_exam.examId;
			choose.groupId = group.id;
			choose.indexId = (++choose_index);
			choose.id = $(c).children("id").text();
			choose.title = $(c).children("title").text();
			choose.item1 = $(c).children("item1").text();
			choose.item2 = $(c).children("item2").text();
			choose.item3 = $(c).children("item3").text();
			choose.item4 = $(c).children("item4").text();
			choose.item5 = $(c).children("item5").text();
			choose.answer = $(c2).children("answer").text();
			choose.score = $(c2).children("score").text();
			
			choose.itemSize = 0;			
			if(choose.item1.length > 0){
				choose.itemSize++;
			}
			if(choose.item2.length > 0){
				choose.itemSize++;
			}
			if(choose.item3.length > 0){
				choose.itemSize++;
			}
			if(choose.item4.length > 0){
				choose.itemSize++;
			}
			if(choose.item5.length > 0){
				choose.itemSize++;
			}
			
			var imgIndex = choose.item1.toLowerCase().lastIndexOf(".jpg");
			if(imgIndex==-1){
				imgIndex = choose.item1.toLowerCase().lastIndexOf(".png");	
			}
			if(imgIndex==-1){
				imgIndex = choose.item1.toLowerCase().lastIndexOf(".gif");	
			}
			if( imgIndex>0 && imgIndex==(choose.item1.length-4)){
				choose.itemType = "img";
			}else{
				choose.itemType = "txt";
			}			

			group.chooses.push(choose);			
		}
		arivoc_exam.groups.push(group);
		
	}
	
}

function arivoc_exam_parseEventXML(data) {

	$(data).find("time").each(function(i) {

		var evt = new Arivoc_Listen_Exam_Event();		
		
		evt.groupid = $(this).children("groupid").text();
		evt.titleid = $(this).children("titleid").text();
		evt.titletype = $(this).children("titletype").text();
		evt.start = $(this).children("start").text();
		evt.end = $(this).children("end").text();
		evt.eventtype = $(this).children("eventtype").text();
		evt.extend = $(this).children("extend").text();

		arivoc_exam.events.push(evt);

	});

	$("#"+arivoc_btn_exam_play).css({"background" : "url(../images/classroom/start_exam.png)"});
}

function Arivoc_Listen_Exam() {
	
	this.needRedraw = false;
	this.examId;
	this.examName;
	this.examType;
	this.material;
	this.isAnswerCard;	
	this.mp3Url;
	this.mp3PlayTime=0;
	this.mp3TotalTime=0;
	this.root_path;
	this.online = false;
	this.events = new Array();
	this.groups = new Array();
	this.zipUrl;
	
	this.clear = function(){
		$("#"+arivoc_exam_titleDivId).html("");
		$("#"+arivoc_exam_groupsDivId).html("");
		$("#"+arivoc_exam_score).html("");
		this.events = new Array();
		this.groups = new Array();
		$("#"+arivoc_btn_exam_play).css({"background" : "url(../images/classroom/start_exam2.png)"});
		$("#"+arivoc_btn_exam_play).unbind("click",on_btn_Arivoc_Exam_Started);
		$("#"+arivoc_btn_exam_play).unbind("click",on_btn_Arivoc_Exam_Paused);
		$("#"+arivoc_label_cur_time).html("00:00");
		$("#"+arivoc_label_total_time).html("00:00");
		$("#"+arivoc_exam_submit).css({"background" : "url(../images/classroom/tjsj2.png)", "cursor" : "default"});
		$("#"+arivoc_exam_progressBarId).width('0%');
		this.pause();
	}
	
	this.init = function(){
		var exam_audio = $("#" + arivoc_exam_audio_playId)[0];	
		exam_audio.ondurationchange=function(){
			this.mp3TotalTime = exam_audio.duration;
			var mm = parseInt(this.mp3TotalTime/60);
			var ss = parseInt(this.mp3TotalTime-60*mm);
			var ms = "";
			if(mm>9){
				ms += mm;
			}else{
				ms += "0"+mm;
			}			
			ms += ":";
			if(ss>9){
				ms += ss;
			}else{
				ms += "0"+ss;
			}
			$("#"+arivoc_label_total_time).html(ms);
		}
		exam_audio.src = this.mp3Url;		
		exam_audio.load();
		$("#"+arivoc_exam_progressBarId).width('0%');
		$("#"+arivoc_exam_score).html("");
	}
	
	this.play = function(){
		stopAllAudio("exam");
		
		var exam_audio = $("#" + arivoc_exam_audio_playId)[0];
		exam_audio.currentTime = this.mp3PlayTime;
		exam_audio.play();
	}
	
	this.pause = function(){		
		
		var exam_audio = $("#" + arivoc_exam_audio_playId)[0];
		exam_audio.pause();
	}
	
	this.draw = function(){
		$("#"+arivoc_exam_score).html("");
		$("#"+arivoc_exam_titleDivId).html(this.examName);
		$("#"+arivoc_exam_groupsDivId).html("");
		arivoc_exam_draw_group();		
	}
}

function Arivoc_Listen_Exam_Event(){

	this.groupid;
	this.titleid;
	this.titletype;
	this.start;
	this.end;
	this.eventtype;
	this.extend;
	this.isStarted = false;
	this.isFinished = false;
	this.isTiped = false;
}

function Arivoc_Listen_Exam_Group(){
	
	this.id;
	this.groupType;
	this.groupName;
	this.groupDesc;
	this.isReStart;	
	this.examId;	
	this.chooses = new Array();	
	this.blanks = new Array();
}

function Arivoc_Listen_Exam_Choose(){
	this.id;
	this.title;
	this.itemType;
	this.itemSize;
	this.item1;
	this.item2;
	this.item3;
	this.item4;
	this.item5;
	this.indexId;
	this.examId;
	this.groupId;
	this.chooseId;
	this.answer;
	this.score;
}

function Arivoc_Listen_Exam_Blank(){
	this.id;
	this.title;
	this.indexId;
	this.examId;
	this.groupId;
	this.answer;
	this.score;
}

function arivoc_exam_draw_group(){
	for(var i=0; i<arivoc_exam.groups.length; i++){
		var group = arivoc_exam.groups[i];
		var g_str = "<DIV class='exam-group' id='group"+group.id+"' style='font-weight:bold; margin-top:20px; border:0px solid red;display:block;'>"+group.groupName+"</DIV>";
		
		$("#"+arivoc_exam_groupsDivId).append(g_str);
		
		var imgIndex = group.groupDesc.toLowerCase().lastIndexOf(".jpg");
		if(imgIndex==-1){
			imgIndex = group.groupDesc.toLowerCase().lastIndexOf(".png");
		}
		if(imgIndex==-1){
			imgIndex = group.groupDesc.toLowerCase().lastIndexOf(".gif");
		}
		
		if( imgIndex>0 && imgIndex==(group.groupDesc.length-4)){
			g_str = "<DIV style='margin-left:30px;'><img src='"+arivoc_exam.root_path+group.groupDesc+"' style='max-width:90%'/></DIV>";
			$("#group"+group.id).append(g_str);
		} else if (group.groupDesc.length != 0 && group.groupDesc.indexOf("#td#") != -1) {
			var table_str = "";
			var rows = group.groupDesc.split("#br#");
			for (var ii = 0; ii < rows.length; ii++) {
				table_str += "<tr>";
				if (rows[ii].indexOf("#td#") != -1) {
					rows[ii] = rows[ii].split("#td#");
				} else {
					rows[ii] = [rows[ii]];
				}
				for (var j = 0; j < rows[ii].length; j++) {
					table_str += "<td";
					if (rows[ii].length == 1) {
						table_str += " colspan='2' align='center'";
					}
					table_str += (" style='border: solid #000 1px;padding-top:10px;padding-bottom:10px;padding-left:10px;'>" + rows[ii][j] + "</td>");
				}
				table_str += "</tr>";
			}
			g_str = "<table style='border-collapse: collapse;margin-left:40px;margin-top:15px;width:600px;font-size:16px;font-weight:normal;'>" + table_str + "</table>";
			$("#group"+group.id).append(g_str);
		} else if (group.groupDesc.length != 0 && group.groupDesc.indexOf("<br>") != -1) {
			g_str = "<div style='border: solid #000 1px; padding: 10px; margin-left:40px; margin-top:15px; width:600px; font-size:16px; font-weight:normal;'>" + group.groupDesc + "</div>";
			$("#group"+group.id).append(g_str);
		}
		
		for (var k = 0; k < group.blanks.length; k++) {
			var blank = group.blanks[k];
			arivoc_exam_draw_blank(blank);
		}
		
		for(var l=0; l<group.chooses.length; l++){
			var choose = group.chooses[l];			
			arivoc_exam_draw_item(choose);			
		}		
	}	
}

function arivoc_exam_draw_blank(blank) {
	var b = $("<div class='exam-blank' id='blank" + blank.id + "' style='font-weight:normal;margin-top:10px;margin-left:30px;border:0px solid blue;'><span>" + blank.title + "</span><input type='text' score='" + blank.score + "' /><span style='color:red;font-size:16px;display:none;'>&nbsp;答案：" + blank.answer + "</span></div>");
	b.find("input").attr("answer", blank.answer);
	$("#group" + blank.groupId).append(b);
}

function arivoc_exam_draw_item(choose){
	if(choose.itemType=='img'){
		arivoc_exam_draw_item_img(choose);
	}else if(choose.itemType=='txt' && choose.title.length>0){
		arivoc_exam_draw_item_txt(choose);
	}else if(choose.itemType=='txt' && choose.title.length==0){
		arivoc_exam_draw_item_txt2(choose);
	}
}

function arivoc_exam_draw_item_img(choose){
	
	var c_str = "<DIV class='exam-choose' id='choose"+choose.id+"' style='font-weight:normal;margin-top:10px;margin-left:30px;border:0px solid blue;'><DIV style='border:0px solid blue;'>"+choose.indexId+"."+choose.title+"</DIV></DIV>";
	$("#group"+choose.groupId).append(c_str);	

	var str = "<DIV style='margin-top:10px;margin-left:20px;'>";		
	if(choose.itemSize>0){
		str += "<span style='margin-right:30px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='A' answer='" + choose.answer + "' score='" + choose.score + "'>A.<img src='"+arivoc_exam.root_path+choose.item1+"' width='100px'/></span>";
	}	
	if(choose.itemSize>1){
		str += "<span style='margin-right:30px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='B' answer='" + choose.answer + "' score='" + choose.score + "'>B.<img src='"+arivoc_exam.root_path+choose.item2+"' width='100px'/></span>";
	}	
	if(choose.itemSize>2){
		str += "<span style='margin-right:30px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='C' answer='" + choose.answer + "' score='" + choose.score + "'>C.<img src='"+arivoc_exam.root_path+choose.item3+"' width='100px'/></span>";
	}	
	if(choose.itemSize>3){
		str += "<span style='margin-right:30px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='D' answer='" + choose.answer + "' score='" + choose.score + "'>D.<img src='"+arivoc_exam.root_path+choose.item4+"' width='100px'/></span>";
	}	
	if(choose.itemSize>4){
		str += "<span style='margin-right:30px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='E' answer='" + choose.answer + "' score='" + choose.score + "'>E.<img src='"+arivoc_exam.root_path+choose.item5+"' width='100px'/></span>";
	}	
	str += "<DIV>";	
	$("#choose"+choose.id).append(str);	
	
}

function arivoc_exam_draw_item_txt(choose){
	
	var c_str = "<DIV class='exam-choose' id='choose"+choose.id+"' style='font-weight:normal;margin-top:10px;margin-left:30px;border:0px solid blue;'><DIV style='border:0px solid blue;'>"+choose.indexId+"."+choose.title+"</DIV></DIV>";
	$("#group"+choose.groupId).append(c_str);	

	var str = "<DIV style='margin-top:10px;margin-left:20px;'>";
	if(choose.itemSize>0){
		str += "<DIV style='margin-top:5px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='A' answer='" + choose.answer + "' score='" + choose.score + "'>A."+choose.item1+"</DIV>";
	}	
	if(choose.itemSize>1){
		str += "<DIV style='margin-top:5px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='B' answer='" + choose.answer + "' score='" + choose.score + "'>B."+choose.item2+"</DIV>";
	}	
	if(choose.itemSize>2){
		str += "<DIV style='margin-top:5px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='C' answer='" + choose.answer + "' score='" + choose.score + "'>C."+choose.item3+"</DIV>";
	}	
	if(choose.itemSize>3){
		str += "<DIV style='margin-top:5px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='D' answer='" + choose.answer + "' score='" + choose.score + "'>D."+choose.item4+"</DIV>";
	}	
	if(choose.itemSize>4){
		str += "<DIV style='margin-top:5px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='E' answer='" + choose.answer + "' score='" + choose.score + "'>E."+choose.item5+"</DIV>";
	}	
	str += "<DIV>";	
	$("#choose"+choose.id).append(str);	
	
}

function arivoc_exam_draw_item_txt2(choose){
	
	var c_str = "<DIV class='exam-choose' id='choose"+choose.id+"' style='font-weight:normal;margin-top:10px;margin-left:30px;border:0px solid blue;'><DIV style='border:0px solid blue;margin-top:5px;float:left'>"+choose.indexId+".</DIV><DIV style='border:0px solid blue;float:left'>";
	
	if(choose.itemSize>0){
		c_str += "<DIV style='margin-top:5px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='A' answer='" + choose.answer + "' score='" + choose.score + "'>A."+choose.item1+"</DIV>";
	}	
	if(choose.itemSize>1){
		c_str += "<DIV style='margin-top:5px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='B' answer='" + choose.answer + "' score='" + choose.score + "'>B."+choose.item2+"</DIV>";
	}	
	if(choose.itemSize>2){
		c_str += "<DIV style='margin-top:5px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='C' answer='" + choose.answer + "' score='" + choose.score + "'>C."+choose.item3+"</DIV>";
	}	
	if(choose.itemSize>3){
		c_str += "<DIV style='margin-top:5px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='D' answer='" + choose.answer + "' score='" + choose.score + "'>D."+choose.item4+"</DIV>";
	}	
	if(choose.itemSize>4){
		c_str += "<DIV style='margin-top:5px;'><input type='radio' name='chooseAnswer" + choose.id + "' alt='E' answer='" + choose.answer + "' score='" + choose.score + "'>E."+choose.item5+"</DIV>";
	}
	
	c_str += choose.title+"</DIV></DIV><DIV style='clear:both;'></DIV>";
	
	$("#group"+choose.groupId).append(c_str);	

	
}

function on_btn_Arivoc_Exam_Started(){
	if (arivoc_exam.needRedraw) {
		arivoc_exam.draw();
		arivoc_exam.needRedraw = false;
	}
	
	$("#"+arivoc_btn_exam_play).css({"background" : "url(../images/classroom/stop_exam.png)"});
	$("#"+arivoc_btn_exam_play).unbind("click",on_btn_Arivoc_Exam_Started);
	$("#"+arivoc_btn_exam_play).bind("click",on_btn_Arivoc_Exam_Paused);
	if (candrag) {
		$("#"+arivoc_exam_progressTrackId).bind("click", on_audio_changed);
	}
	arivoc_exam.play();
	arivoc_exam_progressId = setInterval(arivoc_exam_progress, 100);
	
	
}

function on_btn_Arivoc_Exam_Paused(){
	
	$("#"+arivoc_btn_exam_play).css({"background" : "url(../images/classroom/start_exam.png)"});
	$("#"+arivoc_btn_exam_play).unbind("click",on_btn_Arivoc_Exam_Paused);
	$("#"+arivoc_btn_exam_play).bind("click",on_btn_Arivoc_Exam_Started);
	$("#"+arivoc_exam_progressTrackId).unbind("click", on_audio_changed);
	arivoc_exam.pause();
	clearInterval(arivoc_exam_progressId);
	
	
}

function on_audio_changed(e) {
	var ratio = e.offsetX / $("#"+arivoc_exam_progressTrackId).width();
	var exam_audio = $("#"+arivoc_exam_audio_playId)[0];
	exam_audio.currentTime = exam_audio.duration * ratio;
}



function arivoc_exam_progress(){	
	
	var exam_audio = $("#"+arivoc_exam_audio_playId)[0];
	
	if(exam_audio.ended){
		clearInterval(arivoc_exam_progressId);
		arivoc_exam.mp3PlayTime = 0;
		$("#"+arivoc_exam_progressBarId).width('0%');
		$("#"+arivoc_label_cur_time).html("00:00");
		$("#"+arivoc_btn_exam_play).css({"background" : "url(../images/classroom/start_exam2.png)"});
		$("#"+arivoc_btn_exam_play).unbind("click",on_btn_Arivoc_Exam_Paused);
		$("#"+arivoc_btn_exam_play).unbind("click",on_btn_Arivoc_Exam_Started);
		$("#"+arivoc_exam_submit).css({"background" : "url(../images/classroom/tjanniu.png)", "cursor" : "pointer"});
	}else{
	
		arivoc_exam.mp3PlayTime = exam_audio.currentTime;
		
		var processed = (100*arivoc_exam.mp3PlayTime/arivoc_exam.mp3TotalTime);	
		$("#"+arivoc_exam_progressBarId).width(processed+'%');
		
		var mm = parseInt(arivoc_exam.mp3PlayTime/60);
		var ss = parseInt(arivoc_exam.mp3PlayTime-60*mm);
		var ms = "";
		if(mm>9){
			ms += mm;
		}else{
			ms += "0"+mm;
		}			
		ms += ":";
		if(ss>9){
			ms += ss;
		}else{
			ms += "0"+ss;
		}
		$("#"+arivoc_label_cur_time).html(ms);
		
		var tt = parseInt(arivoc_exam.mp3PlayTime);		
		for(var i=0;i<arivoc_exam.events.length;i++){
			var evt = arivoc_exam.events[i];
			
			if(!evt.isFinished){
				
				if(evt.eventtype == "2"){
					if(tt >= evt.start && !evt.isStarted){

						setTimeout(recordingEvent(evt.eventtype,evt.groupid,evt.titleid,evt.titletype,evt.start,evt.end,evt.extend), 0);
						
						if(evt.isStarted){								
							evt.isFinished = true;
						}else{
							evt.isStarted = true;
						}
					}
					
				}else if(evt.eventtype == "3"){
					
					if(tt >= evt.start && !evt.isStarted){

						setTimeout(recordingEvent(evt.eventtype,evt.groupid,evt.titleid,evt.titletype,evt.start,evt.end,evt.extend), 0);
						
						if(evt.isStarted){								
							evt.isFinished = true;
						}else{
							evt.isStarted = true;
						}

					}
					
				}
				
			}
			
			
		}
	
	}
	
}

function recordingEvent(eventtype,groupid,titleid,titletype,start,end,extend){
	
	if(eventtype=='2'){
		
		for(var i=0; i<arivoc_exam.groups.length; i++){
			var g = arivoc_exam.groups[i];
			if(groupid == g.id){
				$("#group"+g.id).css('display','block'); 
			}else{
				$("#group"+g.id).css('display','none'); 		
			}
		}
	}
	
}


function exam_submit() {
	if ($("#"+arivoc_exam_submit).css("cursor") == "default") {
		return;
	}
	$("#"+arivoc_exam_submit).css({"background" : "url(../images/classroom/tjsj2.png)", "cursor" : "default"});
	$(".exam-group").css('display','block');
	var scoreTotal = 0;
	$("#"+arivoc_exam_groupsDivId).find("input").each(function(i, input) {
		if ($(input).attr("type") == "text") {
			$(input).attr("readonly", "readonly");
			if ($(input).val().toLowerCase() == $(input).attr("answer").toLowerCase()) {
				scoreTotal += parseInt($(input).attr("score"));
				$(input).next("span").html("<img src='http://static2.kouyu100.com/images2/listenexam/dui.png' />").show();
			} else {
				$(input).next("span").show();
			}
		} else if ($(input).attr("type") == "radio") {
			$(input).attr("disabled", "disabled");
			
			if ($(input).attr("alt").toLowerCase() == $(input).attr("answer").toLowerCase()) {
				$(input).parent().css("color", "red");
			}
			
			if ($(input).prop("checked") == true) {
				if ($(input).attr("alt").toLowerCase() == $(input).attr("answer").toLowerCase()) {
					scoreTotal += parseInt($(input).attr("score"));
					$(input).parent().append("<img src='http://static2.kouyu100.com/images2/listenexam/dui.png' />");
				} else {
					$(input).parent().append("<img src='http://static2.kouyu100.com/images2/listenexam/ch.png' />");
				}
			}
		}
	});
	$("#"+arivoc_exam_score).html("成绩：" + scoreTotal + "分").css("color", "#CD2626");
	arivoc_exam.needRedraw = true;
	$("#"+arivoc_btn_exam_play).css({"background" : "url(../images/classroom/start_exam.png)"});
	$("#"+arivoc_btn_exam_play).bind("click",on_btn_Arivoc_Exam_Started);
}




