(function($){
	
	$.ottversion = {
		
		
		version: 103,
		
		downurl: "",
		
		versionToString: function(ver) {
			var version = ver || $.ottversion.version;
			return Math.floor(version / 100) + "." + Math.floor(version % 100 / 10) + "." + version % 10;
		},
		
		
		check: function(callback) {
			var params = {
				action: "getTeacherToolClientVersionInfo",
				clientVersion: $.ottversion.version,
				code: 88,
				device: "99:99:99:99:99:99",
//				paras: [],
				salt1: "offline_teacher_tools",
				salt2: "2",
				version: 100
			};
			
			$.ajax({
				type:"post",
				url:"http://estore.ky100.cc/estore/webinterface/webcall.action?v=" + Math.random(),
				async:true,
				contentType: "application/jsonp; charset=utf-8",
				dataType: "jsonp",
				jsonp: "callback",
				jsonpCallback: "getTeacherToolClientVersionInfo",
				data: {msg: window.btoa(JSON.stringify(params))},
				success: function(result) {
					if (result.status == 0) {
						$.ottversion.downurl = result.url;
						callback({
							isforce: result.allow,
							version: $.ottversion.versionToString(result.lastVersion),
							content: result.content
						});
					} else if (result.status == 4) {
						callback(null);
					}
				},
				error: function(a, b, c) {
					callback(null);
				}
			});
		},
		
		
		download: function(path, callback) {
			var filename = $.ottversion.downurl.substring($.ottversion.downurl.lastIndexOf("/") + 1);
			var downloadfile = Components.classes["@mozilla.org/file/local;1"].createInstance(Components.interfaces.nsILocalFile);
			downloadfile.initWithPath(path + filename);
			if (downloadfile.exists()) {
				delectFile(path + filename);
			}
			downloadfile.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0666);
			
			var downloader;
			Downloads.createDownload({
				source: $.ottversion.downurl,
				target: downloadfile
			}).then(function(a) {
				downloader = a;
				downloader.onchange = function() {
					callback({phase: "loading", value: downloader.progress});
					if (downloader.succeeded == true) {
						callback({phase: "success", value: filename});
					}
				}
				downloader.start();
			}, function() {
				
			});
		},
		
		
		update: function(updatepath, targetpath, callback) {
			var updatefile = new FileUtils.File(updatepath);
			var targetdir = new FileUtils.File(targetpath);
			var targetfile = new FileUtils.File(targetpath + "content.jar");
			if (targetfile.exists()) {
				delectFile(targetpath + "content.jar");
			}
			try {
				updatefile.renameTo(targetdir, "content.jar");
			} catch (e) {
				alert(e);
			}
		},
		
		
		saveOfflineInfor: function(infor) {
			
			var teacherBehavior = {};
			teacherBehavior.userId = -1;
			teacherBehavior.userName = "";
			teacherBehavior.domainId = "";
			teacherBehavior.actionType = infor;
			teacherBehavior.clientType = 3;
			teacherBehavior.clientVersion = $.ottversion.versionToString();
			teacherBehavior.description = "";
			teacherBehavior.counts = -1;
			teacherBehavior.collectTime = newDate();
			teacherBehavior.pcId = -1;
			
			offlineSave(teacherBehavior);
			
			function offlineSave(data) {
				var jsondata = [];
				var inforFile = new FileUtils.File(defaultDataRoot() + "offlineinfor");
				if (inforFile.exists()) {
					jsondata = JSON.parse(readFileToString(inforFile));
					if (!$.isArray(jsondata)) {
						jsondata = [];
					}
					jsondata.push(data);
					writeFileToString(inforFile.path, JSON.stringify(jsondata));
				} else {
					jsondata.push(data);
					createFile(inforFile.path, JSON.stringify(jsondata));
				}
			}
			
			function newDate() {
				var nd = new Date();
				var yyyy = nd.getFullYear();
				var mm = nd.getMonth() + 1;
				mm = (mm < 10) ? "0" + mm : mm;
				var dd = nd.getDate();
				dd = (dd < 10) ? "0" + dd : dd;
				var h = nd.getHours();
				h = (h < 10) ? "0" + h : h;
				var m = nd.getMinutes();
				m = (m < 10) ? "0" + m : m;
				var s = nd.getSeconds();
				s = (s < 10) ? "0" + s : s;
				return yyyy + "-" + mm + "-" + dd + " " + h + ":" + m + ":" + s;
			}
			
			
		},
		
		uploadOfflineInfor: function() {
			
			var inforFile = new FileUtils.File(defaultDataRoot() + "offlineinfor");
			
			if (navigator.onLine && inforFile.exists()) {
				var jsondata = readFileToString(inforFile);
				if (jsondata == "") {
					return;
				}
				onlineUpload(window.btoa(jsondata));
			}
			
			function onlineUpload(d) {
				$.ajax({
					type:"get",
//					url:"http://syntax.kouyu100.com/kouyu100_exammonitor/saveTeacherBehavior.action",
					url:"http://exammonitor.kouyu100.com/saveTeacherBehavior.action",
					async:true,
					contentType: "application/jsonp; charset=utf-8",
					dataType: "jsonp",
					jsonp: "callback",
					jsonpCallback: "offlineInforBack",
					data: {data: d},
					success: function(result) {
						if (result.status == 0) {
							writeFileToString(inforFile.path, "[]");
						}
					},
					error: function() {}
				});
			}
			
		}
		
	};
	
})(jQuery);
