using Verse;
using RimWorld;

namespace JTReplaceWalls
{
	public class Designator_Build_JT : Designator_Place //Replicate same inheritance and you can access private fields with dummy fields
    {
        //Dummy fields; this is because the replacing method is called from the original Designator_Build class and has access to the original fields even if private
        //This also means that class fields (I.E. bellow) aren't actually ever accessed and is only here so this compiles.
        public BuildableDef entDef;
        public ThingDef stuffDef;

        //Static class fields can be accessed by the replacing method: be careful not to make dummy fields static.
        public static bool wall = false;
        public static bool check = true;
        public static bool embrasure = true;
        public static bool concrete = true;

        public override AcceptanceReport CanDesignateCell(IntVec3 c)
        {
            /* Moved to Vaccine.cs
            if (check)
            {
                foreach (ModMetaData mod in ModsConfig.ActiveModsInLoadOrder)
                {
                    if (mod.Name == "ED-Embrasures")
                    {
                        embrasure = false;
                    }
                    if (mod.Name == "ConcreteWalls")
                    {
                        concrete = false;
                    }
                }
                check = false;
            }

            //Because doing it in XML would replace the whole def
            if (!wall && DefDatabase<ThingDef>.GetNamed("Wall", false) != null)
            {
                DefDatabase<ThingDef>.GetNamed("Wall").building.canPlaceOverWall = true;
                wall = true;
            }
            if (!embrasure && DefDatabase<ThingDef>.GetNamed("Embrasure", false) != null)
            {
                DefDatabase<ThingDef>.GetNamed("Embrasure").building.canPlaceOverWall = true;
                embrasure = true;
                Log.Message("JTReplaceWalls: detected Embrasure");
            }
            if (!concrete)
            {
                ThingDef thing = DefDatabase<ThingDef>.GetNamed("ConcreteWall", false);
                if (thing != null)
                {
                    Log.Message("JTReplaceWalls: detected ConcreteWall");
                    thing.building = new BuildingProperties();
                    thing.building.canPlaceOverWall = true;
                    concrete = true;
                }
                thing = DefDatabase<ThingDef>.GetNamed("ConcreteAutodoor", false);
                if (thing != null)
                {
                    Log.Message("JTReplaceWalls: detected ConcreteAutodoor");
                    thing.building = new BuildingProperties();
                    thing.building.canPlaceOverWall = true;
                    concrete = true;
                }
                thing = DefDatabase<ThingDef>.GetNamed("ConcreteEmbrasure", false);
                if (thing != null)
                {
                    Log.Message("JTReplaceWalls: detected ConcreteEmbrasure");
                    thing.building = new BuildingProperties();
                    thing.building.canPlaceOverWall = true;
                    concrete = true;
                }
            }
            //End XML replacement
            */

            return GenConstruct_JT.CanPlaceBlueprintAt(entDef, c, placingRot, Map, stuffDef, DebugSettings.godMode, null);
        }

        //Should never be called, here just because compiler complains
        public override BuildableDef PlacingDef
        {
            get
            {
                return entDef;
            }
        }

    }
}
