   assets =
{
   Asset("ANIM", "anim/alwaysontikitorch.zip"),
   Asset("SOUND", "sound/common.fsb"),
}
   local prefabs = 
{
  "tikitorchflame",
}

   local function onnear(inst)
       if inst.components.fueled then
       inst.components.fueled:InitializeFuelLevel(200)    
       end
       if not inst.components.cooker then
       inst:AddComponent("cooker")
       end
       end

   local function onfar(inst)
       if inst.components.cooker then
       inst:RemoveComponent("cooker")
       end
    
       if inst.components.fueled then
       inst.components.fueled:InitializeFuelLevel(400)
       
       end
end

local alwaysontikitorch = Class(function(self, inst)
    self.inst = inst
    self.alwaysontikitorch = alwaysontikitorch
end)

function alwaysontikitorch:OnSave()    
    return 
    {
        alwaysontikitorch = self.alwaysontikitorch
    }
end

function alwaysontikitorch:OnLoad(data)
    if data and data.alwaysontikitorch then
        self:Setalwaysontikitorch(data.alwaysontikitorch)
    end
end


   local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	inst:Remove()
end	

        
   
   local function onhit(inst,worker)
	if inst.components.spawner.child and    inst.components.spawner.child.components.combat then
	inst.components.spawner.child.components.combat:SuggestTarget(worker)
	end
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle")
end

   local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
        MakeObstaclePhysics(inst, 0.33)

       
           inst:AddComponent("inspectable")
    inst.components.inspectable.getstatus = function(inst)
        local sec = inst.components.fueled:GetCurrentSection()
        if sec == 0 then 
            return "OUT"
        elseif sec <= 4 then
            local t = {"EMBERS","LOW","NORMAL","HIGH"}
            return t[sec]
        end
    end


inst:AddComponent("burnable")
       inst.components.burnable:AddBurnFX("tikitorchflame", Vector3(-7, 45, 0), "fire_marker")
     --inst:ListenForEvent("onextinguish", onextinguish) --in case of creepy hands

       inst:AddComponent("fueled")
       inst.components.fueled.accepting = false
       inst.components.fueled.maxfuel = 800
       inst.components.fueled:SetSections(4)
        
   inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 0.00000001 + 0.00000001*GetSeasonManager():GetPrecipitationRate()
        else
            inst.components.fueled.rate = 0.00000001
        end
        
       if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
    
   inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            --inst.components.burnable:Extinguish()
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
        end
    end)
        
       anim:SetBank("pigtorch")
       anim:SetBuild("alwaysontikitorch")
       anim:PlayAnimation("idle", true)
       inst:AddTag("campfire")
       
       local minimap = inst.entity:AddMiniMapEntity()
	  minimap:SetIcon( "alwaysontikitorch.tex" )  

      inst:AddComponent("sanityaura")
      inst.components.sanityaura.aura = TUNING.SANITYAURA_TINY
       
       inst:AddTag("structure")
       inst:AddComponent("lootdropper")
       --inst.components.lootdropper:SetLoot({"log", "log", "log", "poop"})
       inst:AddComponent("workable")
       inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
       inst.components.workable:SetWorkLeft(4)
       inst.components.workable:SetOnFinishCallback(onhammered)
       inst.components.workable:SetOnWorkCallback(onhit)
       
   inst:AddComponent( "spawner" )
   inst:AddComponent( "playerprox" )
       inst.components.playerprox:SetDist(10,12)
       inst.components.playerprox:SetOnPlayerNear(onnear)
       inst.components.playerprox:SetOnPlayerFar(onfar)	
       return inst
       end

   return Prefab( "common/alwaysontikitorch", fn, assets, prefabs),
     MakePlacer("common/alwaysontikitorch_placer", "pigtorch", "alwaysontikitorch", "idle")