
local Global_Texts = {

-----COMBAT TUTORIAL
	Tutorial_InfoButton_Text = "When confronted with new enemies, be sure to learn about their abilities. \n\nHold down $1 while mousing over units to examine them",
	Tutorial_InfoButton_Title = "Inspect Units",

	Tutorial_CombatPower_Text = "This is the Power Grid. Whenever a building is damaged, it will be reduced. \n\nIf it is reduced to zero, you LOSE.",
	Tutorial_CombatPower_Title = "Power Grid",

    Tutorial_CombatAiming_Text = "When aiming a weapon, the ORANGE tiles show where you can shoot.",
    Tutorial_CombatAiming_Title = "Valid Targets",

	Tutorial_CombatMonster_Text = "Every enemy attack is forewarned. Next turn, this one will attack the buildings. \n\nHover over an enemy to see details about its attack.", 
	Tutorial_CombatMonster_Title = "Enemy Attacks",

	Tutorial_CombatMech_Text = "This is your Combat Mech. It can punch any adjacent tile. \n\nClick on your Mech, move it closer to the enemy, and punch him.", 
	Tutorial_CombatMech_Title = "Combat Mech",
	
	Tutorial_DeadTutorial_Title = "Disabled Squad",
	Tutorial_DeadTutorial_Text = "All of your Mechs were disabled. In normal battles, the Vek would then continue their attacks and the mission would end. \n\nFor this tutorial, your Mechs have been fully repaired.",

	Tutorial_CombatGameover_Text = "Your Power Grid has been reduced to zero. Normally this would mean game over. \n\nBecause this is a simulation, you can continue fighting the Vek.", 
	Tutorial_CombatGameover_Title = "Game Over",

	Tutorial_CombatUndo_Text = "You cannot hit the enemy from this location. Use 'Undo Move' to reposition the Mech!",
	Tutorial_CombatUndo_Title = "Undo Movement",

	Tutorial_CombatPunch_Text = "Punch this enemy!",
	Tutorial_CombatPunch_Title = "",

	Tutorial_CombatPush_Text = "Your Mech's punch PUSHED this unit. It will now attack a new location! \n\nPushes can save buildings from enemy attacks, or even make enemies attack each other.", 
	Tutorial_CombatPush_Title = "Pushing Enemies",

	Tutorial_CombatTank_Text = "This is your Tank Mech. \n\nIt shoots a projectile that travels in a straight line until it hits another object.",
	Tutorial_CombatTank_Title = "Tank Mech",

	Tutorial_CombatComplete_Text = "Every mission, you win by defeating the Vek or fighting them until they retreat.",
	Tutorial_CombatComplete_Title = "Completing Missions",

	Tutorial_CombatBonus_Text = "Missions also have bonus objectives. \n\nCompleting these will earn you additional resources after the battle.",
	Tutorial_CombatBonus_Title = "Bonus Objectives",

	Tutorial_CombatWeapon_Text = "Click on a weapon to use it. The number keys will also work as a shortcut. \n\nYou may not move after you've shot a weapon.", 
	Tutorial_CombatWeapon_Title = "Weapon Use",

	Tutorial_CombatEnd_Text = "When all of your Mechs have used an action or there is nothing left for your units to do, press this button to end your turn.",
	Tutorial_CombatEnd_Title = "End Turn",

--- MISSION TUTORIALS 

	Tutorial_Tanks_Text = "The tanks have come online and can now be controlled!",
	Tutorial_Tanks_Title = "Old Earth Tanks",

	Tutorial_Terraform_Text = "This Terraformer unit is under your control during this mission. \n\nUse it to turn Grass tiles into Sand tiles.",
	Tutorial_Terraform_Title = "Terraformer",

	Tutorial_VolatileVek_Text = "Your bonus objective in this mission is to not let this Vek die.",
	Tutorial_VolatileVek_Title = "Volatile Vek",

---- STANDARTD TUTORIALS 

--	Tutorial_FinalIsland_Title = "Final Mission",
	--Tutorial_FinalIsland_Text = "You may attempt the Final Mission now that you've completed two Islands. Alternatively, you can continue to secure more Islands. \n\nYour --choice should depend on how long you would like to play this timeline. The difficulty will always scale to your current progress.",
	
	Warning_Final = "Warning: This final mission is still in development. \n\nIt is less polished and still being designed. \n\nYou should still find it roughly playable. Good luck!",
	
	Warning_OldSave = "Warning: This save file was created by a previous version of Into the Breach. \n\nSince the game is still in development, I can't guarantee full backwards compatibility for every update and you may experience problems with this save. \n\nThat said, chances are good that you won't have any issues. Sorry about the possible troubles!",

	Tutorial_PoweredPilot_Title = "Powered Pilot",
	Tutorial_PoweredPilot_Text = "This Pilot is a Sentient machine and requires Reactor Power to activate its special ability.",

	Tutorial_Acid_Title = "A.C.I.D.",
	Tutorial_Acid_Text = "This unit is inflicted with A.C.I.D. With its defenses corroded, incoming Weapon Damage will be doubled.\n\nAll other damage (Push, Fire, Blocking, etc.) is unaffected.",

	Tutorial_Frozen_Text = "This unit is FROZEN. It cannot move or attack and will remain Frozen until it takes damage.",
	Tutorial_Frozen_Title = "Frozen Unit",

	Tutorial_Frozen_Mech_Text = "This Mech can use its Repair Skill to free itself from the ice, but otherwise cannot attack or move.",
	Tutorial_Frozen_Mech_Title = "Frozen Mech",
	
	Tutorial_Shield_Title = "Energy Shields",
	Tutorial_Shield_Text = "This is a Shield. It will block damage and any negative effects (Fire, Freezing, A.C.I.D, etc.). \n\nOnly direct damage will remove the Shield. Non-damaging, negative effects will have no effect.", 
	
	Tutorial_Armor_Title = "Armored Unit",
	Tutorial_Armor_Text = "This unit is Armored. All incoming Weapon Damage will be reduced by 1. \n\nAll other damage (Push, Fire, Blocking, etc.) is unaffected.",

	Tutorial_Environment_Text = "This mission has a special effect that will happen every turn. \n\nMouse over the environment icon to get more information.",
	Tutorial_Environment_Title = "Environment Effect",

	Tutorial_PowerGrid_Text = "The Power Grid connects every corporate Island. Any damage it takes in missions will persist. \n\nThe Vek caused damage before you arrived, but there will be opportunities to restore it.",
	Tutorial_PowerGrid_Title = "Damaged Power Grid",

	Tutorial_Overpower_Text = "If your Power Grid is full when it receives additional power, your Grid Defense will be permanently upgraded.",
	Tutorial_Overpower_Title = "Overpowered Grid",
	
	Tutorial_FullOverpower_Text = "You can only Overpower your Power Grid to have an additional +25 Defense.",
	Tutorial_FullOverpower_Title = "Defense Grid Maxed",

	Tutorial_GridDefense_Text = "This building resisted damage! \n\nThe chance of a building resisting damage is shown to the right of your Power Meter.",
	Tutorial_GridDefense_Title = "Grid Defense",

	Tutorial_Jelly_Text = "This enemy Psion provides a passive bonus to all Vek. Killing it removes the bonus. \n\nSelect the Psion and mouse over its portrait in the bottom left for more information.",
	Tutorial_Jelly_Title = "Vek Psion",

	Tutorial_Webbed_Text = "This unit has been WEBBED! \n\nMouseover the status icons on the bottom left to investigate what that means.",
	Tutorial_Webbed_Title = "Webbed Mech",

	Tutorial_IslandNewGame_Text = "You can attempt the Islands you've unlocked in any order. \n\nVek difficulty will scale depending on how many Islands you've completed this game.",
	Tutorial_IslandNewGame_Title = "Corporate Islands",

	Tutorial_Spawning_Text = "An enemy unit will emerge here next turn! \n\nYou can temporarily block enemies from spawning, but it will damage the blocking unit.",
	Tutorial_Spawning_Title = "Emerging Enemies",

	Tutorial_Forest_Text = "The FOREST on this tile took damage, turning it into FIRE. \n\nIf a unit stands on Fire, it will ignite and take damage every turn.",
	Tutorial_Forest_Title = "Burning Forests",

	Tutorial_Fire_Text = "This Mech is on FIRE! It will take one damage every turn. \n\nMechs can REPAIR status effects, but cannot attack the same turn that they repair.",
	Tutorial_Fire_Title = "Burning Mechs",

	Tutorial_DamagedMech_Text = "Your Mechs will automatically repair all damage after battle. \n\nIf a Mech is reduced to 0 health, the Pilot dies and the Mech is disabled for the rest of that battle.",
	Tutorial_DamagedMech_Title = "Damaged Mechs",

	Tutorial_Corroded_Text = "This Mech is inflicted with A.C.I.D.! It corrodes the unit's armor, causing all incoming damage to be doubled. \n\nMechs can REPAIR status effects, but cannot attack the same turn that they repair.",
	Tutorial_Corroded_Title = "Acidic Mechs",

	Tutorial_Pod_Text = "This Pod contains equipment from the future! \n\nYou can collect it with your Mech, or just defend it until the end of the battle.",
	Tutorial_Pod_Title = "Time Pods",

	Tutorial_PodDestroyed_Title = "Destroyed Time Pods",
	Tutorial_PodDestroyed_Text = "The Time Pod on this tile has been destroyed! \n\nTime Pods are destroyed by taking damage or by any enemy standing on it.",
		
	Tutorial_Water_Text = "Mechs cannot use their weapons when standing in Water.",
	Tutorial_Water_Title = "Swimming Robots",
	
	Tutorial_WaterUndo_Text = "Mechs cannot use their weapons when standing in Water. \n\nYou can use Undo Move if you'd like to reposition it.",
	Tutorial_WaterUndo_Title = "Swimming Robots",

	Tutorial_DeadPilot_Text = "Your Mech was disabled! Its Pilot was killed and it will not be able to act for the rest of the mission.",
	Tutorial_DeadPilot_Title = "Disabled Mechs",

	Tutorial_Drowning_Text = "This unit fell into the Water, killing it instantly!",
	Tutorial_Drowning_Title = "Drowning Unit",

	Tutorial_PushDamage_Text = "Pushing units into things deals 1 additional damage to both!",
	Tutorial_PushDamage_Title = "Pushing into Objects",

	Tutorial_PushDeath_Text = "Pushing units into things deals 1 additional damage to both! \n\nIn this case, the extra damage killed the unit!",
	Tutorial_PushDeath_Title = "Pushing into Objects",

	Tutorial_BuildingDamage_Text = "This building tile was damaged, so your city Power Grid was reduced. \n\nYour primary goal is to prevent this!",
	Tutorial_BuildingDamage_Title = "Building Damage",

	Tutorial_Combat_Title = "Combat Simulation",
	Tutorial_Combat_Text = "There is a Combat Simulation available to get new Commanders up to speed with mechanized combat. \n\nWould you like to launch the simulation?",

	Tutorial_Money_Title = "Corporation Reputation",
	Tutorial_Money_Text = "As you secure regions and complete bonus objectives, your reputation with the local Corporation will increase. \n\n You can spend reputation on supplies at the end of the Island.",

	Tutorial_Cores_Title = "Reactor Cores",
	Tutorial_Cores_Text = "You now have a Reactor Core! Open a Mech's Upgrade Screen and install it.",

	Tutorial_Cores2_Title = "Core Installation",
	Tutorial_Cores2_Text = "You can use this button to install Reactor Cores in a Mech. \n\nEach Core will increase a Mech's maximum reactor power by one.",

	Tutorial_Cores3_Title = "Weapon Modifications",
	Tutorial_Cores3_Text = "You can use reactor power to activate weapon modifications. \n\nClick on a mod to power it. You can always click again to remove the power if you want to put it elsewhere.",

	Tutorial_Weapon_Title = "New Weapon",
	Tutorial_Weapon_Text = "You just got a new weapon! You can equip it in the Upgrade Screen.",

	Tutorial_Pilot_Title = "New Pilot",
	Tutorial_Pilot_Text = "You just got a new Pilot! You can assign them in the Upgrade Screen.",
	
	---Beta warning for squad unlock change
	
	Tutorial_OldProfile_Title = "Old Profile",
	Tutorial_OldProfile_Text = "The game has been updated and older beta profiles might encounter some oddities after these changes.\n\nYour Achievement Coins Total might be negative now because of changes to pricing of previously unlocked Mechs. The game is functioning, you'll just need more Achievements to break even.\n\nIf you have a run in progress, it may not load correctly. I hope it still works, but I apologize if it does not.", 
		
	---Tutorial Large Screens
	Tutorial_Weapons = "WEAPON EFFECTS",
	Tutorial_WeaponsText = "When aiming a weapon or examining an enemy attack, icons show you exactly what will happen.",
	Tutorial_Weapons_Push = "PUSHING",
	Tutorial_Weapons_PushText = "An arrow on a tile means a unit on that tile will be pushed",
	Tutorial_Weapons_Damage = "DAMAGE",
	Tutorial_Weapons_DamageText = "A number on a tile means the unit on that tile will be damaged",
	Tutorial_Weapons_PushDamage = "PUSH + DAMAGE",
	Tutorial_Weapons_PushDamageText = "Some weapons can cause multiple effects on a single tile",
	
	Tutorial_Art = "ARTILLERY MECH",
	Tutorial_ArtText = "Artillery Weapons can shoot over obstacles like mountains, but cannot shoot adjacent tiles.",
	Tutorial_ArtExtra = "The Artillery Mech's weapon will only damage units on the CENTER tile, while units on ADJACENT tiles are pushed.",
	
	Tutorial_Rewards = "MISSION REWARDS",
	Tutorial_RewardsText = "Every mission has different potential rewards for completing bonus objectives. \n    You won't be able to do every mission on the Island, so choose carefully!",
	Tutorial_Rewards_Cores = "POWER CORES: Used to upgrade your Mechs.",
	Tutorial_Rewards_Power = "GRID POWER: Restores your Power Grid. \nIf your Power Grid reaches zero, you lose.",
	Tutorial_Rewards_Reputation = "CORP REPUTATION: Used to purchase items once the Island is secure.",
	Tutorial_Rewards_Difficulty = "WARNING: Missions with more potential rewards will have additional dangers!",
	Tutorial_RegionName = "Safeguard Valley",
	
	Tutorial_Final = "FINAL MISSION",
	Tutorial_FinalText = "After securing two corporate islands, the Final Mission is available to complete.",
	Tutorial_Final_ScalingTitle = "Difficulty",
	Tutorial_Final_Scaling = "The difficulty of this battle scales to your current progress. Fighting it now will be as much of a challenge as attempting it after securing additional Islands",
	Tutorial_Final_ScoringTitle = "Civilians",
	Tutorial_Final_Scoring = "Securing more islands before the Final Mission will allow you to save more civilians and increase your final score.",
	
	Tutorial_StartCombat = "Start Simulation",
	Tutorial_DeclineCombat = "Decline",
	Tutorial_DeclineAll = "No, I know what I'm doing (hide ALL future tutorial tips)",
	
	Tutorial_Dismiss = "(Click to Dismiss)",
	
	--tooltips
	TipTitle_FinalMission = "Final Mission",
	TipText_FinalMission = "You may complete the Final Mission at any point after securing two Corporate Islands.\n\nThe difficulty of the mission scales to your current progress.", 

	
	TipTitle_Reputation = "Corporate Reputation",
	TipText_Reputation = "Use reputation points to purchase supplies once an Island is secured.",
	TipTitle_Cores = "Reactor Cores",
	TipText_Cores = "Used for upgrading your Mechs. \n\nOpen the Mech Upgrade screen by clicking on any Mech icon on the left.",
	
	TipTitle_Order = "Attack Order",
	TipText_Order = "Mouse over here or hold ALT to display the order enemies will attack.",
	TipText_Menu = "Game Menu [ESC]",
	TipTitle_Menu = "Open the Game Menu",
	
	TipText_Overlay = "Shows the order that actions will happen during the enemy turn. Hotkey: [$1]",
	TipTitle_Overlay = "Attack Order",
	
	TipText_TimerBattle = "How long you've been playing your current game. \n\nYou can hide this in the Options menu.",
	TipTitle_TimerBattle = "Game Time",
	
	TipText_ResetTurn = "Go back in time to the start of the current turn. Available after taking at least one action. \n\nYou can only do this once per battle.",
	TipTitle_ResetTurn = "Reset Turn",
	
	TipText_ResetTurnUsed = "You can only use this once per battle.",
	TipTitle_ResetTurnUsed = "Reset Turn Used",
	
	TipText_ResetTurnExtra = "Go back in time to the start of the current turn. Available after taking at least one action. \n\nYour 'Temporal Reset' Pilot gives you one extra Reset per battle. You have 2 remaining.",
	TipTitle_ResetTurnExtra = "Reset Turn",
	
	TipText_ResetTurnFinal = "Go back in time to the start of the current turn. Available after taking at least one action. \n\nYou only have 1 Reset remaining.",
	TipTitle_ResetTurnFinal = "Reset Turn",
	
	TipText_CombatSpeed = "Modifies how quickly enemy units take their turn. \n\nSlow it down if you're new and having troubles following enemy actions, speed it up if you're experienced and comfortable with combat.",
	TipTitle_CombatSpeed = "Combat Speed",
	
	TipText_Abandon = "End this attempt and send a Pilot back in time to try again.",
	TipTitle_Abandon = "Abandon Timeline",	
	
	TipTitle_TutorialTips = "Tutorial Tips",
	TipText_TutorialTips = "Show relevant Tutorial popups during the game. \n\nHighly recommended for new players.",
	
	TipTitle_BoardScale = "Max Board Scale",
	TipText_BoardScale = "Customize the max combat board rendering scale.\n\nThis can be useful to decrease the scale for larger monitors.\n\nCurrent window default scale is: $1",
	
	TipTitle_DefaultRes = "Default Window",
	TipText_DefaultRes = "Restore the game to its default 720p Window. Recommended for streaming.",
	
	TipTitle_AudioMuted = "",
	TipText_AudioMuted = "Audio is currently muted",
		
	TipTitle_Timer = "Game Timer UI",
	TipText_Timer = "Add Game Timer to the UI. \n\nHelpful for speed running or obtaining the 'Lightning War' achievement",
	
	TipTitle_Colorblind = "Colorblind Mode",
	TipText_Colorblind = "Changes some colors and adds additional icons to aid colorblind players.\n\nLet us know if you'd like anything improved with this.",
	
	TipTitle_LargeFont = "Larger Fonts",
	TipText_LargeFont = "Increases the size of tooltips, dialogs, and other critical texts.",
	
	TipTitle_NoLargeFont = "Larger Fonts Unavailable",
	TipText_NoLargeFont = "Your current window resolution is too small to support larger fonts.",
	
	TipTitle_Confirm = "End Turn Confirmation",
	TipText_Confirm = "Receive confirmation when you attempt to end your turn and have units still available to act.",
	
	TipTitle_Stretch = "Stretch Scaling",
	TipText_Stretch = "Stretch art and UI when adjusting to larger resolutions. \n\nHelpful for high (1440p or more) resolution monitors if the UI is too small, but might make the art and text slightly blurry.",
	
	TipTitle_NoStretch = "Stretch Scaling Unavailable",
	TipText_NoStretch = "Your Video Drivers do not support the necessary requirements for this. \n\nPlease update or contact support if you need this feature.",
	
	TipTitle_BattleVictory = "Battle Victory",
	TipText_BattleVictory = "All enemies will retreat in $1 turns",
	TipText_BattleVictory_One = "All enemies will retreat in 1 turn",
	
	TipTitle_BattleVictory_Final = "Final Victory",
	TipText_BattleVictory_Final = "The bomb will explode in $1 turns",
	TipText_BattleVictory_One_Final = "The bomb will explode in 1 turn",
	
	TipTitle_RepObj = "Reputation Objective",
	TipText_RepObj = "Rewards Corporate Reputation, used to buy equipment.",
	TipTitle_PodObj = "Time Pod",
	TipText_PodObj = "A Time Pod's contents could be useful for the fights ahead.",
	TipTitle_PowerObj = "Power Objective",
	TipText_PowerObj = "Restores power to the Power Grid",
	TipTitle_CoreObj = "Reactor Core Objective",
	TipText_CoreObj = "Rewards a Reactor Core, used to upgrade Mechs.",
	TipTitle_Saved = "Saved People",
	TipText_Saved = "The number of people you've saved in this time line \n\nHigher difficulties have more people per building in battle.",
	TipTitle_UpgradeReactor = "Mech Reactor",
	TipText_UpgradeReactor = "You can use reactor power to improve your weapons, or power additional weapons. \n\nInstall Reactor Cores to upgrade a Mech's reactor.",
	TipTitle_UndoCore = "Undo Core Installation",
	TipText_UndoCore = "Undo recent Core installations.",
	TipTitle_Health = "Mech Health",
	TipText_Health = "",
	TipTitle_Move = "Mech Movement",
	TipText_Move = "",
	
	TipTitle_ZoltanHealth = "Zoltan Health",
	TipText_ZoltanHealth = "The Zoltan Pilot prevents increasing the HP of this Mech",
	
	TipTitle_MechClass = "Mech Class",
	TipText_MechClass = "The Mech's Class determines which weapon types it can efficiently use. \n\nWeapons not in the same class will cost 1 extra Reactor Power.",
	
	TipTitle_Cyborg = "Cyborg Class",
	TipText_Cyborg = "Cyborgs require 1 extra Reactor Power to use any non-Cyborg weapon or passive.",
	
	TipText_RenamePilot = "Click to rename this Pilot.",
	TipTitle_RenamePilot = "Rename Pilot",
	TipText_RenameMech = "Click to rename this Mech.",
	TipTitle_RenameMech = "Rename Mech",
	
	TipTitle_PilotMax = "Max Level",
	TipText_PilotMax = "This Pilot has unlocked all of their skills!",
	TipTitle_PilotExperience = "Pilot Experience",
	TipText_PilotExperience = "Once this Pilot gains enough experience in combat, they will unlock more skills.",
	TipTitle_PilotAI = "Basic AI Pilot",
	TipText_PilotAI = "Basic AI Pilots are already operating at their peak efficiency and do not gain experience in combat. \n\nFind superior human Pilots, or advanced AI Pilots, to replace the basic AI.",
	
	TipText_GridDefense = "The percentage chance any building will resist damage. \n\nGain Power when your Power Grid is full to upgrade its Defense.",
	TipTitle_GridDefense = "Grid Defense",
	TipText_PowerGrid = "You LOSE if this reaches zero. \n\nReduced every time a Powered Building is damaged in combat.",
	TipTitle_PowerGrid = "Power Grid",
	
	TipTitle_BuyCore = "Reactor Core",
	TipText_BuyCore = "Reactor Cores are used to upgrade your Mechs between missions.",
	TipTitle_BuyPower = "Grid Power",
	TipText_BuyPower = "Repair damage to your Power Grid. \n\nIf your Power Grid is full, this will permanently upgrade your Grid Defense.",
	
	TipTitle_BuyPower_Grid = "Overpower Grid",
	TipText_BuyPower_Grid = "Your Power Grid is full. Additional Power will permanently upgrade your Grid Defense. \n\nThe bonus will decrease the higher your Grid Defense gets, to a maximum of +25.",
	
	TipTitle_BuyPower_Full = "Full Grid",
	TipText_BuyPower_Full = "Your Power Grid and Grid Defense are both at their maximum value. \n\nYou cannot purchase additional Power.",
	
	TipTitle_Mission_Normal = "Standard Vek Threat",
	TipText_Mission_Normal = "No special additions for this mission",
	TipTitle_Mission_Hard = "High Vek Threat",
	TipText_Mission_Hard = "One extra Alpha Vek will be present when the mission starts",
	TipTitle_Mission_Easy = "Defense Grid Active",
	TipText_Mission_Easy = "Some buildings start with a free Shield",
	
	------ ENVIRONMENTS ---------
	
	TipTitle_Env_BeltLine = "Conveyor Belts",
	TipText_Env_BeltLine = "Conveyor Belts will push units around the map",
	TipTitle_Env_BeltRandom = "Conveyor Belts",
	TipText_Env_BeltRandom = "Conveyor Belts will push units around the map",
	TipTitle_Env_Airstrike = "Air Strikes",
	TipText_Env_Airstrike = "A bomber will periodically target areas of the map",
	TipTitle_Env_Tides = "Tidal Waves",
	TipText_Env_Tides = "The map will gradually be flooded in water",
	TipTitle_Env_Cataclysm = "Cataclysmic Earthquakes",
	TipText_Env_Cataclysm = "The map will gradually break apart into a massive chasm",
	TipTitle_Env_Seismic = "Seismic Activity",
	TipText_Env_Seismic = "Ground tiles will periodically sink into chasms, taking any unit with them",
	TipTitle_Env_Lightning = "Lightning Storm",
	TipText_Env_Lightning = "Dangerous lightning will threaten the map, killing anything it strikes",
	TipTitle_Env_SnowStorm = "Ice Storm",
	TipText_Env_SnowStorm = "Large areas of the map will periodically freeze solid",	
	
	---------- Island Descriptions
	
		
	Corp_Grass_Description = "This Museum Island recreates Old Earth as it was before the oceans rose and nearly wiped out humanity.",
	Corp_Desert_Description = "Terraforming specialists, R.S.T. turned the environment against the Vek and nearly destroyed their Island in the process.",
	Corp_Snow_Description = "Pinnacle Robotics fights a war on two fronts, one against the Vek, the other against its own Sentient Weapons.",
	Corp_Factory_Description = "Detritus tech can break down any matter into its base elements. Their factory-cities are devoted to waste removal and recycling.",
	
	--Order Texts
	Order_Fire = "Fire Damage",
	Order_Psion = "Psion Regenerate",
	Order_Tentacle = "Psion Tentacle",
	Order_Actions = "Enemy Actions",
	Order_NPC = "NPC Actions",
	Order_NPC_Bots = "NPC Bot Actions",
	Order_Emerge = "Enemies Emerge",
	Order_Env = "Environment",
	Order_Smoke = "Storm Smoke",
	
	---Combat Texts
	Deploying_Mech = "Deploying $1",
	Deploying_Instructions = "Select a location in the yellow Drop Zone",
	Deploying_Complete = "Deployment Complete",
	Deploying_Confirm = "You may change your placements before confirming",
	Combat_Deployment = "DEPLOYMENT",
	Deploy_Remaining = "Remaining Units:",
	Button_Deployment_Done = "CONFIRM",
	Button_Button_Pawnlist = "     Unit List",
	Button_Button_Objectives = "Bonus Objectives     ",
	
	Skip_Units = "You still have units that can act. They will lose their turn.",
	Reset_Turn = "Go back in time to the start of your turn?\n\nPower limitations means you can only do this once per battle.",
	Reset_TurnExtra = "Go back in time to the start of your turn?\n\nYour 'Temporal Reset' Pilot means you can do this twice this battle.",
	Reset_TurnFinal = "Go back in time to the start of your turn?\n\nYou only have one Reset remaining.",
	Button_EndTurn = "End Turn",
	Button_Undo = "UNDO \nMOVE",
	Button_UndoTurn = "RESET TURN",
	Button_UndoTurnUsed = "RESET USED",
	
	Active_Units = "Active Units: ",
	
	Objective_EnemyRetreat = "Victory in",
	Objective_EnemyRetreat2 = "turns",
	Objective_EnemyRetreat3 = "turn",
	
	Button_Editor_Exit = "EDIT MAP",
	Button_Done_Testing = "DONE TESTING",
	
	Disarm_Info = "[ Right Click ]\nor\n[ $1 ]\nto Disarm",
	
	-- Skill Info
	Skill_Passive = "PASSIVE",
	Skill_ClassAny = "Any",
	Skill_ClassTechnoVek = "Cyborg",
	Skill_ClassPassive = "Passive",
	Skill_ClassPrime = "Prime",
	Skill_ClassDeath = "On Death",
	Skill_ClassBrute = "Brute",
	Skill_ClassRanged = "Ranged",
	Skill_ClassScience = "Science",
	Skill_ClassEnemy = "Enemy",
	Skill_ClassString = "$1 Class Weapon",
	Skill_ClassPassString = "Passive Effect",
	Skill_Damage = "Damage: ",
	Skill_SelfDamage = "Self-Damage: ",
	Skill_Limited = "Uses per battle: ",
	
	Skill_WrongClass = " No matching Mech class. \n 1 Power penalty applies.",
	Skill_CyborgOnly = "Non-Cyborg Weapon",
	
	--- Pilot Info
	Pilot_Special = "Special",
	Pilot_PowerReq = "Requires $1 power",
	Pilot_Powered = "Powered",
	Pilot_None = "None",
	Pilot_Max = "Max Level",
	Pilot_XP = "$1 / $2 xp",
	Pilot_Unknown = "Unknown Skill",
	Pilot_UnknownText = "Gain experience to unlock this skill.",
	Pilot_Skills = "Skills",
	Pilot_Experience = "Experience",
	Pilot_History = "History",
	Pilot_History_Timelines = "Previous Timelines: $1",
	Pilot_History_Final = "Final Battles: $1",
	
	Pilot_HealthName = "Health Bonus",
	Pilot_HealthShort = "+2 Mech HP",
	Pilot_HealthDesc = "Piloted Mech health is increased by 2.",
	
	Pilot_MoveName = "Move Bonus",
	Pilot_MoveShort = "+1 Mech Move",
	Pilot_MoveDesc = "Piloted Mech movement is increased by 1.",
	
	Pilot_GridName = "Grid Defense Bonus",
	Pilot_GridShort = "+3 Grid DEF",
	Pilot_GridDesc = "Grid Defense increased by 3. This affects the chance of resisting Building Damage in combat.",
	
	Pilot_ReactorName = "Reactor Bonus",
	Pilot_ReactorShort = "+1 Mech Reactor",
	Pilot_ReactorDesc = "Piloted Mech reactor increased by 1.",
	
	Pilot_XpString = "$1 / $2 xp",
	Pilot_XpMax = "Max Level",
	Pilot_XpAI = "Mechs can pilot themselves, but it's better to have a specialized Pilot.",
	
	-- Gamepad instructions`
	Gamepad_SelectUnit = "Select Unit",
	Gamepad_PlaceUnit = "Place Unit",
	Gamepad_MoveUnit = "Move Unit",
	Gamepad_FireWeapon = "Fire Weapon",
	Gamepad_Cancel = "Cancel Shot",
	
	--Combat State Labels
	State_Tutorial = "SIMULATION STARTED",
	State_Gameover = "GAME OVER",
	State_Player = "PLAYER TURN",
	State_Enemy = "ENEMY TURN",
	State_Start = "MISSION START",
	State_Complete = "MISSION COMPLETE",
	State_Disabled = "MECHS DISABLED",
	State_Turns = "$1 Turns Remaining",
	State_LastTurn = "Last Turn",
	
	--Upgrade Screen
	
	Upgrade_MoveLabel = "+1 Move",
	Upgrade_HealthLabel = "+2 Health",
	Upgrade_Install = "INSTALL",
	Upgrade_Max = "MAXED",
	Upgrade_Class = "Mech Class: $1",
	Upgrade_Test = "Use the Virtual Simulator to test Mech Loadouts",
	Upgrade_Armory = "STORAGE",
	Upgrade_Pilot = "PILOT",
	Upgrade_Stats = "STATS",
	Upgrade_Reactor = "REACTOR",
	Upgrade_Move = "Move:",
	Upgrade_Health = "Health:",
	Upgrade_Weapons = "WEAPONS",
	Button_Upgrade_Test = "TEST MECH",
	Button_Upgrade_Undo = "UNDO",
	Wrong_Cost = "Costs one additional \n          power to use",
	Wrong_Class = "Wrong Class",
	Upgrade_Page = "Page $1 of $2",
	Upgrade_New = "NEW!",
	
	--Victory Screen
	Victory_RegionLost = "Region Lost",
	Victory_FailedRewards = "No rewards for a failed mission.",
	Victory_Simulation = "Simulation Complete",
	Victory_SimulationText = "Congratulations on your first successful mission, Commander! I'm confident in your ability to save the planet after such extensive training.",
	Objective_Title = "Bonus Objectives",
	Objective_Title_One = "Bonus Objective",
	Objective_Title_Final = "Primary Objective",
	Victory_Civilians = "Civilians Protected",
	Victory_Title = "Region Secured",
	Pod_Title = "POD RECOVERED",
	Pod_Contents = "Pod Contents:",
	
	---Store
	Store_Core = "Reactor Core",
	Store_Cost = "Cost:  $1",
	Store_Equipped = "Equipped",
	Store_Purchase = "Purchase equipment using       Reputation", -- star image goes in here
	Store_Sell = "Donate weapons and pilots for       Reputation", --star image goes in here
	Store_SellTitle = "DONATE",
	Store_BuyTitle = "ACQUIRE",
	Store_Weapons = "Weapons",
	Store_Pilots = "Pilots",
	Leave_Confirm = "Your unspent Corporate Reputation will be lost if you leave now.",
	SellPilot_Confirm = "Are you sure you want to permanently assign this Pilot to the Island?\n(Grants Reputation)",
	SellWeapon_Confirm = "Are you sure you want to donate this weapon?\n(Grants Reputation)",
	
	--Rewards
	Reward_Title = "Perfect Island!",
	Reward_Subheading = "Select one free reward",
	
	--- Misc
	Pod_Objective = "Protect the Time Pod",
	Secret_Objective = "Protect the Strange Pod",
	Secret_Objective_Failed = "Protect the Strange Pod (Failed)",
	Pod_Detected = "Time Pod Detected",
	Pod_Failed = "Protect the Time Pod (Failed)",
	Toggle_NeverAgain = "Don't Ask Again",
	Mission_Map_Deploy = "Start Mission",
	Pawn_Box_Water = "Water \nLogged",
	Pawn_Box_Acid = "Water \nLogged",
	Pawn_Box_Smoke = "Smoke \nBlocking",
	Pawn_Box_Ice = "Ice \nBlocking",
	Pawn_Box_Shot = "Bonus Move \nOnly",
	Pawn_Box_Lava = "Lava \nBlocking",
	Boss_Title = "Warning: Vek Offensive",
	Boss_Text = "Vek are overrunning two regions on the Island. \nThe region you do not save will be lost forever.",
	Top_Power = "POWER",
	Top_Grid = "GRID",
	Top_Defense = "DEFENSE",
	Pilot_TurnOver = "Turn Over",
	Pilot_Disabled = "Disabled",
	Pilot_EnemyDead = "Killed",
	
	--Office
	Island_Office = "$1 Head Office",
	
	--Mission Texts
	Mission_Normal = "Vek Threat Detected!",
	Mission_Easy = "Defensive Shields Active!",
	Mission_Hard = "High Threat Detected!",
	Mission_Final = "The Last Stand",
	Mission_Failed = "Region Destroyed by Vek",
	Mission_None = "No Vek Detected",
	
	--Confirm Box
	Button_Confirm_No = "NO",
	Button_Confirm_Yes = "YES",
	Confirm_Question = "Continue?",
	Button_Confirm_Ok = "OK",
	
	-- Pilot News
	PilotNews_Dead = "DECEASED",
	PilotNews_Revived = "REVIVED",
	PilotNews_ReviveText = "The Emergency Medical Supplies were able to save $1 from the brink of death!",
	PilotNews_Vek = "REGENERATED",
	PilotNews_VekText = "$1 has recovered from the brink of death! The effort required to regenerate has cost XP.",
	PilotNews_DeadText = "$1 died after taking severe damage in the battle against the creatures.",
	PilotNews_Promoted = "PROMOTED",
	PilotNews_Skill = "New Skill Unlocked:",
	Button_Pilot_News_Done = "Understood",
	
	
	--Buttons
	Button_Continue = "CONTINUE",
	Button_Wait = "WAIT",
	Button_Create = "CREATE",
	
	--Main Menu
	Button_Profile = "Create New Profile",
	Button_MainContinue = "Continue",
	Button_MainCredits = "Credits",
	Button_MainNew = "New Game",
	Button_MainOptions = "Options",
	Button_MainProgress = "Progress",
	Button_MainStats = "Statistics",
	Button_MainAchievs = "Achievements",
	Button_MainSquads = "Squads",
	Button_MainQuit = "Quit",
	Button_MainProfile = "Profile",
	Toggle_EnableTips = "Enable Tutorial Tips",
	NewGame_Confirm = "You currently have a game in progress. Starting a new one will permanently erase it.",
	Delete_Confirm = "You will lose all game progress and unlocks. This cannot be undone.",
	Warning_NoSave = "'Into the Breach' does not appear to have file access to save progress. \n\nPlease quit and check if your Anti-Virus software is blocking it. \n\nIf the problem persists email us at contact@subsetgames.com",
	Warning_FileWriteIssue = "'Into the Breach' is possibly unable to save progress. \n\nPlease quit and check if your Anti-Virus software is blocking it. \n\nIf the problem persists email us at contact@subsetgames.com",
	Menu_NoSave = "WARNING: There is a file write error and your progress cannot be saved.",
	Confirm_Header = "Confirm Action",
	Warn_Header = "Warning!",
	Profile_Delete_Failed = "Your profile data could not be fully deleted. It may be read only, or it may have extra files in its folder. You can delete it manually from here: \n\n",
	Profile_Delete_Failed_OSX = "Your profile data could not be deleted. This is a known issue in OS X. \n\nYou can delete your profile data manually from this location: \n\n",
	
	
	Stats_Header = "Statistics",
	Stats_TotalVictory = "Victories:",
	Stats_TotalLost = "Timelines Lost:",
	Stats_TotalGames = "Total Games:",
	
	Stats_TotalTravelers = "Total Time Travelers:",
	Stats_TotalKills = "Total Enemy Kills:",
	Stats_TotalSaved = "Total Civilians Saved:",
	Stats_TotalIsland = "Total Islands Secured:",
	Stats_TotalPods = "Pods Collected:",
	
	Stats_ScoreDefeat = "Defeated",
	Stats_ScoreVictory = "$1 Island Victory!",
	Stats_ScoreScore = "Civilians Saved:",
	Stats_ScoreKills = "Total Kills:",
	Stats_ScoreFailed = "Failed Objectives:",
	Stats_ScoreTimer = "Game Time:",
	
	Stats_SquadGames = "Total Games:",
	Stats_SquadScore = "High Score:",
	Stats_SquadKills = "Total Kills:",
	
	Stats_PilotBattles = "Battles:",
	Stats_PilotJumps = "Time Jumps:",
	Stats_PilotKills = "Total Kills:",
	Stats_Pilot_Deaths = "Total Deaths:",
	
	Stats_VekDeadliest = "Deadliest Enemy",
	Stats_VekDeadliestStat = "Killed Mechs:",
	Stats_VekWeakest = "Most Squashable",
	Stats_VekWeakestStat = "Times Killed:",
	Stats_VekDestruction = "Most Destructive",
	Stats_VekDestructionStat = "Grid Damage:",
	
	
	Stats_ListButton = "Back to List",
	Stats_SquadButton = "Change Squad",
	Stats_PilotButton = "Change Pilot",
	Stats_Done = "Close",
	
	Stats_ToggleGlobal = "Filter by Selected Squad",
	
	--Hangar
	Toggle_Easy = "Easy",
	Toggle_Hard = "Hard",
	Toggle_Normal = "Normal",
	Hangar_None = "None",
	Hangar_CustomSquad = "Final Selection:",
	Hangar_Traveler_Heading = "Time Traveler",
	Hangar_Island_Victory = "Medals awarded based on how many Corporate Islands are secured before completing the Final Island.",
	Hangar_Island_Victory_2 = "2 Island Victory: $1",
	Hangar_Island_Victory_3 = "3 Island Victory: $1",
	Hangar_Island_Victory_4 = "4 Island Victory: $1",
	Hangar_Island_Victory_Title = "Victory Medals",
	Hangar_Ach_Coins = "Note: Achievements earn you Coins to unlock new Mech Squads!",
	Hangar_Locked = "Locked",
	Hangar_Randomized = "Random Squad",
	Hangar_Custom = "Custom Squad",
	Hangar_Complete = "Complete more Islands to unlock!",
	Hangar_Achievements = "Earn more Coins!",
	Hangar_Buy = "Click to Purchase!",
	Button_Hangar_Squad = "Change Squad",
	Button_Hangar_Pilot = "Change Time Traveler",
	Button_Hangar_Random_Pilot = "Randomize",
	Button_Hangar_Reroll = "Balanced Roll",
	Button_Hangar_RandomRoll = "Chaos Roll",
	Button_Hangar_Ach = "View All Achievements",
	Button_Hangar_Secret = "Buy Secret Squad       ",
	Hangar_Total_Ach = "Total Coins Earned",
	Button_Hangar_Recustom = "Edit Squad",
	Hangar_Custom_Locked = "Unlock the Squad \"$1\" to use this Mech",
	Hangar_Custom_Locked_Title = "Locked Mech",
	Button_Hangar_Start = "Start Game",
	Hangar_Random = "Random Mech",
	Hangar_Select = "Squad Selection",
	Hangar_Achievements_Title = "Achievements",
	
	Ach_Squad = "Squad Based",
	Ach_Global = "Global",
	
	Hangar_Custom = "Customize Squad",
	Hangar_Coins = "Gain Coins by completing Achievements! Use Coins to unlock new Squads!",
	Hangar_Pilot_Unlock = "Find new Pilots while playing to unlock them here!",
	Hangar_Pilot = "Pilot Selection",
	Hangar_Traveler = "Last \nTraveler",
	Hangar_NoAbility = "No Special Ability",
	Hangar_NoTraveler = "Last Pilot Not Available",
	Randomized = "Create random Squad using unlocked Mechs.",
	Customized = "Create a custom Squad using unlocked Mechs.",
	RandomizedLocked = "Unlock more Mechs to use this feature!",
	No_Weapon = "No Weapon",
	
	TipTitle_MechColor = "",
	TipText_MechColor = "Click to change Mech Color",
	TipTitle_MechName = "",
	TipText_MechName = "Click to rename Mech",
	TipTitle_PilotName = "",
	TipText_PilotName = "Click to rename Pilot",
	TipTitle_PilotMech = "",
	TipText_PilotMech = "Click to change starting Mech for the Time Traveler",
	TipTitle_HangarMovement = "Movement",
	TipText_HangarMovement = "How many tiles this Mech can move each turn.",
	TipTitle_HangarHealth = "Health",
	TipText_HangarHealth = "How much damage this Mech can take before being disabled.",
	TipTitle_HangarClass = "Mech Class",
	TipText_HangarClass = "The Mech's Class determines which weapons it can use without a power penalty.",
	TipTitle_HangarFlying = "Flying",
	TipText_HangarFlying = "Flying units can move over any terrain tile.",
	TipTitle_HangarArmor = "Armored",
	TipText_HangarArmor = "Weapon damage to this unit is reduced by 1. All other damage (Push, Blocking, Fire, etc.) is unaffected.",
	
	TipTitle_HangarNormal = "Normal",
	TipText_HangarNormal = "Designed to provide an interesting challenge to new and experienced players.",
	TipTitle_HangarEasy = "Easy Mode",
	TipText_HangarEasy = "Reduced enemy spawn rates.\n\nScore is reduced by 50%.",
	TipTitle_HangarHard = "Hard Mode",
	TipText_HangarHard = "Increased spawn rates and more Alpha Vek.\n\nScore is increased by 50%.",
	
	
	TipText_LockedColor = "Unlock the Squad '$1' to use this color",
	TipTitle_LockedColor = "Locked Color",
	
	TipTitle_Repeat = "Repeat Passive Equipment",
	TipText_Repeat = "Your Mech Squad cannot have multiple copies of the same Passive Equipment. \n\nYou can still play with the Squad, but the extra copies of the Passive Equipment will be removed.",
	
	TipTitle_ChaosRoll = "Chaos Roll",
	TipText_ChaosRoll = "Purely random squad. No restrictions to class, weaponry, or Mech.",
	
	TipTitle_BalancedRoll = "Balanced Roll",
	TipText_BalancedRoll = "Slightly restricted random squad.\n\nAll Mechs will be unique and not from the same class. Mechs will have no more than 4 weapons between them.",
	
	--Options
	Toggle_Fullscreen = "Fullscreen",
	Toggle_Stretch = "Stretch Scaling",
	Toggle_Timer = "Game Timer UI",
	Button_Options_Hotkeys = "Edit Hotkeys",
	Button_Options_Default = "Default Windowed",
	Button_Options_Scale = "Max Board Scale: $1",
	Toggle_Mute = "Mute All Audio",
	Toggle_Colorblind = "Colorblind Mode",
	Toggle_Large = "Larger Fonts",
	Toggle_Tips = "Tutorial Tips",
	Abandon_Confirm = "You will send a Pilot to a new timeline and lose all other progress.",
	Escape_Title = "MENU",
	Escape_Info = "INFO",
	Escape_Sound = "Effects Volume",
	Escape_Music = "Music Volume",
	Escape_Speed = "Combat Speed",
	Toggle_Confirm = "End Turn Confirmation",
	Escape_Gameplay = "Gameplay",
	Escape_Video = "Sound + Video",
	Button_Escape_Menu = "MAIN MENU",
	Button_Escape_Exit_Editmode = "MAP EDIT MODE",
	Button_Escape_Exit_Editor = "QUIT EDITOR",
	Button_Escape_Options = "OPTIONS",
	Button_Escape_Ach = "ACHIEVEMENTS",
	Button_Escape_Quit = "SAVE and QUIT",
	Button_Escape_Abandon = "ABANDON TIMELINE",
	Button_Escape_Continue = "CONTINUE",
	
	Mouse_Middle = "Middle Mouse",
	Mouse_X1 = "Mouse 4",
	Mouse_X2 = "Mouse 5",
	
	--Opening Sequence
	Opening_1 = "Humanity: Destroyed      ",
	Opening_2 = "Vek Threat: Unstoppable",
	Opening_3 = "Mission: Failed              ",
	Opening_4 = "Open a breach.        ",
	Opening_5 = "Time to go back and try again.",
	
	--Game Over
	Button_Victory_Pilot = "SEND PILOT",
	Button_Victory_Quit = "MAIN MENU",
	Button_Victory_Done = "CONTINUE",
	
	--End of Island
	Button_Select_Mission_Leave = "LEAVE ISLAND",
	Button_Select_Mission_Store = "SPEND REPUTATION",
	Button_Select_Mission_Reward = "REPUTATION REWARD!",
	
	--Island Stuff
	Island_Environment = "ENVIRONMENT",
	Island_CEO = "CEO",
	Island_Vek = "VEK:",
	Island_Boss = "LEADER:",
	Island_Unlock = "Complete $1 $2 to unlock!",
	Island_Unlock_Single = "Island",
	Island_Unlock_Mult = "Islands",
	Island_UnlockTitle = "Island Locked",
	
	Island_UnlockTitle = "Island Unlocked!",
	Island_1 = "ONE Island",
	Island_2 = "TWO Islands",
	Island_3 = "THREE Islands",
	Island_Text = "By completing $1 you've unlocked \n\n\n\n\nIn future games, you will be able to visit unlocked Islands in any order.",
	Island_Squad = "New Squad available when starting a new game!",
	
	--Alerts
	Alert_Cleared = "ATTACK CANCELED",
	Alert_Fire = "FIRE DAMAGE",
	Alert_Elec = "ELECTRIC DAMAGE",
	Alert_Blocked = "BLOCKED ENEMY",
	Alert_Attacking = "NOT ATTACKING",
	Alert_PodDestroyed = "POD DESTROYED",
	Alert_PodSecured = "POD SECURED",
	Alert_Threat = "THREATENED",
	Alert_Healed = "UNIT REPAIRED",
	Alert_BlobSpawn = "SPLIT SUPPRESSED",
	Alert_Regen = "PSION REGENERATION",
	Alert_Tentacle = "PSION ATTACK",
	Alert_Action = "ACTION AVAILABLE",
	Alert_Level = "LEVEL UP!",
	Alert_Warning = "WARNING!",
	Alert_Incoming = "POD INCOMING",
	Alert_Passive = "PASSIVE BONUS",
	Alert_Resisted = "RESISTED",
	Alert_Power = "POWER LOST",
	Alert_Casualties = "Casualties",
	Alert_Unused = "POWER AVAILABLE",
	Alert_NoWeapon = "NO WEAPON POWERED",
	Alert_Open = "OPEN DOOR",
	Alert_Pilot = "PILOT AVAILABLE",
	Alert_Lost = "REGION LOST",
	Alert_Secured = "REGION SECURED",
	Alert_Cores = "CORES AVAILABLE",
	Alert_PilotCores = "PILOT & POWER AVAILABLE",
	Alert_Overflow = "DEFENSE UP!",
	Alert_FullOverflow = "GRID MAX!",
	Alert_Smoke = "SMOKE BLOCKING!",
	Alert_Water = "MECH SUBMERGED!",
	Alert_NoTarget = "NO TARGET AVAILABLE!",
	
	Status_Full = "Some effects not listed due to lack of space",
	
	SquadName_Filler = "Time Travelers",
	
	TipTitle_Archive_A = "Rift Walkers",
	TipText_Archive_A = "These were the very first Mechs to fight against the Vek. They are efficient and reliable.",
	
	TipTitle_Archive_B = "Steel Judoka",
	TipText_Archive_B = "These Mechs specialize in positional manipulation to turn the Vek against each other.",
	
	TipTitle_Rust_A = "Rusting Hulks",
	TipText_Rust_A = "R.S.T. weather manipulators allow these Mechs to take advantage of smoke storms everywhere.",
	
	TipTitle_Rust_B = "Flame Behemoths",
	TipText_Rust_B = "Invincible to flames, these Mechs aim to burn any threat to ashes.",
	
	TipTitle_Pinnacle_A = "Zenith Guard",
	TipText_Pinnacle_A = "Detritus' Beam technology and Pinnacle's Shield technology create a powerful combination.",
	
	TipTitle_Pinnacle_B = "Frozen Titans",
	TipText_Pinnacle_B = "These Titans rely on the Cryo Launcher, a powerful weapon that takes an experienced Pilot to master.",
	
	TipTitle_Detritus_A = "Blitzkrieg",
	TipText_Detritus_A = "R.S.T. engineers designed this Squad around the mass destruction capabilities of harnessed lightning.",
	
	TipTitle_Detritus_B = "Hazardous Mechs",
	TipText_Detritus_B = "These Mechs have spectacular damage output but rely on nanobots feeding off dead Vek to stay alive.",
	
	TipTitle_Random = "Randomized Squad",
	TipText_Random = "Create a Random Squad out of all of the Mechs you've unlocked.",
	
	TipTitle_Custom = "Customized Squad",
	TipText_Custom = "Create a Custom Squad using any of the Mechs you've unlocked.",
	
	TipTitle_Secret = "Secret Squad",
	TipText_Secret = "Humanity's last hope are a blend of Machine and Vek created to defend Earth.",
	
	---Achievements
	Achievement_Completed = "Completed on $1 Difficulty",
	Achievement_Header = "Achievement!",
	Achievement_Header_Pilot = "Pilot Found!",
	Achievement_Text_Pilot = "Unlocked in Hangar",
	
	-----hotkeys
	Mute_Title = "Mute Volume",
	Mute_Description = "Disable all sound",
	
	Undo_Title = "Undo Move",
	Undo_Description = "Undo the last movement you did with a Mech",
	
	Reset_Title = "Reset Turn",
	Reset_Description = "If available, reset to the start of the Player Turn",
	
	SelectMech1_Title = "Select Mech 1",
	SelectMech1_Description = "Select your first Mech (based on list order)",
	
	SelectMech2_Title = "Select Mech 2",
	SelectMech2_Description = "Select your second Mech (based on list order)",
	
	SelectMech3_Title = "Select Mech 3",
	SelectMech3_Description = "Select your third Mech (based on list order)",
	
	SelectDeploy1_Title = "Select Deployed 1",
	SelectDeploy1_Description = "Select your first Mech's deployed unit",
	
	SelectDeploy2_Title = "Select Deployed 2",
	SelectDeploy2_Description = "Select your second Mech's deployed unit",
	
	SelectDeploy3_Title = "Select Deployed 3",
	SelectDeploy3_Description = "Select your third Mech's deployed unit",
	
	SelectMission1_Title = "Select Mission Unit 1",
	SelectMission1_Description = "Select the mission unit you currently control (if available)",
	
	SelectMission2_Title = "Select Mission Unit 2",
	SelectMission2_Description = "Select the second mission unit you currently control (if available)",
	
	Cycle_Title = "Cycle Units",
	Cycle_Description = "Cycle to the next available active, controlled unit",
	
	Deselect_Title = "Deselect / Disarm Weapon",
	Deselect_Title = "Deselect / Disarm Weapon",
	Deselect_Description = "Clear currently selected unit",
	
	Info_Title = "Info Overlay",
	Info_Description = "Hold down to inspect any unit under your mouse",
	
	Overlay_Title = "Attack Order Overlay",
	Overlay_Description = "Hold down to view the current attack order for enemy units",
	
	Weapon1_Title = "Weapon 1",
	Weapon1_Description = "Arm or disarm the first weapon equipped on a unit",
	
	Weapon2_Title = "Weapon 2",
	Weapon2_Description = "Arm or disarm the second weapon equipped on a unit",
	
	Repair_Title = "Repair",
	Repair_Description = "Activate your Mech Repair Skill (if available)",
	
	EndTurn_Title = "End Turn",
	EndTurn_Description = "End your turn, or confirm the end of deployment",
	
	Fullscreen_Title = "Toggle Fullscreen",
	Fullscreen_Description = "Toggle fullscreen mode",
	
	
	---------- CREDITS + VICTORY TEXT
	
	Credits_Studio = "A game from:",
	Credits_StudioName = "SUBSET GAMES",
	Credits_Created = "Created by:",
	Credits_CreatedName = "Justin Ma and Matthew Davis",
	Credits_Music = "Music:",
	Credits_MusicName = "Ben Prunty",
	Credits_Sound = "Sound:",
	Credits_SoundName = "Power Up Audio",
	
	Credits_SoundSub1 = "Sound Designers:",
	Credits_SoundSub1Name = "Joey Godard\nJeff Tangsoc\nKevin Regamey\nCole Verderber",
	
	Credits_SoundSub2 = "Sound Library:",
	Credits_SoundSub2Name = "",

	Credits_Writing = "Writing:",
	Credits_WritingName = "Chris Avellone",
	Credits_Editing = "Additional Editing:",
	Credits_EditingName = "Alison Waller",
	Credits_Community = "Community Management:",
	Credits_CommunityName = "Isla Schanuel",
	Credits_Portraits = "Portrait Concept Art:",
	Credits_PortraitsName = "Polina Hristova",
	Credits_Mechs = "Mech Concept Art:",
	Credits_MechsName = "Gareth Davies",
	Credits_QA = "QA Testing:",
	Credits_QAName = "The Research Centaur UX+QA",
	
	Credits_QASub1 = "Test Manager:",
	Credits_QASub1Name = "Jay Fernandes",
	Credits_QASub2 = "QA Specialists:",
	Credits_QASub2Name = "Matthew Barnes\nLucia Aldana",
	
	Credits_Testers = "Thank you to our amazing community testers:",
	Credits_TestersName = "5thHorseman\nAlfie275\nchewbacca77\nDarthcaboose\nDiscord\nFynn\nJoni\nKieve\nLem\nNick Patrick\nRick Edmonds\nSleeper Service\n",
	Credits_Thanks = "Special thank you for their advice and support:",
	Credits_ThanksName = "Maria\nAlison\nMichael Nielsen\nEstelle Tigani\nAllison Thrower\nBryan\nIlona Koleda\nEsther Oh",
	Credits_ThanksExtra = "and the rest of our family, friends,\nand fellow indie developers",
	Credits_Babies = "Production Babies:",
	Credits_BabiesName = "Fox and Willow",
	Credits_FinalThanks = "Thank you for playing!",
	
}

function GetText(id)
	if Global_Texts[id] ~= nil then
		return Global_Texts[id]
	end
	
	if Weapon_Texts[id] ~= nil then
		return Weapon_Texts[id]
	end
	
	if Achievement_Texts[id] ~= nil then
		return Achievement_Texts[id]
	end
	
	return "no string found"
end