/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.BadPaddingException;
import sun.security.rsa.RSACore;
import sun.security.rsa.RSAKeyFactory;
import sun.security.rsa.RSAPadding;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;

public abstract class RSASignature
extends SignatureSpi {
    private static final int baseLength = 8;
    private final ObjectIdentifier digestOID;
    private final int encodedLength;
    private final MessageDigest md;
    private boolean digestReset;
    private RSAPrivateKey privateKey;
    private RSAPublicKey publicKey;
    private RSAPadding padding;

    RSASignature(String string, ObjectIdentifier objectIdentifier, int n) {
        this.digestOID = objectIdentifier;
        try {
            this.md = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException);
        }
        this.digestReset = true;
        this.encodedLength = 8 + n + this.md.getDigestLength();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        RSAPublicKey rSAPublicKey = (RSAPublicKey)RSAKeyFactory.toRSAKey(publicKey);
        this.privateKey = null;
        this.publicKey = rSAPublicKey;
        this.initCommon(rSAPublicKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        RSAPrivateKey rSAPrivateKey;
        this.privateKey = rSAPrivateKey = (RSAPrivateKey)RSAKeyFactory.toRSAKey(privateKey);
        this.publicKey = null;
        this.initCommon(rSAPrivateKey, secureRandom);
    }

    private void initCommon(RSAKey rSAKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.resetDigest();
        int n = RSACore.getByteLength(rSAKey);
        try {
            this.padding = RSAPadding.getInstance(1, n, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
        int n2 = this.padding.getMaxDataSize();
        if (this.encodedLength > n2) {
            throw new InvalidKeyException("Key is too short for this signature algorithm");
        }
    }

    private void resetDigest() {
        if (!this.digestReset) {
            this.md.reset();
            this.digestReset = true;
        }
    }

    private byte[] getDigestValue() {
        this.digestReset = true;
        return this.md.digest();
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        this.md.update(by);
        this.digestReset = false;
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.md.update(byArray, n, n2);
        this.digestReset = false;
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        this.md.update(byteBuffer);
        this.digestReset = false;
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.getDigestValue();
        try {
            byte[] byArray2 = RSASignature.encodeSignature(this.digestOID, byArray);
            byte[] byArray3 = this.padding.pad(byArray2);
            byte[] byArray4 = RSACore.rsa(byArray3, this.privateKey, true);
            return byArray4;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SignatureException("Could not sign data", generalSecurityException);
        }
        catch (IOException iOException) {
            throw new SignatureException("Could not encode data", iOException);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (byArray.length != RSACore.getByteLength(this.publicKey)) {
            throw new SignatureException("Signature length not correct: got " + byArray.length + " but was expecting " + RSACore.getByteLength(this.publicKey));
        }
        byte[] byArray2 = this.getDigestValue();
        try {
            byte[] byArray3 = RSACore.rsa(byArray, this.publicKey);
            byte[] byArray4 = this.padding.unpad(byArray3);
            byte[] byArray5 = RSASignature.decodeSignature(this.digestOID, byArray4);
            return MessageDigest.isEqual(byArray2, byArray5);
        }
        catch (BadPaddingException badPaddingException) {
            return false;
        }
        catch (IOException iOException) {
            throw new SignatureException("Signature encoding error", iOException);
        }
    }

    public static byte[] encodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        new AlgorithmId(objectIdentifier).encode(derOutputStream);
        derOutputStream.putOctetString(byArray);
        DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
        return derValue.toByteArray();
    }

    public static byte[] decodeSignature(ObjectIdentifier objectIdentifier, byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream.getSequence(2);
        if (derValueArray.length != 2 || derInputStream.available() != 0) {
            throw new IOException("SEQUENCE length error");
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValueArray[0]);
        if (!algorithmId.getOID().equals((Object)objectIdentifier)) {
            throw new IOException("ObjectIdentifier mismatch: " + algorithmId.getOID());
        }
        if (algorithmId.getEncodedParams() != null) {
            throw new IOException("Unexpected AlgorithmId parameters");
        }
        byte[] byArray2 = derValueArray[1].getOctetString();
        return byArray2;
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new UnsupportedOperationException("setParameter() not supported");
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new UnsupportedOperationException("getParameter() not supported");
    }

    public static final class MD2withRSA
    extends RSASignature {
        public MD2withRSA() {
            super("MD2", AlgorithmId.MD2_oid, 10);
        }
    }

    public static final class MD5withRSA
    extends RSASignature {
        public MD5withRSA() {
            super("MD5", AlgorithmId.MD5_oid, 10);
        }
    }

    public static final class SHA1withRSA
    extends RSASignature {
        public SHA1withRSA() {
            super("SHA-1", AlgorithmId.SHA_oid, 7);
        }
    }

    public static final class SHA224withRSA
    extends RSASignature {
        public SHA224withRSA() {
            super("SHA-224", AlgorithmId.SHA224_oid, 11);
        }
    }

    public static final class SHA256withRSA
    extends RSASignature {
        public SHA256withRSA() {
            super("SHA-256", AlgorithmId.SHA256_oid, 11);
        }
    }

    public static final class SHA384withRSA
    extends RSASignature {
        public SHA384withRSA() {
            super("SHA-384", AlgorithmId.SHA384_oid, 11);
        }
    }

    public static final class SHA512withRSA
    extends RSASignature {
        public SHA512withRSA() {
            super("SHA-512", AlgorithmId.SHA512_oid, 11);
        }
    }
}

