/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import sun.tools.asm.Assembler;
import sun.tools.java.Environment;
import sun.tools.java.Type;
import sun.tools.tree.Context;
import sun.tools.tree.Expression;
import sun.tools.tree.Statement;
import sun.tools.tree.Vset;

public class DeclarationStatement
extends Statement {
    int mod;
    Expression type;
    Statement[] args;

    public DeclarationStatement(long l, int n, Expression expression, Statement[] statementArray) {
        super(107, l);
        this.mod = n;
        this.type = expression;
        this.args = statementArray;
    }

    @Override
    Vset check(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        environment.error(this.where, "invalid.decl");
        return this.checkBlockStatement(environment, context, vset, hashtable);
    }

    @Override
    Vset checkBlockStatement(Environment environment, Context context, Vset vset, Hashtable hashtable) {
        if (this.labels != null) {
            environment.error(this.where, "declaration.with.label", this.labels[0]);
        }
        vset = this.reach(environment, vset);
        Type type = this.type.toType(environment, context);
        for (int i = 0; i < this.args.length; ++i) {
            vset = this.args[i].checkDeclaration(environment, context, vset, this.mod, type, hashtable);
        }
        return vset;
    }

    @Override
    public Statement inline(Environment environment, Context context) {
        int n = 0;
        for (int i = 0; i < this.args.length; ++i) {
            this.args[i] = this.args[i].inline(environment, context);
            if (this.args[i] == null) continue;
            ++n;
        }
        return n == 0 ? null : this;
    }

    @Override
    public Statement copyInline(Context context, boolean bl) {
        DeclarationStatement declarationStatement = (DeclarationStatement)this.clone();
        if (this.type != null) {
            declarationStatement.type = this.type.copyInline(context);
        }
        declarationStatement.args = new Statement[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            declarationStatement.args[i] = this.args[i].copyInline(context, bl);
        }
        return declarationStatement;
    }

    @Override
    public int costInline(int n, Environment environment, Context context) {
        int n2 = 1;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            n2 += this.args[i].costInline(n, environment, context);
        }
        return n2;
    }

    @Override
    public void code(Environment environment, Context context, Assembler assembler) {
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i] == null) continue;
            this.args[i].code(environment, context, assembler);
        }
    }

    @Override
    public void print(PrintStream printStream, int n) {
        printStream.print("declare ");
        super.print(printStream, n);
        this.type.print(printStream);
        printStream.print(" ");
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                printStream.print(", ");
            }
            if (this.args[i] != null) {
                this.args[i].print(printStream);
                continue;
            }
            printStream.print("<empty>");
        }
        printStream.print(";");
    }
}

