/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import sun.jvmstat.monitor.MonitorException;
import sun.jvmstat.monitor.MonitoredVm;
import sun.tools.jstat.ExpressionResolver;
import sun.tools.jstat.HeaderClosure;
import sun.tools.jstat.OptionFormat;
import sun.tools.jstat.OutputFormatter;
import sun.tools.jstat.RowClosure;
import sun.tools.jstat.SymbolResolutionClosure;

public class OptionOutputFormatter
implements OutputFormatter {
    private OptionFormat format;
    private String header;
    private MonitoredVm vm;

    public OptionOutputFormatter(MonitoredVm monitoredVm, OptionFormat optionFormat) throws MonitorException {
        this.vm = monitoredVm;
        this.format = optionFormat;
        this.resolve();
    }

    private void resolve() throws MonitorException {
        ExpressionResolver expressionResolver = new ExpressionResolver(this.vm);
        SymbolResolutionClosure symbolResolutionClosure = new SymbolResolutionClosure(expressionResolver);
        this.format.apply(symbolResolutionClosure);
    }

    @Override
    public String getHeader() throws MonitorException {
        if (this.header == null) {
            HeaderClosure headerClosure = new HeaderClosure();
            this.format.apply(headerClosure);
            this.header = headerClosure.getHeader();
        }
        return this.header;
    }

    @Override
    public String getRow() throws MonitorException {
        RowClosure rowClosure = new RowClosure(this.vm);
        this.format.apply(rowClosure);
        return rowClosure.getRow();
    }
}

