/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.jarsigner;

import com.sun.jarsigner.ContentSigner;
import com.sun.jarsigner.ContentSignerParameters;
import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import sun.security.pkcs.PKCS7;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AccessDescription;
import sun.security.x509.GeneralName;
import sun.security.x509.URIName;

public final class TimestampedSigner
extends ContentSigner {
    private static final String SUBJECT_INFO_ACCESS_OID = "1.3.6.1.5.5.7.1.11";
    private static final ObjectIdentifier AD_TIMESTAMPING_Id;

    @Override
    public byte[] generateSignedData(ContentSignerParameters contentSignerParameters, boolean bl, boolean bl2) throws NoSuchAlgorithmException, CertificateException, IOException {
        if (contentSignerParameters == null) {
            throw new NullPointerException();
        }
        String string = contentSignerParameters.getSignatureAlgorithm();
        X509Certificate[] x509CertificateArray = contentSignerParameters.getSignerCertificateChain();
        byte[] byArray = contentSignerParameters.getSignature();
        byte[] byArray2 = bl ? null : contentSignerParameters.getContent();
        URI uRI = null;
        if (bl2 && (uRI = contentSignerParameters.getTimestampingAuthority()) == null && (uRI = TimestampedSigner.getTimestampingURI(contentSignerParameters.getTimestampingAuthorityCertificate())) == null) {
            throw new CertificateException("Subject Information Access extension not found");
        }
        return PKCS7.generateSignedData((byte[])byArray, (X509Certificate[])x509CertificateArray, (byte[])byArray2, (String)contentSignerParameters.getSignatureAlgorithm(), (URI)uRI, (String)contentSignerParameters.getTSAPolicyID());
    }

    public static URI getTimestampingURI(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return null;
        }
        try {
            byte[] byArray = x509Certificate.getExtensionValue(SUBJECT_INFO_ACCESS_OID);
            if (byArray == null) {
                return null;
            }
            DerInputStream derInputStream = new DerInputStream(byArray);
            derInputStream = new DerInputStream(derInputStream.getOctetString());
            DerValue[] derValueArray = derInputStream.getSequence(5);
            for (int i = 0; i < derValueArray.length; ++i) {
                URIName uRIName;
                GeneralName generalName;
                AccessDescription accessDescription = new AccessDescription(derValueArray[i]);
                if (!accessDescription.getAccessMethod().equals(AD_TIMESTAMPING_Id) || (generalName = accessDescription.getAccessLocation()).getType() != 6 || !(uRIName = (URIName)generalName.getName()).getScheme().equalsIgnoreCase("http") && !uRIName.getScheme().equalsIgnoreCase("https")) continue;
                return uRIName.getURI();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static {
        ObjectIdentifier objectIdentifier = null;
        try {
            objectIdentifier = new ObjectIdentifier("1.3.6.1.5.5.7.48.3");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AD_TIMESTAMPING_Id = objectIdentifier;
    }
}

