/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.jarsigner;

import com.sun.jarsigner.ContentSigner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import sun.security.tools.jarsigner.JarSignerParameters;
import sun.security.tools.jarsigner.TimestampedSigner;
import sun.security.util.ManifestDigester;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertInfo;

class SignatureFile {
    Manifest sf;
    String baseName;

    public SignatureFile(MessageDigest[] messageDigestArray, Manifest manifest, ManifestDigester manifestDigester, String string, boolean bl) {
        ManifestDigester.Entry entry;
        this.baseName = string;
        String string2 = System.getProperty("java.version");
        String string3 = System.getProperty("java.vendor");
        this.sf = new Manifest();
        Attributes attributes = this.sf.getMainAttributes();
        attributes.putValue(Attributes.Name.SIGNATURE_VERSION.toString(), "1.0");
        attributes.putValue("Created-By", string2 + " (" + string3 + ")");
        if (bl) {
            for (int i = 0; i < messageDigestArray.length; ++i) {
                attributes.putValue(messageDigestArray[i].getAlgorithm() + "-Digest-Manifest", Base64.getEncoder().encodeToString(manifestDigester.manifestDigest(messageDigestArray[i])));
            }
        }
        if ((entry = manifestDigester.get("Manifest-Main-Attributes", false)) != null) {
            for (int i = 0; i < messageDigestArray.length; ++i) {
                attributes.putValue(messageDigestArray[i].getAlgorithm() + "-Digest-" + "Manifest-Main-Attributes", Base64.getEncoder().encodeToString(entry.digest(messageDigestArray[i])));
            }
        } else {
            throw new IllegalStateException("ManifestDigester failed to create Manifest-Main-Attribute entry");
        }
        Map<String, Attributes> map = this.sf.getEntries();
        for (Map.Entry<String, Attributes> entry2 : manifest.getEntries().entrySet()) {
            String string4 = entry2.getKey();
            entry = manifestDigester.get(string4, false);
            if (entry == null) continue;
            Attributes attributes2 = new Attributes();
            for (int i = 0; i < messageDigestArray.length; ++i) {
                attributes2.putValue(messageDigestArray[i].getAlgorithm() + "-Digest", Base64.getEncoder().encodeToString(entry.digest(messageDigestArray[i])));
            }
            map.put(string4, attributes2);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        this.sf.write(outputStream);
    }

    public String getMetaName() {
        return "META-INF/" + this.baseName + ".SF";
    }

    public String getBaseName() {
        return this.baseName;
    }

    public Block generateBlock(PrivateKey privateKey, String string, X509Certificate[] x509CertificateArray, boolean bl, String string2, X509Certificate x509Certificate, String string3, ContentSigner contentSigner, String[] stringArray, ZipFile zipFile) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException {
        return new Block(this, privateKey, string, x509CertificateArray, bl, string2, x509Certificate, string3, contentSigner, stringArray, zipFile);
    }

    public static class Block {
        private byte[] block;
        private String blockFileName;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Block(SignatureFile signatureFile, PrivateKey privateKey, String string, X509Certificate[] x509CertificateArray, boolean bl, String string2, X509Certificate x509Certificate, String string3, ContentSigner contentSigner, String[] stringArray, ZipFile zipFile) throws NoSuchAlgorithmException, InvalidKeyException, IOException, SignatureException, CertificateException {
            String string4;
            Object object;
            Principal principal = x509CertificateArray[0].getIssuerDN();
            if (!(principal instanceof X500Name)) {
                object = new X509CertInfo(x509CertificateArray[0].getTBSCertificate());
                principal = (Principal)object.get("issuer.dname");
            }
            object = x509CertificateArray[0].getSerialNumber();
            String string5 = privateKey.getAlgorithm();
            if (string == null) {
                if (string5.equalsIgnoreCase("DSA")) {
                    string4 = "SHA1withDSA";
                } else if (string5.equalsIgnoreCase("RSA")) {
                    string4 = "SHA256withRSA";
                } else {
                    if (!string5.equalsIgnoreCase("EC")) throw new RuntimeException("private key is not a DSA or RSA key");
                    string4 = "SHA256withECDSA";
                }
            } else {
                string4 = string;
            }
            String string6 = string4.toUpperCase(Locale.ENGLISH);
            if (string6.endsWith("WITHRSA") && !string5.equalsIgnoreCase("RSA") || string6.endsWith("WITHECDSA") && !string5.equalsIgnoreCase("EC") || string6.endsWith("WITHDSA") && !string5.equalsIgnoreCase("DSA")) {
                throw new SignatureException("private key algorithm is not compatible with signature algorithm");
            }
            this.blockFileName = "META-INF/" + signatureFile.getBaseName() + "." + string5;
            AlgorithmId algorithmId = AlgorithmId.get(string4);
            AlgorithmId algorithmId2 = AlgorithmId.get(string5);
            Signature signature = Signature.getInstance(string4);
            signature.initSign(privateKey);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            signatureFile.write(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            if (contentSigner == null) {
                contentSigner = new TimestampedSigner();
            }
            URI uRI = null;
            try {
                if (string2 != null) {
                    uRI = new URI(string2);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IOException(uRISyntaxException);
            }
            JarSignerParameters jarSignerParameters = new JarSignerParameters(stringArray, uRI, x509Certificate, string3, byArray2, string4, x509CertificateArray, byArray, zipFile);
            this.block = contentSigner.generateSignedData(jarSignerParameters, bl, string2 != null || x509Certificate != null);
        }

        public String getMetaName() {
            return this.blockFileName;
        }

        public void write(OutputStream outputStream) throws IOException {
            outputStream.write(this.block);
        }
    }
}

