/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.doclint.DocLint;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.jvm.Profile;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.OptionHelper;
import com.sun.tools.javac.processing.JavacProcessingEnvironment;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;

public enum Option {
    G("-g", "opt.g", OptionKind.STANDARD, OptionGroup.BASIC),
    G_NONE("-g:none", "opt.g.none", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            optionHelper.put("-g:", "none");
            return false;
        }
    }
    ,
    G_CUSTOM("-g:", "opt.g.lines.vars.source", OptionKind.STANDARD, OptionGroup.BASIC, ChoiceKind.ANYOF, "lines", "vars", "source"),
    XLINT("-Xlint", "opt.Xlint", OptionKind.EXTENDED, OptionGroup.BASIC),
    XLINT_CUSTOM("-Xlint:", "opt.Xlint.suboptlist", OptionKind.EXTENDED, OptionGroup.BASIC, ChoiceKind.ANYOF, Option.getXLintChoices()),
    XDOCLINT("-Xdoclint", "opt.Xdoclint", OptionKind.EXTENDED, OptionGroup.BASIC),
    XDOCLINT_CUSTOM("-Xdoclint:", "opt.Xdoclint.subopts", "opt.Xdoclint.custom", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public boolean matches(String string) {
            return DocLint.isValidOption(string.replace(2.XDOCLINT_CUSTOM.text, "-Xmsgs:"));
        }

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            String string2 = optionHelper.get(XDOCLINT_CUSTOM);
            String string3 = string2 == null ? string : string2 + " " + string;
            optionHelper.put(2.XDOCLINT_CUSTOM.text, string3);
            return false;
        }
    }
    ,
    NOWARN("-nowarn", "opt.nowarn", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            optionHelper.put("-Xlint:none", string);
            return false;
        }
    }
    ,
    VERBOSE("-verbose", "opt.verbose", OptionKind.STANDARD, OptionGroup.BASIC),
    DEPRECATION("-deprecation", "opt.deprecation", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            optionHelper.put("-Xlint:deprecation", string);
            return false;
        }
    }
    ,
    CLASSPATH("-classpath", "opt.arg.path", "opt.classpath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    CP("-cp", "opt.arg.path", "opt.classpath", OptionKind.STANDARD, OptionGroup.FILEMANAGER){

        @Override
        public boolean process(OptionHelper optionHelper, String string, String string2) {
            return super.process(optionHelper, "-classpath", string2);
        }
    }
    ,
    SOURCEPATH("-sourcepath", "opt.arg.path", "opt.sourcepath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    BOOTCLASSPATH("-bootclasspath", "opt.arg.path", "opt.bootclasspath", OptionKind.STANDARD, OptionGroup.FILEMANAGER){

        @Override
        public boolean process(OptionHelper optionHelper, String string, String string2) {
            optionHelper.remove("-Xbootclasspath/p:");
            optionHelper.remove("-Xbootclasspath/a:");
            return super.process(optionHelper, string, string2);
        }
    }
    ,
    XBOOTCLASSPATH_PREPEND("-Xbootclasspath/p:", "opt.arg.path", "opt.Xbootclasspath.p", OptionKind.EXTENDED, OptionGroup.FILEMANAGER),
    XBOOTCLASSPATH_APPEND("-Xbootclasspath/a:", "opt.arg.path", "opt.Xbootclasspath.a", OptionKind.EXTENDED, OptionGroup.FILEMANAGER),
    XBOOTCLASSPATH("-Xbootclasspath:", "opt.arg.path", "opt.bootclasspath", OptionKind.EXTENDED, OptionGroup.FILEMANAGER){

        @Override
        public boolean process(OptionHelper optionHelper, String string, String string2) {
            optionHelper.remove("-Xbootclasspath/p:");
            optionHelper.remove("-Xbootclasspath/a:");
            return super.process(optionHelper, "-bootclasspath", string2);
        }
    }
    ,
    EXTDIRS("-extdirs", "opt.arg.dirs", "opt.extdirs", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    DJAVA_EXT_DIRS("-Djava.ext.dirs=", "opt.arg.dirs", "opt.extdirs", OptionKind.EXTENDED, OptionGroup.FILEMANAGER){

        @Override
        public boolean process(OptionHelper optionHelper, String string, String string2) {
            return super.process(optionHelper, "-extdirs", string2);
        }
    }
    ,
    ENDORSEDDIRS("-endorseddirs", "opt.arg.dirs", "opt.endorseddirs", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    DJAVA_ENDORSED_DIRS("-Djava.endorsed.dirs=", "opt.arg.dirs", "opt.endorseddirs", OptionKind.EXTENDED, OptionGroup.FILEMANAGER){

        @Override
        public boolean process(OptionHelper optionHelper, String string, String string2) {
            return super.process(optionHelper, "-endorseddirs", string2);
        }
    }
    ,
    PROC("-proc:", "opt.proc.none.only", OptionKind.STANDARD, OptionGroup.BASIC, ChoiceKind.ONEOF, "none", "only"),
    PROCESSOR("-processor", "opt.arg.class.list", "opt.processor", OptionKind.STANDARD, OptionGroup.BASIC),
    PROCESSORPATH("-processorpath", "opt.arg.path", "opt.processorpath", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    PARAMETERS("-parameters", "opt.parameters", OptionKind.STANDARD, OptionGroup.BASIC),
    D("-d", "opt.arg.directory", "opt.d", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    S("-s", "opt.arg.directory", "opt.sourceDest", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    H("-h", "opt.arg.directory", "opt.headerDest", OptionKind.STANDARD, OptionGroup.FILEMANAGER),
    IMPLICIT("-implicit:", "opt.implicit", OptionKind.STANDARD, OptionGroup.BASIC, ChoiceKind.ONEOF, "none", "class"),
    ENCODING("-encoding", "opt.arg.encoding", "opt.encoding", OptionKind.STANDARD, OptionGroup.FILEMANAGER){

        @Override
        public boolean process(OptionHelper optionHelper, String string, String string2) {
            return super.process(optionHelper, string, string2);
        }
    }
    ,
    SOURCE("-source", "opt.arg.release", "opt.source", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public boolean process(OptionHelper optionHelper, String string, String string2) {
            Source source = Source.lookup(string2);
            if (source == null) {
                optionHelper.error("err.invalid.source", string2);
                return true;
            }
            return super.process(optionHelper, string, string2);
        }
    }
    ,
    TARGET("-target", "opt.arg.release", "opt.target", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public boolean process(OptionHelper optionHelper, String string, String string2) {
            Target target = Target.lookup(string2);
            if (target == null) {
                optionHelper.error("err.invalid.target", string2);
                return true;
            }
            return super.process(optionHelper, string, string2);
        }
    }
    ,
    PROFILE("-profile", "opt.arg.profile", "opt.profile", OptionKind.STANDARD, OptionGroup.BASIC){

        @Override
        public boolean process(OptionHelper optionHelper, String string, String string2) {
            Profile profile = Profile.lookup(string2);
            if (profile == null) {
                optionHelper.error("err.invalid.profile", string2);
                return true;
            }
            return super.process(optionHelper, string, string2);
        }
    }
    ,
    VERSION("-version", "opt.version", OptionKind.STANDARD, OptionGroup.INFO){

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            Log log = optionHelper.getLog();
            String string2 = optionHelper.getOwnName();
            log.printLines(Log.PrefixKind.JAVAC, "version", string2, JavaCompiler.version());
            return super.process(optionHelper, string);
        }
    }
    ,
    FULLVERSION("-fullversion", null, OptionKind.HIDDEN, OptionGroup.INFO){

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            Log log = optionHelper.getLog();
            String string2 = optionHelper.getOwnName();
            log.printLines(Log.PrefixKind.JAVAC, "fullVersion", string2, JavaCompiler.fullVersion());
            return super.process(optionHelper, string);
        }
    }
    ,
    DIAGS("-XDdiags=", null, OptionKind.HIDDEN, OptionGroup.INFO){

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            String string2 = (string = string.substring(string.indexOf(61) + 1)).contains("%") ? "-XDdiagsFormat=" : "-XDdiags=";
            if (XD.matches(string2 = string2 + string)) {
                return XD.process(optionHelper, string2);
            }
            return false;
        }
    }
    ,
    HELP("-help", "opt.help", OptionKind.STANDARD, OptionGroup.INFO){

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            Log log = optionHelper.getLog();
            String string2 = optionHelper.getOwnName();
            log.printLines(Log.PrefixKind.JAVAC, "msg.usage.header", string2);
            for (Option option : 17.getJavaCompilerOptions()) {
                option.help(log, OptionKind.STANDARD);
            }
            log.printNewline();
            return super.process(optionHelper, string);
        }
    }
    ,
    A("-A", "opt.arg.key.equals.value", "opt.A", OptionKind.STANDARD, OptionGroup.BASIC, true){

        @Override
        public boolean matches(String string) {
            return string.startsWith("-A");
        }

        @Override
        public boolean hasArg() {
            return false;
        }

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            int n = string.length();
            if (n == 2) {
                optionHelper.error("err.empty.A.argument", new Object[0]);
                return true;
            }
            int n2 = string.indexOf(61);
            String string2 = string.substring(2, n2 != -1 ? n2 : n);
            if (!JavacProcessingEnvironment.isValidOptionName(string2)) {
                optionHelper.error("err.invalid.A.key", string);
                return true;
            }
            return this.process(optionHelper, string, string);
        }
    }
    ,
    X("-X", "opt.X", OptionKind.STANDARD, OptionGroup.INFO){

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            Log log = optionHelper.getLog();
            for (Option option : 19.getJavaCompilerOptions()) {
                option.help(log, OptionKind.EXTENDED);
            }
            log.printNewline();
            log.printLines(Log.PrefixKind.JAVAC, "msg.usage.nonstandard.footer", new Object[0]);
            return super.process(optionHelper, string);
        }
    }
    ,
    J("-J", "opt.arg.flag", "opt.J", OptionKind.STANDARD, OptionGroup.INFO, true){

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            throw new AssertionError((Object)"the -J flag should be caught by the launcher.");
        }
    }
    ,
    MOREINFO("-moreinfo", null, OptionKind.HIDDEN, OptionGroup.BASIC){

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            Type.moreInfo = true;
            return super.process(optionHelper, string);
        }
    }
    ,
    WERROR("-Werror", "opt.Werror", OptionKind.STANDARD, OptionGroup.BASIC),
    PROMPT("-prompt", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    DOE("-doe", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    PRINTSOURCE("-printsource", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    WARNUNCHECKED("-warnunchecked", null, OptionKind.HIDDEN, OptionGroup.BASIC){

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            optionHelper.put("-Xlint:unchecked", string);
            return false;
        }
    }
    ,
    XMAXERRS("-Xmaxerrs", "opt.arg.number", "opt.maxerrs", OptionKind.EXTENDED, OptionGroup.BASIC),
    XMAXWARNS("-Xmaxwarns", "opt.arg.number", "opt.maxwarns", OptionKind.EXTENDED, OptionGroup.BASIC),
    XSTDOUT("-Xstdout", "opt.arg.file", "opt.Xstdout", OptionKind.EXTENDED, OptionGroup.INFO){

        @Override
        public boolean process(OptionHelper optionHelper, String string, String string2) {
            try {
                Log log = optionHelper.getLog();
                log.setWriters(new PrintWriter((Writer)new FileWriter(string2), true));
            }
            catch (IOException iOException) {
                optionHelper.error("err.error.writing.file", string2, iOException);
                return true;
            }
            return super.process(optionHelper, string, string2);
        }
    }
    ,
    XPRINT("-Xprint", "opt.print", OptionKind.EXTENDED, OptionGroup.BASIC),
    XPRINTROUNDS("-XprintRounds", "opt.printRounds", OptionKind.EXTENDED, OptionGroup.BASIC),
    XPRINTPROCESSORINFO("-XprintProcessorInfo", "opt.printProcessorInfo", OptionKind.EXTENDED, OptionGroup.BASIC),
    XPREFER("-Xprefer:", "opt.prefer", OptionKind.EXTENDED, OptionGroup.BASIC, ChoiceKind.ONEOF, "source", "newer"),
    XPKGINFO("-Xpkginfo:", "opt.pkginfo", OptionKind.EXTENDED, OptionGroup.BASIC, ChoiceKind.ONEOF, "always", "legacy", "nonempty"),
    O("-O", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    XJCOV("-Xjcov", null, OptionKind.HIDDEN, OptionGroup.BASIC),
    PLUGIN("-Xplugin:", "opt.arg.plugin", "opt.plugin", OptionKind.EXTENDED, OptionGroup.BASIC){

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            String string2 = string.substring(string.indexOf(58) + 1);
            String string3 = optionHelper.get(PLUGIN);
            optionHelper.put(24.PLUGIN.text, string3 == null ? string2 : string3 + '\u0000' + string2.trim());
            return false;
        }
    }
    ,
    XDIAGS("-Xdiags:", "opt.diags", OptionKind.EXTENDED, OptionGroup.BASIC, ChoiceKind.ONEOF, "compact", "verbose"),
    XD("-XD", null, OptionKind.HIDDEN, OptionGroup.BASIC){

        @Override
        public boolean matches(String string) {
            return string.startsWith(this.text);
        }

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            int n = (string = string.substring(this.text.length())).indexOf(61);
            String string2 = n < 0 ? string : string.substring(0, n);
            String string3 = n < 0 ? string : string.substring(n + 1);
            optionHelper.put(string2, string3);
            return false;
        }
    }
    ,
    AT("@", "opt.arg.file", "opt.AT", OptionKind.STANDARD, OptionGroup.INFO, true){

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            throw new AssertionError((Object)"the @ flag should be caught by CommandLine.");
        }
    }
    ,
    SOURCEFILE("sourcefile", null, OptionKind.HIDDEN, OptionGroup.INFO){

        @Override
        public boolean matches(String string) {
            return string.endsWith(".java") || SourceVersion.isName(string);
        }

        @Override
        public boolean process(OptionHelper optionHelper, String string) {
            if (string.endsWith(".java")) {
                File file = new File(string);
                if (!file.exists()) {
                    optionHelper.error("err.file.not.found", file);
                    return true;
                }
                if (!file.isFile()) {
                    optionHelper.error("err.file.not.file", file);
                    return true;
                }
                optionHelper.addFile(file);
            } else {
                optionHelper.addClassName(string);
            }
            return false;
        }
    };

    public final String text;
    final OptionKind kind;
    final OptionGroup group;
    final String argsNameKey;
    final String descrKey;
    final boolean hasSuffix;
    final ChoiceKind choiceKind;
    final Map<String, Boolean> choices;

    private Option(String string2, String string3, OptionKind optionKind, OptionGroup optionGroup) {
        this(string2, null, string3, optionKind, optionGroup, null, null, false);
    }

    private Option(String string2, String string3, String string4, OptionKind optionKind, OptionGroup optionGroup) {
        this(string2, string3, string4, optionKind, optionGroup, null, null, false);
    }

    private Option(String string2, String string3, String string4, OptionKind optionKind, OptionGroup optionGroup, boolean bl) {
        this(string2, string3, string4, optionKind, optionGroup, null, null, bl);
    }

    private Option(String string2, String string3, OptionKind optionKind, OptionGroup optionGroup, ChoiceKind choiceKind, Map<String, Boolean> map) {
        this(string2, null, string3, optionKind, optionGroup, choiceKind, map, false);
    }

    private Option(String string2, String string3, OptionKind optionKind, OptionGroup optionGroup, ChoiceKind choiceKind, String ... stringArray) {
        this(string2, null, string3, optionKind, optionGroup, choiceKind, Option.createChoices(stringArray), false);
    }

    private static Map<String, Boolean> createChoices(String ... stringArray) {
        LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
        for (String string : stringArray) {
            linkedHashMap.put(string, false);
        }
        return linkedHashMap;
    }

    private Option(String string2, String string3, String string4, OptionKind optionKind, OptionGroup optionGroup, ChoiceKind choiceKind, Map<String, Boolean> map, boolean bl) {
        this.text = string2;
        this.argsNameKey = string3;
        this.descrKey = string4;
        this.kind = optionKind;
        this.group = optionGroup;
        this.choiceKind = choiceKind;
        this.choices = map;
        char c = string2.charAt(string2.length() - 1);
        this.hasSuffix = bl || c == ':' || c == '=';
    }

    public String getText() {
        return this.text;
    }

    public OptionKind getKind() {
        return this.kind;
    }

    public boolean hasArg() {
        return this.argsNameKey != null && !this.hasSuffix;
    }

    public boolean matches(String string) {
        if (!this.hasSuffix) {
            return string.equals(this.text);
        }
        if (!string.startsWith(this.text)) {
            return false;
        }
        if (this.choices != null) {
            String string2 = string.substring(this.text.length());
            if (this.choiceKind == ChoiceKind.ONEOF) {
                return this.choices.keySet().contains(string2);
            }
            for (String string3 : string2.split(",+")) {
                if (this.choices.keySet().contains(string3)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean process(OptionHelper optionHelper, String string, String string2) {
        if (this.choices != null) {
            if (this.choiceKind == ChoiceKind.ONEOF) {
                String string32;
                for (String string32 : this.choices.keySet()) {
                    optionHelper.remove(string + string32);
                }
                String string4 = string + string2;
                optionHelper.put(string4, string4);
                string32 = string.substring(0, string.length() - 1);
                optionHelper.put(string32, string2);
            } else {
                for (String string5 : string2.split(",+")) {
                    String string6 = string + string5;
                    optionHelper.put(string6, string6);
                }
            }
        }
        optionHelper.put(string, string2);
        return false;
    }

    public boolean process(OptionHelper optionHelper, String string) {
        if (this.hasSuffix) {
            return this.process(optionHelper, this.text, string.substring(this.text.length()));
        }
        return this.process(optionHelper, string, string);
    }

    void help(Log log, OptionKind optionKind) {
        if (this.kind != optionKind) {
            return;
        }
        log.printRawLines(Log.WriterKind.NOTICE, String.format("  %-26s %s", this.helpSynopsis(log), log.localize(Log.PrefixKind.JAVAC, this.descrKey, new Object[0])));
    }

    private String helpSynopsis(Log log) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.text);
        if (this.argsNameKey == null) {
            if (this.choices != null) {
                String string = "{";
                for (Map.Entry<String, Boolean> entry : this.choices.entrySet()) {
                    if (entry.getValue().booleanValue()) continue;
                    stringBuilder.append(string);
                    stringBuilder.append(entry.getKey());
                    string = ",";
                }
                stringBuilder.append("}");
            }
        } else {
            if (!this.hasSuffix) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(log.localize(Log.PrefixKind.JAVAC, this.argsNameKey, new Object[0]));
        }
        return stringBuilder.toString();
    }

    private static Map<String, Boolean> getXLintChoices() {
        LinkedHashMap<String, Boolean> linkedHashMap = new LinkedHashMap<String, Boolean>();
        linkedHashMap.put("all", false);
        for (Lint.LintCategory lintCategory : Lint.LintCategory.values()) {
            linkedHashMap.put(lintCategory.option, lintCategory.hidden);
        }
        for (Lint.LintCategory lintCategory : Lint.LintCategory.values()) {
            linkedHashMap.put("-" + lintCategory.option, lintCategory.hidden);
        }
        linkedHashMap.put("none", false);
        return linkedHashMap;
    }

    static Set<Option> getJavaCompilerOptions() {
        return EnumSet.allOf(Option.class);
    }

    public static Set<Option> getJavacFileManagerOptions() {
        return Option.getOptions(EnumSet.of(OptionGroup.FILEMANAGER));
    }

    public static Set<Option> getJavacToolOptions() {
        return Option.getOptions(EnumSet.of(OptionGroup.BASIC));
    }

    static Set<Option> getOptions(Set<OptionGroup> set) {
        EnumSet<Option> enumSet = EnumSet.noneOf(Option.class);
        for (Option option : Option.values()) {
            if (!set.contains((Object)option.group)) continue;
            enumSet.add(option);
        }
        return Collections.unmodifiableSet(enumSet);
    }

    public static enum PkgInfo {
        ALWAYS,
        LEGACY,
        NONEMPTY;


        public static PkgInfo get(Options options) {
            String string = options.get(XPKGINFO);
            return string == null ? LEGACY : PkgInfo.valueOf(StringUtils.toUpperCase(string));
        }
    }

    static enum ChoiceKind {
        ONEOF,
        ANYOF;

    }

    static enum OptionGroup {
        BASIC,
        FILEMANAGER,
        INFO,
        OPERAND;

    }

    public static enum OptionKind {
        STANDARD,
        EXTENDED,
        HIDDEN;

    }
}

