/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class LVTRanges {
    protected static final Context.Key<LVTRanges> lvtRangesKey = new Context.Key();
    private static final long serialVersionUID = 1812267524140424433L;
    protected Context context;
    protected Map<Symbol.MethodSymbol, Map<JCTree, List<Symbol.VarSymbol>>> aliveRangeClosingTrees = new WeakHashMap<Symbol.MethodSymbol, Map<JCTree, List<Symbol.VarSymbol>>>();

    public static LVTRanges instance(Context context) {
        LVTRanges lVTRanges = context.get(lvtRangesKey);
        if (lVTRanges == null) {
            lVTRanges = new LVTRanges(context);
        }
        return lVTRanges;
    }

    public LVTRanges(Context context) {
        this.context = context;
        context.put(lvtRangesKey, this);
    }

    public List<Symbol.VarSymbol> getVars(Symbol.MethodSymbol methodSymbol, JCTree jCTree) {
        Map<JCTree, List<Symbol.VarSymbol>> map = this.aliveRangeClosingTrees.get(methodSymbol);
        return map != null ? map.get(jCTree) : null;
    }

    public boolean containsKey(Symbol.MethodSymbol methodSymbol, JCTree jCTree) {
        Map<JCTree, List<Symbol.VarSymbol>> map = this.aliveRangeClosingTrees.get(methodSymbol);
        if (map == null) {
            return false;
        }
        return map.containsKey(jCTree);
    }

    public void setEntry(Symbol.MethodSymbol methodSymbol, JCTree jCTree, List<Symbol.VarSymbol> list) {
        Map<JCTree, List<Symbol.VarSymbol>> map = this.aliveRangeClosingTrees.get(methodSymbol);
        if (map != null) {
            map.put(jCTree, list);
        } else {
            map = new WeakHashMap<JCTree, List<Symbol.VarSymbol>>();
            map.put(jCTree, list);
            this.aliveRangeClosingTrees.put(methodSymbol, map);
        }
    }

    public List<Symbol.VarSymbol> removeEntry(Symbol.MethodSymbol methodSymbol, JCTree jCTree) {
        Map<JCTree, List<Symbol.VarSymbol>> map = this.aliveRangeClosingTrees.get(methodSymbol);
        if (map != null) {
            List<Symbol.VarSymbol> list = map.remove(jCTree);
            if (map.isEmpty()) {
                this.aliveRangeClosingTrees.remove(methodSymbol);
            }
            return list;
        }
        return null;
    }

    public String toString() {
        String string = "";
        for (Map.Entry<Symbol.MethodSymbol, Map<JCTree, List<Symbol.VarSymbol>>> entry : this.aliveRangeClosingTrees.entrySet()) {
            string = string + "Method: \n" + entry.getKey().flatName() + "\n";
            int n = 1;
            for (Map.Entry<JCTree, List<Symbol.VarSymbol>> entry2 : entry.getValue().entrySet()) {
                string = string + "    Tree " + n + ": \n" + entry2.getKey().toString() + "\n";
                string = string + "        Variables closed:\n";
                for (Symbol.VarSymbol varSymbol : entry2.getValue()) {
                    string = string + "            " + varSymbol.toString();
                }
                string = string + "\n";
                ++n;
            }
        }
        return string;
    }
}

