/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.ConstFold;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import java.util.Map;

public class Annotate {
    protected static final Context.Key<Annotate> annotateKey = new Context.Key();
    final Attr attr;
    final TreeMaker make;
    final Log log;
    final Symtab syms;
    final Names names;
    final Resolve rs;
    final Types types;
    final ConstFold cfolder;
    final Check chk;
    private int enterCount = 0;
    ListBuffer<Worker> q = new ListBuffer();
    ListBuffer<Worker> typesQ = new ListBuffer();
    ListBuffer<Worker> repeatedQ = new ListBuffer();
    ListBuffer<Worker> afterRepeatedQ = new ListBuffer();
    ListBuffer<Worker> validateQ = new ListBuffer();

    public static Annotate instance(Context context) {
        Annotate annotate = context.get(annotateKey);
        if (annotate == null) {
            annotate = new Annotate(context);
        }
        return annotate;
    }

    protected Annotate(Context context) {
        context.put(annotateKey, this);
        this.attr = Attr.instance(context);
        this.make = TreeMaker.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
        this.rs = Resolve.instance(context);
        this.types = Types.instance(context);
        this.cfolder = ConstFold.instance(context);
        this.chk = Check.instance(context);
    }

    public void earlier(Worker worker) {
        this.q.prepend(worker);
    }

    public void normal(Worker worker) {
        this.q.append(worker);
    }

    public void typeAnnotation(Worker worker) {
        this.typesQ.append(worker);
    }

    public void repeated(Worker worker) {
        this.repeatedQ.append(worker);
    }

    public void afterRepeated(Worker worker) {
        this.afterRepeatedQ.append(worker);
    }

    public void validate(Worker worker) {
        this.validateQ.append(worker);
    }

    public void enterStart() {
        ++this.enterCount;
    }

    public void enterDone() {
        --this.enterCount;
        this.flush();
    }

    public void enterDoneWithoutFlush() {
        --this.enterCount;
    }

    public void flush() {
        if (this.enterCount != 0) {
            return;
        }
        ++this.enterCount;
        try {
            while (this.q.nonEmpty()) {
                this.q.next().run();
            }
            while (this.typesQ.nonEmpty()) {
                this.typesQ.next().run();
            }
            while (this.repeatedQ.nonEmpty()) {
                this.repeatedQ.next().run();
            }
            while (this.afterRepeatedQ.nonEmpty()) {
                this.afterRepeatedQ.next().run();
            }
            while (this.validateQ.nonEmpty()) {
                this.validateQ.next().run();
            }
        }
        finally {
            --this.enterCount;
        }
    }

    Attribute.Compound enterAnnotation(JCTree.JCAnnotation jCAnnotation, Type type, Env<AttrContext> env) {
        return this.enterAnnotation(jCAnnotation, type, env, false);
    }

    Attribute.TypeCompound enterTypeAnnotation(JCTree.JCAnnotation jCAnnotation, Type type, Env<AttrContext> env) {
        return (Attribute.TypeCompound)this.enterAnnotation(jCAnnotation, type, env, true);
    }

    Attribute.Compound enterAnnotation(JCTree.JCAnnotation jCAnnotation, Type type, Env<AttrContext> env, boolean bl) {
        Type type2 = jCAnnotation.annotationType.type != null ? jCAnnotation.annotationType.type : this.attr.attribType(jCAnnotation.annotationType, env);
        jCAnnotation.type = this.chk.checkType(jCAnnotation.annotationType.pos(), type2, type);
        if (jCAnnotation.type.isErroneous()) {
            this.attr.postAttr(jCAnnotation);
            if (bl) {
                return new Attribute.TypeCompound(jCAnnotation.type, List.nil(), new TypeAnnotationPosition());
            }
            return new Attribute.Compound(jCAnnotation.type, List.nil());
        }
        if ((jCAnnotation.type.tsym.flags() & 0x2000L) == 0L) {
            this.log.error(jCAnnotation.annotationType.pos(), "not.annotation.type", jCAnnotation.type.toString());
            this.attr.postAttr(jCAnnotation);
            if (bl) {
                return new Attribute.TypeCompound(jCAnnotation.type, List.nil(), null);
            }
            return new Attribute.Compound(jCAnnotation.type, List.nil());
        }
        List<JCTree.JCExpression> list = jCAnnotation.args;
        if (list.length() == 1 && !((JCTree.JCExpression)list.head).hasTag(JCTree.Tag.ASSIGN)) {
            list.head = this.make.at(((JCTree.JCExpression)list.head).pos).Assign(this.make.Ident(this.names.value), (JCTree.JCExpression)list.head);
        }
        ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> listBuffer = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
        List list2 = list;
        while (list2.nonEmpty()) {
            JCTree.JCExpression jCExpression = (JCTree.JCExpression)list2.head;
            if (!jCExpression.hasTag(JCTree.Tag.ASSIGN)) {
                this.log.error(jCExpression.pos(), "annotation.value.must.be.name.value", new Object[0]);
            } else {
                JCTree.JCAssign jCAssign = (JCTree.JCAssign)jCExpression;
                if (!jCAssign.lhs.hasTag(JCTree.Tag.IDENT)) {
                    this.log.error(jCExpression.pos(), "annotation.value.must.be.name.value", new Object[0]);
                } else {
                    Symbol symbol;
                    JCTree.JCIdent jCIdent = (JCTree.JCIdent)jCAssign.lhs;
                    jCIdent.sym = symbol = this.rs.resolveQualifiedMethod(jCAssign.rhs.pos(), env, jCAnnotation.type, jCIdent.name, List.nil(), null);
                    jCIdent.type = symbol.type;
                    if (symbol.owner != jCAnnotation.type.tsym) {
                        this.log.error(jCIdent.pos(), "no.annotation.member", jCIdent.name, jCAnnotation.type);
                    }
                    Type type3 = symbol.type.getReturnType();
                    Attribute attribute = this.enterAttributeValue(type3, jCAssign.rhs, env);
                    if (!symbol.type.isErroneous()) {
                        listBuffer.append(new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)symbol, attribute));
                    }
                    jCExpression.type = type3;
                }
            }
            list2 = list2.tail;
        }
        if (bl) {
            if (jCAnnotation.attribute == null || !(jCAnnotation.attribute instanceof Attribute.TypeCompound)) {
                list2 = new Attribute.TypeCompound(jCAnnotation.type, listBuffer.toList(), new TypeAnnotationPosition());
                jCAnnotation.attribute = list2;
                return list2;
            }
            return jCAnnotation.attribute;
        }
        list2 = new Attribute.Compound(jCAnnotation.type, listBuffer.toList());
        jCAnnotation.attribute = list2;
        return list2;
    }

    Attribute enterAttributeValue(Type type, JCTree.JCExpression jCExpression, Env<AttrContext> env) {
        try {
            type.tsym.complete();
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.log.error(jCExpression.pos(), "cant.resolve", Kinds.kindName(completionFailure.sym), completionFailure.sym);
            type = this.syms.errType;
        }
        if (type.hasTag(TypeTag.ARRAY)) {
            if (!jCExpression.hasTag(JCTree.Tag.NEWARRAY)) {
                jCExpression = this.make.at(jCExpression.pos).NewArray(null, List.nil(), List.of(jCExpression));
            }
            JCTree.JCNewArray jCNewArray = (JCTree.JCNewArray)jCExpression;
            if (jCNewArray.elemtype != null) {
                this.log.error(jCNewArray.elemtype.pos(), "new.not.allowed.in.annotation", new Object[0]);
            }
            ListBuffer<Attribute> listBuffer = new ListBuffer<Attribute>();
            List<JCTree.JCExpression> list = jCNewArray.elems;
            while (list.nonEmpty()) {
                listBuffer.append(this.enterAttributeValue(this.types.elemtype(type), (JCTree.JCExpression)list.head, env));
                list = list.tail;
            }
            jCNewArray.type = type;
            return new Attribute.Array(type, listBuffer.toArray(new Attribute[listBuffer.length()]));
        }
        if (jCExpression.hasTag(JCTree.Tag.NEWARRAY)) {
            if (!type.isErroneous()) {
                this.log.error(jCExpression.pos(), "annotation.value.not.allowable.type", new Object[0]);
            }
            JCTree.JCNewArray jCNewArray = (JCTree.JCNewArray)jCExpression;
            if (jCNewArray.elemtype != null) {
                this.log.error(jCNewArray.elemtype.pos(), "new.not.allowed.in.annotation", new Object[0]);
            }
            List<JCTree.JCExpression> list = jCNewArray.elems;
            while (list.nonEmpty()) {
                this.enterAttributeValue(this.syms.errType, (JCTree.JCExpression)list.head, env);
                list = list.tail;
            }
            return new Attribute.Error(this.syms.errType);
        }
        if ((type.tsym.flags() & 0x2000L) != 0L) {
            if (jCExpression.hasTag(JCTree.Tag.ANNOTATION)) {
                return this.enterAnnotation((JCTree.JCAnnotation)jCExpression, type, env);
            }
            this.log.error(jCExpression.pos(), "annotation.value.must.be.annotation", new Object[0]);
            type = this.syms.errType;
        }
        if (jCExpression.hasTag(JCTree.Tag.ANNOTATION)) {
            if (!type.isErroneous()) {
                this.log.error(jCExpression.pos(), "annotation.not.valid.for.type", type);
            }
            this.enterAnnotation((JCTree.JCAnnotation)jCExpression, this.syms.errType, env);
            return new Attribute.Error(((JCTree.JCAnnotation)jCExpression).annotationType.type);
        }
        if (type.isPrimitive() || this.types.isSameType(type, this.syms.stringType)) {
            Type type2 = this.attr.attribExpr(jCExpression, env, type);
            if (type2.isErroneous()) {
                return new Attribute.Error(type2.getOriginalType());
            }
            if (type2.constValue() == null) {
                this.log.error(jCExpression.pos(), "attribute.value.must.be.constant", new Object[0]);
                return new Attribute.Error(type);
            }
            type2 = this.cfolder.coerce(type2, type);
            return new Attribute.Constant(type, type2.constValue());
        }
        if (type.tsym == this.syms.classType.tsym) {
            Type type3 = this.attr.attribExpr(jCExpression, env, type);
            if (type3.isErroneous()) {
                if (TreeInfo.name(jCExpression) == this.names._class && ((JCTree.JCFieldAccess)jCExpression).selected.type.isErroneous()) {
                    Name name = ((JCTree.JCFieldAccess)jCExpression).selected.type.tsym.flatName();
                    return new Attribute.UnresolvedClass(type, this.types.createErrorType(name, this.syms.unknownSymbol, this.syms.classType));
                }
                return new Attribute.Error(type3.getOriginalType());
            }
            if (TreeInfo.name(jCExpression) != this.names._class) {
                this.log.error(jCExpression.pos(), "annotation.value.must.be.class.literal", new Object[0]);
                return new Attribute.Error(this.syms.errType);
            }
            return new Attribute.Class(this.types, ((JCTree.JCFieldAccess)jCExpression).selected.type);
        }
        if (type.hasTag(TypeTag.CLASS) && (type.tsym.flags() & 0x4000L) != 0L) {
            Type type4 = this.attr.attribExpr(jCExpression, env, type);
            Symbol symbol = TreeInfo.symbol(jCExpression);
            if (symbol == null || TreeInfo.nonstaticSelect(jCExpression) || symbol.kind != 4 || (symbol.flags() & 0x4000L) == 0L) {
                this.log.error(jCExpression.pos(), "enum.annotation.must.be.enum.constant", new Object[0]);
                return new Attribute.Error(type4.getOriginalType());
            }
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
            return new Attribute.Enum(type, varSymbol);
        }
        if (!type.isErroneous()) {
            this.log.error(jCExpression.pos(), "annotation.value.not.allowable.type", new Object[0]);
        }
        return new Attribute.Error(this.attr.attribExpr(jCExpression, env, type));
    }

    private <T extends Attribute.Compound> T processRepeatedAnnotations(List<T> list, AnnotateRepeatedContext<T> annotateRepeatedContext, Symbol symbol) {
        Object object;
        Object object2;
        Attribute.Compound compound = (Attribute.Compound)list.head;
        List<Attribute> list2 = List.nil();
        Type type = null;
        Type.ArrayType arrayType = null;
        Type type2 = null;
        Symbol.MethodSymbol methodSymbol = null;
        Assert.check(!list.isEmpty() && !list.tail.isEmpty());
        int n = 0;
        List list3 = list;
        while (!list3.isEmpty()) {
            Assert.check(++n > 1 || !list3.tail.isEmpty());
            object2 = (Attribute.Compound)list3.head;
            type = ((Attribute.Compound)object2).type;
            if (arrayType == null) {
                arrayType = this.types.makeArrayType(type);
            }
            boolean bl = n > 1;
            object = this.getContainingType((Attribute.Compound)object2, annotateRepeatedContext.pos.get(object2), bl);
            if (object != null) {
                Assert.check(type2 == null || object == type2);
                type2 = object;
                methodSymbol = this.validateContainer(type2, type, annotateRepeatedContext.pos.get(object2));
                if (methodSymbol != null) {
                    list2 = list2.prepend((Attribute)object2);
                }
            }
            list3 = list3.tail;
        }
        if (!list2.isEmpty()) {
            list2 = list2.reverse();
            list3 = this.make.at(annotateRepeatedContext.pos.get(compound));
            object2 = new Pair<Object, Attribute.Array>(methodSymbol, new Attribute.Array((Type)arrayType, list2));
            if (annotateRepeatedContext.isTypeCompound) {
                Attribute.TypeCompound typeCompound = new Attribute.TypeCompound(type2, List.of(object2), ((Attribute.TypeCompound)list.head).position);
                typeCompound.setSynthesized(true);
                object = typeCompound;
                return (T)object;
            }
            Attribute.Compound compound2 = new Attribute.Compound(type2, List.of(object2));
            object = ((TreeMaker)((Object)list3)).Annotation(compound2);
            if (!this.chk.annotationApplicable((JCTree.JCAnnotation)object, symbol)) {
                this.log.error(((JCTree)object).pos(), "invalid.repeatable.annotation.incompatible.target", type2, type);
            }
            if (!this.chk.validateAnnotationDeferErrors((JCTree.JCAnnotation)object)) {
                this.log.error(((JCTree)object).pos(), "duplicate.annotation.invalid.repeated", type);
            }
            compound2 = this.enterAnnotation((JCTree.JCAnnotation)object, type2, annotateRepeatedContext.env);
            compound2.setSynthesized(true);
            Attribute.Compound compound3 = compound2;
            return (T)compound3;
        }
        return null;
    }

    private Type getContainingType(Attribute.Compound compound, JCDiagnostic.DiagnosticPosition diagnosticPosition, boolean bl) {
        Type type = compound.type;
        Symbol.TypeSymbol typeSymbol = type.tsym;
        Attribute.Compound compound2 = typeSymbol.attribute(this.syms.repeatableType.tsym);
        if (compound2 == null) {
            if (bl) {
                this.log.error(diagnosticPosition, "duplicate.annotation.missing.container", type, this.syms.repeatableType);
            }
            return null;
        }
        return this.filterSame(this.extractContainingType(compound2, diagnosticPosition, typeSymbol), type);
    }

    private Type filterSame(Type type, Type type2) {
        if (type == null || type2 == null) {
            return type;
        }
        return this.types.isSameType(type, type2) ? null : type;
    }

    private Type extractContainingType(Attribute.Compound compound, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.TypeSymbol typeSymbol) {
        if (compound.values.isEmpty()) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation", typeSymbol);
            return null;
        }
        Pair pair = (Pair)compound.values.head;
        Name name = ((Symbol.MethodSymbol)pair.fst).name;
        if (name != this.names.value) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation", typeSymbol);
            return null;
        }
        if (!(pair.snd instanceof Attribute.Class)) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation", typeSymbol);
            return null;
        }
        return ((Attribute.Class)pair.snd).getValue();
    }

    private Symbol.MethodSymbol validateContainer(Type type, Type type2, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        AnnoConstruct annoConstruct2;
        Symbol.MethodSymbol methodSymbol = null;
        boolean bl = false;
        Scope scope = type.tsym.members();
        int n = 0;
        boolean bl2 = false;
        for (AnnoConstruct annoConstruct2 : scope.getElementsByName(this.names.value)) {
            if (++n == 1 && annoConstruct2.kind == 16) {
                methodSymbol = (Symbol.MethodSymbol)annoConstruct2;
                continue;
            }
            bl2 = true;
        }
        if (bl2) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.multiple.values", type, n);
            return null;
        }
        if (n == 0) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.no.value", type);
            return null;
        }
        if (methodSymbol.kind != 16) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.invalid.value", type);
            bl = true;
        }
        Type type3 = methodSymbol.type.getReturnType();
        annoConstruct2 = this.types.makeArrayType(type2);
        if (!this.types.isArray(type3) || !this.types.isSameType((Type)annoConstruct2, type3)) {
            this.log.error(diagnosticPosition, "invalid.repeatable.annotation.value.return", type, type3, annoConstruct2);
            bl = true;
        }
        if (bl2) {
            bl = true;
        }
        return bl ? null : methodSymbol;
    }

    public class AnnotateRepeatedContext<T extends Attribute.Compound> {
        public final Env<AttrContext> env;
        public final Map<Symbol.TypeSymbol, ListBuffer<T>> annotated;
        public final Map<T, JCDiagnostic.DiagnosticPosition> pos;
        public final Log log;
        public final boolean isTypeCompound;

        public AnnotateRepeatedContext(Env<AttrContext> env, Map<Symbol.TypeSymbol, ListBuffer<T>> map, Map<T, JCDiagnostic.DiagnosticPosition> map2, Log log, boolean bl) {
            Assert.checkNonNull(env);
            Assert.checkNonNull(map);
            Assert.checkNonNull(map2);
            Assert.checkNonNull(log);
            this.env = env;
            this.annotated = map;
            this.pos = map2;
            this.log = log;
            this.isTypeCompound = bl;
        }

        public T processRepeatedAnnotations(List<T> list, Symbol symbol) {
            return (T)Annotate.this.processRepeatedAnnotations(list, this, symbol);
        }

        public void annotateRepeated(Worker worker) {
            Annotate.this.repeated(worker);
        }
    }

    public static interface Worker {
        public void run();

        public String toString();
    }
}

