/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.UnionType;

public abstract class Type
extends AnnoConstruct
implements TypeMirror {
    public static final JCNoType noType = new JCNoType(){

        @Override
        public String toString() {
            return "none";
        }
    };
    public static final JCNoType recoveryType = new JCNoType(){

        @Override
        public String toString() {
            return "recovery";
        }
    };
    public static final JCNoType stuckType = new JCNoType(){

        @Override
        public String toString() {
            return "stuck";
        }
    };
    public static boolean moreInfo = false;
    public Symbol.TypeSymbol tsym;

    public boolean hasTag(TypeTag typeTag) {
        return typeTag == this.getTag();
    }

    public abstract TypeTag getTag();

    public boolean isNumeric() {
        return false;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isPrimitiveOrVoid() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isNullOrReference() {
        return false;
    }

    public boolean isPartial() {
        return false;
    }

    public Object constValue() {
        return null;
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    public Type getModelType() {
        return this;
    }

    public static List<Type> getModelTypes(List<Type> list) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type : list) {
            listBuffer.append(type.getModelType());
        }
        return listBuffer.toList();
    }

    public Type getOriginalType() {
        return this;
    }

    public <R, S> R accept(Visitor<R, S> visitor, S s) {
        return visitor.visitType(this, s);
    }

    public Type(Symbol.TypeSymbol typeSymbol) {
        this.tsym = typeSymbol;
    }

    public Type map(Mapping mapping) {
        return this;
    }

    public static List<Type> map(List<Type> list, Mapping mapping) {
        if (list.nonEmpty()) {
            List<Type> list2 = Type.map(list.tail, mapping);
            Type type = mapping.apply((Type)list.head);
            if (list2 != list.tail || type != list.head) {
                return list2.prepend(type);
            }
        }
        return list;
    }

    public Type constType(Object object) {
        throw new AssertionError();
    }

    public Type baseType() {
        return this;
    }

    public Type annotatedType(List<Attribute.TypeCompound> list) {
        return new AnnotatedType(list, this);
    }

    public boolean isAnnotated() {
        return false;
    }

    public Type unannotatedType() {
        return this;
    }

    @Override
    public List<Attribute.TypeCompound> getAnnotationMirrors() {
        return List.nil();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return null;
    }

    @Override
    public <A extends Annotation> A[] getAnnotationsByType(Class<A> clazz) {
        Annotation[] annotationArray = (Annotation[])Array.newInstance(clazz, 0);
        return annotationArray;
    }

    public static List<Type> baseTypes(List<Type> list) {
        if (list.nonEmpty()) {
            Type type = ((Type)list.head).baseType();
            List<Type> list2 = Type.baseTypes(list.tail);
            if (type != list.head || list2 != list.tail) {
                return list2.prepend(type);
            }
        }
        return list;
    }

    @Override
    public String toString() {
        String string;
        String string2 = string = this.tsym == null || this.tsym.name == null ? "<none>" : this.tsym.name.toString();
        if (moreInfo && this.hasTag(TypeTag.TYPEVAR)) {
            string = string + this.hashCode();
        }
        return string;
    }

    public static String toString(List<Type> list) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(((Type)list.head).toString());
        List list2 = list.tail;
        while (list2.nonEmpty()) {
            stringBuilder.append(",").append(((Type)list2.head).toString());
            list2 = list2.tail;
        }
        return stringBuilder.toString();
    }

    public String stringValue() {
        Object object = Assert.checkNonNull(this.constValue());
        return object.toString();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String argtypes(boolean bl) {
        List<Type> list = this.getParameterTypes();
        if (!bl) {
            return list.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (list.tail.nonEmpty()) {
            stringBuilder.append(list.head);
            list = list.tail;
            stringBuilder.append(',');
        }
        if (((Type)list.head).unannotatedType().hasTag(TypeTag.ARRAY)) {
            stringBuilder.append(((ArrayType)((Type)list.head).unannotatedType()).elemtype);
            if (((List)((Type)list.head).getAnnotationMirrors()).nonEmpty()) {
                stringBuilder.append(((Type)list.head).getAnnotationMirrors());
            }
            stringBuilder.append("...");
        } else {
            stringBuilder.append(list.head);
        }
        return stringBuilder.toString();
    }

    public List<Type> getTypeArguments() {
        return List.nil();
    }

    public Type getEnclosingType() {
        return null;
    }

    public List<Type> getParameterTypes() {
        return List.nil();
    }

    public Type getReturnType() {
        return null;
    }

    public Type getReceiverType() {
        return null;
    }

    public List<Type> getThrownTypes() {
        return List.nil();
    }

    public Type getUpperBound() {
        return null;
    }

    public Type getLowerBound() {
        return null;
    }

    public List<Type> allparams() {
        return List.nil();
    }

    public boolean isErroneous() {
        return false;
    }

    public static boolean isErroneous(List<Type> list) {
        List<Type> list2 = list;
        while (list2.nonEmpty()) {
            if (((Type)list2.head).isErroneous()) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean isRaw() {
        return false;
    }

    public boolean isCompound() {
        return this.tsym.completer == null && (this.tsym.flags() & 0x1000000L) != 0L;
    }

    public boolean isInterface() {
        return (this.tsym.flags() & 0x200L) != 0L;
    }

    public boolean isFinal() {
        return (this.tsym.flags() & 0x10L) != 0L;
    }

    public boolean contains(Type type) {
        return type == this;
    }

    public static boolean contains(List<Type> list, Type type) {
        List<Type> list2 = list;
        while (list2.tail != null) {
            if (((Type)list2.head).contains(type)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    public boolean containsAny(List<Type> list) {
        for (Type type : list) {
            if (!this.contains(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(List<Type> list, List<Type> list2) {
        for (Type type : list) {
            if (!type.containsAny(list2)) continue;
            return true;
        }
        return false;
    }

    public static List<Type> filter(List<Type> list, Filter<Type> filter) {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type type : list) {
            if (!filter.accepts(type)) continue;
            listBuffer.append(type);
        }
        return listBuffer.toList();
    }

    public boolean isSuperBound() {
        return false;
    }

    public boolean isExtendsBound() {
        return false;
    }

    public boolean isUnbound() {
        return false;
    }

    public Type withTypeVar(Type type) {
        return this;
    }

    public MethodType asMethodType() {
        throw new AssertionError();
    }

    public void complete() {
    }

    public Symbol.TypeSymbol asElement() {
        return this.tsym;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.OTHER;
    }

    @Override
    public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
        throw new AssertionError();
    }

    public static interface Visitor<R, S> {
        public R visitClassType(ClassType var1, S var2);

        public R visitWildcardType(WildcardType var1, S var2);

        public R visitArrayType(ArrayType var1, S var2);

        public R visitMethodType(MethodType var1, S var2);

        public R visitPackageType(PackageType var1, S var2);

        public R visitTypeVar(TypeVar var1, S var2);

        public R visitCapturedType(CapturedType var1, S var2);

        public R visitForAll(ForAll var1, S var2);

        public R visitUndetVar(UndetVar var1, S var2);

        public R visitErrorType(ErrorType var1, S var2);

        public R visitAnnotatedType(AnnotatedType var1, S var2);

        public R visitType(Type var1, S var2);
    }

    public static class UnknownType
    extends Type {
        public UnknownType() {
            super(null);
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.UNKNOWN;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitUnknown(this, p);
        }

        @Override
        public boolean isPartial() {
            return true;
        }
    }

    public static class AnnotatedType
    extends Type
    implements javax.lang.model.type.ArrayType,
    DeclaredType,
    PrimitiveType,
    TypeVariable,
    javax.lang.model.type.WildcardType {
        private List<Attribute.TypeCompound> typeAnnotations;
        private Type underlyingType;

        protected AnnotatedType(List<Attribute.TypeCompound> list, Type type) {
            super(type.tsym);
            this.typeAnnotations = list;
            this.underlyingType = type;
            Assert.check(list != null && list.nonEmpty(), "Can't create AnnotatedType without annotations: " + type);
            Assert.check(!type.isAnnotated(), "Can't annotate already annotated type: " + type + "; adding: " + list);
        }

        @Override
        public TypeTag getTag() {
            return this.underlyingType.getTag();
        }

        @Override
        public boolean isAnnotated() {
            return true;
        }

        @Override
        public List<Attribute.TypeCompound> getAnnotationMirrors() {
            return this.typeAnnotations;
        }

        @Override
        public TypeKind getKind() {
            return this.underlyingType.getKind();
        }

        @Override
        public Type unannotatedType() {
            return this.underlyingType;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitAnnotatedType(this, s);
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return this.underlyingType.accept(typeVisitor, p);
        }

        @Override
        public Type map(Mapping mapping) {
            this.underlyingType.map(mapping);
            return this;
        }

        @Override
        public Type constType(Object object) {
            return this.underlyingType.constType(object);
        }

        @Override
        public Type getEnclosingType() {
            return this.underlyingType.getEnclosingType();
        }

        @Override
        public Type getReturnType() {
            return this.underlyingType.getReturnType();
        }

        @Override
        public List<Type> getTypeArguments() {
            return this.underlyingType.getTypeArguments();
        }

        @Override
        public List<Type> getParameterTypes() {
            return this.underlyingType.getParameterTypes();
        }

        @Override
        public Type getReceiverType() {
            return this.underlyingType.getReceiverType();
        }

        @Override
        public List<Type> getThrownTypes() {
            return this.underlyingType.getThrownTypes();
        }

        @Override
        public Type getUpperBound() {
            return this.underlyingType.getUpperBound();
        }

        @Override
        public Type getLowerBound() {
            return this.underlyingType.getLowerBound();
        }

        @Override
        public boolean isErroneous() {
            return this.underlyingType.isErroneous();
        }

        @Override
        public boolean isCompound() {
            return this.underlyingType.isCompound();
        }

        @Override
        public boolean isInterface() {
            return this.underlyingType.isInterface();
        }

        @Override
        public List<Type> allparams() {
            return this.underlyingType.allparams();
        }

        @Override
        public boolean isPrimitive() {
            return this.underlyingType.isPrimitive();
        }

        @Override
        public boolean isPrimitiveOrVoid() {
            return this.underlyingType.isPrimitiveOrVoid();
        }

        @Override
        public boolean isNumeric() {
            return this.underlyingType.isNumeric();
        }

        @Override
        public boolean isReference() {
            return this.underlyingType.isReference();
        }

        @Override
        public boolean isNullOrReference() {
            return this.underlyingType.isNullOrReference();
        }

        @Override
        public boolean isPartial() {
            return this.underlyingType.isPartial();
        }

        @Override
        public boolean isParameterized() {
            return this.underlyingType.isParameterized();
        }

        @Override
        public boolean isRaw() {
            return this.underlyingType.isRaw();
        }

        @Override
        public boolean isFinal() {
            return this.underlyingType.isFinal();
        }

        @Override
        public boolean isSuperBound() {
            return this.underlyingType.isSuperBound();
        }

        @Override
        public boolean isExtendsBound() {
            return this.underlyingType.isExtendsBound();
        }

        @Override
        public boolean isUnbound() {
            return this.underlyingType.isUnbound();
        }

        @Override
        public String toString() {
            if (this.typeAnnotations != null && !this.typeAnnotations.isEmpty()) {
                return "(" + this.typeAnnotations.toString() + " :: " + this.underlyingType.toString() + ")";
            }
            return "({} :: " + this.underlyingType.toString() + ")";
        }

        @Override
        public boolean contains(Type type) {
            return this.underlyingType.contains(type);
        }

        @Override
        public Type withTypeVar(Type type) {
            this.underlyingType = this.underlyingType.withTypeVar(type);
            return this;
        }

        @Override
        public Symbol.TypeSymbol asElement() {
            return this.underlyingType.asElement();
        }

        @Override
        public MethodType asMethodType() {
            return this.underlyingType.asMethodType();
        }

        @Override
        public void complete() {
            this.underlyingType.complete();
        }

        @Override
        public TypeMirror getComponentType() {
            return ((ArrayType)this.underlyingType).getComponentType();
        }

        public Type makeVarargs() {
            return ((ArrayType)this.underlyingType).makeVarargs().annotatedType(this.typeAnnotations);
        }

        @Override
        public TypeMirror getExtendsBound() {
            return ((WildcardType)this.underlyingType).getExtendsBound();
        }

        @Override
        public TypeMirror getSuperBound() {
            return ((WildcardType)this.underlyingType).getSuperBound();
        }
    }

    public static class ErrorType
    extends ClassType
    implements javax.lang.model.type.ErrorType {
        private Type originalType = null;

        public ErrorType(Type type, Symbol.TypeSymbol typeSymbol) {
            super(noType, List.nil(), null);
            this.tsym = typeSymbol;
            this.originalType = type == null ? noType : type;
        }

        public ErrorType(Symbol.ClassSymbol classSymbol, Type type) {
            this(type, classSymbol);
            classSymbol.type = this;
            classSymbol.kind = 63;
            classSymbol.members_field = new Scope.ErrorScope(classSymbol);
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.ERROR;
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        public ErrorType(Name name, Symbol.TypeSymbol typeSymbol, Type type) {
            this(new Symbol.ClassSymbol(0x40000009L, name, null, typeSymbol), type);
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitErrorType(this, s);
        }

        @Override
        public Type constType(Object object) {
            return this;
        }

        @Override
        public Type getEnclosingType() {
            return this;
        }

        @Override
        public Type getReturnType() {
            return this;
        }

        public Type asSub(Symbol symbol) {
            return this;
        }

        @Override
        public Type map(Mapping mapping) {
            return this;
        }

        public boolean isGenType(Type type) {
            return true;
        }

        @Override
        public boolean isErroneous() {
            return true;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public boolean isInterface() {
            return false;
        }

        @Override
        public List<Type> allparams() {
            return List.nil();
        }

        @Override
        public List<Type> getTypeArguments() {
            return List.nil();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ERROR;
        }

        @Override
        public Type getOriginalType() {
            return this.originalType;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitError(this, p);
        }
    }

    static class BottomType
    extends Type
    implements NullType {
        public BottomType() {
            super(null);
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.BOT;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.NULL;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNull(this, p);
        }

        @Override
        public Type constType(Object object) {
            return this;
        }

        @Override
        public String stringValue() {
            return "null";
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }
    }

    public static class JCVoidType
    extends Type
    implements NoType {
        public JCVoidType() {
            super(null);
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.VOID;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.VOID;
        }

        @Override
        public boolean isCompound() {
            return false;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNoType(this, p);
        }

        @Override
        public boolean isPrimitiveOrVoid() {
            return true;
        }
    }

    public static class JCNoType
    extends Type
    implements NoType {
        public JCNoType() {
            super(null);
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.NONE;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.NONE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNoType(this, p);
        }

        @Override
        public boolean isCompound() {
            return false;
        }
    }

    public static class CapturedUndetVar
    extends UndetVar {
        public CapturedUndetVar(CapturedType capturedType, Types types) {
            super(capturedType, types);
            if (!capturedType.lower.hasTag(TypeTag.BOT)) {
                this.bounds.put(UndetVar.InferenceBound.LOWER, List.of(capturedType.lower));
            }
        }

        @Override
        public void addBound(UndetVar.InferenceBound inferenceBound, Type type, Types types, boolean bl) {
            if (bl) {
                super.addBound(inferenceBound, type, types, bl);
            }
        }

        @Override
        public boolean isCaptured() {
            return true;
        }
    }

    public static class UndetVar
    extends DelegatedType {
        protected Map<InferenceBound, List<Type>> bounds;
        public Type inst = null;
        public int declaredCount;
        public UndetVarListener listener = null;
        Mapping toTypeVarMap = new Mapping("toTypeVarMap"){

            @Override
            public Type apply(Type type) {
                if (type.hasTag(TypeTag.UNDETVAR)) {
                    UndetVar undetVar = (UndetVar)type;
                    return undetVar.inst != null ? undetVar.inst : undetVar.qtype;
                }
                return type.map(this);
            }
        };

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitUndetVar(this, s);
        }

        public UndetVar(TypeVar typeVar, Types types) {
            super(TypeTag.UNDETVAR, typeVar);
            this.bounds = new EnumMap<InferenceBound, List<Type>>(InferenceBound.class);
            List<Type> list = types.getBounds(typeVar);
            this.declaredCount = list.length();
            this.bounds.put(InferenceBound.UPPER, list);
            this.bounds.put(InferenceBound.LOWER, List.nil());
            this.bounds.put(InferenceBound.EQ, List.nil());
        }

        @Override
        public String toString() {
            return this.inst == null ? this.qtype + "?" : this.inst.toString();
        }

        public String debugString() {
            String string = "inference var = " + this.qtype + "\n";
            if (this.inst != null) {
                string = string + "inst = " + this.inst + '\n';
            }
            for (InferenceBound inferenceBound : InferenceBound.values()) {
                List<Type> list = this.bounds.get((Object)inferenceBound);
                if (list.size() <= 0) continue;
                string = string + (Object)((Object)inferenceBound) + " = " + list + '\n';
            }
            return string;
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        @Override
        public Type baseType() {
            return this.inst == null ? this : this.inst.baseType();
        }

        public List<Type> getBounds(InferenceBound ... inferenceBoundArray) {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (InferenceBound inferenceBound : inferenceBoundArray) {
                listBuffer.appendList(this.bounds.get((Object)inferenceBound));
            }
            return listBuffer.toList();
        }

        public List<Type> getDeclaredBounds() {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            int n = 0;
            for (Type type : this.getBounds(InferenceBound.UPPER)) {
                if (n++ == this.declaredCount) break;
                listBuffer.append(type);
            }
            return listBuffer.toList();
        }

        public void setBounds(InferenceBound inferenceBound, List<Type> list) {
            this.bounds.put(inferenceBound, list);
        }

        public final void addBound(InferenceBound inferenceBound, Type type, Types types) {
            this.addBound(inferenceBound, type, types, false);
        }

        protected void addBound(InferenceBound inferenceBound, Type type, Types types, boolean bl) {
            Type type2 = this.toTypeVarMap.apply(type).baseType();
            List<Type> list = this.bounds.get((Object)inferenceBound);
            for (Type type3 : list) {
                if (!types.isSameType(type3, type2, true) && type != this.qtype) continue;
                return;
            }
            this.bounds.put(inferenceBound, list.prepend(type2));
            this.notifyChange(EnumSet.of(inferenceBound));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void substBounds(List<Type> list, List<Type> list2, Types types) {
            List<Type> list3 = list.diff(list2);
            if (list3.isEmpty()) {
                return;
            }
            final EnumSet<InferenceBound> enumSet = EnumSet.noneOf(InferenceBound.class);
            UndetVarListener undetVarListener = this.listener;
            try {
                this.listener = new UndetVarListener(){

                    @Override
                    public void varChanged(UndetVar undetVar, Set<InferenceBound> set) {
                        enumSet.addAll(set);
                    }
                };
                for (Map.Entry<InferenceBound, List<Type>> entry : this.bounds.entrySet()) {
                    InferenceBound inferenceBound = entry.getKey();
                    List<Type> list4 = entry.getValue();
                    ListBuffer<Type> listBuffer = new ListBuffer<Type>();
                    ListBuffer<Type> listBuffer2 = new ListBuffer<Type>();
                    for (Type type : list4) {
                        if (!type.containsAny(list3)) {
                            listBuffer.append(type);
                            continue;
                        }
                        listBuffer2.append(type);
                    }
                    this.bounds.put(inferenceBound, listBuffer.toList());
                    for (Type type : listBuffer2) {
                        this.addBound(inferenceBound, types.subst(type, list, list2), types, true);
                    }
                }
            }
            finally {
                this.listener = undetVarListener;
                if (!enumSet.isEmpty()) {
                    this.notifyChange(enumSet);
                }
            }
        }

        private void notifyChange(EnumSet<InferenceBound> enumSet) {
            if (this.listener != null) {
                this.listener.varChanged(this, enumSet);
            }
        }

        public boolean isCaptured() {
            return false;
        }

        public static enum InferenceBound {
            UPPER{

                @Override
                public InferenceBound complement() {
                    return LOWER;
                }
            }
            ,
            LOWER{

                @Override
                public InferenceBound complement() {
                    return UPPER;
                }
            }
            ,
            EQ{

                @Override
                public InferenceBound complement() {
                    return EQ;
                }
            };


            public abstract InferenceBound complement();
        }

        public static interface UndetVarListener {
            public void varChanged(UndetVar var1, Set<InferenceBound> var2);
        }
    }

    public static class ForAll
    extends DelegatedType
    implements ExecutableType {
        public List<Type> tvars;

        public ForAll(List<Type> list, Type type) {
            super(TypeTag.FORALL, (MethodType)type);
            this.tvars = list;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitForAll(this, s);
        }

        @Override
        public String toString() {
            return "<" + this.tvars + ">" + this.qtype;
        }

        @Override
        public List<Type> getTypeArguments() {
            return this.tvars;
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }

        @Override
        public Type map(Mapping mapping) {
            return mapping.apply(this.qtype);
        }

        @Override
        public boolean contains(Type type) {
            return this.qtype.contains(type);
        }

        @Override
        public MethodType asMethodType() {
            return (MethodType)this.qtype;
        }

        @Override
        public void complete() {
            List<Type> list = this.tvars;
            while (list.nonEmpty()) {
                ((TypeVar)list.head).bound.complete();
                list = list.tail;
            }
            this.qtype.complete();
        }

        public List<TypeVar> getTypeVariables() {
            return List.convert(TypeVar.class, this.getTypeArguments());
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.EXECUTABLE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitExecutable(this, p);
        }
    }

    public static abstract class DelegatedType
    extends Type {
        public Type qtype;
        public TypeTag tag;

        public DelegatedType(TypeTag typeTag, Type type) {
            super(type.tsym);
            this.tag = typeTag;
            this.qtype = type;
        }

        @Override
        public TypeTag getTag() {
            return this.tag;
        }

        @Override
        public String toString() {
            return this.qtype.toString();
        }

        @Override
        public List<Type> getTypeArguments() {
            return this.qtype.getTypeArguments();
        }

        @Override
        public Type getEnclosingType() {
            return this.qtype.getEnclosingType();
        }

        @Override
        public List<Type> getParameterTypes() {
            return this.qtype.getParameterTypes();
        }

        @Override
        public Type getReturnType() {
            return this.qtype.getReturnType();
        }

        @Override
        public Type getReceiverType() {
            return this.qtype.getReceiverType();
        }

        @Override
        public List<Type> getThrownTypes() {
            return this.qtype.getThrownTypes();
        }

        @Override
        public List<Type> allparams() {
            return this.qtype.allparams();
        }

        @Override
        public Type getUpperBound() {
            return this.qtype.getUpperBound();
        }

        @Override
        public boolean isErroneous() {
            return this.qtype.isErroneous();
        }
    }

    public static class CapturedType
    extends TypeVar {
        public WildcardType wildcard;

        public CapturedType(Name name, Symbol symbol, Type type, Type type2, WildcardType wildcardType) {
            super(name, symbol, type2);
            this.lower = Assert.checkNonNull(type2);
            this.bound = type;
            this.wildcard = wildcardType;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitCapturedType(this, s);
        }

        @Override
        public boolean isCaptured() {
            return true;
        }

        @Override
        public String toString() {
            return "capture#" + ((long)this.hashCode() & 0xFFFFFFFFL) % 997L + " of " + this.wildcard;
        }
    }

    public static class TypeVar
    extends Type
    implements TypeVariable {
        public Type bound = null;
        public Type lower;
        int rank_field = -1;

        public TypeVar(Name name, Symbol symbol, Type type) {
            super(null);
            this.tsym = new Symbol.TypeVariableSymbol(0L, name, this, symbol);
            this.lower = type;
        }

        public TypeVar(Symbol.TypeSymbol typeSymbol, Type type, Type type2) {
            super(typeSymbol);
            this.bound = type;
            this.lower = type2;
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.TYPEVAR;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitTypeVar(this, s);
        }

        @Override
        public Type getUpperBound() {
            if ((this.bound == null || this.bound.hasTag(TypeTag.NONE)) && this != this.tsym.type) {
                this.bound = this.tsym.type.getUpperBound();
            }
            return this.bound;
        }

        @Override
        public Type getLowerBound() {
            return this.lower;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.TYPEVAR;
        }

        public boolean isCaptured() {
            return false;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitTypeVariable(this, p);
        }
    }

    public static class PackageType
    extends Type
    implements NoType {
        PackageType(Symbol.TypeSymbol typeSymbol) {
            super(typeSymbol);
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.PACKAGE;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitPackageType(this, s);
        }

        @Override
        public String toString() {
            return this.tsym.getQualifiedName().toString();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.PACKAGE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitNoType(this, p);
        }
    }

    public static class MethodType
    extends Type
    implements ExecutableType {
        public List<Type> argtypes;
        public Type restype;
        public List<Type> thrown;
        public Type recvtype;

        public MethodType(List<Type> list, Type type, List<Type> list2, Symbol.TypeSymbol typeSymbol) {
            super(typeSymbol);
            this.argtypes = list;
            this.restype = type;
            this.thrown = list2;
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.METHOD;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitMethodType(this, s);
        }

        @Override
        public String toString() {
            return "(" + this.argtypes + ")" + this.restype;
        }

        @Override
        public List<Type> getParameterTypes() {
            return this.argtypes;
        }

        @Override
        public Type getReturnType() {
            return this.restype;
        }

        @Override
        public Type getReceiverType() {
            return this.recvtype;
        }

        @Override
        public List<Type> getThrownTypes() {
            return this.thrown;
        }

        @Override
        public boolean isErroneous() {
            return MethodType.isErroneous(this.argtypes) || this.restype != null && this.restype.isErroneous();
        }

        @Override
        public Type map(Mapping mapping) {
            List<Type> list = MethodType.map(this.argtypes, mapping);
            Type type = mapping.apply(this.restype);
            List<Type> list2 = MethodType.map(this.thrown, mapping);
            if (list == this.argtypes && type == this.restype && list2 == this.thrown) {
                return this;
            }
            return new MethodType(list, type, list2, this.tsym);
        }

        @Override
        public boolean contains(Type type) {
            return type == this || MethodType.contains(this.argtypes, type) || this.restype.contains(type) || MethodType.contains(this.thrown, type);
        }

        @Override
        public MethodType asMethodType() {
            return this;
        }

        @Override
        public void complete() {
            List<Type> list = this.argtypes;
            while (list.nonEmpty()) {
                ((Type)list.head).complete();
                list = list.tail;
            }
            this.restype.complete();
            this.recvtype.complete();
            list = this.thrown;
            while (list.nonEmpty()) {
                ((Type)list.head).complete();
                list = list.tail;
            }
        }

        public List<TypeVar> getTypeVariables() {
            return List.nil();
        }

        @Override
        public Symbol.TypeSymbol asElement() {
            return null;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.EXECUTABLE;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitExecutable(this, p);
        }
    }

    public static class ArrayType
    extends Type
    implements javax.lang.model.type.ArrayType {
        public Type elemtype;

        public ArrayType(Type type, Symbol.TypeSymbol typeSymbol) {
            super(typeSymbol);
            this.elemtype = type;
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.ARRAY;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitArrayType(this, s);
        }

        @Override
        public String toString() {
            return this.elemtype + "[]";
        }

        @Override
        public boolean equals(Object object) {
            return this == object || object instanceof ArrayType && this.elemtype.equals(((ArrayType)object).elemtype);
        }

        @Override
        public int hashCode() {
            return (TypeTag.ARRAY.ordinal() << 5) + this.elemtype.hashCode();
        }

        public boolean isVarargs() {
            return false;
        }

        @Override
        public List<Type> allparams() {
            return this.elemtype.allparams();
        }

        @Override
        public boolean isErroneous() {
            return this.elemtype.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.elemtype.isParameterized();
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public boolean isRaw() {
            return this.elemtype.isRaw();
        }

        public ArrayType makeVarargs() {
            return new ArrayType(this.elemtype, this.tsym){

                @Override
                public boolean isVarargs() {
                    return true;
                }
            };
        }

        @Override
        public Type map(Mapping mapping) {
            Type type = mapping.apply(this.elemtype);
            if (type == this.elemtype) {
                return this;
            }
            return new ArrayType(type, this.tsym);
        }

        @Override
        public boolean contains(Type type) {
            return type == this || this.elemtype.contains(type);
        }

        @Override
        public void complete() {
            this.elemtype.complete();
        }

        @Override
        public Type getComponentType() {
            return this.elemtype;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.ARRAY;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitArray(this, p);
        }
    }

    public static class IntersectionClassType
    extends ClassType
    implements IntersectionType {
        public boolean allInterfaces;

        public IntersectionClassType(List<Type> list, Symbol.ClassSymbol classSymbol, boolean bl) {
            super(noType, List.nil(), classSymbol);
            this.allInterfaces = bl;
            Assert.check((classSymbol.flags() & 0x1000000L) != 0L);
            this.supertype_field = (Type)list.head;
            this.interfaces_field = list.tail;
            Assert.check(this.supertype_field.tsym.completer != null || !this.supertype_field.isInterface(), this.supertype_field);
        }

        @Override
        public java.util.List<? extends TypeMirror> getBounds() {
            return Collections.unmodifiableList(this.getExplicitComponents());
        }

        public List<Type> getComponents() {
            return this.interfaces_field.prepend(this.supertype_field);
        }

        public List<Type> getExplicitComponents() {
            return this.allInterfaces ? this.interfaces_field : this.getComponents();
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.INTERSECTION;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitIntersection(this, p);
        }
    }

    public static class UnionClassType
    extends ClassType
    implements UnionType {
        final List<? extends Type> alternatives_field;

        public UnionClassType(ClassType classType, List<? extends Type> list) {
            super(classType.outer_field, classType.typarams_field, classType.tsym);
            this.allparams_field = classType.allparams_field;
            this.supertype_field = classType.supertype_field;
            this.interfaces_field = classType.interfaces_field;
            this.all_interfaces_field = classType.interfaces_field;
            this.alternatives_field = list;
        }

        public Type getLub() {
            return this.tsym.type;
        }

        @Override
        public java.util.List<? extends TypeMirror> getAlternatives() {
            return Collections.unmodifiableList(this.alternatives_field);
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.UNION;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitUnion(this, p);
        }
    }

    public static class ErasedClassType
    extends ClassType {
        public ErasedClassType(Type type, Symbol.TypeSymbol typeSymbol) {
            super(type, List.nil(), typeSymbol);
        }

        @Override
        public boolean hasErasedSupertypes() {
            return true;
        }
    }

    public static class ClassType
    extends Type
    implements DeclaredType {
        private Type outer_field;
        public List<Type> typarams_field;
        public List<Type> allparams_field;
        public Type supertype_field;
        public List<Type> interfaces_field;
        public List<Type> all_interfaces_field;
        int rank_field = -1;

        public ClassType(Type type, List<Type> list, Symbol.TypeSymbol typeSymbol) {
            super(typeSymbol);
            this.outer_field = type;
            this.typarams_field = list;
            this.allparams_field = null;
            this.supertype_field = null;
            this.interfaces_field = null;
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.CLASS;
        }

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitClassType(this, s);
        }

        @Override
        public Type constType(Object object) {
            final Object object2 = object;
            return new ClassType(this.getEnclosingType(), this.typarams_field, this.tsym){

                @Override
                public Object constValue() {
                    return object2;
                }

                @Override
                public Type baseType() {
                    return this.tsym.type;
                }
            };
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.getEnclosingType().hasTag(TypeTag.CLASS) && this.tsym.owner.kind == 2) {
                stringBuilder.append(this.getEnclosingType().toString());
                stringBuilder.append(".");
                stringBuilder.append(this.className(this.tsym, false));
            } else {
                stringBuilder.append(this.className(this.tsym, true));
            }
            if (((List)this.getTypeArguments()).nonEmpty()) {
                stringBuilder.append('<');
                stringBuilder.append(((List)this.getTypeArguments()).toString());
                stringBuilder.append(">");
            }
            return stringBuilder.toString();
        }

        private String className(Symbol symbol, boolean bl) {
            if (symbol.name.isEmpty() && (symbol.flags() & 0x1000000L) != 0L) {
                StringBuilder stringBuilder = new StringBuilder(this.supertype_field.toString());
                List<Type> list = this.interfaces_field;
                while (list.nonEmpty()) {
                    stringBuilder.append("&");
                    stringBuilder.append(((Type)list.head).toString());
                    list = list.tail;
                }
                return stringBuilder.toString();
            }
            if (symbol.name.isEmpty()) {
                ClassType classType = (ClassType)this.tsym.type.unannotatedType();
                String string = classType == null ? Log.getLocalizedString("anonymous.class", new Object[]{null}) : (classType.interfaces_field != null && classType.interfaces_field.nonEmpty() ? Log.getLocalizedString("anonymous.class", classType.interfaces_field.head) : Log.getLocalizedString("anonymous.class", classType.supertype_field));
                if (moreInfo) {
                    string = string + String.valueOf(symbol.hashCode());
                }
                return string;
            }
            if (bl) {
                return symbol.getQualifiedName().toString();
            }
            return symbol.name.toString();
        }

        @Override
        public List<Type> getTypeArguments() {
            if (this.typarams_field == null) {
                this.complete();
                if (this.typarams_field == null) {
                    this.typarams_field = List.nil();
                }
            }
            return this.typarams_field;
        }

        public boolean hasErasedSupertypes() {
            return this.isRaw();
        }

        @Override
        public Type getEnclosingType() {
            return this.outer_field;
        }

        public void setEnclosingType(Type type) {
            this.outer_field = type;
        }

        @Override
        public List<Type> allparams() {
            if (this.allparams_field == null) {
                this.allparams_field = ((List)this.getTypeArguments()).prependList(this.getEnclosingType().allparams());
            }
            return this.allparams_field;
        }

        @Override
        public boolean isErroneous() {
            return this.getEnclosingType().isErroneous() || ClassType.isErroneous((List<Type>)this.getTypeArguments()) || this != this.tsym.type.unannotatedType() && this.tsym.type.isErroneous();
        }

        @Override
        public boolean isParameterized() {
            return this.allparams().tail != null;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public boolean isRaw() {
            return this != this.tsym.type && this.tsym.type.allparams().nonEmpty() && this.allparams().isEmpty();
        }

        @Override
        public Type map(Mapping mapping) {
            Type type = this.getEnclosingType();
            Type type2 = mapping.apply(type);
            java.util.List list = this.getTypeArguments();
            List<Type> list2 = ClassType.map((List<Type>)list, mapping);
            if (type2 == type && list2 == list) {
                return this;
            }
            return new ClassType(type2, list2, this.tsym);
        }

        @Override
        public boolean contains(Type type) {
            return type == this || this.isParameterized() && (this.getEnclosingType().contains(type) || ClassType.contains((List<Type>)this.getTypeArguments(), type)) || this.isCompound() && (this.supertype_field.contains(type) || ClassType.contains(this.interfaces_field, type));
        }

        @Override
        public void complete() {
            if (this.tsym.completer != null) {
                this.tsym.complete();
            }
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.DECLARED;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitDeclared(this, p);
        }
    }

    public static class WildcardType
    extends Type
    implements javax.lang.model.type.WildcardType {
        public Type type;
        public BoundKind kind;
        public TypeVar bound;
        boolean isPrintingBound = false;

        @Override
        public <R, S> R accept(Visitor<R, S> visitor, S s) {
            return visitor.visitWildcardType(this, s);
        }

        public WildcardType(Type type, BoundKind boundKind, Symbol.TypeSymbol typeSymbol) {
            super(typeSymbol);
            this.type = Assert.checkNonNull(type);
            this.kind = boundKind;
        }

        public WildcardType(WildcardType wildcardType, TypeVar typeVar) {
            this(wildcardType.type, wildcardType.kind, wildcardType.tsym, typeVar);
        }

        public WildcardType(Type type, BoundKind boundKind, Symbol.TypeSymbol typeSymbol, TypeVar typeVar) {
            this(type, boundKind, typeSymbol);
            this.bound = typeVar;
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.WILDCARD;
        }

        @Override
        public boolean contains(Type type) {
            return this.kind != BoundKind.UNBOUND && this.type.contains(type);
        }

        @Override
        public boolean isSuperBound() {
            return this.kind == BoundKind.SUPER || this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isExtendsBound() {
            return this.kind == BoundKind.EXTENDS || this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isUnbound() {
            return this.kind == BoundKind.UNBOUND;
        }

        @Override
        public boolean isReference() {
            return true;
        }

        @Override
        public boolean isNullOrReference() {
            return true;
        }

        @Override
        public Type withTypeVar(Type type) {
            if (this.bound == type) {
                return this;
            }
            this.bound = (TypeVar)type;
            return this;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.kind.toString());
            if (this.kind != BoundKind.UNBOUND) {
                stringBuilder.append(this.type);
            }
            if (moreInfo && this.bound != null && !this.isPrintingBound) {
                try {
                    this.isPrintingBound = true;
                    stringBuilder.append("{:").append(this.bound.bound).append(":}");
                }
                finally {
                    this.isPrintingBound = false;
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public Type map(Mapping mapping) {
            Type type = this.type;
            if (type != null) {
                type = mapping.apply(type);
            }
            if (type == this.type) {
                return this;
            }
            return new WildcardType(type, this.kind, this.tsym, this.bound);
        }

        @Override
        public Type getExtendsBound() {
            if (this.kind == BoundKind.EXTENDS) {
                return this.type;
            }
            return null;
        }

        @Override
        public Type getSuperBound() {
            if (this.kind == BoundKind.SUPER) {
                return this.type;
            }
            return null;
        }

        @Override
        public TypeKind getKind() {
            return TypeKind.WILDCARD;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitWildcard(this, p);
        }
    }

    public static class JCPrimitiveType
    extends Type
    implements PrimitiveType {
        TypeTag tag;

        public JCPrimitiveType(TypeTag typeTag, Symbol.TypeSymbol typeSymbol) {
            super(typeSymbol);
            this.tag = typeTag;
            Assert.check(typeTag.isPrimitive);
        }

        @Override
        public boolean isNumeric() {
            return this.tag != TypeTag.BOOLEAN;
        }

        @Override
        public boolean isPrimitive() {
            return true;
        }

        @Override
        public TypeTag getTag() {
            return this.tag;
        }

        @Override
        public boolean isPrimitiveOrVoid() {
            return true;
        }

        @Override
        public Type constType(Object object) {
            final Object object2 = object;
            return new JCPrimitiveType(this.tag, this.tsym){

                @Override
                public Object constValue() {
                    return object2;
                }

                @Override
                public Type baseType() {
                    return this.tsym.type;
                }
            };
        }

        @Override
        public String stringValue() {
            Object object = Assert.checkNonNull(this.constValue());
            if (this.tag == TypeTag.BOOLEAN) {
                return (Integer)object == 0 ? "false" : "true";
            }
            if (this.tag == TypeTag.CHAR) {
                return String.valueOf((char)((Integer)object).intValue());
            }
            return object.toString();
        }

        @Override
        public boolean isFalse() {
            return this.tag == TypeTag.BOOLEAN && this.constValue() != null && (Integer)this.constValue() == 0;
        }

        @Override
        public boolean isTrue() {
            return this.tag == TypeTag.BOOLEAN && this.constValue() != null && (Integer)this.constValue() != 0;
        }

        @Override
        public <R, P> R accept(TypeVisitor<R, P> typeVisitor, P p) {
            return typeVisitor.visitPrimitive(this, p);
        }

        @Override
        public TypeKind getKind() {
            switch (this.tag) {
                case BYTE: {
                    return TypeKind.BYTE;
                }
                case CHAR: {
                    return TypeKind.CHAR;
                }
                case SHORT: {
                    return TypeKind.SHORT;
                }
                case INT: {
                    return TypeKind.INT;
                }
                case LONG: {
                    return TypeKind.LONG;
                }
                case FLOAT: {
                    return TypeKind.FLOAT;
                }
                case DOUBLE: {
                    return TypeKind.DOUBLE;
                }
                case BOOLEAN: {
                    return TypeKind.BOOLEAN;
                }
            }
            throw new AssertionError();
        }
    }

    public static abstract class Mapping {
        private String name;

        public Mapping(String string) {
            this.name = string;
        }

        public abstract Type apply(Type var1);

        public String toString() {
            return this.name;
        }
    }
}

