/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.AnnotationTypeFieldWriter;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnnotationTypeFieldBuilder
extends AbstractMemberBuilder {
    protected ClassDoc classDoc;
    protected VisibleMemberMap visibleMemberMap;
    protected AnnotationTypeFieldWriter writer;
    protected List<ProgramElementDoc> members;
    protected int currentMemberIndex;

    protected AnnotationTypeFieldBuilder(AbstractBuilder.Context context, ClassDoc classDoc, AnnotationTypeFieldWriter annotationTypeFieldWriter, int n) {
        super(context);
        this.classDoc = classDoc;
        this.writer = annotationTypeFieldWriter;
        this.visibleMemberMap = new VisibleMemberMap(classDoc, n, this.configuration);
        this.members = new ArrayList<ProgramElementDoc>(this.visibleMemberMap.getMembersFor(classDoc));
        if (this.configuration.getMemberComparator() != null) {
            Collections.sort(this.members, this.configuration.getMemberComparator());
        }
    }

    public static AnnotationTypeFieldBuilder getInstance(AbstractBuilder.Context context, ClassDoc classDoc, AnnotationTypeFieldWriter annotationTypeFieldWriter) {
        return new AnnotationTypeFieldBuilder(context, classDoc, annotationTypeFieldWriter, 5);
    }

    @Override
    public String getName() {
        return "AnnotationTypeFieldDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.members.size() > 0;
    }

    public void buildAnnotationTypeField(XMLNode xMLNode, Content content) {
        this.buildAnnotationTypeMember(xMLNode, content);
    }

    public void buildAnnotationTypeMember(XMLNode xMLNode, Content content) {
        if (this.writer == null) {
            return;
        }
        int n = this.members.size();
        if (n > 0) {
            this.writer.addAnnotationFieldDetailsMarker(content);
            this.currentMemberIndex = 0;
            while (this.currentMemberIndex < n) {
                Content content2 = this.writer.getMemberTreeHeader();
                this.writer.addAnnotationDetailsTreeHeader(this.classDoc, content2);
                Content content3 = this.writer.getAnnotationDocTreeHeader((MemberDoc)this.members.get(this.currentMemberIndex), content2);
                this.buildChildren(xMLNode, content3);
                content2.addContent(this.writer.getAnnotationDoc(content3, this.currentMemberIndex == n - 1));
                content.addContent(this.writer.getAnnotationDetails(content2));
                ++this.currentMemberIndex;
            }
        }
    }

    public void buildSignature(XMLNode xMLNode, Content content) {
        content.addContent(this.writer.getSignature((MemberDoc)this.members.get(this.currentMemberIndex)));
    }

    public void buildDeprecationInfo(XMLNode xMLNode, Content content) {
        this.writer.addDeprecated((MemberDoc)this.members.get(this.currentMemberIndex), content);
    }

    public void buildMemberComments(XMLNode xMLNode, Content content) {
        if (!this.configuration.nocomment) {
            this.writer.addComments((MemberDoc)this.members.get(this.currentMemberIndex), content);
        }
    }

    public void buildTagInfo(XMLNode xMLNode, Content content) {
        this.writer.addTags((MemberDoc)this.members.get(this.currentMemberIndex), content);
    }

    public AnnotationTypeFieldWriter getWriter() {
        return this.writer;
    }
}

