/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.markup.DocType;
import com.sun.tools.doclets.formats.html.markup.HtmlDocument;
import com.sun.tools.doclets.formats.html.markup.HtmlStyle;
import com.sun.tools.doclets.formats.html.markup.HtmlTag;
import com.sun.tools.doclets.formats.html.markup.HtmlTree;
import com.sun.tools.doclets.formats.html.markup.StringContent;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.util.DocFile;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.DocletConstants;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.javadoc.SourcePositionImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Writer;

public class SourceToHTMLConverter {
    private static final int NUM_BLANK_LINES = 60;
    private static final String NEW_LINE = DocletConstants.NL;
    private final ConfigurationImpl configuration;
    private final RootDoc rootDoc;
    private DocPath outputdir;
    private DocPath relativePath = DocPath.empty;

    private SourceToHTMLConverter(ConfigurationImpl configurationImpl, RootDoc rootDoc, DocPath docPath) {
        this.configuration = configurationImpl;
        this.rootDoc = rootDoc;
        this.outputdir = docPath;
    }

    public static void convertRoot(ConfigurationImpl configurationImpl, RootDoc rootDoc, DocPath docPath) {
        new SourceToHTMLConverter(configurationImpl, rootDoc, docPath).generate();
    }

    void generate() {
        if (this.rootDoc == null || this.outputdir == null) {
            return;
        }
        PackageDoc[] packageDocArray = this.rootDoc.specifiedPackages();
        for (int i = 0; i < packageDocArray.length; ++i) {
            if (this.configuration.nodeprecated && Util.isDeprecated((Doc)packageDocArray[i])) continue;
            this.convertPackage(packageDocArray[i], this.outputdir);
        }
        ClassDoc[] classDocArray = this.rootDoc.specifiedClasses();
        for (int i = 0; i < classDocArray.length; ++i) {
            if (this.configuration.nodeprecated && (Util.isDeprecated((Doc)classDocArray[i]) || Util.isDeprecated((Doc)classDocArray[i].containingPackage()))) continue;
            this.convertClass(classDocArray[i], this.outputdir);
        }
    }

    public void convertPackage(PackageDoc packageDoc, DocPath docPath) {
        if (packageDoc == null) {
            return;
        }
        ClassDoc[] classDocArray = packageDoc.allClasses();
        for (int i = 0; i < classDocArray.length; ++i) {
            if (this.configuration.nodeprecated && Util.isDeprecated((Doc)classDocArray[i])) continue;
            this.convertClass(classDocArray[i], docPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertClass(ClassDoc classDoc, DocPath docPath) {
        if (classDoc == null) {
            return;
        }
        try {
            Reader reader;
            Object object;
            SourcePosition sourcePosition = classDoc.position();
            if (sourcePosition == null) {
                return;
            }
            if (sourcePosition instanceof SourcePositionImpl) {
                object = ((SourcePositionImpl)sourcePosition).fileObject();
                if (object == null) {
                    return;
                }
                reader = object.openReader(true);
            } else {
                object = sourcePosition.file();
                if (object == null) {
                    return;
                }
                reader = new FileReader((File)object);
            }
            object = new LineNumberReader(reader);
            int n = 1;
            this.relativePath = DocPaths.SOURCE_OUTPUT.resolve(DocPath.forPackage(classDoc)).invert();
            Content content = SourceToHTMLConverter.getHeader();
            HtmlTree htmlTree = new HtmlTree(HtmlTag.PRE);
            try {
                String string;
                while ((string = ((LineNumberReader)object).readLine()) != null) {
                    SourceToHTMLConverter.addLineNo(htmlTree, n);
                    this.addLine(htmlTree, string, n);
                    ++n;
                }
            }
            finally {
                ((BufferedReader)object).close();
            }
            SourceToHTMLConverter.addBlankLines(htmlTree);
            HtmlTree htmlTree2 = HtmlTree.DIV(HtmlStyle.sourceContainer, htmlTree);
            content.addContent(htmlTree2);
            this.writeToFile(content, docPath.resolve(DocPath.forClass(classDoc)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(Content content, DocPath docPath) throws IOException {
        DocType docType = DocType.TRANSITIONAL;
        HtmlTree htmlTree = new HtmlTree(HtmlTag.HEAD);
        ((Content)htmlTree).addContent(HtmlTree.TITLE(new StringContent(this.configuration.getText("doclet.Window_Source_title"))));
        ((Content)htmlTree).addContent(this.getStyleSheetProperties());
        HtmlTree htmlTree2 = HtmlTree.HTML(this.configuration.getLocale().getLanguage(), htmlTree, content);
        HtmlDocument htmlDocument = new HtmlDocument(docType, htmlTree2);
        this.configuration.message.notice("doclet.Generating_0", docPath.getPath());
        DocFile docFile = DocFile.createFileForOutput(this.configuration, docPath);
        try (Writer writer = docFile.openWriter();){
            ((Content)htmlDocument).write(writer, true);
        }
    }

    public HtmlTree getStyleSheetProperties() {
        DocPath docPath;
        Object object;
        String string = this.configuration.stylesheetfile;
        if (string.length() > 0) {
            object = DocFile.createFileForInput(this.configuration, string);
            docPath = DocPath.create(((DocFile)object).getName());
        } else {
            docPath = DocPaths.STYLESHEET;
        }
        object = this.relativePath.resolve(docPath);
        HtmlTree htmlTree = HtmlTree.LINK("stylesheet", "text/css", ((DocPath)object).getPath(), "Style");
        return htmlTree;
    }

    private static Content getHeader() {
        return new HtmlTree(HtmlTag.BODY);
    }

    private static void addLineNo(Content content, int n) {
        HtmlTree htmlTree = new HtmlTree(HtmlTag.SPAN);
        htmlTree.addStyle(HtmlStyle.sourceLineNo);
        if (n < 10) {
            htmlTree.addContent("00" + Integer.toString(n));
        } else if (n < 100) {
            htmlTree.addContent("0" + Integer.toString(n));
        } else {
            htmlTree.addContent(Integer.toString(n));
        }
        content.addContent(htmlTree);
    }

    private void addLine(Content content, String string, int n) {
        if (string != null) {
            content.addContent(Util.replaceTabs(this.configuration, string));
            HtmlTree htmlTree = HtmlTree.A_NAME("line." + Integer.toString(n));
            content.addContent(htmlTree);
            content.addContent(NEW_LINE);
        }
    }

    private static void addBlankLines(Content content) {
        for (int i = 0; i < 60; ++i) {
            content.addContent(NEW_LINE);
        }
    }

    public static String getAnchorName(Doc doc) {
        return "line." + doc.position().line();
    }
}

