/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.formats.html;

import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.formats.html.AllClassesFrameWriter;
import com.sun.tools.doclets.formats.html.ClassUseWriter;
import com.sun.tools.doclets.formats.html.ConfigurationImpl;
import com.sun.tools.doclets.formats.html.DeprecatedListWriter;
import com.sun.tools.doclets.formats.html.FrameOutputWriter;
import com.sun.tools.doclets.formats.html.HelpWriter;
import com.sun.tools.doclets.formats.html.PackageFrameWriter;
import com.sun.tools.doclets.formats.html.PackageIndexFrameWriter;
import com.sun.tools.doclets.formats.html.PackageIndexWriter;
import com.sun.tools.doclets.formats.html.PackageTreeWriter;
import com.sun.tools.doclets.formats.html.ProfileIndexFrameWriter;
import com.sun.tools.doclets.formats.html.ProfilePackageFrameWriter;
import com.sun.tools.doclets.formats.html.ProfilePackageIndexFrameWriter;
import com.sun.tools.doclets.formats.html.SingleIndexWriter;
import com.sun.tools.doclets.formats.html.SourceToHTMLConverter;
import com.sun.tools.doclets.formats.html.SplitIndexWriter;
import com.sun.tools.doclets.formats.html.TreeWriter;
import com.sun.tools.doclets.internal.toolkit.AbstractDoclet;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractBuilder;
import com.sun.tools.doclets.internal.toolkit.util.ClassTree;
import com.sun.tools.doclets.internal.toolkit.util.DocFile;
import com.sun.tools.doclets.internal.toolkit.util.DocPath;
import com.sun.tools.doclets.internal.toolkit.util.DocPaths;
import com.sun.tools.doclets.internal.toolkit.util.DocletAbortException;
import com.sun.tools.doclets.internal.toolkit.util.IndexBuilder;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import com.sun.tools.javac.jvm.Profile;
import java.io.IOException;
import java.util.Arrays;

public class HtmlDoclet
extends AbstractDoclet {
    private static HtmlDoclet docletToStart = null;
    public final ConfigurationImpl configuration = new ConfigurationImpl();
    public static final ConfigurationImpl sharedInstanceForOptions = new ConfigurationImpl();

    public static boolean start(RootDoc rootDoc) {
        HtmlDoclet htmlDoclet;
        if (docletToStart != null) {
            htmlDoclet = docletToStart;
            docletToStart = null;
        } else {
            htmlDoclet = new HtmlDoclet();
        }
        return htmlDoclet.start(htmlDoclet, rootDoc);
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    protected void generateOtherFiles(RootDoc rootDoc, ClassTree classTree) throws Exception {
        DocFile docFile;
        super.generateOtherFiles(rootDoc, classTree);
        if (this.configuration.linksource) {
            SourceToHTMLConverter.convertRoot(this.configuration, rootDoc, DocPaths.SOURCE_OUTPUT);
        }
        if (this.configuration.topFile.isEmpty()) {
            this.configuration.standardmessage.error("doclet.No_Non_Deprecated_Classes_To_Document", new Object[0]);
            return;
        }
        boolean bl = this.configuration.nodeprecated;
        this.performCopy(this.configuration.helpfile);
        this.performCopy(this.configuration.stylesheetfile);
        if (this.configuration.classuse) {
            ClassUseWriter.generate(this.configuration, classTree);
        }
        IndexBuilder indexBuilder = new IndexBuilder(this.configuration, bl);
        if (this.configuration.createtree) {
            TreeWriter.generate(this.configuration, classTree);
        }
        if (this.configuration.createindex) {
            if (this.configuration.splitindex) {
                SplitIndexWriter.generate(this.configuration, indexBuilder);
            } else {
                SingleIndexWriter.generate(this.configuration, indexBuilder);
            }
        }
        if (!this.configuration.nodeprecatedlist && !bl) {
            DeprecatedListWriter.generate(this.configuration);
        }
        AllClassesFrameWriter.generate(this.configuration, new IndexBuilder(this.configuration, bl, true));
        FrameOutputWriter.generate(this.configuration);
        if (this.configuration.createoverview) {
            PackageIndexWriter.generate(this.configuration);
        }
        if (this.configuration.helpfile.length() == 0 && !this.configuration.nohelp) {
            HelpWriter.generate(this.configuration);
        }
        if (this.configuration.stylesheetfile.length() == 0) {
            docFile = DocFile.createFileForOutput(this.configuration, DocPaths.STYLESHEET);
            docFile.copyResource(DocPaths.RESOURCES.resolve(DocPaths.STYLESHEET), false, true);
        }
        docFile = DocFile.createFileForOutput(this.configuration, DocPaths.JAVASCRIPT);
        docFile.copyResource(DocPaths.RESOURCES.resolve(DocPaths.JAVASCRIPT), true, true);
    }

    @Override
    protected void generateClassFiles(ClassDoc[] classDocArray, ClassTree classTree) {
        Arrays.sort(classDocArray);
        for (int i = 0; i < classDocArray.length; ++i) {
            if (!this.configuration.isGeneratedDoc(classDocArray[i]) || !classDocArray[i].isIncluded()) continue;
            ClassDoc classDoc = i == 0 ? null : classDocArray[i - 1];
            ClassDoc classDoc2 = classDocArray[i];
            ClassDoc classDoc3 = i + 1 == classDocArray.length ? null : classDocArray[i + 1];
            try {
                AbstractBuilder abstractBuilder;
                if (classDoc2.isAnnotationType()) {
                    abstractBuilder = this.configuration.getBuilderFactory().getAnnotationTypeBuilder((AnnotationTypeDoc)classDoc2, (Type)classDoc, (Type)classDoc3);
                    abstractBuilder.build();
                    continue;
                }
                abstractBuilder = this.configuration.getBuilderFactory().getClassBuilder(classDoc2, classDoc, classDoc3, classTree);
                abstractBuilder.build();
                continue;
            }
            catch (IOException iOException) {
                throw new DocletAbortException(iOException);
            }
            catch (DocletAbortException docletAbortException) {
                throw docletAbortException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new DocletAbortException(exception);
            }
        }
    }

    @Override
    protected void generateProfileFiles() throws Exception {
        if (this.configuration.showProfiles && this.configuration.profilePackages.size() > 0) {
            ProfileIndexFrameWriter.generate(this.configuration);
            Profile profile = null;
            for (int i = 1; i < this.configuration.profiles.getProfileCount(); ++i) {
                String string = Profile.lookup((int)i).name;
                if (!this.configuration.shouldDocumentProfile(string)) continue;
                ProfilePackageIndexFrameWriter.generate(this.configuration, string);
                PackageDoc[] packageDocArray = (PackageDoc[])this.configuration.profilePackages.get(string);
                PackageDoc packageDoc = null;
                for (int j = 0; j < packageDocArray.length; ++j) {
                    if (this.configuration.nodeprecated && Util.isDeprecated((Doc)packageDocArray[j])) continue;
                    ProfilePackageFrameWriter.generate(this.configuration, packageDocArray[j], i);
                    PackageDoc packageDoc2 = j + 1 < packageDocArray.length && packageDocArray[j + 1].name().length() > 0 ? packageDocArray[j + 1] : null;
                    AbstractBuilder abstractBuilder = this.configuration.getBuilderFactory().getProfilePackageSummaryBuilder(packageDocArray[j], packageDoc, packageDoc2, Profile.lookup(i));
                    abstractBuilder.build();
                    packageDoc = packageDocArray[j];
                }
                Profile profile2 = i + 1 < this.configuration.profiles.getProfileCount() ? Profile.lookup(i + 1) : null;
                AbstractBuilder abstractBuilder = this.configuration.getBuilderFactory().getProfileSummaryBuilder(Profile.lookup(i), profile, profile2);
                abstractBuilder.build();
                profile = Profile.lookup(i);
            }
        }
    }

    @Override
    protected void generatePackageFiles(ClassTree classTree) throws Exception {
        PackageDoc[] packageDocArray = this.configuration.packages;
        if (packageDocArray.length > 1) {
            PackageIndexFrameWriter.generate(this.configuration);
        }
        PackageDoc packageDoc = null;
        for (int i = 0; i < packageDocArray.length; ++i) {
            if (this.configuration.nodeprecated && Util.isDeprecated((Doc)packageDocArray[i])) continue;
            PackageFrameWriter.generate(this.configuration, packageDocArray[i]);
            PackageDoc packageDoc2 = i + 1 < packageDocArray.length && packageDocArray[i + 1].name().length() > 0 ? packageDocArray[i + 1] : null;
            packageDoc2 = i + 2 < packageDocArray.length && packageDoc2 == null ? packageDocArray[i + 2] : packageDoc2;
            AbstractBuilder abstractBuilder = this.configuration.getBuilderFactory().getPackageSummaryBuilder(packageDocArray[i], packageDoc, packageDoc2);
            abstractBuilder.build();
            if (this.configuration.createtree) {
                PackageTreeWriter.generate(this.configuration, packageDocArray[i], packageDoc, packageDoc2, this.configuration.nodeprecated);
            }
            packageDoc = packageDocArray[i];
        }
    }

    public static int optionLength(String string) {
        return sharedInstanceForOptions.optionLength(string);
    }

    public static boolean validOptions(String[][] stringArray, DocErrorReporter docErrorReporter) {
        docletToStart = new HtmlDoclet();
        return HtmlDoclet.docletToStart.configuration.validOptions(stringArray, docErrorReporter);
    }

    private void performCopy(String string) {
        if (string.isEmpty()) {
            return;
        }
        try {
            DocFile docFile = DocFile.createFileForInput(this.configuration, string);
            DocPath docPath = DocPath.create(docFile.getName());
            DocFile docFile2 = DocFile.createFileForOutput(this.configuration, docPath);
            if (docFile2.isSameFile(docFile)) {
                return;
            }
            this.configuration.message.notice((SourcePosition)null, "doclet.Copying_File_0_To_File_1", docFile.toString(), docPath.getPath());
            docFile2.copyFile(docFile);
        }
        catch (IOException iOException) {
            this.configuration.message.error((SourcePosition)null, "doclet.perform_copy_exception_encountered", iOException.toString());
            throw new DocletAbortException(iOException);
        }
    }
}

