/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.GenFileStream;
import com.sun.tools.corba.se.idl.InterfaceState;
import com.sun.tools.corba.se.idl.PrimitiveEntry;
import com.sun.tools.corba.se.idl.StringEntry;
import com.sun.tools.corba.se.idl.SymtabEntry;
import com.sun.tools.corba.se.idl.TypedefEntry;
import com.sun.tools.corba.se.idl.ValueBoxEntry;
import com.sun.tools.corba.se.idl.toJavaPortable.AuxGen;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;
import java.util.Hashtable;

public class Holder
implements AuxGen {
    protected Hashtable symbolTable;
    protected SymtabEntry entry;
    protected GenFileStream stream;
    protected String holderClass;
    protected String helperClass;
    protected String holderType;

    @Override
    public void generate(Hashtable hashtable, SymtabEntry symtabEntry) {
        this.symbolTable = hashtable;
        this.entry = symtabEntry;
        this.init();
        this.openStream();
        if (this.stream == null) {
            return;
        }
        this.writeHeading();
        this.writeBody();
        this.writeClosing();
        this.closeStream();
    }

    protected void init() {
        this.holderClass = this.entry.name() + "Holder";
        this.helperClass = Util.helperName(this.entry, true);
        if (this.entry instanceof ValueBoxEntry) {
            ValueBoxEntry valueBoxEntry = (ValueBoxEntry)this.entry;
            TypedefEntry typedefEntry = ((InterfaceState)valueBoxEntry.state().elementAt((int)0)).entry;
            SymtabEntry symtabEntry = typedefEntry.type();
            this.holderType = Util.javaName(symtabEntry);
        } else {
            this.holderType = Util.javaName(this.entry);
        }
    }

    protected void openStream() {
        this.stream = Util.stream(this.entry, "Holder.java");
    }

    protected void writeHeading() {
        Util.writePackage(this.stream, this.entry, (short)3);
        Util.writeProlog(this.stream, this.stream.name());
        if (this.entry.comment() != null) {
            this.entry.comment().generate("", this.stream);
        }
        this.stream.println("public final class " + this.holderClass + " implements org.omg.CORBA.portable.Streamable");
        this.stream.println('{');
    }

    protected void writeBody() {
        if (this.entry instanceof ValueBoxEntry) {
            this.stream.println("  public " + this.holderType + " value;");
        } else {
            Util.writeInitializer("  public ", "value", "", this.entry, this.stream);
        }
        this.stream.println();
        this.writeCtors();
        this.writeRead();
        this.writeWrite();
        this.writeType();
    }

    protected void writeClosing() {
        this.stream.println('}');
    }

    protected void closeStream() {
        this.stream.close();
    }

    protected void writeCtors() {
        this.stream.println("  public " + this.holderClass + " ()");
        this.stream.println("  {");
        this.stream.println("  }");
        this.stream.println();
        this.stream.println("  public " + this.holderClass + " (" + this.holderType + " initialValue)");
        this.stream.println("  {");
        this.stream.println("    value = initialValue;");
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeRead() {
        this.stream.println("  public void _read (org.omg.CORBA.portable.InputStream i)");
        this.stream.println("  {");
        if (this.entry instanceof ValueBoxEntry) {
            TypedefEntry typedefEntry = ((InterfaceState)((ValueBoxEntry)this.entry).state().elementAt((int)0)).entry;
            SymtabEntry symtabEntry = typedefEntry.type();
            if (symtabEntry instanceof StringEntry) {
                this.stream.println("    value = i.read_string ();");
            } else if (symtabEntry instanceof PrimitiveEntry) {
                this.stream.println("    value = " + this.helperClass + ".read (i).value;");
            } else {
                this.stream.println("    value = " + this.helperClass + ".read (i);");
            }
        } else {
            this.stream.println("    value = " + this.helperClass + ".read (i);");
        }
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeWrite() {
        this.stream.println("  public void _write (org.omg.CORBA.portable.OutputStream o)");
        this.stream.println("  {");
        if (this.entry instanceof ValueBoxEntry) {
            TypedefEntry typedefEntry = ((InterfaceState)((ValueBoxEntry)this.entry).state().elementAt((int)0)).entry;
            SymtabEntry symtabEntry = typedefEntry.type();
            if (symtabEntry instanceof StringEntry) {
                this.stream.println("    o.write_string (value);");
            } else if (symtabEntry instanceof PrimitiveEntry) {
                String string = this.entry.name();
                this.stream.println("    " + string + " vb = new " + string + " (value);");
                this.stream.println("    " + this.helperClass + ".write (o, vb);");
            } else {
                this.stream.println("    " + this.helperClass + ".write (o, value);");
            }
        } else {
            this.stream.println("    " + this.helperClass + ".write (o, value);");
        }
        this.stream.println("  }");
        this.stream.println();
    }

    protected void writeType() {
        this.stream.println("  public org.omg.CORBA.TypeCode _type ()");
        this.stream.println("  {");
        this.stream.println("    return " + this.helperClass + ".type ();");
        this.stream.println("  }");
        this.stream.println();
    }
}

