uniform sampler2D map0;
uniform vec2 pixsize;
uniform vec2 uvmin;
uniform vec2 uvmax;
uniform float scale;

vec4 texclamp(vec2 uv)
{
	return texture2D(map0, clamp(uv, uvmin, uvmax));
}

void sampling(void)
{
	float du = (uvmax.x - uvmin.x) * 0.5 / scale / (pixsize.x + 1.0);
	float dv = (uvmax.y - uvmin.y) * 0.5 / scale / (pixsize.y + 1.0);
	vec2 uv = gl_TexCoord[0].xy;

	float weight = 0.0;

	weight += 1.0;
	vec4 col = texture2D(map0, uv) * weight;

	weight += 4.0;
	col += texclamp(uv + vec2( du,   0));
	col += texclamp(uv + vec2(-du,   0));
	col += texclamp(uv + vec2(  0, -dv));
	col += texclamp(uv + vec2(  0,  dv));

	du *= 0.5;
	dv *= 0.5;

	weight += 4.0;
	col += texclamp(uv + vec2( du, -dv));
	col += texclamp(uv + vec2( du,  dv));
	col += texclamp(uv + vec2(-du, -dv));
	col += texclamp(uv + vec2(-du,  dv));

	col = col / weight;
	gl_FragColor.xyz = col.xyz;
}

void main(void)
{
	sampling();
}
