--[[--------------------------------------------------------------------------------------------------------------------------------- 
Find Spell ID Functions
Spell IDs are need to get spell button textures and cool downs.
---------------------------------------------------------------------------------------------------------------------------------]]

function HUI_Chat(msg)
	if msg==nil then msg="nil" end
	if msg==true then msg="true" end
	if msg==false then msg="false" end
	msg = "HealUI: " .. msg
	DEFAULT_CHAT_FRAME:AddMessage(msg,1,1,1)
end


function HUI_Debug(msg)
	if not (HUI_Settings.Debug) then return; end
	
	if msg==nil then msg="nil" end
	if msg==true then msg="true" end
	if msg==false then msg="false" end
	msg = "HealUI: " .. msg
	DEFAULT_CHAT_FRAME:AddMessage(msg,1,1,1)
end


function HUI_Get_DebuffType(tUnit_Name, tDebuffType)
	if not (tUnit_Name) or not (tDebuffType) then return; end;
	local i=1
	local name, rank, icon, count, debuffType, duration, timeLeft, isMine, isStealable;		
	local name = "test"
	while ( name ) do
		name, rank, icon, count, debuffType, duration, timeLeft, isMine, isStealable = UnitDebuff(tUnit_Name, i);
		if (debuffType) then
			if (debuffType == tDebuffType) then 
				return timeLeft, duration, count
			end
		end
		i = i + 1;
	end
	return 
end


function HUI_Check_Debuffs(tUnit_Name) -- Returns poison, disease, magic, curse, weakenedsoul, Spiritofredemption
-- Check to see if the member can be cured of a harmful effect
	-- Do this before showing buffs so Weakened Soul is detected before drawing buffs
	-- Iterator for debuffs
		
	-- Variables to determine if cures should be shown
	-- This is done in case there are multiples of one kind of effect
	local poisonshow = nil;
	local diseaseshow = nil;
	local magicshow = nil;
	local curseshow = nil;
	local weakenedsoul = nil;
	local spirit_of_redemption = nil; 
	local maxtimeleft = 0
	
	local name, rank, icon, count, debuffType, duration, timeLeft, isMine, isStealable;		
	for i=1, 16 do		
		name, rank, icon, count, debuffType, duration, timeLeft, isMine, isStealable = UnitDebuff(tUnit_Name, i);
		if (debuffType) then
			if (debuffType == "Curse") then 
				curseshow = true; 
			end
			if (debuffType == "Disease") then 
				diseaseshow =  true; 
			end
			if (debuffType == "Magic") then 
				magicshow = true; 
			end
			if (debuffType == "Poison") then 
				poisonshow = true; 
			end
		end
		if (name) then
			if (name=="Weakened Soul") then weakenedsoul = true; end;
			if (name=="Spirit of Redemption") then spirit_of_redemption = true; end;
		end
	end
		
	return poisonshow, diseaseshow, magicshow,	curseshow, weakenedsoul;
end


function HUI_Get_Buff_Times(tUnit_Name, tBuff_Name, tMine)
	if not (tUnit_Name) or not (tBuff_Name) then return; end;
	
	local name, rank, icon, count, debuffType, duration, exptime, isMine, isStealable;		
	if (tMine) then
		local i = 1;
		local name = "test"
		while ( name ) do
			--name, rank, icon, count, debuffType, duration, exptime, isMine, isStealable = UnitBuff(tUnit_Name, tBuff_Name, "RAID|PLAYER"); 
			name, rank, icon, count, debuffType, duration, exptime, isMine, isStealable = UnitBuff(tUnit_Name, i, "PLAYER"); 
			if (name) and (name==tBuff_Name) then 
				--HUI_Chat("Found Buff="..name)
				if (isMine) and (isMine=="player") then
					--HUI_Chat("Buff is mine. Buff="..name..", Unit="..UnitName(isMine));
					return exptime, duration, count, 1;
				end
			end
			i = i + 1;
		end
	else
		name, rank, icon, count, debuffType, duration, exptime, isMine, isStealable = UnitBuff(tUnit_Name, tBuff_Name);
	end
	if (name) then return exptime, duration, count, 1; end
end


function HUI_Get_Buff_Times_old(tUnit_Name, tBuff_Name, tMine)
	--name, rank, icon, count, debuffType, duration, expirationTime, isMine, isStealable = UnitBuff(unit, index or name [, castable])

	if not (tUnit_Name) or not (tBuff_Name) then return; end;
	
	local i = 1;
	local name, rank, icon, count, debuffType, duration, exptime, isMine, isStealable;		
	local name = "test"
	while ( name ) do
		name, rank, icon, count, debuffType, duration, exptime, isMine, isStealable = UnitBuff(tUnit_Name, i);
		if (name) and (name==tBuff_Name) then 
			if not (tMine) then
				return exptime, duration, count, 1;
			elseif (isMine) and (isMine=="player") then
				--HUI_Chat("Buff is mine. Buff="..name..", Unit="..UnitName(isMine));
				return exptime, duration, count, 1;
			end
		end
		i = i + 1;
	end
	return;
end

function HUI_Check_for_Buff(tUnit_Name, tBuff_Name)
	if not (tUnit_Name) or not (tBuff_Name) then return; end;
	
	local i = 1;
	local name, rank, icon, count, debuffType, duration, timeLeft, isMine, isStealable;		
	local name = "test"
	while ( name ) do
		name, rank, icon, count, debuffType, duration, timeLeft, isMine, isStealable = UnitBuff(tUnit_Name, i);
		if (name) and (name==tBuff_Name) then 
			return true;
		end
		i = i + 1;
	end
	return;
end

	

function HUI_Check_for_WeaponBuff(tBuff_Name)
	local tHas_WeaponBuff = nil
	if not (tBuff_Name) then
		return tHas_WeaponBuff;
	end
	
	local hasMainHandEnchant, mainHandExpiration, mainHandCharges, hasOffHandEnchant, offHandExpiration, offHandCharges;
	hasMainHandEnchant, mainHandExpiration, mainHandCharges, hasOffHandEnchant, offHandExpiration, offHandCharges = GetWeaponEnchantInfo();
		
	if ( hasMainHandEnchant ) then
		local tspace = string.find(tBuff_Name, " ")
		if (tspace) then
			tBuff_Name = string.sub(tBuff_Name, 1, tspace-1)
		end
		local slotId, textureName;
	
		slotId, textureName = GetInventorySlotInfo('MainHandSlot');
	
		HUI_Tooltip:ClearLines();
		HUI_Tooltip:SetInventoryItem('player', slotId);
		
		for i = 1, HUI_Tooltip:NumLines() do
			if getglobal('HUI_TooltipTextLeft' .. i):GetText() then
				local line = getglobal('HUI_TooltipTextLeft' .. i):GetText();
				if ( string.find(line, tBuff_Name) ) then
					tHas_WeaponBuff = 1;
					do break end; --WINTROW.6, break for efficiency
				end
			end
		end
	end
	return tHas_WeaponBuff;
end

-- Call on spell/config change
function HUI_Debuff_SetIsNeeded()
	local isNeeded = nil
	for b = 1, HUI_Max_Buttons do
		if (HUI_Spell_Button[b] and HUI_Spell_Button[b].CheckDebuff) then isNeeded = 1; end
	end
	RIU3_Debuff_isNeeded = isNeeded
end
