--[[
To Do:

Allow macros to be used.




17. Acual spell info in tooltips (need to search for spell IDs to make this happen). No simple spell name to spell ID functions.
18. Drag and drop unitframes. (don't see how I can get clicking to work) (maybe drag and drop using the same method below)
	- A drag starts drag&drop mode. A moving unit icon pops up on side of unit dragged.
	- On enter of a another unit, while in drag&drop mode, causes a "insert here" icon next to unitframe entered.
	- Clicking a unitframe while in the drag&drop mood causes the "dragged unit" to be insert at the unit clicked. The unit clicked and all ones below are slide down one.
	- OnLeave MainFrame clears  drag&drop mode
	- Add lock check button (on header?)
	- Check incombat on drag, on enter, or click.

]]

-- Get Menu Button Number based on the button name

local addonName, L = ...; 
local function defaultFunc(L, key) 
return key; 
end 
setmetatable(L, {__index=defaultFunc});


function HUI_Tools_Menu_Button_GetNumber(butName)
	local tButton = nil
	if (butName) then
		local strButton = string.sub(butName, 16, 17)  -- HUI_Menu_Button01
		if (strButton) then	tButton = tonumber(strButton); end
	end
	if (not tButton) or (tButton<1) or (tButton>12) then return; end
	return tButton;
end

-- Called when a spell is dragged on to a menu button
function HUI_Tools_Menu_Button_OnReceiveDrag(self)
	local tButton = HUI_Tools_Menu_Button_GetNumber(self:GetName());
	if (not tButton) or (tButton<1) or (tButton>12) then return; end
			
	-- Check If Cursor has spell 
	if (CursorHasSpell()) or (CursorHasMacro()) then
		local Ctype, Cdetail,Csubdetail = GetCursorInfo() 
				
		if not (Ctype) or not (Cdetail) then return; end
		
		if not (Csubdetail) then Csubdetail = ""; end
		HUI_Chat(L["Type=" ].. Ctype .. L[", Detail="] .. Cdetail .. L[", Subdetail="] .. Csubdetail);
		
		local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange, body, isLocal = nil;
		local isMacro = nil;
		if (Ctype=="spell") then
			-- Get Cursor's Spell Info
			name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo(Cdetail, Csubdetail);
		end
		
		if (Ctype=="macro") then
			name, icon, body, isLocal = GetMacroInfo(Cdetail);
			isMacro = 1;
		end
			
		if (name) then
			local tSpell_ID_Old = HUI_MenuSpell_Button[tButton].SpellName;
			local Old_isMacro = HUI_MenuSpell_Button[tButton].isMacro;
						
			-- Check if spell changed
			if (not tSpell_ID_Old) or (name~=tSpell_ID_Old) then
					
				-- If Already had spell, then set the old spell in cursor
				if (tSpell_ID_Old) then
					ClearCursor(); 
					if not (Old_isMacro) then
						PickupSpellBookItem(tSpell_ID_Old); 
					else
						PickupMacro(tSpell_ID_Old);
					end
					HUI_Tools_Menu_Old_CopyButton(tButton);
					HUI_hasOldSpellOptions = 1;
				else
					ClearCursor();  -- Else clear cursor
					HUI_hasOldSpellOptions = nil;
				end
				-- Clear old spell options 
				HUI_Tools_Menu_Clear_SpellOptions(tButton)
				-- Set new spell as button slot's spell
				HUI_MenuSpell_Button[tButton].SpellName = name;
				
				if (isMacro) then
					HUI_MenuSpell_Button[tButton].isMacro = 1;
				else
					HUI_MenuSpell_Button[tButton].isMacro = nil;
				end
				
				-- If cursor had options then use them.
				if (HUI_CursorSpellOptions.SpellName) and (HUI_MenuSpell_Button[tButton].SpellName==HUI_CursorSpellOptions.SpellName) then
					HUI_Tools_Menu_Cursor_GetSpellOptions(tButton); -- copy stored cursor spell options
				else
					HUI_Tools_Menu_Class_SpellOptions(tButton); -- Find spell options in class spell list
				end
				HUI_Tools_Menu_Cursor_ClearSpellOptions();
				if (HUI_hasOldSpellOptions) then HUI_Tools_Menu_Cursor_CopyOld(); end
					
				local butIcon = getglobal(self:GetName().."Icon");
				if (butIcon) and (icon) then
					butIcon:SetTexture(icon);
					butIcon:Show();
					self:SetNormalTexture("Interface\\Buttons\\UI-Quickslot2");
				else
					butIcon:Hide();
					self:SetNormalTexture("Interface\\Buttons\\UI-Quickslot");
				end
				-- Show Changes
				HUI_Show_Menu()
			end -- If new spell
		end -- If found new spell anem
	end -- If cursor has spell
end

-- Called when user attempts to drag a spell out of a menu button
function HUI_Tools_Menu_Button_OnModifiedClick(self) 
	local tButton = HUI_Tools_Menu_Button_GetNumber(self:GetName());
	if (not tButton) or (tButton<1) or (tButton>12) then return; end

	if (HUI_MenuSpell_Button[tButton].SpellName) then
		--PickupSpell(HUI_MenuSpell_Button[tButton].SpellName);
		if not (HUI_MenuSpell_Button[tButton].isMacro) then
			PickupSpellBookItem(HUI_MenuSpell_Button[tButton].SpellName); 
		else
			PickupMacro(HUI_MenuSpell_Button[tButton].SpellName);
		end
		HUI_Tools_Menu_Cursor_SetSpellOptions(tButton);
		-- Clear Spell Options on button since now empty
		HUI_MenuSpell_Button[tButton].SpellName = nil;
		HUI_Tools_Menu_Clear_SpellOptions(tButton)
		HUI_Show_Menu();
	end
end

-- Clear all spell options for a button
function HUI_Tools_Menu_Clear_SpellOptions(tButton)
	if not (tButton) or not (HUI_MenuSpell_Button[tButton]) then return; end
	HUI_MenuSpell_Button[tButton].CheckIfActive = nil;
	HUI_MenuSpell_Button[tButton].IsMine = nil;
	HUI_MenuSpell_Button[tButton].CheckDebuff = nil;
	HUI_MenuSpell_Button[tButton].DebuffDisease = nil;
	HUI_MenuSpell_Button[tButton].DebuffMagic = nil;
	HUI_MenuSpell_Button[tButton].DebuffPoison = nil;
	HUI_MenuSpell_Button[tButton].DebuffCurse = nil;
	HUI_MenuSpell_Button[tButton].DebuffWeakenedSoul = nil;
		
	HUI_MenuSpell_Button[tButton].CastOnDead = nil;
	HUI_MenuSpell_Button[tButton].IfAggro = nil;
	
	HUI_MenuSpell_Button[tButton].hasProc = nil;
	HUI_MenuSpell_Button[tButton].ProcName = nil;
end

-- Set spell options for a button based on the class spell list
function HUI_Tools_Menu_Class_SpellOptions(tButton)
	if not (tButton) or not (HUI_MenuSpell_Button[tButton]) or not (HUI_MenuSpell_Button[tButton].SpellName) then return; end
	
	local sName = nil;
	if not (HUI_MenuSpell_Button[tButton].isMacro) then
		sName = HUI_MenuSpell_Button[tButton].SpellName;
	else
		sName = HUI_MenuSpell_Button[tButton].MacroSpell;
	end
	if (HUI_SpellOptions) and  (HUI_SpellOptions[sName]) then
		HUI_MenuSpell_Button[tButton].CheckIfActive = HUI_SpellOptions[sName].CheckIfActive;
		HUI_MenuSpell_Button[tButton].IsMine = HUI_SpellOptions[sName].IsMine;
		HUI_MenuSpell_Button[tButton].CheckDebuff = HUI_SpellOptions[sName].CheckDebuff;
		HUI_MenuSpell_Button[tButton].DebuffDisease = HUI_SpellOptions[sName].DebuffDisease;
		HUI_MenuSpell_Button[tButton].DebuffMagic = HUI_SpellOptions[sName].DebuffMagic;
		HUI_MenuSpell_Button[tButton].DebuffPoison = HUI_SpellOptions[sName].DebuffPoison;
		HUI_MenuSpell_Button[tButton].DebuffCurse = HUI_SpellOptions[sName].DebuffCurse;
		HUI_MenuSpell_Button[tButton].DebuffWeakenedSoul = HUI_SpellOptions[sName].DebuffWeakenedSoul;
		
		HUI_MenuSpell_Button[tButton].CastOnDead = HUI_SpellOptions[sName].CastOnDead;
		HUI_MenuSpell_Button[tButton].IfAggro = HUI_SpellOptions[sName].IfAggro;
		
		--HUI_MenuSpell_Button[tButton].hasProc = HUI_SpellOptions[sName].hasProc;
		--HUI_MenuSpell_Button[tButton].ProcName = HUI_SpellOptions[sName].ProcName;
	else
		HUI_Tools_Menu_Clear_SpellOptions(tButton);
	end
end

function HUI_Tools_Menu_Cursor_ClearSpellOptions()
	HUI_CursorSpellOptions.SpellName = nil
	HUI_CursorSpellOptions.isMacro = nil
	HUI_CursorSpellOptions.MacroSpell = nil
	HUI_CursorSpellOptions.CheckIfActive = nil;
	HUI_CursorSpellOptions.IsMine = nil;
	HUI_CursorSpellOptions.CheckDebuff = nil;
	HUI_CursorSpellOptions.DebuffDisease = nil;
	HUI_CursorSpellOptions.DebuffMagic = nil;
	HUI_CursorSpellOptions.DebuffPoison = nil;
	HUI_CursorSpellOptions.DebuffCurse = nil;
	HUI_CursorSpellOptions.DebuffWeakenedSoul = nil;
	HUI_CursorSpellOptions.CastOnDead = nil;
	HUI_CursorSpellOptions.IfAggro = nil;
	HUI_CursorSpellOptions.hasProc = nil;
	HUI_CursorSpellOptions.ProcName = nil;
end

function HUI_Tools_Menu_Cursor_SetSpellOptions(tButton)
	if (not tButton) or (tButton<1) or (tButton>12) then return; end
	HUI_CursorSpellOptions.SpellName = HUI_MenuSpell_Button[tButton].SpellName;
	HUI_CursorSpellOptions.isMacro = HUI_MenuSpell_Button[tButton].isMacro;
	HUI_CursorSpellOptions.MacroSpell = HUI_MenuSpell_Button[tButton].MacroSpell;
	HUI_CursorSpellOptions.CheckIfActive = HUI_MenuSpell_Button[tButton].CheckIfActive;
	HUI_CursorSpellOptions.IsMine = HUI_MenuSpell_Button[tButton].IsMine;
	HUI_CursorSpellOptions.CheckDebuff = HUI_MenuSpell_Button[tButton].CheckDebuff;
	HUI_CursorSpellOptions.DebuffDisease = HUI_MenuSpell_Button[tButton].DebuffDisease;
	HUI_CursorSpellOptions.DebuffMagic = HUI_MenuSpell_Button[tButton].DebuffMagic;
	HUI_CursorSpellOptions.DebuffPoison = HUI_MenuSpell_Button[tButton].DebuffPoison;
	HUI_CursorSpellOptions.DebuffCurse = HUI_MenuSpell_Button[tButton].DebuffCurse;
	HUI_CursorSpellOptions.DebuffWeakenedSoul = HUI_MenuSpell_Button[tButton].DebuffWeakenedSoul;
	HUI_CursorSpellOptions.CastOnDead = HUI_MenuSpell_Button[tButton].CastOnDead;
	HUI_CursorSpellOptions.IfAggro = HUI_MenuSpell_Button[tButton].IfAggro;
	HUI_CursorSpellOptions.hasProc = HUI_MenuSpell_Button[tButton].hasProc;
	HUI_CursorSpellOptions.ProcName = HUI_MenuSpell_Button[tButton].ProcName;
end

function HUI_Tools_Menu_Cursor_GetSpellOptions(tButton)
	if (not tButton) or (tButton<1) or (tButton>12) then return; end
	-- HUI_MenuSpell_Button[tButton].SpellName = HUI_CursorSpellOptions.SpellName;
	HUI_MenuSpell_Button[tButton].isMacro = HUI_CursorSpellOptions.isMacro; --HUI_CursorSpellOptions.isMacro;
	HUI_MenuSpell_Button[tButton].MacroSpell = HUI_CursorSpellOptions.MacroSpell; --HUI_CursorSpellOptions.MacroSpell;
	HUI_MenuSpell_Button[tButton].CheckIfActive = HUI_CursorSpellOptions.CheckIfActive;
	HUI_MenuSpell_Button[tButton].IsMine = HUI_CursorSpellOptions.IsMine;
	HUI_MenuSpell_Button[tButton].CheckDebuff = HUI_CursorSpellOptions.CheckDebuff;
	HUI_MenuSpell_Button[tButton].DebuffDisease = HUI_CursorSpellOptions.DebuffDisease;
	HUI_MenuSpell_Button[tButton].DebuffMagic = HUI_CursorSpellOptions.DebuffMagic;
	HUI_MenuSpell_Button[tButton].DebuffPoison = HUI_CursorSpellOptions.DebuffPoison;
	HUI_MenuSpell_Button[tButton].DebuffCurse = HUI_CursorSpellOptions.DebuffCurse;
	HUI_MenuSpell_Button[tButton].DebuffWeakenedSoul = HUI_CursorSpellOptions.DebuffWeakenedSoul;
	HUI_MenuSpell_Button[tButton].CastOnDead = HUI_CursorSpellOptions.CastOnDead;
	HUI_MenuSpell_Button[tButton].IfAggro = HUI_CursorSpellOptions.IfAggro;
	HUI_MenuSpell_Button[tButton].hasProc = HUI_CursorSpellOptions.hasProc;
	HUI_MenuSpell_Button[tButton].ProcName = HUI_CursorSpellOptions.ProcName;
	HUI_Tools_Menu_Cursor_ClearSpellOptions();
end


function HUI_Tools_Menu_Cursor_CopyOld()
	HUI_CursorSpellOptions.SpellName = HUI_OldSpellOptions.SpellName;
	HUI_CursorSpellOptions.isMacro = HUI_OldSpellOptions.isMacro;
	HUI_CursorSpellOptions.MacroSpell = HUI_OldSpellOptions.MacroSpell;
	HUI_CursorSpellOptions.CheckIfActive = HUI_OldSpellOptions.CheckIfActive;
	HUI_CursorSpellOptions.IsMine = HUI_OldSpellOptions.IsMine;
	HUI_CursorSpellOptions.CheckDebuff = HUI_OldSpellOptions.CheckDebuff;
	HUI_CursorSpellOptions.DebuffDisease = HUI_OldSpellOptions.DebuffDisease;
	HUI_CursorSpellOptions.DebuffMagic = HUI_OldSpellOptions.DebuffMagic;
	HUI_CursorSpellOptions.DebuffPoison = HUI_OldSpellOptions.DebuffPoison;
	HUI_CursorSpellOptions.DebuffCurse = HUI_OldSpellOptions.DebuffCurse;
	HUI_CursorSpellOptions.DebuffWeakenedSoul = HUI_OldSpellOptions.DebuffWeakenedSoul;
	HUI_CursorSpellOptions.CastOnDead = HUI_OldSpellOptions.CastOnDead;
	HUI_CursorSpellOptions.IfAggro = HUI_OldSpellOptions.IfAggro;
	HUI_CursorSpellOptions.hasProc = HUI_OldSpellOptions.hasProc;
	HUI_CursorSpellOptions.ProcName = HUI_OldSpellOptions.ProcName;
	HUI_Tools_Menu_Old_ClearSpellOptions();
end

function HUI_Tools_Menu_Old_ClearSpellOptions()
	HUI_OldSpellOptions.SpellName = nil
	HUI_OldSpellOptions.isMacro = nil
	HUI_OldSpellOptions.MacroSpell = nil
	HUI_OldSpellOptions.CheckIfActive = nil;
	HUI_OldSpellOptions.IsMine = nil;
	HUI_OldSpellOptions.CheckDebuff = nil;
	HUI_OldSpellOptions.DebuffDisease = nil;
	HUI_OldSpellOptions.DebuffMagic = nil;
	HUI_OldSpellOptions.DebuffPoison = nil;
	HUI_OldSpellOptions.DebuffCurse = nil;
	HUI_OldSpellOptions.DebuffWeakenedSoul = nil;
	HUI_OldSpellOptions.CastOnDead = nil;
	HUI_OldSpellOptions.IfAggro = nil;
	HUI_OldSpellOptions.hasProc = nil;
	HUI_OldSpellOptions.ProcName = nil;
	HUI_hasOldSpellOptions = nil;
end

function HUI_Tools_Menu_Old_CopyButton(tButton)
	if (not tButton) or (tButton<1) or (tButton>12) then return; end
	HUI_OldSpellOptions.SpellName = HUI_MenuSpell_Button[tButton].SpellName;
	HUI_OldSpellOptions.isMacro = HUI_MenuSpell_Button[tButton].isMacro;
	HUI_OldSpellOptions.MacroSpell = HUI_MenuSpell_Button[tButton].MacroSpell
	HUI_OldSpellOptions.CheckIfActive = HUI_MenuSpell_Button[tButton].CheckIfActive;
	HUI_OldSpellOptions.IsMine = HUI_MenuSpell_Button[tButton].IsMine;
	HUI_OldSpellOptions.CheckDebuff = HUI_MenuSpell_Button[tButton].CheckDebuff;
	HUI_OldSpellOptions.DebuffDisease = HUI_MenuSpell_Button[tButton].DebuffDisease;
	HUI_OldSpellOptions.DebuffMagic = HUI_MenuSpell_Button[tButton].DebuffMagic;
	HUI_OldSpellOptions.DebuffPoison = HUI_MenuSpell_Button[tButton].DebuffPoison;
	HUI_OldSpellOptions.DebuffCurse = HUI_MenuSpell_Button[tButton].DebuffCurse;
	HUI_OldSpellOptions.DebuffWeakenedSoul = HUI_MenuSpell_Button[tButton].DebuffWeakenedSoul;
	HUI_OldSpellOptions.CastOnDead = HUI_MenuSpell_Button[tButton].CastOnDead;
	HUI_OldSpellOptions.IfAggro = HUI_MenuSpell_Button[tButton].IfAggro;
	HUI_OldSpellOptions.hasProc = HUI_MenuSpell_Button[tButton].hasProc;
	HUI_OldSpellOptions.ProcName = HUI_MenuSpell_Button[tButton].ProcName;
end




function HUI_Tools_Menu_Button_Init()

end

function HUI_Tools_Menu_Button_Update()
	
end

function HUI_Tools_Menu_Button_OnClick()

end

function HUI_Tools_Menu_Button_ShowTooltip(self)
	local tButton = HUI_Tools_Menu_Button_GetNumber(self:GetName());
	if (not tButton) or (tButton<1) or (tButton>12) then return; end
	
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	if (HUI_MenuSpell_Button[tButton].SpellName) then
		GameTooltip:SetText(HUI_MenuSpell_Button[tButton].SpellName); 
	else
		GameTooltip:SetText(L["Drop in the spell or macro that should be used when button is clicked"]);
	end
	GameTooltip:Show();
end

function findSpell(spellName, bookType)
   local i, s;
   local found = false;
   for i = 1, MAX_SKILLLINE_TABS do
     local name, texture, offset, numSpells = GetSpellTabInfo(i);
     if (not name) then break; end
     for s = offset + 1, offset + numSpells do
       local	spell, rank = GetSpellInfo(s, bookType);
       if (spell == spellName) then found = true; end
       if (found and spell ~=spellName) then return s-1; end
     end
   end
   if (found) then return s; end
   return nil;
 end

 
 
 
 
 -- Get Menu Button Number based on the button name
function HUI_Tools_Menu_MacroSpell_Button_GetNumber(butName)
	local tButton = nil
	if (butName) then
		local strButton = string.sub(butName, 17, 18)  -- HUI_Menu_Button01
		if (strButton) then	tButton = tonumber(strButton); end
	end
	if (not tButton) or (tButton<1) or (tButton>12) then return; end
	return tButton;
end
 
 
 -- Called when a spell is dragged on to a menu button
function HUI_Tools_Menu_MacroSpell_Button_OnReceiveDrag(self)
	local tButton = HUI_Tools_Menu_MacroSpell_Button_GetNumber(self:GetName());
	if (not tButton) or (tButton<1) or (tButton>12) then return; end
	if not (HUI_MenuSpell_Button[tButton].SpellName) then return; end
	if not (HUI_MenuSpell_Button[tButton].isMacro) then return; end
			
	-- Check If Cursor has spell 
	if (CursorHasSpell()) then
		local Ctype, Cdetail,Csubdetail = GetCursorInfo() 
		if not (Ctype) or not (Ctype=="spell") or not (Cdetail) then return; end
				
		local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo(Cdetail, Csubdetail);
		if (name) then
			local tSpell_ID_Old = HUI_MenuSpell_Button[tButton].MacroSpell;
			-- Check if spell changed
			if (not tSpell_ID_Old) or (name~=tSpell_ID_Old) then
				-- If Already had spell, then set the old spell in cursor
				if (tSpell_ID_Old) then
					ClearCursor(); 
					PickupSpellBookItem(tSpell_ID_Old); 
				else
					ClearCursor();  -- Else clear cursor
				end
				-- Clear old spell options 
				HUI_Tools_Menu_Clear_SpellOptions(tButton);
				-- Set new spell as button slot's spell
				HUI_MenuSpell_Button[tButton].MacroSpell = name;
				-- Find spell options in class spell list
				HUI_Tools_Menu_Class_SpellOptions(tButton);
					
				HUI_Tools_Menu_Cursor_ClearSpellOptions();
					
				local butIcon = getglobal(self:GetName().."Icon");
				if (butIcon) and (icon) then
					butIcon:SetTexture(icon);
					butIcon:Show();
					self:SetNormalTexture("Interface\\Buttons\\UI-Quickslot2");
				else
					butIcon:Hide();
					self:SetNormalTexture("Interface\\Buttons\\UI-Quickslot");
				end
				-- Show Changes
				HUI_Show_Menu()
			end -- If new spell
		end -- If found new spell anem
	end -- If cursor has spell
end

-- Called when user attempts to drag a spell out of a menu button
function HUI_Tools_Menu_MacroSpell_Button_OnModifiedClick(self) 
	local tButton = HUI_Tools_Menu_MacroSpell_Button_GetNumber(self:GetName());
	if (not tButton) or (tButton<1) or (tButton>12) then return; end
	if not (HUI_MenuSpell_Button[tButton].SpellName) then return; end
	if not (HUI_MenuSpell_Button[tButton].isMacro) then return; end
	
	if (HUI_MenuSpell_Button[tButton].MacroSpell) then
		--PickupSpell(HUI_MenuSpell_Button[tButton].SpellName);
		PickupSpellBookItem(HUI_MenuSpell_Button[tButton].MacroSpell); 
		-- Clear Spell Options on button since now empty
		HUI_MenuSpell_Button[tButton].MacroSpell = nil;
		HUI_Tools_Menu_Clear_SpellOptions(tButton)
		HUI_Show_Menu();
	end
end

function HUI_Tools_Menu_MacroSpell_Button_ShowTooltip(self)
	local tButton = HUI_Tools_Menu_MacroSpell_Button_GetNumber(self:GetName());
	if (not tButton) or (tButton<1) or (tButton>12) then return; end
	
	GameTooltip:SetOwner(self, 'ANCHOR_BOTTOMRIGHT');
	if (HUI_MenuSpell_Button[tButton].MacroSpell) then
		GameTooltip:SetText(HUI_MenuSpell_Button[tButton].SpellName); 
	else
		GameTooltip:SetText(L["Drop in the spell that should be monitored for this button"]);
	end
	GameTooltip:Show();
end
