local addonName, L = ...; 
local function defaultFunc(L, key) 
return key; 
end 
setmetatable(L, {__index=defaultFunc});

function HUI_Init_Fav_Values()
	for s=0, HUI_Max_Favs do
		HUI_Fav[s] = {}
		HUI_Fav[s].UnitNumber = nil -- Which HUI_Unit this UFrame is showing
		HUI_Fav[s].Show = nil -- Whether the UFrame should be shown
	
		HUI_Fav[s].Header = nil -- The header of the Unit Frame
		HUI_Fav[s].Handler = nil
		HUI_Fav[s].Button = {}
		HUI_Fav[s].Button[0] = nil
		HUI_Fav[s].IsActive = {}
		HUI_Fav[s].HasDebuff = {}
		HUI_Fav[s].LastExpTime = {}
		
		HUI_Fav[s].HasCurse = nil
		HUI_Fav[s].HasDisease = nil
		HUI_Fav[s].HasPoison = nil
		HUI_Fav[s].HasMagic = nil
		HUI_Fav[s].HasWS = nil
		
		HUI_Fav[s].IsDead = nil
		
		for t = 0, HUI_Max_Buttons do
			HUI_Fav[s].Button[t] = nil -- Create reference and default value to nil for Buttons of this UFrame
			HUI_Fav[s].IsActive[t] = nil-- Tracks whether the mod thinks the button is active. So can clear cooldown if it isn't
			HUI_Fav[s].HasDebuff[t] = nil
			HUI_Fav[s].LastExpTime[t] = nil
		end
		HUI_Fav[s].LastHealth = 0 -- Last checked Health value, used to decide whether to update healthbar.
	end
	HUI_Fav_List_Clear()
end


function HUI_Fav_Swap(FavID1, FavID2)
	if not (FavID1) or not (FavID2) then return; end

	HUI_Fav_List[FavID1], HUI_Fav_List[FavID2] = HUI_Fav_List[FavID2], HUI_Fav_List[FavID1]
	HUI_Fav[FavID1].UnitNumber, HUI_Fav[FavID2].UnitNumber = HUI_Fav[FavID2].UnitNumber, HUI_Fav[FavID1].UnitNumber
	HUI_Fav[FavID1].Show, HUI_Fav[FavID2].Show = HUI_Fav[FavID2].Show, HUI_Fav[FavID1].Show
	HUI_Fav[FavID1].HasCurse, HUI_Fav[FavID2].HasCurse = HUI_Fav[FavID2].HasCurse, HUI_Fav[FavID1].HasCurse
	HUI_Fav[FavID1].HasDisease, HUI_Fav[FavID2].HasDisease = HUI_Fav[FavID2].HasDisease, HUI_Fav[FavID1].HasDisease
	HUI_Fav[FavID1].HasPoison, HUI_Fav[FavID2].HasPoison = HUI_Fav[FavID2].HasPoison, HUI_Fav[FavID1].HasPoison
	HUI_Fav[FavID1].HasMagic, HUI_Fav[FavID2].HasMagic = HUI_Fav[FavID2].HasMagic, HUI_Fav[FavID1].HasMagic
	HUI_Fav[FavID1].HasWS, HUI_Fav[FavID2].HasWS = HUI_Fav[FavID2].HasWS, HUI_Fav[FavID1].HasWS
	
	HUI_Fav_ClearUFavButtons(FavID1)
	HUI_FavFrame_Buttons_UpdateUnit(FavID1)
	HUI_Fav_SetFrame(FavID1)
	HUI_Fav_ClearUFavButtons(FavID2)
	HUI_FavFrame_Buttons_UpdateUnit(FavID2)
	HUI_Fav_SetFrame(FavID2)
	HUI_Refresh_Favs()
end


function HUI_Fav_List_Clear()
	for s=0, HUI_Max_Favs do
		HUI_Fav_List[s] = nil
	end
	HUI_Num_Favs = 0
	-- Hide Fav UFrames
	HUI_Fav_Change = 1
end

function HUI_Fav_List_Add(tUFrameID)
	if not (tUFrameID) then return; end
	if (HUI_Num_Favs>=HUI_Max_Favs) then
		HUI_Chat(L["Unable to Add to Favorites. Too Many Favorites."])
		return
	end
	local tName = HUI_Unit[tUFrameID].Name 
	if not (tName) then return; end
	local found = nil
	for i=1, HUI_Num_Favs do
		if (tName == HUI_Fav_List[HUI_Num_Favs]) then found = 1; end
	end
	if (found) then
		HUI_Chat(L["Name already in favorites list."])
		return
	end
	HUI_Chat(L["Adding "]..tName..L[" to Favorites"])
	HUI_Num_Favs = HUI_Num_Favs + 1
	HUI_Fav_List[HUI_Num_Favs] = tName
	HUI_Fav_UFav_ClearStatus(HUI_Num_Favs)
		
	HUI_Fav_ClearUFavButtons(HUI_Num_Favs)
	HUI_FavFrame_Buttons_UpdateUnit(HUI_Num_Favs)
	HUI_Fav_SetFrame(HUI_Num_Favs)
	HUI_Fav_SetFavoritesFrame()
	HUI_Refresh_Favs()
end

function HUI_Fav_List_RemoveID(tID)
	if not (tID) then return; end
	if (tID>HUI_Num_Favs) then return; end
	if (tID==HUI_Num_Favs) then 
		HUI_Num_Favs = HUI_Num_Favs - 1
		HUI_Fav_Change = 1
		HUI_Fav_SetFavoritesFrame()
		return;
	end
		
	for s=tID, HUI_Num_Favs-1 do
		HUI_Fav_List[s] = HUI_Fav_List[s+1]
		HUI_Fav_ClearUFavButtons(s)
		HUI_FavFrame_Buttons_UpdateUnit(s)
		HUI_Fav_SetFrame(s)
	end
	HUI_Num_Favs = HUI_Num_Favs - 1
	--HUI_Fav_Change = 1
	HUI_Fav_SetFavoritesFrame()
end

function HUI_Fav_List_Remove(tName)
	if not (tName) then return; end
	if (HUI_Num_Favs<1) then return; end
	
	for s=1, HUI_Num_Favs do
		if (tName==HUI_Fav_List[s]) then
			HUI_Fav_List_RemoveID(s)
		end
	end
end

function HUI_Fav_List_Print()
	if (HUI_Num_Favs<1) then 
		HUI_Chat(L["Favorites List is Empty"])
		return
	end
	
	HUI_Chat(L["Favorites List"])
	for s=1, HUI_Num_Favs do
		HUI_Chat(s..". "..HUI_Fav_List[s])
	end
end




function HUI_Fav_List_Update()
		
	if (HUI_Num_Favs<1) then 
		HUI_Fav_AddNewUnits()
		return; 
	end
	
	for s=1, HUI_Num_Favs do
		local found = nil
		for r=0, HUI_Num_Units do
			if (HUI_Unit[r].Name) and (HUI_Fav_List[s] == HUI_Unit[r].Name) then
				found = 1
				HUI_Fav[s].UnitNumber = r -- Copy info
			end
		end
		if not (found) then
			HUI_Chat(L["Favorite "]..HUI_Fav_List[s]..L[" Not Found, Removing."])
			HUI_Fav_List_Remove(HUI_Fav_List[s])
		end
	end
	HUI_Fav_AddNewUnits()
	
	--HUI_FavFrame_Buttons_UpdateUnit()
	--HUI_Fav_ClearButtons()
end

function HUI_Fav_AddNewUnits()
	-- Cycle through all raid/party members
	for r=0, HUI_Num_Units do
		found = nil
		for s=1, HUI_Num_Favs do
			if (HUI_Unit[r].Name) and (HUI_Fav_List[s] == HUI_Unit[r].Name) then found = 1; end
		end
		if not (found) then HUI_Fav_List_Add(r); end
	end
end


function HUI_Fav_FindUFrame_FromName(tName)
	if not (tName) then return; end
	for f = 0, HUI_Num_Units do
		if (HUI_Unit[f].Name) and (tName==HUI_Unit[f].Name) then
			return f
		end
	end
end



function HUI_Fav_Set_Debuffs(tUFrame) -- Returns poison, disease, magic, curse, weakenedsoul, Spiritofredemption
	HUI_Fav[tUFrame].HasCurse = nil
	HUI_Fav[tUFrame].HasDisease = nil
	HUI_Fav[tUFrame].HasPoison = nil
	HUI_Fav[tUFrame].HasMagic = nil
	HUI_Fav[tUFrame].HasWS = nil
	
	local tUnit_Name = HUI_Fav_List[tUFrame] 
	--local spirit_of_redemption = nil; 
			
	local i = 1;
	local name, rank, icon, count, debuffType, duration, timeLeft, isMine, isStealable;		
	local name = L["test"]
	while ( name ) do		
		name, rank, icon, count, debuffType, duration, timeLeft, isMine, isStealable = UnitDebuff(tUnit_Name, i);
		if (debuffType) then
			if (debuffType == "Curse") then 
				HUI_Fav[tUFrame].HasCurse = true; 
			end
			if (debuffType == "Disease") then 
				HUI_Fav[tUFrame].HasDisease = true; 
			end
			if (debuffType == "Magic") then 
				HUI_Fav[tUFrame].HasMagic = true; 
			end
			if (debuffType == "Poison") then 
				HUI_Fav[tUFrame].HasPoison = true; 
			end
		end
		if (name) then
			if (name=="Weakened Soul") then HUI_Fav[tUFrame].HasWS = true; end;
			--if (name=="Spirit of Redemption") then spirit_of_redemption = true; end;
		end
		i = i + 1;
		if i>30 then return; end
	end
end


function HUI_Fav_MoveToTop(FrameID)
	if not (FrameID) or (FrameID<2) then return; end
	for i= FrameID, 2, -1 do
		HUI_Fav_Swap(FrameID, FrameID-1)
	end
end

function HUI_Fav_MoveToBottom(FrameID)
	if not (FrameID) or (FrameID>=HUI_Num_Favs) then return; end
	for i= FrameID, HUI_Num_Favs-1 do
		HUI_Fav_Swap(FrameID, FrameID+1)
	end
end
